/*
 * Copyright (c) 2024, Ambiq Micro, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * Third party software included in this distribution is subject to the
 * additional license terms as defined in the /docs/licenses directory.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @file     apollo4l.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     05. June 2024
 * @note     Generated by SVDConv V3.3.42 on Wednesday, 05.06.2024 13:33:40
 *           from File './apollo4l.svd',
 *           last modified on Wednesday, 05.06.2024 18:33:39
 */



/** @addtogroup Ambiq Micro
  * @{
  */


/** @addtogroup apollo4l
  * @{
  */


#ifndef APOLLO4L_H
#define APOLLO4L_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M4 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /*!< -12  Memory Management, MPU mismatch, including Access Violation
                                                     and No Match                                                              */
  BusFault_IRQn             = -11,              /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                     related Fault                                                             */
  UsageFault_IRQn           = -10,              /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /*!< -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  apollo4l Specific Interrupt Numbers  ========================================== */
  BROWNOUT_IRQn             =   0,              /*!< 0  BROWNOUT_IRQ                                                           */
  WDT_IRQn                  =   1,              /*!< 1  WDT_IRQ                                                                */
  RTC_IRQn                  =   2,              /*!< 2  RTC_IRQ                                                                */
  VCOMP_IRQn                =   3,              /*!< 3  VCOMP_IRQ                                                              */
  IOSLAVE_IRQn              =   4,              /*!< 4  IOSLAVE_IRQ                                                            */
  IOSLAVEACC_IRQn           =   5,              /*!< 5  IOSLAVEACC_IRQ                                                         */
  IOMSTR0_IRQn              =   6,              /*!< 6  IOMSTR0_IRQ                                                            */
  IOMSTR1_IRQn              =   7,              /*!< 7  IOMSTR1_IRQ                                                            */
  IOMSTR2_IRQn              =   8,              /*!< 8  IOMSTR2_IRQ                                                            */
  IOMSTR3_IRQn              =   9,              /*!< 9  IOMSTR3_IRQ                                                            */
  IOMSTR4_IRQn              =  10,              /*!< 10 IOMSTR4_IRQ                                                            */
  IOMSTR5_IRQn              =  11,              /*!< 11 IOMSTR5_IRQ                                                            */
  IOMSTR6_IRQn              =  12,              /*!< 12 IOMSTR6_IRQ                                                            */
  IOMSTR7_IRQn              =  13,              /*!< 13 IOMSTR7_IRQ                                                            */
  TIMER_IRQn                =  14,              /*!< 14 TIMER_IRQ                                                              */
  UART0_IRQn                =  15,              /*!< 15 UART0_IRQ                                                              */
  UART1_IRQn                =  16,              /*!< 16 UART1_IRQ                                                              */
  UART2_IRQn                =  17,              /*!< 17 UART2_IRQ                                                              */
  UART3_IRQn                =  18,              /*!< 18 UART3_IRQ                                                              */
  ADC_IRQn                  =  19,              /*!< 19 ADC_IRQ                                                                */
  MSPI0_IRQn                =  20,              /*!< 20 MSPI0_IRQ                                                              */
  MSPI1_IRQn                =  21,              /*!< 21 MSPI1_IRQ                                                              */
  MSPI2_IRQn                =  22,              /*!< 22 MSPI2_IRQ                                                              */
  CLKGEN_IRQn               =  23,              /*!< 23 CLKGEN_IRQ                                                             */
  CRYPTOSEC_IRQn            =  24,              /*!< 24 CRYPTOSEC_IRQ                                                          */
  SDIO_IRQn                 =  26,              /*!< 26 SDIO_IRQ                                                               */
  GPU_IRQn                  =  28,              /*!< 28 GPU_IRQ                                                                */
  STIMER_CMPR0_IRQn         =  32,              /*!< 32 STIMER_CMPR0_IRQ                                                       */
  STIMER_CMPR1_IRQn         =  33,              /*!< 33 STIMER_CMPR1_IRQ                                                       */
  STIMER_CMPR2_IRQn         =  34,              /*!< 34 STIMER_CMPR2_IRQ                                                       */
  STIMER_CMPR3_IRQn         =  35,              /*!< 35 STIMER_CMPR3_IRQ                                                       */
  STIMER_CMPR4_IRQn         =  36,              /*!< 36 STIMER_CMPR4_IRQ                                                       */
  STIMER_CMPR5_IRQn         =  37,              /*!< 37 STIMER_CMPR5_IRQ                                                       */
  STIMER_CMPR6_IRQn         =  38,              /*!< 38 STIMER_CMPR6_IRQ                                                       */
  STIMER_CMPR7_IRQn         =  39,              /*!< 39 STIMER_CMPR7_IRQ                                                       */
  STIMER_OVF_IRQn           =  40,              /*!< 40 STIMER_OVF_IRQ                                                         */
  I2S0_IRQn                 =  44,              /*!< 44 I2S0_IRQ                                                               */
  PDM0_IRQn                 =  48,              /*!< 48 PDM0_IRQ                                                               */
  GPIO0_001F_IRQn           =  56,              /*!< 56 GPIO0_001F_IRQ                                                         */
  GPIO0_203F_IRQn           =  57,              /*!< 57 GPIO0_203F_IRQ                                                         */
  GPIO0_405F_IRQn           =  58,              /*!< 58 GPIO0_405F_IRQ                                                         */
  GPIO0_607F_IRQn           =  59,              /*!< 59 GPIO0_607F_IRQ                                                         */
  GPIO1_001F_IRQn           =  60,              /*!< 60 GPIO1_001F_IRQ                                                         */
  GPIO1_203F_IRQn           =  61,              /*!< 61 GPIO1_203F_IRQ                                                         */
  GPIO1_405F_IRQn           =  62,              /*!< 62 GPIO1_405F_IRQ                                                         */
  GPIO1_607F_IRQn           =  63,              /*!< 63 GPIO1_607F_IRQ                                                         */
  CPUCPUMB_IRQn             =  64,              /*!< 64 CPUCPUMB_IRQ                                                           */
  DSWP0CPUMB_IRQn           =  65,              /*!< 65 DSWP0CPUMB_IRQ                                                         */
  DSWP1CPUMB_IRQn           =  66,              /*!< 66 DSWP1CPUMB_IRQ                                                         */
  TIMER0_IRQn               =  67,              /*!< 67 TIMER0_IRQ                                                             */
  TIMER1_IRQn               =  68,              /*!< 68 TIMER1_IRQ                                                             */
  TIMER2_IRQn               =  69,              /*!< 69 TIMER2_IRQ                                                             */
  TIMER3_IRQn               =  70,              /*!< 70 TIMER3_IRQ                                                             */
  TIMER4_IRQn               =  71,              /*!< 71 TIMER4_IRQ                                                             */
  TIMER5_IRQn               =  72,              /*!< 72 TIMER5_IRQ                                                             */
  TIMER6_IRQn               =  73,              /*!< 73 TIMER6_IRQ                                                             */
  TIMER7_IRQn               =  74,              /*!< 74 TIMER7_IRQ                                                             */
  TIMER8_IRQn               =  75,              /*!< 75 TIMER8_IRQ                                                             */
  TIMER9_IRQn               =  76,              /*!< 76 TIMER9_IRQ                                                             */
  TIMER10_IRQn              =  77,              /*!< 77 TIMER10_IRQ                                                            */
  TIMER11_IRQn              =  78,              /*!< 78 TIMER11_IRQ                                                            */
  TIMER12_IRQn              =  79,              /*!< 79 TIMER12_IRQ                                                            */
  TIMER13_IRQn              =  80,              /*!< 80 TIMER13_IRQ                                                            */
  TIMER14_IRQn              =  81,              /*!< 81 TIMER14_IRQ                                                            */
  TIMER15_IRQn              =  82,              /*!< 82 TIMER15_IRQ                                                            */
  CACHE_IRQn                =  83,              /*!< 83 CACHE_IRQ                                                              */
  MAX_IRQn                  =  84               /*!< 84 Not a valid IRQ. The maximum IRQ is this value - 1.                    */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M4 Processor and Core Peripherals  =========================== */
#define __CM4_REV                 0x0100U       /*!< CM4 Core Revision                                                         */
#define __NVIC_PRIO_BITS               3        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __VTOR_PRESENT                 1        /*!< Set to 1 if CPU supports Vector Table Offset Register                     */
#define __MPU_PRESENT                  1        /*!< MPU present                                                               */
#define __FPU_PRESENT                  1        /*!< FPU present                                                               */
#define __FPU_DP                       0        /*!< Double Precision FPU                                                      */
#define __DSP_PRESENT                  0        /*!< DSP extension present                                                     */
#define __ICACHE_PRESENT               1        /*!< Instruction Cache present                                                 */
#define __DCACHE_PRESENT               1        /*!< Data Cache present                                                        */
#define __ITCM_PRESENT                 1        /*!< Instruction TCM present                                                   */
#define __DTCM_PRESENT                 1        /*!< Data TCM present                                                          */
#define __SAUREGION_PRESENT            0        /*!< SAU region present                                                        */
#define __PMU_PRESENT                  0        /*!< PMU present                                                               */
#define __PMU_NUM_EVENTCNT             0        /*!< PMU Event Counters                                                        */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                           /*!< ARM Cortex-M4 processor and core peripherals                              */
#include "system_apollo4l.h"                    /*!< apollo4l System                                                           */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog Digital Converter Control (ADC)
  */

typedef struct {                                /*!< (@ 0x40038000) ADC Structure                                              */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) The ADC Configuration Register contains the software
                                                                    control for selecting the clock frequency
                                                                    used for the SAR conversions, the trigger
                                                                    polarity, the trigger select, the reference
                                                                    voltage select, the low power mode, the
                                                                    operating mode (single scan per trigger
                                                                    vs. repeating mode) and ADC enable.                        */

    struct {
      __IOM uint32_t ADCEN      : 1;            /*!< [0..0] This bit enables the ADC module. While the ADC is enabled,
                                                     the ADCCFG and SLOT Configuration regsiter settings must
                                                     remain stable and unchanged. All configuration register
                                                     settings, slot configuration settings and window comparison
                                                     settings should be written prior to setting the ADCEN bit
                                                     to '1'.                                                                   */
            uint32_t            : 1;
      __IOM uint32_t RPTEN      : 1;            /*!< [2..2] This bit enables Repeating Scan Mode.                              */
      __IOM uint32_t LPMODE     : 1;            /*!< [3..3] Select power mode to enter between active scans.                   */
      __IOM uint32_t CKMODE     : 1;            /*!< [4..4] Clock mode register                                                */
            uint32_t            : 7;
      __IOM uint32_t DFIFORDEN  : 1;            /*!< [12..12] Destructive FIFO Read Enable. Setting this will enable
                                                     FIFO pop upon reading the FIFOPR register.                                */
            uint32_t            : 3;
      __IOM uint32_t TRIGSEL    : 3;            /*!< [18..16] Select the ADC trigger source.                                   */
      __IOM uint32_t TRIGPOL    : 1;            /*!< [19..19] This bit selects the ADC trigger polarity for external
                                                     off chip triggers.                                                        */
      __IOM uint32_t RPTTRIGSEL : 1;            /*!< [20..20] This bit selects which periodic trigger to use with
                                                     RPTEN = 1.                                                                */
            uint32_t            : 3;
      __IOM uint32_t CLKSEL     : 2;            /*!< [25..24] Select the source and frequency for the general purpose
                                                     ADC clock. HFRC_24MHZ is the only valid GP ADC clock selection
                                                     and must be configured for proper operation.                              */
            uint32_t            : 6;
    } CFG_b;
  } ;

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) This register indicates the basic power status
                                                                    for the ADC. For detailed power status,
                                                                    see the power control power status register.
                                                                    ADC power mode 0 indicates the ADC is in
                                                                    its full power state and is ready to process
                                                                    scans. ADC Power mode 1 indicates the ADC
                                                                    enabled and in a low power state.                          */

    struct {
      __IOM uint32_t PWDSTAT    : 1;            /*!< [0..0] Indicates the power-status of the ADC.                             */
            uint32_t            : 31;
    } STAT_b;
  } ;

  union {
    __IOM uint32_t SWT;                         /*!< (@ 0x00000008) This register enables initiating an ADC scan
                                                                    through software.                                          */

    struct {
      __IOM uint32_t SWT        : 8;            /*!< [7..0] Writing 0x37 to this register generates a software trigger.        */
            uint32_t            : 24;
    } SWT_b;
  } ;

  union {
    __IOM uint32_t SL0CFG;                      /*!< (@ 0x0000000C) Slot 0 Configuration                                       */

    struct {
      __IOM uint32_t SLEN0      : 1;            /*!< [0..0] This bit enables slot 0 for ADC conversions.                       */
      __IOM uint32_t WCEN0      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     0.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL0     : 4;            /*!< [11..8] Select one of the 11 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE0    : 2;            /*!< [17..16] Set the Precision Mode For Slot 0.                               */
      __IOM uint32_t TRKCYC0    : 6;            /*!< [23..18] Set additional input signal sampling/tracking time
                                                     to the specified number of ADC clock cycles. (Note that
                                                     a value of 0 in this register specifies the minimum required
                                                     5 cycles. A maximum of 64 specifies 69 cycles.)                           */
      __IOM uint32_t ADSEL0     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL0CFG_b;
  } ;

  union {
    __IOM uint32_t SL1CFG;                      /*!< (@ 0x00000010) Slot 1 Configuration                                       */

    struct {
      __IOM uint32_t SLEN1      : 1;            /*!< [0..0] This bit enables slot 1 for ADC conversions.                       */
      __IOM uint32_t WCEN1      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     1.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL1     : 4;            /*!< [11..8] Select one of the 11 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE1    : 2;            /*!< [17..16] Set the Precision Mode For Slot 1.                               */
      __IOM uint32_t TRKCYC1    : 6;            /*!< [23..18] Set additional input signal sampling/tracking time
                                                     to the specified number of ADC clock cycles. (Note that
                                                     a value of 0 in this register specifies the minimum required
                                                     5 cycles. A maximum of 64 specifies 69 cycles.)                           */
      __IOM uint32_t ADSEL1     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL1CFG_b;
  } ;

  union {
    __IOM uint32_t SL2CFG;                      /*!< (@ 0x00000014) Slot 2 Configuration                                       */

    struct {
      __IOM uint32_t SLEN2      : 1;            /*!< [0..0] This bit enables slot 2 for ADC conversions.                       */
      __IOM uint32_t WCEN2      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     2.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL2     : 4;            /*!< [11..8] Select one of the 11 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE2    : 2;            /*!< [17..16] Set the Precision Mode For Slot 2.                               */
      __IOM uint32_t TRKCYC2    : 6;            /*!< [23..18] Set additional input signal sampling/tracking time
                                                     to the specified number of ADC clock cycles. (Note that
                                                     a value of 0 in this register specifies the minimum required
                                                     5 cycles. A maximum of 64 specifies 69 cycles.)                           */
      __IOM uint32_t ADSEL2     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL2CFG_b;
  } ;

  union {
    __IOM uint32_t SL3CFG;                      /*!< (@ 0x00000018) Slot 3 Configuration                                       */

    struct {
      __IOM uint32_t SLEN3      : 1;            /*!< [0..0] This bit enables slot 3 for ADC conversions.                       */
      __IOM uint32_t WCEN3      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     3.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL3     : 4;            /*!< [11..8] Select one of the 11 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE3    : 2;            /*!< [17..16] Set the Precision Mode For Slot 3.                               */
      __IOM uint32_t TRKCYC3    : 6;            /*!< [23..18] Set additional input signal sampling/tracking time
                                                     to the specified number of ADC clock cycles. (Note that
                                                     a value of 0 in this register specifies the minimum required
                                                     5 cycles. A maximum of 64 specifies 69 cycles.)                           */
      __IOM uint32_t ADSEL3     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL3CFG_b;
  } ;

  union {
    __IOM uint32_t SL4CFG;                      /*!< (@ 0x0000001C) Slot 4 Configuration                                       */

    struct {
      __IOM uint32_t SLEN4      : 1;            /*!< [0..0] This bit enables slot 4 for ADC conversions.                       */
      __IOM uint32_t WCEN4      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     4.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL4     : 4;            /*!< [11..8] Select one of the 11 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE4    : 2;            /*!< [17..16] Set the Precision Mode For Slot 4.                               */
      __IOM uint32_t TRKCYC4    : 6;            /*!< [23..18] Set additional input signal sampling/tracking time
                                                     to the specified number of ADC clock cycles. (Note that
                                                     a value of 0 in this register specifies the minimum required
                                                     5 cycles. A maximum of 64 specifies 69 cycles.)                           */
      __IOM uint32_t ADSEL4     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL4CFG_b;
  } ;

  union {
    __IOM uint32_t SL5CFG;                      /*!< (@ 0x00000020) Slot 5 Configuration                                       */

    struct {
      __IOM uint32_t SLEN5      : 1;            /*!< [0..0] This bit enables slot 5 for ADC conversions.                       */
      __IOM uint32_t WCEN5      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     5.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL5     : 4;            /*!< [11..8] Select one of the 11 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE5    : 2;            /*!< [17..16] Set the Precision Mode For Slot 5.                               */
      __IOM uint32_t TRKCYC5    : 6;            /*!< [23..18] Set additional input signal sampling/tracking time
                                                     to the specified number of ADC clock cycles. (Note that
                                                     a value of 0 in this register specifies the minimum required
                                                     5 cycles. A maximum of 64 specifies 69 cycles.)                           */
      __IOM uint32_t ADSEL5     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL5CFG_b;
  } ;

  union {
    __IOM uint32_t SL6CFG;                      /*!< (@ 0x00000024) Slot 6 Configuration                                       */

    struct {
      __IOM uint32_t SLEN6      : 1;            /*!< [0..0] This bit enables slot 6 for ADC conversions.                       */
      __IOM uint32_t WCEN6      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     6.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL6     : 4;            /*!< [11..8] Select one of the 11 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE6    : 2;            /*!< [17..16] Set the Precision Mode For Slot 6.                               */
      __IOM uint32_t TRKCYC6    : 6;            /*!< [23..18] Set additional input signal sampling/tracking time
                                                     to the specified number of ADC clock cycles. (Note that
                                                     a value of 0 in this register specifies the minimum required
                                                     5 cycles. A maximum of 64 specifies 69 cycles.)                           */
      __IOM uint32_t ADSEL6     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL6CFG_b;
  } ;

  union {
    __IOM uint32_t SL7CFG;                      /*!< (@ 0x00000028) Slot 7 Configuration                                       */

    struct {
      __IOM uint32_t SLEN7      : 1;            /*!< [0..0] This bit enables slot 7 for ADC conversions.                       */
      __IOM uint32_t WCEN7      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     7.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL7     : 4;            /*!< [11..8] Select one of the 11 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE7    : 2;            /*!< [17..16] Set the Precision Mode For Slot 7.                               */
      __IOM uint32_t TRKCYC7    : 6;            /*!< [23..18] Set additional input signal sampling/tracking time
                                                     to the specified number of ADC clock cycles. (Note that
                                                     a value of 0 in this register specifies the minimum required
                                                     5 cycles. A maximum of 64 specifies 69 cycles.)                           */
      __IOM uint32_t ADSEL7     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL7CFG_b;
  } ;

  union {
    __IOM uint32_t WULIM;                       /*!< (@ 0x0000002C) Window Comparator Upper Limits                             */

    struct {
      __IOM uint32_t ULIM       : 20;           /*!< [19..0] Sets the upper limit for the window comparator.                   */
            uint32_t            : 12;
    } WULIM_b;
  } ;

  union {
    __IOM uint32_t WLLIM;                       /*!< (@ 0x00000030) Window Comparator Lower Limits                             */

    struct {
      __IOM uint32_t LLIM       : 20;           /*!< [19..0] Sets the lower limit for the window comparator.                   */
            uint32_t            : 12;
    } WLLIM_b;
  } ;

  union {
    __IOM uint32_t SCWLIM;                      /*!< (@ 0x00000034) Scale Window Comparator Limits                             */

    struct {
      __IOM uint32_t SCWLIMEN   : 1;            /*!< [0..0] Scale the window limits compare values per precision
                                                     mode. When set to 0x0 (default), the values in the 20-bit
                                                     limits registers will compare directly with the FIFO values
                                                     regardless of the precision mode the slot is configured
                                                     to. When set to 0x1, the compare values will be divided
                                                     by the difference in precision bits while performing the
                                                     window limit comparisons.                                                 */
            uint32_t            : 31;
    } SCWLIM_b;
  } ;

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000038) The ADC FIFO Register contains the slot number
                                                                    and fifo data for the oldest conversion
                                                                    data in the FIFO. The COUNT field indicates
                                                                    the total number of valid entries in the
                                                                    FIFO. A write to this register will pop
                                                                    one of the FIFO entries off the FIFO and
                                                                    decrease the COUNT by 1 if the COUNT is
                                                                    greater than zero.                                         */

    struct {
      __IOM uint32_t DATA       : 20;           /*!< [19..0] Oldest data in the FIFO.                                          */
      __IOM uint32_t COUNT      : 8;            /*!< [27..20] Number of valid entries in the ADC FIFO.                         */
      __IOM uint32_t SLOTNUM    : 3;            /*!< [30..28] Slot number associated with this FIFO data.                      */
      __IOM uint32_t RSVD       : 1;            /*!< [31..31] RESERVED.                                                        */
    } FIFO_b;
  } ;

  union {
    __IOM uint32_t FIFOPR;                      /*!< (@ 0x0000003C) This is a Pop Read mirrored copy of the ADCFIFO
                                                                    register with the only difference being
                                                                    that reading this register will result in
                                                                    a simultaneous FIFO POP which is also achieved
                                                                    by writing to the ADCFIFO Register. Note:
                                                                    The DFIFORDEN bit must be set in the CFG
                                                                    register for the the destructive read to
                                                                    be enabled.                                                */

    struct {
      __IOM uint32_t DATA       : 20;           /*!< [19..0] Oldest data in the FIFO.                                          */
      __IOM uint32_t COUNT      : 8;            /*!< [27..20] Number of valid entries in the ADC FIFO.                         */
      __IOM uint32_t SLOTNUMPR  : 3;            /*!< [30..28] Slot number associated with this FIFO data.                      */
      __IOM uint32_t RSVDPR     : 1;            /*!< [31..31] RESERVED.                                                        */
    } FIFOPR_b;
  } ;

  union {
    __IOM uint32_t INTTRIGTIMER;                /*!< (@ 0x00000040) ADC-Internal Repeating Trigger Timer Configuration         */

    struct {
      __IOM uint32_t TIMERMAX   : 10;           /*!< [9..0] Trigger counter count max, used as initial condition
                                                     to trigger. Also used repeatedly each time counter reaches
                                                     it to restart trigger timer at zero. To update this value,
                                                     first disable the INTTRIGTIMER by setting TIMEREN to DIS,
                                                     change TIMERMAX, and then reenable it INTTRIGTIMER by setting
                                                     TIMEREN to EN again.                                                      */
            uint32_t            : 6;
      __IOM uint32_t CLKDIV     : 3;            /*!< [18..16] Configure number of divide-by-2 of clock source as
                                                     input to trigger counter. (Max value of 5.) A value of
                                                     0 in this register would not divide down the ADC input
                                                     clock. A value of 1 would divide the ADC input clock frequency
                                                     by 2. A value of 5 would divide the ADC input clock frequency
                                                     by 2^5 = 32. To update this value, first disable the INTTRIGTIMER
                                                     by setting TIMEREN to DIS, change CLKDIV, and then reenable
                                                     it INTTRIGTIMER by setting TIMEREN to EN again.                           */
            uint32_t            : 12;
      __IOM uint32_t TIMEREN    : 1;            /*!< [31..31] ADC-internal trigger timer enable.                               */
    } INTTRIGTIMER_b;
  } ;
  __IM  uint32_t  RESERVED[7];

  union {
    __IOM uint32_t ZXCFG;                       /*!< (@ 0x00000060) Zero Crossing Comparator Configuration                     */

    struct {
      __IOM uint32_t ZXEN       : 1;            /*!< [0..0] Enable the ZX comparator                                           */
            uint32_t            : 3;
      __IOM uint32_t ZXCHANSEL  : 1;            /*!< [4..4] Select which slots to use for zero crossing measurement.
                                                     0 enables zero crossing detection on slots 0 and 2. 1 enables
                                                     zero crossing detection on slots 1 and 3.                                 */
            uint32_t            : 27;
    } ZXCFG_b;
  } ;

  union {
    __IOM uint32_t ZXLIM;                       /*!< (@ 0x00000064) Zero Crossing Comparator Limits                            */

    struct {
      __IOM uint32_t LZXC       : 12;           /*!< [11..0] Sets the lower integer sample limit for the ZX comparator.
                                                     Note that these values are raw ADC values whose bounds
                                                     are specified by PRMODE but not maniupulated by accumulate/divide
                                                     logic. Therefore, there is no oversampling and no binary
                                                     point in this value. Samples must enter the range between
                                                     UZXC and LZXC in order for a zero crossing to be recognized.              */
            uint32_t            : 4;
      __IOM uint32_t UZXC       : 12;           /*!< [27..16] Sets the upper integer sample limit for the ZX comparator.
                                                     Note that these values are raw ADC values whose bounds
                                                     are specified by PRMODE but not maniupulated by accumulate/divide
                                                     logic. Therefore, there is no oversampling and no binary
                                                     point in this value. Samples must enter the range between
                                                     UZXC and LZXC in order for a zero crossing to be recognized.              */
            uint32_t            : 4;
    } ZXLIM_b;
  } ;

  union {
    __IOM uint32_t GAINCFG;                     /*!< (@ 0x00000068) PGA Gain Configuration                                     */

    struct {
      __IOM uint32_t PGACTRLEN  : 1;            /*!< [0..0] Enable PGA gain updates.                                           */
            uint32_t            : 3;
      __IOM uint32_t UPDATEMODE : 1;            /*!< [4..4] PGA update mode                                                    */
            uint32_t            : 27;
    } GAINCFG_b;
  } ;

  union {
    __IOM uint32_t GAIN;                        /*!< (@ 0x0000006C) PGA Gain Codes                                             */

    struct {
      __IOM uint32_t LGA        : 7;            /*!< [6..0] Specifies the low gain code (0 to 102 decimal specifies
                                                     -6.0 dB to 45.0 dB in half-dB increments) for channel A
                                                     (slot 0).                                                                 */
            uint32_t            : 1;
      __IOM uint32_t HGADELTA   : 7;            /*!< [14..8] Specifies the high gain code as an delta from the LGA
                                                     field for channel A (slot 1).                                             */
            uint32_t            : 1;
      __IOM uint32_t LGB        : 7;            /*!< [22..16] Specifies the low gain code (0 to 102 decimal specifies
                                                     -6.0 dB to 45.0 dB in half-dB increments) for channel B
                                                     (slot 2).                                                                 */
            uint32_t            : 1;
      __IOM uint32_t HGBDELTA   : 7;            /*!< [30..24] Specifies the high gain code as an delta from the LGB
                                                     field for channel B (slot 3).                                             */
            uint32_t            : 1;
    } GAIN_b;
  } ;
  __IM  uint32_t  RESERVED1[13];

  union {
    __IOM uint32_t SATCFG;                      /*!< (@ 0x000000A4) Saturation Comparator Configuration                        */

    struct {
      __IOM uint32_t SATEN      : 1;            /*!< [0..0] Enable the saturation comparator                                   */
            uint32_t            : 3;
      __IOM uint32_t SATCHANSEL : 1;            /*!< [4..4] Select which slots to use for saturation measurement.
                                                     0 enables saturation on slots 0 and 2. 1 enables saturation
                                                     on slots 1 and 3.                                                         */
            uint32_t            : 27;
    } SATCFG_b;
  } ;

  union {
    __IOM uint32_t SATLIM;                      /*!< (@ 0x000000A8) Saturation Comparator Limits                               */

    struct {
      __IOM uint32_t LSATC      : 12;           /*!< [11..0] Sets the lower integer sample limit for the saturation
                                                     comparator. Note that these values are raw ADC values whose
                                                     bounds are specified by PRMODE but not manipulated by accumulate/divide
                                                     logic. Therefore, there is no oversampling and no binary
                                                     point in this value.                                                      */
            uint32_t            : 4;
      __IOM uint32_t USATC      : 12;           /*!< [27..16] Sets the upper integer sample limit for the saturation
                                                     comparator. Note that these values are raw ADC values whose
                                                     bounds are specified by PRMODE but not manipulated by accumulate/divide
                                                     logic. Therefore, there is no oversampling and no binary
                                                     point in this value.                                                      */
            uint32_t            : 4;
    } SATLIM_b;
  } ;

  union {
    __IOM uint32_t SATMAX;                      /*!< (@ 0x000000AC) Saturation Comparator Event Counter Limits                 */

    struct {
      __IOM uint32_t SATCAMAX   : 12;           /*!< [11..0] Sets the number of saturation events that may occur
                                                     before a SATCA interrupt occurs. Once this interrupt occurs,
                                                     the saturation event counter must be cleared by writing
                                                     the SATCLR register. A value of 0 is invalid and will cause
                                                     the saturation interrupt to assert immediately.                           */
            uint32_t            : 4;
      __IOM uint32_t SATCBMAX   : 12;           /*!< [27..16] Sets the number of saturation events that may occur
                                                     before a SATCB interrupt occurs. Once this interrupt occurs,
                                                     the saturation event counter must be cleared by writing
                                                     the SATCLR register. A value of 0 is invalid and will cause
                                                     the saturation interrupt to assert immediately.                           */
            uint32_t            : 4;
    } SATMAX_b;
  } ;

  union {
    __IOM uint32_t SATCLR;                      /*!< (@ 0x000000B0) Clears the saturation event counter registers              */

    struct {
      __IOM uint32_t SATCACLR   : 1;            /*!< [0..0] Clear saturation event counter register for channel A
                                                     (slots 0 or 1, depending on SATCHANSEL)                                   */
      __IOM uint32_t SATCBCLR   : 1;            /*!< [1..1] Clear saturation event counter register for channel B
                                                     (slots 2 or 3, depending on SATCHANSEL)                                   */
            uint32_t            : 30;
    } SATCLR_b;
  } ;
  __IM  uint32_t  RESERVED2[25];

  union {
    __IOM uint32_t CALCTRL;                     /*!< (@ 0x00000118) Calibration Control                                        */

    struct {
      __IOM uint32_t RESETDLY   : 10;           /*!< [9..0] Sets the delay between the deassertion of ADC reset and
                                                     the start of calibration in ADC CLKs. Minimum per spec
                                                     is 8 CLKs. Specifying a value smaller than 8 is not supported.            */
      __IOM uint32_t ISODLY     : 10;           /*!< [19..10] Sets the delay between the deassertion of ADC isolation
                                                     and the deassertion of ADC reset in ADC CLKs. This allows
                                                     for synchronous reset of logic within the ADC.                            */
            uint32_t            : 12;
    } CALCTRL_b;
  } ;
  __IM  uint32_t  RESERVED3[57];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
      __IOM uint32_t ZXCA       : 1;            /*!< [8..8] Zero Crossing - Channel A (Slots 0 or 1)                           */
      __IOM uint32_t ZXCB       : 1;            /*!< [9..9] Zero Crossing - Channel B (Slots 2 or 3)                           */
      __IOM uint32_t SATCA      : 1;            /*!< [10..10] Saturation - Channel A (Slots 0 or 1)                            */
      __IOM uint32_t SATCB      : 1;            /*!< [11..11] Saturation - Channel B (Slots 2 or 3)                            */
            uint32_t            : 20;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
      __IOM uint32_t ZXCA       : 1;            /*!< [8..8] Zero Crossing - Channel A (Slots 0 or 1)                           */
      __IOM uint32_t ZXCB       : 1;            /*!< [9..9] Zero Crossing - Channel B (Slots 2 or 3)                           */
      __IOM uint32_t SATCA      : 1;            /*!< [10..10] Saturation - Channel A (Slots 0 or 1)                            */
      __IOM uint32_t SATCB      : 1;            /*!< [11..11] Saturation - Channel B (Slots 2 or 3)                            */
            uint32_t            : 20;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
      __IOM uint32_t ZXCA       : 1;            /*!< [8..8] Zero Crossing - Channel A (Slots 0 or 1)                           */
      __IOM uint32_t ZXCB       : 1;            /*!< [9..9] Zero Crossing - Channel B (Slots 2 or 3)                           */
      __IOM uint32_t SATCA      : 1;            /*!< [10..10] Saturation - Channel A (Slots 0 or 1)                            */
      __IOM uint32_t SATCB      : 1;            /*!< [11..11] Saturation - Channel B (Slots 2 or 3)                            */
            uint32_t            : 20;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
      __IOM uint32_t ZXCA       : 1;            /*!< [8..8] Zero Crossing - Channel A (Slots 0 or 1)                           */
      __IOM uint32_t ZXCB       : 1;            /*!< [9..9] Zero Crossing - Channel B (Slots 2 or 3)                           */
      __IOM uint32_t SATCA      : 1;            /*!< [10..10] Saturation - Channel A (Slots 0 or 1)                            */
      __IOM uint32_t SATCB      : 1;            /*!< [11..11] Saturation - Channel B (Slots 2 or 3)                            */
            uint32_t            : 20;
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED4[12];

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000240) DMA Trigger Enable                                         */

    struct {
      __IOM uint32_t DFIFO75    : 1;            /*!< [0..0] Trigger DMA upon FIFO 75 percent Full                              */
      __IOM uint32_t DFIFOFULL  : 1;            /*!< [1..1] Trigger DMA upon FIFO 100 percent Full                             */
            uint32_t            : 30;
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000244) DMA Trigger Status                                         */

    struct {
      __IOM uint32_t D75STAT    : 1;            /*!< [0..0] Triggered DMA from FIFO 75 percent Full                            */
      __IOM uint32_t DFULLSTAT  : 1;            /*!< [1..1] Triggered DMA from FIFO 100 percent Full                           */
            uint32_t            : 30;
    } DMATRIGSTAT_b;
  } ;
  __IM  uint32_t  RESERVED5[14];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000280) DMA Configuration                                          */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable                                                         */
            uint32_t            : 1;
      __IOM uint32_t DMADIR     : 1;            /*!< [2..2] Direction                                                          */
            uint32_t            : 5;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
      __IOM uint32_t DMADYNPRI  : 1;            /*!< [9..9] Enables dynamic priority based on FIFO fullness. When
                                                     FIFO is full, priority is automatically set to HIGH. Otherwise,
                                                     DMAPRI is used.                                                           */
            uint32_t            : 7;
      __IOM uint32_t DMAMSK     : 1;            /*!< [17..17] Mask the FIFOCNT and SLOTNUM when transferring FIFO
                                                     contents to memory                                                        */
      __IOM uint32_t DPWROFF    : 1;            /*!< [18..18] Power Off the ADC System upon DMACPL.                            */
            uint32_t            : 13;
    } DMACFG_b;
  } ;
  __IM  uint32_t  RESERVED6;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000288) DMA Total Transfer Count                                   */

    struct {
            uint32_t            : 2;
      __IOM uint32_t TOTCOUNT   : 16;           /*!< [17..2] Total Transfer Count                                              */
            uint32_t            : 14;
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x0000028C) DMA Target Address                                         */

    struct {
      __IOM uint32_t LTARGADDR  : 28;           /*!< [27..0] DMA Target Address                                                */
      __IOM uint32_t UTARGADDR  : 4;            /*!< [31..28] SRAM Target                                                      */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000290) DMA Status                                                 */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress                                           */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete                                              */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error                                                          */
            uint32_t            : 29;
    } DMASTAT_b;
  } ;
} ADC_Type;                                     /*!< Size = 660 (0x294)                                                        */



/* =========================================================================================================================== */
/* ================                                          APBDMA                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief APB DMA Register Interfaces (APBDMA)
  */

typedef struct {                                /*!< (@ 0x40011000) APBDMA Structure                                           */

  union {
    __IOM uint32_t BBVALUE;                     /*!< (@ 0x00000000) Control                                                    */

    struct {
      __IOM uint32_t DATAOUT    : 8;            /*!< [7..0] Data Output Values                                                 */
            uint32_t            : 8;
      __IOM uint32_t PIN        : 8;            /*!< [23..16] PIO values                                                       */
            uint32_t            : 8;
    } BBVALUE_b;
  } ;

  union {
    __IOM uint32_t BBSETCLEAR;                  /*!< (@ 0x00000004) Set/Clear                                                  */

    struct {
      __IOM uint32_t SET        : 8;            /*!< [7..0] Write 1 to Set PIO value (set hier priority than clear
                                                     if both bit set)                                                          */
            uint32_t            : 8;
      __IOM uint32_t CLEAR      : 8;            /*!< [23..16] Write 1 to Clear PIO value                                       */
            uint32_t            : 8;
    } BBSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t BBINPUT;                     /*!< (@ 0x00000008) PIO Input Values                                           */

    struct {
      __IOM uint32_t DATAIN     : 8;            /*!< [7..0] PIO values                                                         */
            uint32_t            : 24;
    } BBINPUT_b;
  } ;
  __IM  uint32_t  RESERVED[5];

  union {
    __IOM uint32_t DEBUGDATA;                   /*!< (@ 0x00000020) PIO Input Values                                           */

    struct {
      __IOM uint32_t DEBUGDATA  : 32;           /*!< [31..0] Debug Data                                                        */
    } DEBUGDATA_b;
  } ;
  __IM  uint32_t  RESERVED1[7];

  union {
    __IOM uint32_t DEBUG;                       /*!< (@ 0x00000040) PIO Input Values                                           */

    struct {
      __IOM uint32_t DEBUGEN    : 4;            /*!< [3..0] Debug Enable                                                       */
            uint32_t            : 28;
    } DEBUG_b;
  } ;
} APBDMA_Type;                                  /*!< Size = 68 (0x44)                                                          */



/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Clock Generator (CLKGEN)
  */

typedef struct {                                /*!< (@ 0x40004000) CLKGEN Structure                                           */
  __IM  uint32_t  RESERVED[3];

  union {
    __IOM uint32_t OCTRL;                       /*!< (@ 0x0000000C) This register includes controls for autocalibration
                                                                    in addition to the RTC oscillator controls.                */

    struct {
            uint32_t            : 7;
      __IOM uint32_t OSEL       : 1;            /*!< [7..7] Selects the RTC oscillator (1=LFRC, 0=XT)                          */
            uint32_t            : 24;
    } OCTRL_b;
  } ;

  union {
    __IOM uint32_t CLKOUT;                      /*!< (@ 0x00000010) This register enables the CLKOUT to the GPIOs,
                                                                    and selects the clock source to that.                      */

    struct {
      __IOM uint32_t CKSEL      : 6;            /*!< [5..0] CLKOUT signal select                                               */
            uint32_t            : 1;
      __IOM uint32_t CKEN       : 1;            /*!< [7..7] Enable the CLKOUT signal                                           */
            uint32_t            : 24;
    } CLKOUT_b;
  } ;
  __IM  uint32_t  RESERVED1[3];

  union {
    __IOM uint32_t HFADJ;                       /*!< (@ 0x00000020) This register controls the HFRC adjustment. The
                                                                    HFRC clock can change with temperature and
                                                                    process corners, and this register controls
                                                                    the HFRC adjustment logic which reduces
                                                                    the fluctuations to the clock.                             */

    struct {
      __IOM uint32_t HFADJEN    : 1;            /*!< [0..0] HFRC adjustment control                                            */
      __IOM uint32_t HFADJCK    : 3;            /*!< [3..1] Repeat period for HFRC adjustment                                  */
            uint32_t            : 4;
      __IOM uint32_t HFXTADJ    : 12;           /*!< [19..8] Target HFRC adjustment value.                                     */
      __IOM uint32_t HFWARMUP   : 1;            /*!< [20..20] XT warmup period for HFRC adjustment                             */
      __IOM uint32_t HFADJGAIN  : 3;            /*!< [23..21] Gain control for HFRC adjustment                                 */
      __IOM uint32_t HFADJMAXDELTA : 5;         /*!< [28..24] Maximum delta for HF Adjustments. 0=Disabled, 1-31=maximum
                                                     delta step                                                                */
            uint32_t            : 3;
    } HFADJ_b;
  } ;
  __IM  uint32_t  RESERVED2[3];

  union {
    __IOM uint32_t CLOCKENSTAT;                 /*!< (@ 0x00000030) This register provides the enable status to all
                                                                    the peripheral clocks.                                     */

    struct {
      __IOM uint32_t CLOCKENSTAT : 32;          /*!< [31..0] Clock enable status                                               */
    } CLOCKENSTAT_b;
  } ;

  union {
    __IOM uint32_t CLOCKEN2STAT;                /*!< (@ 0x00000034) This is a continuation of the clock enable status.         */

    struct {
      __IOM uint32_t CLOCKEN2STAT : 32;         /*!< [31..0] Clock enable status 2                                             */
    } CLOCKEN2STAT_b;
  } ;

  union {
    __IOM uint32_t CLOCKEN3STAT;                /*!< (@ 0x00000038) This is a continuation of the clock enable status.         */

    struct {
      __IOM uint32_t CLOCKEN3STAT : 32;         /*!< [31..0] Clock enable status 3                                             */
    } CLOCKEN3STAT_b;
  } ;
  __IM  uint32_t  RESERVED3[2];

  union {
    __IOM uint32_t MISC;                        /*!< (@ 0x00000044) This register controls a 'safe' mode for burst,
                                                                    which disables the clock when burst transition
                                                                    is happening. It also includes a register
                                                                    to force the HFRC during deep sleep. It
                                                                    is mainly used for debug and testing.                      */

    struct {
      __IOM uint32_t FRCHFRC    : 1;            /*!< [0..0] Force HFRC On .                                                    */
      __IOM uint32_t FRCBURSTOFF : 1;           /*!< [1..1] Force fclk, hclk, fclk_wic and fclk_pmu to be turned
                                                     off during burst transition.                                              */
      __IOM uint32_t USEHFRC2FQ48MHZ : 1;       /*!< [2..2] Use HFRC-48MHz or HFRC2-48MHz for DSP                              */
      __IOM uint32_t USEHFRC2FQ96MHZ : 1;       /*!< [3..3] Use HFRC-96MHz or HFRC2-96MHz for DSP                              */
      __IOM uint32_t USEHFRC2FQ192MHZ : 1;      /*!< [4..4] Use HFRC-192MHz or HFRC2-192MHz for MCU                            */
      __IOM uint32_t FRCHFRC2   : 1;            /*!< [5..5] Force HFRC2 On.Setting this bit forces HFRC2 to remain
                                                     on, including in deep sleep. When changing a module's clock
                                                     source to HFRC2, this bit must be set and remain set when
                                                     any module is using HFRC2 as its clock.                                   */
            uint32_t            : 2;
      __IOM uint32_t PWRONCLKENGFX : 1;         /*!< [8..8] Chicken bit to disable Rev B clock enable during reset             */
            uint32_t            : 1;
      __IOM uint32_t PWRONCLKENSDIO : 1;        /*!< [10..10] Chicken bit to disable Rev B clock enable during reset           */
      __IOM uint32_t PWRONCLKENCRYPTO : 1;      /*!< [11..11] Chicken bit to disable Rev B clock enable during reset           */
      __IOM uint32_t PWRONCLKENI2S0 : 1;        /*!< [12..12] Chicken bit to disable Rev B clock enable during reset           */
      __IOM uint32_t PWRONCLKENI2S1 : 1;        /*!< [13..13] Chicken bit to disable Rev B clock enable during reset           */
      __IOM uint32_t AXIXACLKENOVRRIDE : 1;     /*!< [14..14] Chicken bit to disable Rev B added clock gating                  */
      __IOM uint32_t PWRONCLKENI2S0REFCLK : 1;  /*!< [15..15] Chicken bit to disable Rev B clock enable during reset           */
      __IOM uint32_t PWRONCLKENI2S1REFCLK : 1;  /*!< [16..16] Chicken bit to disable Rev B clock enable during reset           */
            uint32_t            : 1;
      __IOM uint32_t CM4DAXICLKGATEEN : 1;      /*!< [18..18] Chicken bit to enable clock gating on CM4 DAXI CLK               */
      __IOM uint32_t GFXCLKCLKGATEEN : 1;       /*!< [19..19] Chicken bit to enable clock gating on GFX CLK                    */
      __IOM uint32_t GFXAXICLKCLKGATEEN : 1;    /*!< [20..20] Chicken bit to enable clock gating on GFX AXI CLK                */
      __IOM uint32_t APBDMACPUCLKCLKGATEEN : 1; /*!< [21..21] Chicken bit to enable clock gating on APB DMA CPU CLK            */
      __IOM uint32_t ETMTRACECLKCLKGATEEN : 1;  /*!< [22..22] Chicken bit to enable clock gating on ETM TRACE CLK              */
      __IOM uint32_t HFRCFUNCCLKGATEEN : 1;     /*!< [23..23] Chicken bit to enable clock gating on HFRC_FUNC_CLK              */
      __IOM uint32_t HFRC96TRUNKGATE : 1;       /*!< [24..24] DO NOT USE. HFRC96_TRUNK_GATE. Setting this bit when
                                                     BIT23=0, will kill HFRC root clock.                                       */
      __IOM uint32_t CLKGENMISCSPARE : 1;       /*!< [25..25] Spare/Unused Chicken Bit                                         */
            uint32_t            : 6;
    } MISC_b;
  } ;

  union {
    __IOM uint32_t HF2ADJ0;                     /*!< (@ 0x00000048) This register controls hf2adj enable, fast_start
                                                                    enable, fast_start_delay setting and counter
                                                                    input offset.                                              */

    struct {
      __IOM uint32_t HF2ADJEN   : 1;            /*!< [0..0] HF2ADJ control                                                     */
      __IOM uint32_t HF2ADJFASTSTREN : 1;       /*!< [1..1] Fast_start_delay control                                           */
      __IOM uint32_t HF2ADJFASTSTRDLY : 13;     /*!< [14..2] Fast_start_delay value setting                                    */
      __IOM uint32_t HF2ADJCNTINOFFSET : 14;    /*!< [28..15] Counter input offset                                             */
      __IOM uint32_t HF2ADJXTHSMUXSEL : 1;      /*!< [29..29] 0=XTHS 1=EXTREF select                                           */
            uint32_t            : 2;
    } HF2ADJ0_b;
  } ;

  union {
    __IOM uint32_t HF2ADJ1;                     /*!< (@ 0x0000004C) This register controls hf2adj trimming enable
                                                                    and trimming offset.                                       */

    struct {
      __IOM uint32_t HF2ADJTRIMEN : 3;          /*!< [2..0] HF2ADJ output selection                                            */
      __IOM uint32_t HF2ADJTRIMOFFSET : 11;     /*!< [13..3] HF2ADJ trimming offset. (signed number)                           */
            uint32_t            : 18;
    } HF2ADJ1_b;
  } ;

  union {
    __IOM uint32_t HF2ADJ2;                     /*!< (@ 0x00000050) This register controls xtal32m divider ratio
                                                                    and HF2ADJ ration setting.                                 */

    struct {
      __IOM uint32_t HF2ADJXTALDIVRATIO : 2;    /*!< [1..0] XTAL32MHz divider ratio for HF2ADJ.                                */
      __IOM uint32_t HF2ADJRATIO : 29;          /*!< [30..2] HF2ADJ ratio setting.                                             */
            uint32_t            : 1;
    } HF2ADJ2_b;
  } ;

  union {
    __IOM uint32_t HF2VAL;                      /*!< (@ 0x00000054) This register provides the read back of the HF2TUNE        */

    struct {
      __IOM uint32_t HF2ADJTRIMOUT : 11;        /*!< [10..0] HF2ADJ trimming output                                            */
            uint32_t            : 21;
    } HF2VAL_b;
  } ;
  __IM  uint32_t  RESERVED4[8];

  union {
    __IOM uint32_t LFRCCTRL;                    /*!< (@ 0x00000078) LFRC control                                               */

    struct {
      __IOM uint32_t LFRCOUT    : 1;            /*!< [0..0] Disable LFRC output                                                */
      __IOM uint32_t LFRCPWD    : 1;            /*!< [1..1] Power down LFRC                                                    */
            uint32_t            : 30;
    } LFRCCTRL_b;
  } ;
  __IM  uint32_t  RESERVED5[2];

  union {
    __IOM uint32_t DISPCLKCTRL;                 /*!< (@ 0x00000084) Provides ability to select the PLL reference
                                                                    clock, and derivative of the display clock                 */

    struct {
      __IOM uint32_t PLLCLKSEL  : 2;            /*!< [1..0] Selection for PLL reference clock.                                 */
            uint32_t            : 1;
      __IOM uint32_t PLLCLKEN   : 1;            /*!< [3..3] Enable for the PLL clock through clkgen                            */
      __IOM uint32_t DISPCLKSEL : 2;            /*!< [5..4] Selection for PLL reference clock.                                 */
            uint32_t            : 26;
    } DISPCLKCTRL_b;
  } ;

  union {
    __IOM uint32_t CLKGENSPARES;                /*!< (@ 0x00000088) CLKGEN Spare Regs                                          */

    struct {
      __IOM uint32_t CLKGENSPARES : 32;         /*!< [31..0] Placeholer spare registes that can be used as needed
                                                     for future use                                                            */
    } CLKGENSPARES_b;
  } ;

  union {
    __IOM uint32_t HFRCIDLECOUNTERS;            /*!< (@ 0x0000008C) Provides SW controlled # idle cycles before powering
                                                                    down HFRC, HFRC2., core clock enable(s)                    */

    struct {
      __IOM uint32_t HFRCPWRDOWNDELAY : 6;      /*!< [5..0] Idle counter for HFRC POWER DOWN DELAY                             */
            uint32_t            : 2;
      __IOM uint32_t HFRCCLKREQDELAY : 6;       /*!< [13..8] Idle counter for HFRC CLK REQ DELAY                               */
            uint32_t            : 2;
      __IOM uint32_t HFRC2PWRDOWNDELAY : 6;     /*!< [21..16] Idle counter for HFRC2 POWER DOWN DELAY                          */
            uint32_t            : 2;
      __IOM uint32_t HFRC2CLKREQDELAY : 6;      /*!< [29..24] Enable for the PLL clock through clkgen                          */
            uint32_t            : 1;
      __IOM uint32_t UPDATEENABLE : 1;          /*!< [31..31] usage : Clear UPDATEENABLE or 1'b0; Update other bits
                                                     fields of this register. Set this register to 1'b1 for
                                                     HW to update.                                                             */
    } HFRCIDLECOUNTERS_b;
  } ;
  __IM  uint32_t  RESERVED6[28];

  union {
    __IOM uint32_t INTRPTEN;                    /*!< (@ 0x00000100) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t OF         : 1;            /*!< [0..0] XT Oscillator Fail interrupt                                       */
            uint32_t            : 31;
    } INTRPTEN_b;
  } ;

  union {
    __IOM uint32_t INTRPTSTAT;                  /*!< (@ 0x00000104) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t OF         : 1;            /*!< [0..0] XT Oscillator Fail interrupt                                       */
            uint32_t            : 31;
    } INTRPTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTRPTCLR;                   /*!< (@ 0x00000108) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t OF         : 1;            /*!< [0..0] XT Oscillator Fail interrupt                                       */
            uint32_t            : 31;
    } INTRPTCLR_b;
  } ;

  union {
    __IOM uint32_t INTRPTSET;                   /*!< (@ 0x0000010C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t OF         : 1;            /*!< [0..0] XT Oscillator Fail interrupt                                       */
            uint32_t            : 31;
    } INTRPTSET_b;
  } ;
} CLKGEN_Type;                                  /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                            CPU                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief CM4 Complex Registers (Cache, TCM, DAXI) (CPU)
  */

typedef struct {                                /*!< (@ 0x48000000) CPU Structure                                              */

  union {
    __IOM uint32_t CACHECFG;                    /*!< (@ 0x00000000) CM4 Cache Control                                          */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] Enables the CM4 cache controller and enables power to
                                                     the cache SRAMs. The ICACHE_ENABLE and DCACHE_ENABLE should
                                                     be set to enable caching for each type of access.                         */
      __IOM uint32_t LRU        : 1;            /*!< [1..1] Sets the cache repleacment policy. 0=LRR (least recently
                                                     replaced), 1=LRU (least recently used). LRR minimizes writes
                                                     to the TAG SRAM.                                                          */
      __IOM uint32_t NC0ENABLE  : 1;            /*!< [2..2] Enable Non-cacheable region 0. See NCR0 registers to
                                                     define the region.                                                        */
      __IOM uint32_t NC1ENABLE  : 1;            /*!< [3..3] Enable Non-cacheable region 1. See NCR1 registers to
                                                     define the region.                                                        */
      __IOM uint32_t CONFIG     : 4;            /*!< [7..4] Sets the cache configuration                                       */
      __IOM uint32_t IENABLE    : 1;            /*!< [8..8] Enable CM4 Instruction Caching                                     */
      __IOM uint32_t DENABLE    : 1;            /*!< [9..9] Enable CM4 Data Caching.                                           */
      __IOM uint32_t CLKGATE    : 1;            /*!< [10..10] Enable clock gating of cache TAG RAM. Software should
                                                     enable this bit for optimal power efficiency.                             */
      __IOM uint32_t LS         : 1;            /*!< [11..11] Enable LS (light sleep) of cache RAMs. Software should
                                                     DISABLE this bit since cache activity is too high to benefit
                                                     from LS usage.                                                            */
      __IOM uint32_t NC1CACHELOCK : 1;          /*!< [12..12] Only valid when Cache Mode D is set. When high sets
                                                     the mode of the the NC1 region such that all accesse to
                                                     this region are cached in to the upper half of the cache.
                                                     When set low then NCR1 is non cacheable.                                  */
      __IOM uint32_t NC0CACHELOCK : 1;          /*!< [13..13] Only valid when Cache Mode D is set. When high sets
                                                     the mode of the the NC0 region such that all accesse to
                                                     this region are cached in to the lower half of the cache.
                                                     When set low then NCR0 is non cacheable.                                  */
            uint32_t            : 6;
      __IOM uint32_t DATACLKGATE : 1;           /*!< [20..20] Enable aggressive clock gating of entire data array.
                                                     This bit should be set to 1 for optimal power efficiency.                 */
            uint32_t            : 3;
      __IOM uint32_t ENABLEMONITOR : 1;         /*!< [24..24] Enable Cache Monitoring Stats. Cache monitoring consumes
                                                     additional power and should only be enabled when profiling
                                                     code and counters will increment when this bit is set.
                                                     Counter values will be retained when this is set to 0,
                                                     allowing software to enable/disable counting for multiple
                                                     code segments.                                                            */
            uint32_t            : 7;
    } CACHECFG_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t CACHECTRL;                   /*!< (@ 0x00000008) Cache Control                                              */

    struct {
      __IOM uint32_t INVALIDATE : 1;            /*!< [0..0] Writing a 1 to this bitfield invalidates the CM4 cache
                                                     contents.                                                                 */
      __IOM uint32_t RESETSTAT  : 1;            /*!< [1..1] Reset Cache Statistics. When written to a 1, the cache
                                                     monitor counters will be cleared. The monitor counters
                                                     can be reset only when the CACHECFG.ENABLE_MONITOR bit
                                                     is set.                                                                   */
      __IOM uint32_t CACHEREADY : 1;            /*!< [2..2] Cache Ready Status (enabled and not processing an invalidate
                                                     operation)                                                                */
            uint32_t            : 29;
    } CACHECTRL_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t NCR0START;                   /*!< (@ 0x00000010) CM4 Cache Noncachable Region 0 Start                       */

    struct {
            uint32_t            : 4;
      __IOM uint32_t ADDR       : 25;           /*!< [28..4] Start address for non-cacheable region 0                          */
            uint32_t            : 3;
    } NCR0START_b;
  } ;

  union {
    __IOM uint32_t NCR0END;                     /*!< (@ 0x00000014) CM4 Cache Noncachable Region 0 End                         */

    struct {
            uint32_t            : 4;
      __IOM uint32_t ADDR       : 25;           /*!< [28..4] End address for non-cacheable region 0                            */
            uint32_t            : 3;
    } NCR0END_b;
  } ;

  union {
    __IOM uint32_t NCR1START;                   /*!< (@ 0x00000018) CM4 Cache Noncachable Region 1 Start                       */

    struct {
            uint32_t            : 4;
      __IOM uint32_t ADDR       : 25;           /*!< [28..4] Start address for non-cacheable region 1                          */
            uint32_t            : 3;
    } NCR1START_b;
  } ;

  union {
    __IOM uint32_t NCR1END;                     /*!< (@ 0x0000001C) CM4 Cache Noncachable Region 1 End                         */

    struct {
            uint32_t            : 4;
      __IOM uint32_t ADDR       : 25;           /*!< [28..4] End address for non-cacheable region 1                            */
            uint32_t            : 3;
    } NCR1END_b;
  } ;
  __IM  uint32_t  RESERVED2[12];

  union {
    __IOM uint32_t DAXICFG;                     /*!< (@ 0x00000050) DAXI Config                                                */

    struct {
      __IOM uint32_t FLUSHLEVEL : 1;            /*!< [0..0] Level of free buffers to flush out dirty buffers.                  */
      __IOM uint32_t AGINGSENABLE : 1;          /*!< [1..1] Enables flushing out shared lines using the aging mechanism.       */
      __IOM uint32_t DAXIPASSTHROUGH : 1;       /*!< [2..2] Passes requests through DAXI logic, disables caching
                                                     lines in the DAXI line buffers.                                           */
      __IOM uint32_t DAXIBECLKGATEEN : 1;       /*!< [3..3] Enables clock gating of DAXI line buffer byte enables.             */
      __IOM uint32_t DAXIDATACLKGATEEN : 1;     /*!< [4..4] Enables clock gating of DAXI line buffer data.                     */
      __IOM uint32_t DAXISTATECLKGATEEN : 1;    /*!< [5..5] Enables clock gating of DAXI state.                                */
            uint32_t            : 2;
      __IOM uint32_t BUFFERENABLE : 4;          /*!< [11..8] Enables DAXI buffers                                              */
            uint32_t            : 4;
      __IOM uint32_t AGINGCOUNTER : 5;          /*!< [20..16] Specifies the relative time that DAXI buffers may remain
                                                     unused before being flushed. Counter is based on CPU clock
                                                     cycles and buffers will generally be flushed in 1-2 AGINGCOUNTER
                                                     timesteps.                                                                */
            uint32_t            : 3;
      __IOM uint32_t MRUGROUPLEVEL : 2;         /*!< [25..24] Sets the MRU group population limit.                             */
            uint32_t            : 6;
    } DAXICFG_b;
  } ;

  union {
    __IOM uint32_t DAXICTRL;                    /*!< (@ 0x00000054) DAXI Control                                               */

    struct {
      __IOM uint32_t DAXIFLUSHWRITE : 1;        /*!< [0..0] Writing a 1 to this bitfield forces a flush of WRITE
                                                     (W->I) or MODIFIED buffers (M->S).                                        */
      __IOM uint32_t DAXIINVALIDATE : 1;        /*!< [1..1] Writing a 1 to this bitfield invalidates any SHARED data
                                                     buffers (S->I).                                                           */
      __IOM uint32_t DAXIREADY  : 1;            /*!< [2..2] DAXI Ready Status (enabled and not processing a flush
                                                     of WRITE or MODIFIED buffers)                                             */
      __IOM uint32_t DAXIBUSY   : 1;            /*!< [3..3] DAXI status indicating DAXI is busy.                               */
      __IOM uint32_t DAXIAHBBUSY : 1;           /*!< [4..4] DAXI status indicating DAXI AHB interface is busy.                 */
      __IOM uint32_t DAXISHARED : 1;            /*!< [5..5] DAXI status indicating at least one full buffer is shared.         */
      __IOM uint32_t DAXIMODIFIED : 1;          /*!< [6..6] DAXI status indicating at least one full buffer has modified
                                                     data.                                                                     */
      __IOM uint32_t DAXIWRITE  : 1;            /*!< [7..7] DAXI status indicating at least one partially written
                                                     buffer has modified data.                                                 */
      __IOM uint32_t DAXIWALLOC : 1;            /*!< [8..8] DAXI status indicating at least one write allocation
                                                     is waiting for prior store to complete.                                   */
      __IOM uint32_t DAXIWRLOAD : 1;            /*!< [9..9] DAXI status indicating at least one partially written
                                                     buffer is waiting for load to convert to modified.                        */
      __IOM uint32_t DAXISTORE  : 1;            /*!< [10..10] DAXI status indicating at least one buffer has outstanding
                                                     store waiting to complete.                                                */
      __IOM uint32_t DAXIBRESPPENDING : 1;      /*!< [11..11] DAXI status indicating at least one AXI B repsonse
                                                     for a store is pending.                                                   */
      __IOM uint32_t DAXIRAXIBUSY : 1;          /*!< [12..12] DAXI status indicating the DAXI RAXI interface is busy.          */
            uint32_t            : 19;
    } DAXICTRL_b;
  } ;
  __IM  uint32_t  RESERVED3[10];

  union {
    __IOM uint32_t ICODEFAULTADDR;              /*!< (@ 0x00000080) ICODE bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t ICODEFAULTADDR : 32;       /*!< [31..0] The ICODE bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } ICODEFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t DCODEFAULTADDR;              /*!< (@ 0x00000084) DCODE bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t DCODEFAULTADDR : 32;       /*!< [31..0] The DCODE bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } DCODEFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t SYSFAULTADDR;                /*!< (@ 0x00000088) System bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t SYSFAULTADDR : 32;         /*!< [31..0] SYS bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } SYSFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t FAULTSTATUS;                 /*!< (@ 0x0000008C) Reflects the status of the bus decoders' fault
                                                                    detection. Any write to this register will
                                                                    clear all of the status bits within the
                                                                    register.                                                  */

    struct {
      __IOM uint32_t ICODEFAULT : 1;            /*!< [0..0] The ICODE Bus Decoder Fault Detected bit. When set, a
                                                     fault has been detected, and the ICODEFAULTADDR register
                                                     will contain the bus address which generated the fault.                   */
      __IOM uint32_t DCODEFAULT : 1;            /*!< [1..1] DCODE Bus Decoder Fault Detected bit. When set, a fault
                                                     has been detected, and the DCODEFAULTADDR register will
                                                     contain the bus address which generated the fault.                        */
      __IOM uint32_t SYSFAULT   : 1;            /*!< [2..2] SYS Bus Decoder Fault Detected bit. When set, a fault
                                                     has been detected, and the SYSFAULTADDR register will contain
                                                     the bus address which generated the fault.                                */
            uint32_t            : 29;
    } FAULTSTATUS_b;
  } ;

  union {
    __IOM uint32_t FAULTCAPTUREEN;              /*!< (@ 0x00000090) Enable the fault capture registers                         */

    struct {
      __IOM uint32_t FAULTCAPTUREEN : 1;        /*!< [0..0] Fault Capture Enable field. When set, the Fault Capture
                                                     monitors are enabled and addresses which generate a hard
                                                     fault are captured into the FAULTADDR registers.                          */
            uint32_t            : 31;
    } FAULTCAPTUREEN_b;
  } ;
  __IM  uint32_t  RESERVED4[11];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x000000C0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t AXIWERROR  : 1;            /*!< [0..0] AXI Write Error Occurred                                           */
            uint32_t            : 31;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x000000C4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t AXIWERROR  : 1;            /*!< [0..0] AXI Write Error Occurred                                           */
            uint32_t            : 31;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x000000C8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t AXIWERROR  : 1;            /*!< [0..0] AXI Write Error Occurred                                           */
            uint32_t            : 31;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x000000CC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t AXIWERROR  : 1;            /*!< [0..0] AXI Write Error Occurred                                           */
            uint32_t            : 31;
    } INTSET_b;
  } ;

  union {
    __IOM uint32_t WRITEERRADDR;                /*!< (@ 0x000000D0) DAXI Write Error Address                                   */

    struct {
      __IOM uint32_t WERRADDR   : 32;           /*!< [31..0] This address will be approximate since multiple write
                                                     transactions might be in flight at any given time. However,
                                                     it should be accurate when debugging/single-stepping                      */
    } WRITEERRADDR_b;
  } ;
  __IM  uint32_t  RESERVED5[11];

  union {
    __IOM uint32_t DMON0;                       /*!< (@ 0x00000100) Data Cache Total Accesses                                  */

    struct {
      __IOM uint32_t DACCESS    : 32;           /*!< [31..0] Total accesses to data cache. All performance metrics
                                                     should be relative to the number of accesses performed.                   */
    } DMON0_b;
  } ;

  union {
    __IOM uint32_t DMON1;                       /*!< (@ 0x00000104) Data Cache Tag Lookups                                     */

    struct {
      __IOM uint32_t DLOOKUP    : 32;           /*!< [31..0] Total tag lookups from data cache.                                */
    } DMON1_b;
  } ;

  union {
    __IOM uint32_t DMON2;                       /*!< (@ 0x00000108) Data Cache Hits                                            */

    struct {
      __IOM uint32_t DHIT       : 32;           /*!< [31..0] Cache hits from lookup operations.                                */
    } DMON2_b;
  } ;

  union {
    __IOM uint32_t DMON3;                       /*!< (@ 0x0000010C) Data Cache Line Hits                                       */

    struct {
      __IOM uint32_t DLINE      : 32;           /*!< [31..0] Cache hits from line cache                                        */
    } DMON3_b;
  } ;

  union {
    __IOM uint32_t IMON0;                       /*!< (@ 0x00000110) Instruction Cache Total Accesses                           */

    struct {
      __IOM uint32_t IACCESS    : 32;           /*!< [31..0] Total accesses to Instruction cache                               */
    } IMON0_b;
  } ;

  union {
    __IOM uint32_t IMON1;                       /*!< (@ 0x00000114) Instruction Cache Tag Lookups                              */

    struct {
      __IOM uint32_t ILOOKUP    : 32;           /*!< [31..0] Total tag lookups from Instruction cache                          */
    } IMON1_b;
  } ;

  union {
    __IOM uint32_t IMON2;                       /*!< (@ 0x00000118) Instruction Cache Hits                                     */

    struct {
      __IOM uint32_t IHIT       : 32;           /*!< [31..0] Cache hits from lookup operations                                 */
    } IMON2_b;
  } ;

  union {
    __IOM uint32_t IMON3;                       /*!< (@ 0x0000011C) Instruction Cache Line Hits                                */

    struct {
      __IOM uint32_t ILINE      : 32;           /*!< [31..0] Cache hits from line cache                                        */
    } IMON3_b;
  } ;
} CPU_Type;                                     /*!< Size = 288 (0x120)                                                        */



/* =========================================================================================================================== */
/* ================                                          CRYPTO                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Embedded security and cryptographic services (CRYPTO)
  */

typedef struct {                                /*!< (@ 0x400C0000) CRYPTO Structure                                           */

  union {
    __IOM uint32_t MEMORYMAP0;                  /*!< (@ 0x00000000) This register maps the virtual register R0 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP0 : 10;         /*!< [10..1] Contains the physical address in memory to map the R0
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP0_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP1;                  /*!< (@ 0x00000004) This register maps the virtual register R1 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP1 : 10;         /*!< [10..1] Contains the physical address in memory to map the R1
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP1_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP2;                  /*!< (@ 0x00000008) This register maps the virtual register R2 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP2 : 10;         /*!< [10..1] Contains the physical address in memory to map the R2
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP2_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP3;                  /*!< (@ 0x0000000C) This register maps the virtual register R3 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP3 : 10;         /*!< [10..1] Contains the physical address in memory to map the R3
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP3_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP4;                  /*!< (@ 0x00000010) This register maps the virtual register R4 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP4 : 10;         /*!< [10..1] Contains the physical address in memory to map the R4
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP4_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP5;                  /*!< (@ 0x00000014) This register maps the virtual register R5 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP5 : 10;         /*!< [10..1] Contains the physical address in memory to map the R5
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP5_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP6;                  /*!< (@ 0x00000018) This register maps the virtual register R6 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP6 : 10;         /*!< [10..1] Contains the physical address in memory to map the R6
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP6_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP7;                  /*!< (@ 0x0000001C) This register maps the virtual register R7 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP7 : 10;         /*!< [10..1] Contains the physical address in memory to map the R7
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP7_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP8;                  /*!< (@ 0x00000020) This register maps the virtual register R8 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP8 : 10;         /*!< [10..1] Contains the physical address in memory to map the R8
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP8_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP9;                  /*!< (@ 0x00000024) This register maps the virtual register R9 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP9 : 10;         /*!< [10..1] Contains the physical address in memory to map the R9
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP9_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP10;                 /*!< (@ 0x00000028) This register maps the virtual register R10 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP10 : 10;        /*!< [10..1] Contains the physical address in memory to map the R10
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP10_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP11;                 /*!< (@ 0x0000002C) This register maps the virtual register R11 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP11 : 10;        /*!< [10..1] Contains the physical address in memory to map the R11
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP11_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP12;                 /*!< (@ 0x00000030) This register maps the virtual register R12 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP12 : 10;        /*!< [10..1] Contains the physical address in memory to map the R12
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP12_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP13;                 /*!< (@ 0x00000034) This register maps the virtual register R13 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP13 : 10;        /*!< [10..1] Contains the physical address in memory to map the R13
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP13_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP14;                 /*!< (@ 0x00000038) This register maps the virtual register R14 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP14 : 10;        /*!< [10..1] Contains the physical address in memory to map the R14
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP14_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP15;                 /*!< (@ 0x0000003C) This register maps the virtual register R15 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP15 : 10;        /*!< [10..1] Contains the physical address in memory to map the R15
                                                     registero.                                                                */
            uint32_t            : 21;
    } MEMORYMAP15_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP16;                 /*!< (@ 0x00000040) This register maps the virtual register R16 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP16 : 10;        /*!< [10..1] Contains the physical address in memory to map the R16
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP16_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP17;                 /*!< (@ 0x00000044) This register maps the virtual register R17 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP17 : 10;        /*!< [10..1] Contains the physical address in memory to map the R17
                                                     registero.                                                                */
            uint32_t            : 21;
    } MEMORYMAP17_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP18;                 /*!< (@ 0x00000048) This register maps the virtual register R18 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP18 : 10;        /*!< [10..1] Contains the physical address in memory to map the R18
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP18_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP19;                 /*!< (@ 0x0000004C) This register maps the virtual register R19 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP19 : 10;        /*!< [10..1] Contains the physical address in memory to map the R19
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP19_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP20;                 /*!< (@ 0x00000050) This register maps the virtual register R20 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP20 : 10;        /*!< [10..1] Contains the physical address in memory to map the R20
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP20_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP21;                 /*!< (@ 0x00000054) This register maps the virtual register R21 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP21 : 10;        /*!< [10..1] Contains the physical address in memory to map the R21
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP21_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP22;                 /*!< (@ 0x00000058) This register maps the virtual register R22 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP22 : 10;        /*!< [10..1] Contains the physical address in memory to map the R22
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP22_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP23;                 /*!< (@ 0x0000005C) This register maps the virtual register R23 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP23 : 10;        /*!< [10..1] Contains the physical address in memory to map the R23
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP23_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP24;                 /*!< (@ 0x00000060) This register maps the virtual register R24 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP24 : 10;        /*!< [10..1] Contains the physical address in memory to map the R24
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP24_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP25;                 /*!< (@ 0x00000064) This register maps the virtual register R25 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP25 : 10;        /*!< [10..1] Contains the physical address in memory to map the R25
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP25_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP26;                 /*!< (@ 0x00000068) This register maps the virtual register R26 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP26 : 10;        /*!< [10..1] Contains the physical address in memory to map the R26
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP26_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP27;                 /*!< (@ 0x0000006C) This register maps the virtual register R27 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP27 : 10;        /*!< [10..1] Contains the physical address in memory to map the R27
                                                     register to.                                                              */
            uint32_t            : 21;
    } MEMORYMAP27_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP28;                 /*!< (@ 0x00000070) This register maps the virtual register R28 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP28 : 10;        /*!< [10..1] Contains the physical address in memory to map the R28
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP28_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP29;                 /*!< (@ 0x00000074) This register maps the virtual register R29 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP29 : 10;        /*!< [10..1] Contains the physical address in memory to map the R29
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP29_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP30;                 /*!< (@ 0x00000078) This register maps the virtual register R30 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP30 : 10;        /*!< [10..1] Contains the physical address in memory to map the R30
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP30_b;
  } ;

  union {
    __IOM uint32_t MEMORYMAP31;                 /*!< (@ 0x0000007C) This register maps the virtual register R31 to
                                                                    a physical address in memory.                              */

    struct {
            uint32_t            : 1;
      __IOM uint32_t PHYSADDRMAP31 : 10;        /*!< [10..1] Contains the physical address in memory to map the R31
                                                     register.                                                                 */
            uint32_t            : 21;
    } MEMORYMAP31_b;
  } ;

  union {
    __IOM uint32_t OPCODE;                      /*!< (@ 0x00000080) This register holds the PKAs OPCODE.                       */

    struct {
      __IOM uint32_t TAG        : 6;            /*!< [5..0] Holds the operations tag or the operand C virtual address.         */
      __IOM uint32_t REGR       : 6;            /*!< [11..6] Result register virtual address 0-15.                             */
      __IOM uint32_t REGB       : 6;            /*!< [17..12] Operand B virtual address 0-15.                                  */
      __IOM uint32_t REGA       : 6;            /*!< [23..18] Operand A virtual address 0-15.                                  */
      __IOM uint32_t LEN        : 3;            /*!< [26..24] The length of the operation. The value serves as a
                                                     pointer to PKA length register, for example, if the value
                                                     is 0, PKA_L0 holds the size of the operation.                             */
      __IOM uint32_t OPCODE     : 5;            /*!< [31..27] Defines the PKA operation:                                       */
    } OPCODE_b;
  } ;

  union {
    __IOM uint32_t NNPT0T1ADDR;                 /*!< (@ 0x00000084) This register maps N_NP_T0_T1 to a virtual address.        */

    struct {
      __IOM uint32_t NVIRTUALADDR : 5;          /*!< [4..0] Virtual address of register N.                                     */
      __IOM uint32_t NPVIRTUALADDR : 5;         /*!< [9..5] Virtual address of register NP.                                    */
      __IOM uint32_t T0VIRTUALADDR : 5;         /*!< [14..10] Virtual address of temporary register number 0                   */
      __IOM uint32_t T1VIRTUALADDR : 5;         /*!< [19..15] Virtual address of temporary register number 1                   */
            uint32_t            : 12;
    } NNPT0T1ADDR_b;
  } ;

  union {
    __IOM uint32_t PKASTATUS;                   /*!< (@ 0x00000088) This register holds the PKA pipe status.                   */

    struct {
      __IOM uint32_t ALUMSB4BITS : 4;           /*!< [3..0] The most significant 4-bits of the operand updated in
                                                     shift operation.                                                          */
      __IOM uint32_t ALULSB4BITS : 4;           /*!< [7..4] The least significant 4-bits of the operand updated in
                                                     shift operation.                                                          */
      __IOM uint32_t ALUSIGNOUT : 1;            /*!< [8..8] Indicates the last operations sign (MSB).                          */
      __IOM uint32_t ALUCARRY   : 1;            /*!< [9..9] Holds the carry of the last ALU operation.                         */
      __IOM uint32_t ALUCARRYMOD : 1;           /*!< [10..10] holds the carry of the last Modular operation.                   */
      __IOM uint32_t ALUSUBISZERO : 1;          /*!< [11..11] Indicates the last subtraction operations sign .                 */
      __IOM uint32_t ALUOUTZERO : 1;            /*!< [12..12] Indicates if the result of ALU OUT is zero.                      */
      __IOM uint32_t ALUMODOVRFLW : 1;          /*!< [13..13] Modular overflow flag.                                           */
      __IOM uint32_t DIVBYZERO  : 1;            /*!< [14..14] Indication if the division is done by zero.                      */
      __IOM uint32_t MODINVOFZERO : 1;          /*!< [15..15] Indicates the Modular inverse of zero.                           */
      __IOM uint32_t OPCODE     : 5;            /*!< [20..16] Opcode of the last operation                                     */
            uint32_t            : 11;
    } PKASTATUS_b;
  } ;

  union {
    __IOM uint32_t PKASWRESET;                  /*!< (@ 0x0000008C) Writing to this register triggers a software
                                                                    reset of the PKA.                                          */

    struct {
      __IOM uint32_t PKASWRESET : 1;            /*!< [0..0] The reset mechanism takes about four PKA clock cycles
                                                     until the reset line is deasserted                                        */
            uint32_t            : 31;
    } PKASWRESET_b;
  } ;

  union {
    __IOM uint32_t PKAL0;                       /*!< (@ 0x00000090) This register holds one of the optional size
                                                                    of the operation.                                          */

    struct {
      __IOM uint32_t PKAL0      : 13;           /*!< [12..0] Size of the operation in bytes.                                   */
            uint32_t            : 19;
    } PKAL0_b;
  } ;

  union {
    __IOM uint32_t PKAL1;                       /*!< (@ 0x00000094) This register holds one of the optional size
                                                                    of the operation.                                          */

    struct {
      __IOM uint32_t PKAL1      : 13;           /*!< [12..0] Size of the operation in bytes.                                   */
            uint32_t            : 19;
    } PKAL1_b;
  } ;

  union {
    __IOM uint32_t PKAL2;                       /*!< (@ 0x00000098) This register holds one of the optional size
                                                                    of the operation.                                          */

    struct {
      __IOM uint32_t PKAL2      : 13;           /*!< [12..0] Size of the operation in bytes.                                   */
            uint32_t            : 19;
    } PKAL2_b;
  } ;

  union {
    __IOM uint32_t PKAL3;                       /*!< (@ 0x0000009C) This register holds one of the optional size
                                                                    of the operation.                                          */

    struct {
      __IOM uint32_t PKAL3      : 13;           /*!< [12..0] Size of the operation in bytes.                                   */
            uint32_t            : 19;
    } PKAL3_b;
  } ;

  union {
    __IOM uint32_t PKAL4;                       /*!< (@ 0x000000A0) This register holds one of the optional size
                                                                    of the operation.                                          */

    struct {
      __IOM uint32_t PKAL4      : 13;           /*!< [12..0] Size of the operation in bytes.                                   */
            uint32_t            : 19;
    } PKAL4_b;
  } ;

  union {
    __IOM uint32_t PKAL5;                       /*!< (@ 0x000000A4) This register holds one of the optional size
                                                                    of the operation.                                          */

    struct {
      __IOM uint32_t PKAL5      : 13;           /*!< [12..0] Size of the operation in bytes.                                   */
            uint32_t            : 19;
    } PKAL5_b;
  } ;

  union {
    __IOM uint32_t PKAL6;                       /*!< (@ 0x000000A8) This register holds one of the optional size
                                                                    of the operation.                                          */

    struct {
      __IOM uint32_t PKAL6      : 13;           /*!< [12..0] Size of the operation in bytes.                                   */
            uint32_t            : 19;
    } PKAL6_b;
  } ;

  union {
    __IOM uint32_t PKAL7;                       /*!< (@ 0x000000AC) This register holds one of the optional size
                                                                    of the operation.                                          */

    struct {
      __IOM uint32_t PKAL7      : 13;           /*!< [12..0] Size of the operation in bytes.                                   */
            uint32_t            : 19;
    } PKAL7_b;
  } ;

  union {
    __IOM uint32_t PKAPIPERDY;                  /*!< (@ 0x000000B0) This register indicates whether the PKA pipe
                                                                    is ready to receive a new OPCODE.                          */

    struct {
      __IOM uint32_t PKAPIPERDY : 1;            /*!< [0..0] Indication whether PKA pipe is ready for new OPCODE.               */
            uint32_t            : 31;
    } PKAPIPERDY_b;
  } ;

  union {
    __IOM uint32_t PKADONE;                     /*!< (@ 0x000000B4) This register indicates whether PKA operation
                                                                    is completed.                                              */

    struct {
      __IOM uint32_t PKADONE    : 1;            /*!< [0..0] Indicates if PKA operation is completed, and pipe is
                                                     empty.                                                                    */
            uint32_t            : 31;
    } PKADONE_b;
  } ;

  union {
    __IOM uint32_t PKAMONSELECT;                /*!< (@ 0x000000B8) This register defines which PKA FSM monitor is
                                                                    being output.                                              */

    struct {
      __IOM uint32_t PKAMONSELECT : 4;          /*!< [3..0] Defines which PKA FSM monitor is being output.                     */
            uint32_t            : 28;
    } PKAMONSELECT_b;
  } ;
  __IM  uint32_t  RESERVED[2];

  union {
    __IOM uint32_t PKAVERSION;                  /*!< (@ 0x000000C4) This register holds the pka version                        */

    struct {
      __IOM uint32_t PKAVERSION : 32;           /*!< [31..0] This is the PKA version                                           */
    } PKAVERSION_b;
  } ;
  __IM  uint32_t  RESERVED1[2];

  union {
    __IOM uint32_t PKAMONREAD;                  /*!< (@ 0x000000D0) The PKA monitor bus register.                              */

    struct {
      __IOM uint32_t PKAMONREAD : 32;           /*!< [31..0] This is the PKA monitor bus register output                       */
    } PKAMONREAD_b;
  } ;

  union {
    __IOM uint32_t PKASRAMADDR;                 /*!< (@ 0x000000D4) first address given to PKA SRAM for write transactions.    */

    struct {
      __IOM uint32_t PKASRAMADDR : 32;          /*!< [31..0] PKA SRAM write starting address                                   */
    } PKASRAMADDR_b;
  } ;

  union {
    __IOM uint32_t PKASRAMWDATA;                /*!< (@ 0x000000D8) Write data to PKA SRAM.                                    */

    struct {
      __IOM uint32_t PKASRAMWDATA : 32;         /*!< [31..0] 32 bit write to PKA SRAM: triggers the SRAM write DMA
                                                     address automatically incremented                                         */
    } PKASRAMWDATA_b;
  } ;

  union {
    __IOM uint32_t PKASRAMRDATA;                /*!< (@ 0x000000DC) Read data from PKA SRAM.                                   */

    struct {
      __IOM uint32_t PKASRAMRDATA : 32;         /*!< [31..0] 32 bit read from PKA SRAM: read - triggers the SRAM
                                                     read DMA address automatically incremented                                */
    } PKASRAMRDATA_b;
  } ;

  union {
    __IOM uint32_t PKASRAMWRCLR;                /*!< (@ 0x000000E0) Write buffer clean.                                        */

    struct {
      __IOM uint32_t PKASRAMWRCLR : 32;         /*!< [31..0] Clear the write buffer.                                           */
    } PKASRAMWRCLR_b;
  } ;

  union {
    __IOM uint32_t PKASRAMRADDR;                /*!< (@ 0x000000E4) first address given to PKA SRAM for read transactions.     */

    struct {
      __IOM uint32_t PKASRAMRADDR : 32;         /*!< [31..0] PKA SRAM read starting address                                    */
    } PKASRAMRADDR_b;
  } ;
  __IM  uint32_t  RESERVED2[2];

  union {
    __IOM uint32_t PKAWORDACCESS;               /*!< (@ 0x000000F0) This register holds the data written to PKA memory
                                                                    using the wop opcode.                                      */

    struct {
      __IOM uint32_t PKAWORDACCESS : 32;        /*!< [31..0] 32 bit read_write data.                                           */
    } PKAWORDACCESS_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t PKABUFFADDR;                 /*!< (@ 0x000000F8) This register maps the virtual buffer registers
                                                                    to a physical address in memory.                           */

    struct {
      __IOM uint32_t PKABUFADDR : 12;           /*!< [11..0] Contains the physical address in memory to map the buffer
                                                     registers.                                                                */
            uint32_t            : 20;
    } PKABUFFADDR_b;
  } ;
  __IM  uint32_t  RESERVED4;

  union {
    __IOM uint32_t RNGIMR;                      /*!< (@ 0x00000100) Interrupt masking register. Consists of {prng_imr
                                                                    trng_imr} bit[31-16] - PRNG_IMR bit[15-0]
                                                                    - TRNG_IMR(Ws - PRNG bit exists only if
                                                                    PRNG_EXISTS flag)                                          */

    struct {
      __IOM uint32_t EHRVALIDINTMASK : 1;       /*!< [0..0] 0x1 - masks the EHR interrupt. No interrupt is generated.          */
      __IOM uint32_t AUTOCORRERRINTMASK : 1;    /*!< [1..1] 0x1 - masks the autocorrelation interrupt. No interrupt
                                                     is generated.                                                             */
      __IOM uint32_t CRNGTERRINTMASK : 1;       /*!< [2..2] 0x1 - masks the CRNGT error interrupt. No interrupt is
                                                     generated.                                                                */
      __IOM uint32_t VNERRINTMASK : 1;          /*!< [3..3] 0x1 - masks the Von-Neumann error interrupt. No interrupt
                                                     is generated.                                                             */
      __IOM uint32_t WATCHDOGINTMASK : 1;       /*!< [4..4] 0x1 - masks the watchdog interrupt. No interrupt is generated.     */
      __IOM uint32_t RNGDMADONEINT : 1;         /*!< [5..5] 0x1 - masks the RNG DMA completion interrupt. No interrupt
                                                     is generated.                                                             */
            uint32_t            : 26;
    } RNGIMR_b;
  } ;

  union {
    __IOM uint32_t RNGISR;                      /*!< (@ 0x00000104) Status register. If corresponding RNG_IMR bit
                                                                    is unmasked, an interrupt is generated.Consists
                                                                    of trng_isr and prng_isr bit[15-0] - TRNG
                                                                    bit[31-16] - PRNG                                          */

    struct {
      __IOM uint32_t EHRVALID   : 1;            /*!< [0..0] 0x1 indicates that 192 bits have been collected in the
                                                     TRNG and are ready to be read.                                            */
      __IOM uint32_t AUTOCORRERR : 1;           /*!< [1..1] 0x1 indicates Autocorrelation test failed four times
                                                     in a row. When it set ,TRNG ceases to function until next
                                                     reset.                                                                    */
      __IOM uint32_t CRNGTERR   : 1;            /*!< [2..2] 0x1 indicates CRNGT in the TRNG test failed. Failure
                                                     occurs when two consecutive blocks of 16 collected bits
                                                     are equal.                                                                */
      __IOM uint32_t VNERR      : 1;            /*!< [3..3] 0x1 indicates Von Neumann error. Error in von Neumann
                                                     occurs if 32 consecutive collected bits are identical,
                                                     ZERO, or ONE.                                                             */
            uint32_t            : 1;
      __IOM uint32_t RNGDMADONE : 1;            /*!< [5..5] 0x1 indicates RNG DMA to SRAM is completed.                        */
            uint32_t            : 10;
      __IOM uint32_t RESEEDINGDONE : 1;         /*!< [16..16] 0x1 indicates completion of reseeding algorithm with
                                                     no errors.                                                                */
      __IOM uint32_t INSTANTIATIONDONE : 1;     /*!< [17..17] 0x1 indicates completion of instantiation algorithm
                                                     with no errors.                                                           */
      __IOM uint32_t FINALUPDATEDONE : 1;       /*!< [18..18] 0x1 indicates completion of final update algorithm.              */
      __IOM uint32_t OUTPUTREADY : 1;           /*!< [19..19] 0x1 indicates that the result of PRNG is valid and
                                                     ready to be read. The result can be read from the RNG_READOUT
                                                     register.                                                                 */
      __IOM uint32_t RESEEDCNTRFULL : 1;        /*!< [20..20] 0x1 indicates that the reseed counter has reached 2^48,
                                                     requiring to run the reseed algorithm before generating
                                                     new random numbers.                                                       */
      __IOM uint32_t RESEEDCNTRTOP40 : 1;       /*!< [21..21] 0x1 indicates that the top 40 bits of the reseed counter
                                                     are set (that is the reseed counter is larger than 2^48-2^8).
                                                     This is a recommendation for running the reseed algorithm
                                                     before the counter reaches its max value.                                 */
      __IOM uint32_t PRNGCRNGTERR : 1;          /*!< [22..22] 0x1 indicates CRNGT in the PRNG test failed. Failure
                                                     occurs when two consecutive results of AES are equal                      */
      __IOM uint32_t REQSIZE    : 1;            /*!< [23..23] 0x1 indicates that the request size counter (which
                                                     represents how many generations of random bits in the PRNG
                                                     have been produced) has reached 2^12, thus requiring a
                                                     working state update before generating new random numbers.                */
      __IOM uint32_t KATERR     : 1;            /*!< [24..24] 0x1 indicates that one of the KAT (Known Answer Tests)
                                                     tests has failed. When set, the entire engine ceases to
                                                     function.                                                                 */
      __IOM uint32_t WHICHKATERR : 2;           /*!< [26..25] When the KAT_ERR bit is set, these bits represent which
                                                     Known Answer Test had failed:                                             */
            uint32_t            : 5;
    } RNGISR_b;
  } ;

  union {
    __IOM uint32_t RNGICR;                      /*!< (@ 0x00000108) Interrupt_status bit clear Register. Consists
                                                                    of trng_icr and prng_icr bit[15-0] - TRNG
                                                                    bit[31-16] - PRNG                                          */

    struct {
      __IOM uint32_t EHRVALID   : 1;            /*!< [0..0] Writing value 0x1 - clears corresponding bit in RNGISR             */
      __IOM uint32_t AUTOCORRERR : 1;           /*!< [1..1] Cannot be cleared by SW! Only RNG reset clears this bit.           */
      __IOM uint32_t CRNGTERR   : 1;            /*!< [2..2] Writing value 0x1 - clears corresponding bit in RNGISR             */
      __IOM uint32_t VNERR      : 1;            /*!< [3..3] Writing value 0x1 - clears corresponding bit in RNGISR             */
      __IOM uint32_t RNGWATCHDOG : 1;           /*!< [4..4] Writing value 0x1 - clears corresponding bit in RNGISR             */
      __IOM uint32_t RNGDMADONE : 1;            /*!< [5..5] Writing value 0x1 - clears corresponding bit in RNGISR             */
            uint32_t            : 10;
      __IOM uint32_t RESEEDINGDONE : 1;         /*!< [16..16] Writing value 0x1 - clears corresponding bit in RNGISR           */
      __IOM uint32_t INSTANTIATIONDONE : 1;     /*!< [17..17] Writing value 0x1 - clears corresponding bit in RNGISR           */
      __IOM uint32_t FINALUPDATEDONE : 1;       /*!< [18..18] Writing value 0x1 - clears corresponding bit in RNGISR           */
      __IOM uint32_t OUTPUTREADY : 1;           /*!< [19..19] Writing value 0x1 - clears corresponding bit in RNGISR           */
      __IOM uint32_t RESEEDCNTRFULL : 1;        /*!< [20..20] Writing value 0x1 - clears corresponding bit in RNGISR           */
      __IOM uint32_t RESEEDCNTRTOP40 : 1;       /*!< [21..21] Writing value 0x1 - clears corresponding bit in RNGISR           */
      __IOM uint32_t PRNGCRNGTERR : 1;          /*!< [22..22] Writing value 0x1 - clears corresponding bit in RNGISR           */
      __IOM uint32_t REQSIZE    : 1;            /*!< [23..23] Writing value 0x1 - clears corresponding bit in RNGISR           */
      __IOM uint32_t KATERR     : 1;            /*!< [24..24] Cannot be cleared by SW! Only RNG reset clears this
                                                     bit.                                                                      */
      __IOM uint32_t WHICHKATERR : 2;           /*!< [26..25] Cannot be cleared by SW! Only RNG reset clears this
                                                     bit.                                                                      */
            uint32_t            : 5;
    } RNGICR_b;
  } ;

  union {
    __IOM uint32_t TRNGCONFIG;                  /*!< (@ 0x0000010C) This register handles TRNG configuration                   */

    struct {
      __IOM uint32_t RNDSRCSEL  : 2;            /*!< [1..0] Defines the length of the oscillator ring (= the number
                                                     of inverters) out of four possible selections.                            */
      __IOM uint32_t SOPSEL     : 1;            /*!< [2..2] Secure Output Port selection:                                      */
            uint32_t            : 29;
    } TRNGCONFIG_b;
  } ;

  union {
    __IOM uint32_t TRNGVALID;                   /*!< (@ 0x00000110) This register indicates that the TRNG data is
                                                                    valid.                                                     */

    struct {
      __IOM uint32_t EHRVALID   : 1;            /*!< [0..0] 0x1 indicates that collection of bits in the TRNG is
                                                     completed, and data can be read from the EHR_DATA register.               */
            uint32_t            : 31;
    } TRNGVALID_b;
  } ;

  union {
    __IOM uint32_t EHRDATA0;                    /*!< (@ 0x00000114) This register contains the data collected in
                                                                    the TRNG[31_0]. Note: can only be set while
                                                                    in debug mode (rng_debug_enable input is
                                                                    set).                                                      */

    struct {
      __IOM uint32_t EHRDATA    : 32;           /*!< [31..0] Contains the data collected in the TRNG[31_0]. Note:
                                                     can only be set while in debug mode (rng_debug_enable input
                                                     is set).                                                                  */
    } EHRDATA0_b;
  } ;

  union {
    __IOM uint32_t EHRDATA1;                    /*!< (@ 0x00000118) This register contains the data collected in
                                                                    the TRNG[63_32]. Note: can only be set while
                                                                    in debug mode (rng_debug_enable input is
                                                                    set).                                                      */

    struct {
      __IOM uint32_t EHRDATA    : 32;           /*!< [31..0] Contains the data collected in the TRNG[63_32]. Note:
                                                     can only be set while in debug mode (rng_debug_enable input
                                                     is set).                                                                  */
    } EHRDATA1_b;
  } ;

  union {
    __IOM uint32_t EHRDATA2;                    /*!< (@ 0x0000011C) This register contains the data collected in
                                                                    the TRNG[95_64]. Note: can only be set while
                                                                    in debug mode (rng_debug_enable input is
                                                                    set).                                                      */

    struct {
      __IOM uint32_t EHRDATA    : 32;           /*!< [31..0] Contains the data collected in the TRNG[95_64]. Note:
                                                     can only be set while in debug mode (rng_debug_enable input
                                                     is set).                                                                  */
    } EHRDATA2_b;
  } ;

  union {
    __IOM uint32_t EHRDATA3;                    /*!< (@ 0x00000120) This register contains the data collected in
                                                                    the TRNG[127_96]. Note: can only be set
                                                                    while in debug mode (rng_debug_enable input
                                                                    is set).                                                   */

    struct {
      __IOM uint32_t EHRDATA    : 32;           /*!< [31..0] Contains the data collected in the TRNG[127_96]. Note:
                                                     can only be set while in debug mode (rng_debug_enable input
                                                     is set).                                                                  */
    } EHRDATA3_b;
  } ;

  union {
    __IOM uint32_t EHRDATA4;                    /*!< (@ 0x00000124) This register contains the data collected in
                                                                    the TRNG[159_128]. Note: can only be set
                                                                    while in debug mode (rng_debug_enable input
                                                                    is set).                                                   */

    struct {
      __IOM uint32_t EHRDATA    : 32;           /*!< [31..0] Contains the data collected in the TRNG[159_128]. Note:
                                                     can only be set while in debug mode (rng_debug_enable input
                                                     is set).                                                                  */
    } EHRDATA4_b;
  } ;

  union {
    __IOM uint32_t EHRDATA5;                    /*!< (@ 0x00000128) This register contains the data collected in
                                                                    the TRNG[191_160]. Note: can only be set
                                                                    while in debug mode (rng_debug_enable input
                                                                    is set).                                                   */

    struct {
      __IOM uint32_t EHRDATA    : 32;           /*!< [31..0] Contains the data collected in the TRNG[191_160]. Note:
                                                     can only be set while in debug mode (rng_debug_enable input
                                                     is set).                                                                  */
    } EHRDATA5_b;
  } ;

  union {
    __IOM uint32_t RNDSOURCEENABLE;             /*!< (@ 0x0000012C) This register holds the enable signal for the
                                                                    random source.                                             */

    struct {
      __IOM uint32_t RNDSRCEN   : 1;            /*!< [0..0] Enable signal for the random source.                               */
            uint32_t            : 31;
    } RNDSOURCEENABLE_b;
  } ;

  union {
    __IOM uint32_t SAMPLECNT1;                  /*!< (@ 0x00000130) Counts clocks between sampling of random bit.              */

    struct {
      __IOM uint32_t SAMPLECNTR1 : 32;          /*!< [31..0] Sets the number of rng_clk cycles between two consecutive
                                                     ring oscillator samples. Note: If the Von-Neumann is bypassed,
                                                     the minimum value for sample counter must not be less than
                                                     decimal seventeen.                                                        */
    } SAMPLECNT1_b;
  } ;

  union {
    __IOM uint32_t AUTOCORRSTATISTIC;           /*!< (@ 0x00000134) Statistics about autocorrelation test activations.         */

    struct {
      __IOM uint32_t AUTOCORRTRYS : 14;         /*!< [13..0] Count each time an autocorrelation test starts. Any
                                                     write to the register resets the counter. Stops collecting
                                                     statistics if one of the counters has reached the limit.                  */
      __IOM uint32_t AUTOCORRFAILS : 8;         /*!< [21..14] Count each time an autocorrelation test fails. Any
                                                     write to the register resets the counter. Stops collecting
                                                     statistics if one of the counters has reached the limit.                  */
            uint32_t            : 10;
    } AUTOCORRSTATISTIC_b;
  } ;

  union {
    __IOM uint32_t TRNGDEBUGCONTROL;            /*!< (@ 0x00000138) This register is used to debug the TRNG                    */

    struct {
            uint32_t            : 1;
      __IOM uint32_t VNCBYPASS  : 1;            /*!< [1..1] When this bit is set, the Von-Neumann balancer is bypassed
                                                     (including the 32 consecutive bits test). Note: Can only
                                                     be set while in debug mode. If TRNG_TESTS_BYPASS_EN HW
                                                     flag is defined, this bit can be set while not in debug
                                                     mode.                                                                     */
      __IOM uint32_t TRNGCRNGTBYPASS : 1;       /*!< [2..2] When this bit is set, the CRNGT test in the TRNG is bypassed.
                                                     Note: Can only be set while in debug mode. If TRNG_TESTS_BYPASS_EN
                                                     HW flag is defined, this bit can be set while not in debug
                                                     mode.                                                                     */
      __IOM uint32_t AUTOCORRELATEBYPASS : 1;   /*!< [3..3] When this bit is set, the autocorrelation test in the
                                                     TRNG module is bypassed. Note: Can only be set while in
                                                     debug mode. If TRNG_TESTS_BYPASS_EN HW flag is defined,
                                                     this bit can be set while not in debug mode.                              */
            uint32_t            : 28;
    } TRNGDEBUGCONTROL_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t RNGSWRESET;                  /*!< (@ 0x00000140) Generate SW reset solely to RNG block.                     */

    struct {
      __IOM uint32_t RNGSWRESET : 1;            /*!< [0..0] Any value written (0x0 or 0x1) causes a reset cycle to
                                                     the TRNG block.                                                           */
            uint32_t            : 31;
    } RNGSWRESET_b;
  } ;
  __IM  uint32_t  RESERVED6[28];

  union {
    __IOM uint32_t RNGDEBUGENINPUT;             /*!< (@ 0x000001B4) Defines the RNG in debug mode                              */

    struct {
      __IOM uint32_t RNGDEBUGEN : 1;            /*!< [0..0] Reflects the rng_debug_enable input port                           */
            uint32_t            : 31;
    } RNGDEBUGENINPUT_b;
  } ;

  union {
    __IOM uint32_t RNGBUSY;                     /*!< (@ 0x000001B8) RNG busy indication                                        */

    struct {
      __IOM uint32_t RNGBUSY    : 1;            /*!< [0..0] Reflects rng_busy output port which Consists of trng_busy
                                                     and prng_busy.                                                            */
      __IOM uint32_t TRNGBUSY   : 1;            /*!< [1..1] Reflects trng_busy.                                                */
      __IOM uint32_t PRNGBUSY   : 1;            /*!< [2..2] Reflects prng_busy.                                                */
            uint32_t            : 29;
    } RNGBUSY_b;
  } ;

  union {
    __IOM uint32_t RSTBITSCOUNTER;              /*!< (@ 0x000001BC) Resets the counter of collected bits in the TRNG           */

    struct {
      __IOM uint32_t RSTBITSCOUNTER : 1;        /*!< [0..0] Writing any value to this address resets the bits counter
                                                     and trng valid registers.                                                 */
            uint32_t            : 31;
    } RSTBITSCOUNTER_b;
  } ;

  union {
    __IOM uint32_t RNGVERSION;                  /*!< (@ 0x000001C0) This register holds the RNG version                        */

    struct {
      __IOM uint32_t EHRWIDTH192 : 1;           /*!< [0..0] EHR width selection.                                               */
      __IOM uint32_t CRNGTEXISTS : 1;           /*!< [1..1] CRNGT exists.                                                      */
      __IOM uint32_t AUTOCORREXISTS : 1;        /*!< [2..2] Auto correct exists.                                               */
      __IOM uint32_t TRNGTESTSBYPASSEN : 1;     /*!< [3..3] TRNG tests bypass enable.                                          */
      __IOM uint32_t PRNGEXISTS : 1;            /*!< [4..4] PRNG Exists.                                                       */
      __IOM uint32_t KATEXISTS  : 1;            /*!< [5..5] KAT exists.                                                        */
      __IOM uint32_t RESEEDINGEXISTS : 1;       /*!< [6..6] Reseeding exists.                                                  */
      __IOM uint32_t RNGUSE5SBOXES : 1;         /*!< [7..7] RNG use 5 (or 20) SBOX AES                                         */
            uint32_t            : 24;
    } RNGVERSION_b;
  } ;

  union {
    __IOM uint32_t RNGCLKENABLE;                /*!< (@ 0x000001C4) Writing to this register enables_disables the
                                                                    RNG clock.                                                 */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] Writing value 0x1 enables RNG clock.                               */
            uint32_t            : 31;
    } RNGCLKENABLE_b;
  } ;

  union {
    __IOM uint32_t RNGDMAENABLE;                /*!< (@ 0x000001C8) Writing to this register enables_disables the
                                                                    RNG DMA.                                                   */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] Writing value 0x1 enables RNG DMA to SRAM. The Value
                                                     is cleared when DMA completes its operation.                              */
            uint32_t            : 31;
    } RNGDMAENABLE_b;
  } ;

  union {
    __IOM uint32_t RNGDMASRCMASK;               /*!< (@ 0x000001CC) This register defines which ring-oscillator length
                                                                    should be used when using the RNG DMA.                     */

    struct {
      __IOM uint32_t ENSRCSEL0  : 1;            /*!< [0..0] Writing value 0x1 enables SRC_SEL 0.                               */
      __IOM uint32_t ENSRCSEL1  : 1;            /*!< [1..1] Writing value 0x1 enables SRC_SEL 1.                               */
      __IOM uint32_t ENSRCSEL2  : 1;            /*!< [2..2] Writing value 0x1 enables SRC_SEL 2.                               */
      __IOM uint32_t ENSRCSEL3  : 1;            /*!< [3..3] Writing value 0x1 enables SRC_SEL 3.                               */
            uint32_t            : 28;
    } RNGDMASRCMASK_b;
  } ;

  union {
    __IOM uint32_t RNGDMASRAMADDR;              /*!< (@ 0x000001D0) This register defines the start address of the
                                                                    DMA for the TRNG data.                                     */

    struct {
      __IOM uint32_t RNGSRAMDMAADDR : 11;       /*!< [10..0] Defines the start address of the DMA for the TRNG data.           */
            uint32_t            : 21;
    } RNGDMASRAMADDR_b;
  } ;
  __IM  uint32_t  RESERVED7;

  union {
    __IOM uint32_t RNGWATCHDOGVAL;              /*!< (@ 0x000001D8) This register defines the number of 192-bits
                                                                    samples that the DMA collects per RNG configuration.bitfie
                                                                    d 7:0 RNG_SAMPLES_NUM rw 0x0 Defines the
                                                                    number of 192-bits samples that the DMA
                                                                    collects per RNG configuration.bitfield
                                                                    31:8 RESERVED rw 0x0 ReservedThis register
                                                                    defines the maximum number of clock cycles
                                                                    per TRNG collection of 192 samples. If the
                                                                    number of cycles for a collection exceeds
                                                                    this threshold, TRNG signals an interrupt.                 */

    struct {
      __IOM uint32_t RNGWATCHDOGVAL : 32;       /*!< [31..0] Defines the maximum number of clock cycles per TRNG
                                                     collection of 192 samples. If the number of cycles for
                                                     a collection exceeds this threshold, TRNG signals an interrupt.           */
    } RNGWATCHDOGVAL_b;
  } ;

  union {
    __IOM uint32_t RNGDMASTATUS;                /*!< (@ 0x000001DC) This register holds the RNG DMA status.                    */

    struct {
      __IOM uint32_t RNGDMABUSY : 1;            /*!< [0..0] Indicates whether DMA is busy.                                     */
      __IOM uint32_t DMASRCSEL  : 2;            /*!< [2..1] The active ring oscillator length using by DMA                     */
      __IOM uint32_t NUMOFSAMPLES : 8;          /*!< [10..3] Number of samples already collected in the current ring
                                                     oscillator chain length.                                                  */
            uint32_t            : 21;
    } RNGDMASTATUS_b;
  } ;
  __IM  uint32_t  RESERVED8[104];

  union {
    __IOM uint32_t CHACHACONTROLREG;            /*!< (@ 0x00000380) CHACHA general configuration.                              */

    struct {
      __IOM uint32_t CHACHAORSALSA : 1;         /*!< [0..0] Core:                                                              */
      __IOM uint32_t INITFROMHOST : 1;          /*!< [1..1] Start init for new Message:                                        */
      __IOM uint32_t CALCKEYFORPOLY1305 : 1;    /*!< [2..2] Only if ChaCha core:                                               */
      __IOM uint32_t KEYLEN     : 1;            /*!< [3..3] For All Core:                                                      */
      __IOM uint32_t NUMOFROUNDS : 2;           /*!< [5..4] The core of ChaCha is a hash function which based on
                                                     rotation operations. The hash function consist in application
                                                     of 20 rounds (default value). In additional, ChaCha have
                                                     two variants (they work exactly as the original algorithm):
                                                     ChaCha20_8 and ChaCha20_12 (using 8 and 12 rounds).                       */
            uint32_t            : 3;
      __IOM uint32_t RESETBLOCKCNT : 1;         /*!< [9..9] For new message                                                    */
      __IOM uint32_t USEIV96BIT : 1;            /*!< [10..10] If use 96bit IV                                                  */
            uint32_t            : 21;
    } CHACHACONTROLREG_b;
  } ;

  union {
    __IOM uint32_t CHACHAVERSION;               /*!< (@ 0x00000384) CHACHA Version                                             */

    struct {
      __IOM uint32_t CHACHAVERSION : 32;        /*!< [31..0] CHACHA version.                                                   */
    } CHACHAVERSION_b;
  } ;

  union {
    __IOM uint32_t CHACHAKEY0;                  /*!< (@ 0x00000388) bits 255:224 of CHACHA Key                                 */

    struct {
      __IOM uint32_t CHACHAKEY0 : 32;           /*!< [31..0] bits 255:224 of CHACHA Key                                        */
    } CHACHAKEY0_b;
  } ;

  union {
    __IOM uint32_t CHACHAKEY1;                  /*!< (@ 0x0000038C) bits 223:192 of CHACHA Key                                 */

    struct {
      __IOM uint32_t CHACHAKEY1 : 32;           /*!< [31..0] bits 223:192 of CHACHA Key                                        */
    } CHACHAKEY1_b;
  } ;

  union {
    __IOM uint32_t CHACHAKEY2;                  /*!< (@ 0x00000390) bits 191:160 of CHACHA Key                                 */

    struct {
      __IOM uint32_t CHACHAKEY2 : 32;           /*!< [31..0] bits191:160 of CHACHA Key                                         */
    } CHACHAKEY2_b;
  } ;

  union {
    __IOM uint32_t CHACHAKEY3;                  /*!< (@ 0x00000394) bits159:128 of CHACHA Key                                  */

    struct {
      __IOM uint32_t CHACHAKEY3 : 32;           /*!< [31..0] bits 159:128 of CHACHA Key                                        */
    } CHACHAKEY3_b;
  } ;

  union {
    __IOM uint32_t CHACHAKEY4;                  /*!< (@ 0x00000398) bits 127:96 of CHACHA Key                                  */

    struct {
      __IOM uint32_t CHACHAKEY4 : 32;           /*!< [31..0] bits 127:96 of CHACHA Key                                         */
    } CHACHAKEY4_b;
  } ;

  union {
    __IOM uint32_t CHACHAKEY5;                  /*!< (@ 0x0000039C) bits 95:64 of CHACHA Key                                   */

    struct {
      __IOM uint32_t CHACHAKEY5 : 32;           /*!< [31..0] bits 95:64 of CHACHA Key                                          */
    } CHACHAKEY5_b;
  } ;

  union {
    __IOM uint32_t CHACHAKEY6;                  /*!< (@ 0x000003A0) bits 63:32 of CHACHA Key                                   */

    struct {
      __IOM uint32_t CHACHAKEY6 : 32;           /*!< [31..0] bits 63:32 of CHACHA Key                                          */
    } CHACHAKEY6_b;
  } ;

  union {
    __IOM uint32_t CHACHAKEY7;                  /*!< (@ 0x000003A4) bits 31:0 of CHACHA Key                                    */

    struct {
      __IOM uint32_t CHACHAKEY7 : 32;           /*!< [31..0] bits 31:0 of CHACHA Key                                           */
    } CHACHAKEY7_b;
  } ;

  union {
    __IOM uint32_t CHACHAIV0;                   /*!< (@ 0x000003A8) bits 31:0 of CHACHA_IV0 register                           */

    struct {
      __IOM uint32_t CHACHAIV0  : 32;           /*!< [31..0] bits 31:0 of CHACHA_IV0 register                                  */
    } CHACHAIV0_b;
  } ;

  union {
    __IOM uint32_t CHACHAIV1;                   /*!< (@ 0x000003AC) bits 31:0 of CHACHA_IV1 register                           */

    struct {
      __IOM uint32_t CHACHAIV1  : 32;           /*!< [31..0] bits 31:0 of CHACHA_IV1 register                                  */
    } CHACHAIV1_b;
  } ;

  union {
    __IOM uint32_t CHACHABUSY;                  /*!< (@ 0x000003B0) This register is set when the CHACHA_SALSA core
                                                                    is active                                                  */

    struct {
      __IOM uint32_t CHACHABUSY : 1;            /*!< [0..0] CHACHA_BUSY Register. This register is set when the CHACHA_SALSA
                                                     core is active.                                                           */
            uint32_t            : 31;
    } CHACHABUSY_b;
  } ;

  union {
    __IOM uint32_t CHACHAHWFLAGS;               /*!< (@ 0x000003B4) This register holds the pre-synthesis HW flag
                                                                    configuration of the CHACHA_SALSA engine                   */

    struct {
      __IOM uint32_t CHACHAEXISTS : 1;          /*!< [0..0] If this flag is set, the Salsa_ChaCha engine include
                                                     ChaCha implementation:                                                    */
      __IOM uint32_t SALSAEXISTS : 1;           /*!< [1..1] If this flag is set, the Salsa_ChaCha engine include
                                                     Salsa implementation:                                                     */
      __IOM uint32_t FASTCHACHA : 1;            /*!< [2..2] If this flag is set, the next matrix calculated when
                                                     the current one is written to data output path (same flag
                                                     for Salsa core):                                                          */
            uint32_t            : 29;
    } CHACHAHWFLAGS_b;
  } ;

  union {
    __IOM uint32_t CHACHABLOCKCNTLSB;           /*!< (@ 0x000003B8) The two first words (n) in the last row of the
                                                                    cipher matrix are the block counter. At
                                                                    the end of each block (512b), the block_cnt
                                                                    for the next block is written by HW to the
                                                                    block_cnt_lsb and block_cnt_msb registers.
                                                                    Need reset block counter , if start new
                                                                    message.                                                   */

    struct {
      __IOM uint32_t CHACHABLOCKCNTLSB : 32;    /*!< [31..0] bits 31:0 of CHACHA_BLOCK_CNT_LSB register.                       */
    } CHACHABLOCKCNTLSB_b;
  } ;

  union {
    __IOM uint32_t CHACHABLOCKCNTMSB;           /*!< (@ 0x000003BC) The two first words (n) in the last row of the
                                                                    cipher matrix are the block counter. At
                                                                    the end of each block (512b), the block_cnt
                                                                    for the next block is written by HW to the
                                                                    block_cnt_lsb and block_cnt_msb registers.
                                                                    Need reset block counter , if start new
                                                                    message.                                                   */

    struct {
      __IOM uint32_t CHACHABLOCKCNTMSB : 32;    /*!< [31..0] bits 31:0 of CHACHA_BLOCK_CNT_MSB register.                       */
    } CHACHABLOCKCNTMSB_b;
  } ;

  union {
    __IOM uint32_t CHACHASWRESET;               /*!< (@ 0x000003C0) Resets CHACHA_SALSA engine.                                */

    struct {
      __IOM uint32_t CHACHSWRESET : 1;          /*!< [0..0] Writing to this address resets the only FSM of CHACHA
                                                     engine. The reset takes 4 CORE_CLK cycles.                                */
            uint32_t            : 31;
    } CHACHASWRESET_b;
  } ;

  union {
    __IOM uint32_t CHACHAFORPOLYKEY0;           /*!< (@ 0x000003C4) bits 255:224 of CHACHA_FOR_POLY_KEY                        */

    struct {
      __IOM uint32_t CHACHAFORPOLYKEY0 : 32;    /*!< [31..0] bits 255:224 of CHACHA_FOR_POLY_KEY                               */
    } CHACHAFORPOLYKEY0_b;
  } ;

  union {
    __IOM uint32_t CHACHAFORPOLYKEY1;           /*!< (@ 0x000003C8) bits 223:192 of CHACHA_FOR_POLY_KEY                        */

    struct {
      __IOM uint32_t CHACHAFORPOLYKEY1 : 32;    /*!< [31..0] bits 223:192 of CHACHA_FOR_POLY_KEY                               */
    } CHACHAFORPOLYKEY1_b;
  } ;

  union {
    __IOM uint32_t CHACHAFORPOLYKEY2;           /*!< (@ 0x000003CC) bits191:160 of CHACHA_FOR_POLY_KEY                         */

    struct {
      __IOM uint32_t CHACHAFORPOLYKEY2 : 32;    /*!< [31..0] bits191:160 of CHACHA_FOR_POLY_KEY                                */
    } CHACHAFORPOLYKEY2_b;
  } ;

  union {
    __IOM uint32_t CHACHAFORPOLYKEY3;           /*!< (@ 0x000003D0) bits159:128 of CHACHA_FOR_POLY_KEY                         */

    struct {
      __IOM uint32_t CHACHAFORPOLYKEY3 : 32;    /*!< [31..0] bits 159:128 of CHACHA_FOR_POLY_KEY                               */
    } CHACHAFORPOLYKEY3_b;
  } ;

  union {
    __IOM uint32_t CHACHAFORPOLYKEY4;           /*!< (@ 0x000003D4) bits 127:96 of CHACHA_FOR_POLY_KEY                         */

    struct {
      __IOM uint32_t CHACHAFORPOLYKEY4 : 32;    /*!< [31..0] bits 127:96 of CHACHA_FOR_POLY_KEY                                */
    } CHACHAFORPOLYKEY4_b;
  } ;

  union {
    __IOM uint32_t CHACHAFORPOLYKEY5;           /*!< (@ 0x000003D8) bits 95:64 of CHACHA_FOR_POLY_KEY                          */

    struct {
      __IOM uint32_t CHACHAFORPOLYKEY5 : 32;    /*!< [31..0] bits 95:64 of CHACHA_FOR_POLY_KEY                                 */
    } CHACHAFORPOLYKEY5_b;
  } ;

  union {
    __IOM uint32_t CHACHAFORPOLYKEY6;           /*!< (@ 0x000003DC) bits 63:32 of CHACHA_FOR_POLY_KEY                          */

    struct {
      __IOM uint32_t CHACHAFORPOLYKEY6 : 32;    /*!< [31..0] bits 63:32 of CHACHA_FOR_POLY_KEY                                 */
    } CHACHAFORPOLYKEY6_b;
  } ;

  union {
    __IOM uint32_t CHACHAFORPOLYKEY7;           /*!< (@ 0x000003E0) bits 31:0 of CHACHA_FOR_POLY_KEY                           */

    struct {
      __IOM uint32_t CHACHAFORPOLYKEY7 : 32;    /*!< [31..0] bits 31:0 of CHACHA_FOR_POLY_KEY                                  */
    } CHACHAFORPOLYKEY7_b;
  } ;

  union {
    __IOM uint32_t CHACHABYTEWORDORDERCNTLREG;  /*!< (@ 0x000003E4) CHACHA_SALSA DATA ORDER configuration.                     */

    struct {
      __IOM uint32_t CHACHADINWORDORDER : 1;    /*!< [0..0] Change the words order of the input data.                          */
      __IOM uint32_t CHACHADINBYTEORDER : 1;    /*!< [1..1] Change the byte order of the input data.                           */
      __IOM uint32_t CHACHACOREMATRIXLBEORDER : 1;/*!< [2..2] Change the quarter of a matrix order in core                     */
      __IOM uint32_t CHACHADOUTWORDORDER : 1;   /*!< [3..3] Change the words order of the output data.                         */
      __IOM uint32_t CHACHADOUTBYTEORDER : 1;   /*!< [4..4] Change the byte order of the output data.                          */
            uint32_t            : 27;
    } CHACHABYTEWORDORDERCNTLREG_b;
  } ;

  union {
    __IOM uint32_t CHACHADEBUGREG;              /*!< (@ 0x000003E8) This register is used to debug the CHACHA engine           */

    struct {
      __IOM uint32_t CHACHADEBUGFSMSTATE : 2;   /*!< [1..0] CHACHA_DEBUG_FSM_STATE                                             */
            uint32_t            : 30;
    } CHACHADEBUGREG_b;
  } ;
  __IM  uint32_t  RESERVED9[5];

  union {
    __IOM uint32_t AESKEY00;                    /*!< (@ 0x00000400) bits 31:0 of AES Key0 (used as the AES key in
                                                                    non-tunneling operations, and as the first
                                                                    tunnel stage key in tunneling operations).                 */

    struct {
      __IOM uint32_t AESKEY00   : 32;           /*!< [31..0] bits 31:0 of AES Key0.                                            */
    } AESKEY00_b;
  } ;

  union {
    __IOM uint32_t AESKEY01;                    /*!< (@ 0x00000404) bits 63:32 of AES Key0 (used as the AES key in
                                                                    non-tunneling operations, and as the first
                                                                    tunnel stage key in tunneling operations).                 */

    struct {
      __IOM uint32_t AESKEY01   : 32;           /*!< [31..0] bits 63:32 of AES Key0.                                           */
    } AESKEY01_b;
  } ;

  union {
    __IOM uint32_t AESKEY02;                    /*!< (@ 0x00000408) bits 95:64 of AES Key0 (used as the AES key in
                                                                    non-tunneling operations, and as the first
                                                                    tunnel stage key in tunneling operations).                 */

    struct {
      __IOM uint32_t AESKEY02   : 32;           /*!< [31..0] bits 95:64 of AES Key0.                                           */
    } AESKEY02_b;
  } ;

  union {
    __IOM uint32_t AESKEY03;                    /*!< (@ 0x0000040C) bits 127:96 of AES Key0 (used as the AES key
                                                                    in non-tunneling operations, and as the
                                                                    first tunnel stage key in tunneling operations).           */

    struct {
      __IOM uint32_t AESKEY03   : 32;           /*!< [31..0] bits 127:96 of AES Key0.                                          */
    } AESKEY03_b;
  } ;

  union {
    __IOM uint32_t AESKEY04;                    /*!< (@ 0x00000410) bits 159:128 of AES Key0 (used as the AES key
                                                                    in non-tunneling operations, and as the
                                                                    first tunnel stage key in tunneling operations).           */

    struct {
      __IOM uint32_t AESKEY04   : 32;           /*!< [31..0] bits 159:128 of AES Key0 .                                        */
    } AESKEY04_b;
  } ;

  union {
    __IOM uint32_t AESKEY05;                    /*!< (@ 0x00000414) bits 191:160 of AES Key0 (used as the AES key
                                                                    in non-tunneling operations, and as the
                                                                    first tunnel stage key in tunneling operations).           */

    struct {
      __IOM uint32_t AESKEY05   : 32;           /*!< [31..0] bits 191:160 of AES Key0.                                         */
    } AESKEY05_b;
  } ;

  union {
    __IOM uint32_t AESKEY06;                    /*!< (@ 0x00000418) bits 223:192 of AES Key0 (used as the AES key
                                                                    in non-tunneling operations, and as the
                                                                    first tunnel stage key in tunneling operations).           */

    struct {
      __IOM uint32_t AESKEY06   : 32;           /*!< [31..0] bits 223:192 of AES Key0.                                         */
    } AESKEY06_b;
  } ;

  union {
    __IOM uint32_t AESKEY07;                    /*!< (@ 0x0000041C) bits 255:224 of AES Key0 (used as the AES key
                                                                    in non-tunneling operations, and as the
                                                                    first tunnel stage key in tunneling operations).           */

    struct {
      __IOM uint32_t AESKEY07   : 32;           /*!< [31..0] bits 255:224 of AES Key0.                                         */
    } AESKEY07_b;
  } ;

  union {
    __IOM uint32_t AESKEY10;                    /*!< (@ 0x00000420) bits 31:0 of AES Key1 (used as the second AES
                                                                    tunnel stage key in tunneling operations).                 */

    struct {
      __IOM uint32_t AESKEY10   : 32;           /*!< [31..0] bits 31:0 of AES Key1.                                            */
    } AESKEY10_b;
  } ;

  union {
    __IOM uint32_t AESKEY11;                    /*!< (@ 0x00000424) bits 63:32 of AES Key1 (used as the second AES
                                                                    tunnel stage key in tunneling operations).                 */

    struct {
      __IOM uint32_t AESKEY11   : 32;           /*!< [31..0] bits 63:32 of AES Key1.                                           */
    } AESKEY11_b;
  } ;

  union {
    __IOM uint32_t AESKEY12;                    /*!< (@ 0x00000428) bits 95:64 of AES Key1 (used as the second AES
                                                                    tunnel stage key in tunneling operations).                 */

    struct {
      __IOM uint32_t AESKEY12   : 32;           /*!< [31..0] bits 95:64 of AES Key1.                                           */
    } AESKEY12_b;
  } ;

  union {
    __IOM uint32_t AESKEY13;                    /*!< (@ 0x0000042C) bits 127:96 of AES Key1 (used as the second AES
                                                                    tunnel stage key in tunneling operations).                 */

    struct {
      __IOM uint32_t AESKEY13   : 32;           /*!< [31..0] bits 127:96 of AES Key1.                                          */
    } AESKEY13_b;
  } ;

  union {
    __IOM uint32_t AESKEY14;                    /*!< (@ 0x00000430) bits 159:128 of AES Key1 (used as the second
                                                                    AES tunnel stage key in tunneling operations).             */

    struct {
      __IOM uint32_t AESKEY14   : 32;           /*!< [31..0] bits 159:128 of AES Key1.                                         */
    } AESKEY14_b;
  } ;

  union {
    __IOM uint32_t AESKEY15;                    /*!< (@ 0x00000434) bits 191:160 of AES Key1 (used as the second
                                                                    AES tunnel stage key in tunneling operations).             */

    struct {
      __IOM uint32_t AESKEY15   : 32;           /*!< [31..0] bits 191:160 of AES Key1.                                         */
    } AESKEY15_b;
  } ;

  union {
    __IOM uint32_t AESKEY16;                    /*!< (@ 0x00000438) bits 223:192 of AES Key1 (used as the second
                                                                    AES tunnel stage key in tunneling operations).             */

    struct {
      __IOM uint32_t AESKEY16   : 32;           /*!< [31..0] bits 223:192 of AES Key1.                                         */
    } AESKEY16_b;
  } ;

  union {
    __IOM uint32_t AESKEY17;                    /*!< (@ 0x0000043C) bits 255:224 of AES Key1 (used as the second
                                                                    AES tunnel stage key in tunneling operations).             */

    struct {
      __IOM uint32_t AESKEY17   : 32;           /*!< [31..0] bits 255:224 of AES Key1.                                         */
    } AESKEY17_b;
  } ;

  union {
    __IOM uint32_t AESIV00;                     /*!< (@ 0x00000440) bits 31:0 of AES_IV0 register. AES IV0 is used
                                                                    as the AES IV (Initialization Value) register
                                                                    in non-tunneling operations,and as the first
                                                                    tunnel stage IV register in tunneling operations.The
                                                                    IV register should be loaded according to
                                                                    the AES mode:in AES CBC_CBC-MAC - the AES
                                                                    IV register should be loaded with the IV
                                                                    (initialization vector).in XTS-AES - the
                                                                    AES IV register should be loaded with the
                                                                    T value (unless the HW T calculation mode
                                                                    is active, in which the T value is calculated
                                                                    by the HW                                                  */

    struct {
      __IOM uint32_t AESIV00    : 32;           /*!< [31..0] bits 31:0 of AES_IV0 register.                                    */
    } AESIV00_b;
  } ;

  union {
    __IOM uint32_t AESIV01;                     /*!< (@ 0x00000444) bits 63:32 of AES_IV0 128b register.For the description
                                                                    of AES_IV0, see the AES_IV_0_0 register
                                                                    description                                                */

    struct {
      __IOM uint32_t AESIV01    : 32;           /*!< [31..0] bits 63:32 of AES_IV0 register.                                   */
    } AESIV01_b;
  } ;

  union {
    __IOM uint32_t AESIV02;                     /*!< (@ 0x00000448) bits 95:64 of AES_IV0 128b register.For the description
                                                                    of AES_IV0, see the AES_IV_0_0 register
                                                                    description                                                */

    struct {
      __IOM uint32_t AESIV02    : 32;           /*!< [31..0] bits 95:64 of AES_IV0 register.                                   */
    } AESIV02_b;
  } ;

  union {
    __IOM uint32_t AESIV03;                     /*!< (@ 0x0000044C) bits 127:96 of AES_IV0 128b register.For the
                                                                    description of AES_IV0, see the AES_IV_0_0
                                                                    register description                                       */

    struct {
      __IOM uint32_t AESIV03    : 32;           /*!< [31..0] bits 127:96 of AES_IV0 register.                                  */
    } AESIV03_b;
  } ;

  union {
    __IOM uint32_t AESIV10;                     /*!< (@ 0x00000450) bits 31:0 of AES_IV1 128b register.AES IV1 is
                                                                    used as the AES IV (Initialization Value)
                                                                    register as the second tunnel stage IV register
                                                                    in tunneling operations.The IV register
                                                                    should be loaded according to the AES mode:in
                                                                    AES CBC_CBC-MAC - the AES IV register should
                                                                    be loaded with the IV (initialization vector).in
                                                                    XTS-AES - the AES IV register should be
                                                                    loaded with the T value (unless the HW T
                                                                    calculation mode is active, in which the
                                                                    T value is calculated by the HW.                           */

    struct {
      __IOM uint32_t AESIV10    : 32;           /*!< [31..0] bits 31:0 of AES_IV1 register.                                    */
    } AESIV10_b;
  } ;

  union {
    __IOM uint32_t AESIV11;                     /*!< (@ 0x00000454) bits 63:32 of AES_IV1 128b register.For the description
                                                                    of AES_IV1, see the AES_IV_1_0 register
                                                                    description                                                */

    struct {
      __IOM uint32_t AESIV11    : 32;           /*!< [31..0] bits 63:32 of AES_IV1 register.                                   */
    } AESIV11_b;
  } ;

  union {
    __IOM uint32_t AESIV12;                     /*!< (@ 0x00000458) bits 95:64 of AES_IV1 128b register.For the description
                                                                    of AES_IV1, see the AES_IV_1_0 register
                                                                    description                                                */

    struct {
      __IOM uint32_t AESIV12    : 32;           /*!< [31..0] bits 95:64 of AES_IV1 register.                                   */
    } AESIV12_b;
  } ;

  union {
    __IOM uint32_t AESIV13;                     /*!< (@ 0x0000045C) bits 127:96 of AES_IV1 128b register.For the
                                                                    description of AES_IV1, see the AES_IV_1_0
                                                                    register description                                       */

    struct {
      __IOM uint32_t AESIV13    : 32;           /*!< [31..0] bits 127:96 of AES_IV1 register.                                  */
    } AESIV13_b;
  } ;

  union {
    __IOM uint32_t AESCTR00;                    /*!< (@ 0x00000460) bits 31:0 of AES_CTR0 128b register.AES CTR0
                                                                    is used as the AES CTR (counter) register
                                                                    in non-tunneling operations, and as the
                                                                    first tunnel stage CTR register in tunneling
                                                                    operations.The CTR register should be loaded
                                                                    according to the AES mode:in AES CTR_GCTR
                                                                    - the AES CTR register should be loaded
                                                                    with the counter value.in XTS-AES - the
                                                                    AES CTR register should be loaded with the
                                                                    i value (in order to calculate the T value
                                                                    from it, if HW T calculation is supported).                */

    struct {
      __IOM uint32_t AESCTR00   : 32;           /*!< [31..0] bits 31:0 of AES_CTR0 register.                                   */
    } AESCTR00_b;
  } ;

  union {
    __IOM uint32_t AESCTR01;                    /*!< (@ 0x00000464) bits 63:32 of AES_CTR0 128b register.For the
                                                                    description of AES_CTR0, see the AES_CTR_0_0
                                                                    register description.                                      */

    struct {
      __IOM uint32_t AESCTR01   : 32;           /*!< [31..0] bits 63:32 of AES_CTR0 register.                                  */
    } AESCTR01_b;
  } ;

  union {
    __IOM uint32_t AESCTR02;                    /*!< (@ 0x00000468) bits 95:64 of AES_CTR0 128b register.For the
                                                                    description of AES_CTR0, see the AES_CTR_0_0
                                                                    register description.                                      */

    struct {
      __IOM uint32_t AESCTR02   : 32;           /*!< [31..0] bits 95:64 of AES_CTR0 register.                                  */
    } AESCTR02_b;
  } ;

  union {
    __IOM uint32_t AESCTR03;                    /*!< (@ 0x0000046C) bits 127:96 of AES_CTR0 128b register.For the
                                                                    description of AES_CTR0, see the AES_CTR_0_0
                                                                    register description.                                      */

    struct {
      __IOM uint32_t AESCTR03   : 32;           /*!< [31..0] bits 127:96 of AES_CTR0 register.                                 */
    } AESCTR03_b;
  } ;

  union {
    __IOM uint32_t AESBUSY;                     /*!< (@ 0x00000470) This register is set when the AES core is active           */

    struct {
      __IOM uint32_t AESBUSY    : 1;            /*!< [0..0] AES_BUSY register. This register is set when the AES
                                                     core is active                                                            */
            uint32_t            : 31;
    } AESBUSY_b;
  } ;
  __IM  uint32_t  RESERVED10;

  union {
    __IOM uint32_t AESSK;                       /*!< (@ 0x00000478) writing to this address causes sampling of the
                                                                    HW key to the AES_KEY0 register                            */

    struct {
      __IOM uint32_t AESSK      : 1;            /*!< [0..0] writing to this address causes sampling of the HW key
                                                     to the AES_KEY0 register                                                  */
            uint32_t            : 31;
    } AESSK_b;
  } ;

  union {
    __IOM uint32_t AESCMACINIT;                 /*!< (@ 0x0000047C) Writing to this address triggers the AES engine
                                                                    generating of K1 and K2 for AES CMAC operations.
                                                                    Note: This is a special register, affected
                                                                    by internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t AESCMACINIT : 1;           /*!< [0..0] Writing to this address starts the generating of K1 and
                                                     K2 for AES CMAC operations                                                */
            uint32_t            : 31;
    } AESCMACINIT_b;
  } ;
  __IM  uint32_t  RESERVED11[13];

  union {
    __IOM uint32_t AESSK1;                      /*!< (@ 0x000004B4) writing to this address causes sampling of the
                                                                    HW key to the AES_KEY1 register                            */

    struct {
      __IOM uint32_t AESSK1     : 1;            /*!< [0..0] writing to this address causes sampling of the HW key
                                                     to the AES_KEY1 register                                                  */
            uint32_t            : 31;
    } AESSK1_b;
  } ;
  __IM  uint32_t  RESERVED12;

  union {
    __IOM uint32_t AESREMAININGBYTES;           /*!< (@ 0x000004BC) This register should be set with the amount of
                                                                    remaining bytes until the end of the current
                                                                    AES operation. The AES engine counts down
                                                                    from this value to determine the last _
                                                                    one before last blocks in AES CMAC, XTS
                                                                    AES and AES CCM.                                           */

    struct {
      __IOM uint32_t AESREMAININGBYTES : 32;    /*!< [31..0] This register should be set with the amount of remaining
                                                     bytes until the end of the current AES operation. The AES
                                                     engine counts down from this value to determine the last
                                                     _ one before last blocks in AES CMAC, XTS AES and AES CCM.                */
    } AESREMAININGBYTES_b;
  } ;

  union {
    __IOM uint32_t AESCONTROL;                  /*!< (@ 0x000004C0) This register holds the configuration of the
                                                                    AES engine. Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
      __IOM uint32_t DECKEY0    : 1;            /*!< [0..0] This field determines whether the AES performs Decrypt_Encrypt
                                                     operations, in non-tunneling operations:                                  */
      __IOM uint32_t MODE0ISCBCCTS : 1;         /*!< [1..1] If MODE_KEY0 is set to 3b001 (CBC), and this field is
                                                     set - the mode is CBC-CTS. In addition, If MODE_KEY0 is
                                                     set to 3b010 (CTR), and this field is set - the mode is
                                                     GCTR.                                                                     */
      __IOM uint32_t MODEKEY0   : 3;            /*!< [4..2] This field determines the AES mode in non tunneling operations,
                                                     and the AES mode of the first stage in tunneling operations:              */
      __IOM uint32_t MODEKEY1   : 3;            /*!< [7..5] This field determines the AES mode of the second stage
                                                     operation in tunneling operations:                                        */
      __IOM uint32_t CBCISESSIV : 1;            /*!< [8..8] If MODE_KEY0 is set to 3b001 (CBC), and this field is
                                                     set - the mode is CBC with ESSIV.                                         */
            uint32_t            : 1;
      __IOM uint32_t AESTUNNELISON : 1;         /*!< [10..10] This field determines whether the AES performs dual-tunnel
                                                     operations or standard non-tunneling operations:                          */
      __IOM uint32_t CBCISBITLOCKER : 1;        /*!< [11..11] If MODE_KEY0 is set to 3b001 (CBC), and this field
                                                     is set - the mode isBITLOCKER.                                            */
      __IOM uint32_t NKKEY0     : 2;            /*!< [13..12] This field determines the AES Key length in non tunneling
                                                     operations, and the AES key length of the first stage in
                                                     tunneling operations:                                                     */
      __IOM uint32_t NKKEY1     : 2;            /*!< [15..14] This field determines the AES key length of the second
                                                     stage operation in tunneling operations:                                  */
            uint32_t            : 6;
      __IOM uint32_t AESTUNNEL1DECRYPT : 1;     /*!< [22..22] This field determines whether the second tunnel stage
                                                     performs encrypt or decrypt operation :                                   */
      __IOM uint32_t AESTUNB1USESPADDEDDATAIN : 1;/*!< [23..23] This field determines, for tunneling operations, the
                                                     data that is fed to the second tunneling stage:                           */
      __IOM uint32_t AESTUNNEL0ENCRYPT : 1;     /*!< [24..24] This field determines whether the first tunnel stage
                                                     performs encrypt or decrypt operation :                                   */
      __IOM uint32_t AESOUTPUTMIDTUNNELDATA : 1;/*!< [25..25] This fields determines whether the AES output is the
                                                     result of the first or second tunneling stage:                            */
      __IOM uint32_t AESTUNNELB1PADEN : 1;      /*!< [26..26] This field determines whether the input data to the
                                                     second tunnel stage is padded with zeroes (according to
                                                     the remaining_bytes value) or not:                                        */
            uint32_t            : 1;
      __IOM uint32_t AESOUTMIDTUNTOHASH : 1;    /*!< [28..28] This field determines for AES-TO-HASH-AND-DOUT tunneling
                                                     operations, whether the AES outputs to the HASH the result
                                                     of the first or the second tunneling stage:                               */
      __IOM uint32_t AESXORCRYPTOKEY : 1;       /*!< [29..29] This field determines the value that is written to
                                                     AES_KEY0, when AES_SK is kicked:                                          */
            uint32_t            : 1;
      __IOM uint32_t DIRECTACCESS : 1;          /*!< [31..31] Using direct access and not the din-dout interface               */
    } AESCONTROL_b;
  } ;
  __IM  uint32_t  RESERVED13;

  union {
    __IOM uint32_t AESHWFLAGS;                  /*!< (@ 0x000004C8) This register holds the pre-synthesis HW flag
                                                                    configuration of the AES engine                            */

    struct {
      __IOM uint32_t SUPPORT256192KEY : 1;      /*!< [0..0] the SUPPORT_256_192_KEY flag                                       */
      __IOM uint32_t AESLARGERKEK : 1;          /*!< [1..1] the AES_LARGE_RKEK flag                                            */
      __IOM uint32_t DPACNTRMSREXIST : 1;       /*!< [2..2] the DPA_CNTRMSR_EXIST flag                                         */
      __IOM uint32_t CTREXIST   : 1;            /*!< [3..3] the CTR_EXIST flag                                                 */
      __IOM uint32_t ONLYENCRYPT : 1;           /*!< [4..4] the ONLY_ENCRYPT flag                                              */
      __IOM uint32_t USESBOXTABLE : 1;          /*!< [5..5] the USE_SBOX_TABLE flag                                            */
            uint32_t            : 2;
      __IOM uint32_t USE5SBOXES : 1;            /*!< [8..8] the USE_5_SBOXES flag                                              */
      __IOM uint32_t AESSUPPORTPREVIV : 1;      /*!< [9..9] the AES_SUPPORT_PREV_IV flag                                       */
      __IOM uint32_t aestunnelexists : 1;       /*!< [10..10] the aes_tunnel_exists flag                                       */
      __IOM uint32_t SECONDREGSSETEXIST : 1;    /*!< [11..11] the SECOND_REGS_SET_EXIST flag                                   */
      __IOM uint32_t DFACNTRMSREXIST : 1;       /*!< [12..12] the DFA_CNTRMSR_EXIST flag                                       */
            uint32_t            : 19;
    } AESHWFLAGS_b;
  } ;
  __IM  uint32_t  RESERVED14[3];

  union {
    __IOM uint32_t AESCTRNOINCREMENT;           /*!< (@ 0x000004D8) This register enables the AES CTR no increment
                                                                    mode (in which the counter mode is not incremented
                                                                    between 2 blocks)                                          */

    struct {
      __IOM uint32_t AESCTRNOINCREMENT : 1;     /*!< [0..0] This field enables the AES CTR 'no increment' mode (in
                                                     which the counter mode is not incremented between 2 blocks)               */
            uint32_t            : 31;
    } AESCTRNOINCREMENT_b;
  } ;
  __IM  uint32_t  RESERVED15[5];

  union {
    __IOM uint32_t AESDFAISON;                  /*!< (@ 0x000004F0) This register disable_enable the AES dfa. Note:
                                                                    This is a special register, affected by
                                                                    internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t AESDFAISON : 1;            /*!< [0..0] writing to this register turns the DFA counter-measures
                                                     on. this register exists only if DFA countermeasures are
                                                     supported                                                                 */
            uint32_t            : 31;
    } AESDFAISON_b;
  } ;
  __IM  uint32_t  RESERVED16;

  union {
    __IOM uint32_t AESDFAERRSTATUS;             /*!< (@ 0x000004F8) dfa error status register.                                 */

    struct {
      __IOM uint32_t AESDFAERRSTATUS : 1;       /*!< [0..0] after a DFA violation this register is set and the AES
                                                     block is disabled) until the next reset. this register
                                                     only exists if DFA countermeasures is are supported                       */
            uint32_t            : 31;
    } AESDFAERRSTATUS_b;
  } ;
  __IM  uint32_t  RESERVED17[10];

  union {
    __IOM uint32_t AESCMACSIZE0KICK;            /*!< (@ 0x00000524) writing to this address triggers the AES engine
                                                                    to perform a CMAC operation with size 0.
                                                                    The CMAC result can be read from the AES_IV0
                                                                    register.                                                  */

    struct {
      __IOM uint32_t AESCMACSIZE0KICK : 1;      /*!< [0..0] writing to this address triggers the AES engine to perform
                                                     a CMAC operation with size 0. The CMAC result can be read
                                                     from the AES_IV0 register.                                                */
            uint32_t            : 31;
    } AESCMACSIZE0KICK_b;
  } ;
  __IM  uint32_t  RESERVED18[70];

  union {
    __IOM uint32_t HASHH0;                      /*!< (@ 0x00000640) H0 data. can only be written in the following
                                                                    HASH_CONTROL modes: MD5 SHA1 SHA224 SHA256
                                                                    SHA384 SHA512                                              */

    struct {
      __IOM uint32_t HASHH0     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH0_b;
  } ;

  union {
    __IOM uint32_t HASHH1;                      /*!< (@ 0x00000644) H1 data. can only be written in the following
                                                                    HASH_CONTROL modes: MD5 SHA1 SHA224 SHA256
                                                                    SHA384 SHA512                                              */

    struct {
      __IOM uint32_t HASHH1     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH1_b;
  } ;

  union {
    __IOM uint32_t HASHH2;                      /*!< (@ 0x00000648) H2 data. can only be written in the following
                                                                    HASH_CONTROL modes: MD5 SHA1 SHA224 SHA256
                                                                    SHA384 SHA512                                              */

    struct {
      __IOM uint32_t HASHH2     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH2_b;
  } ;

  union {
    __IOM uint32_t HASHH3;                      /*!< (@ 0x0000064C) H3 data. can only be written in the following
                                                                    HASH_CONTROL modes: MD5 SHA1 SHA224 SHA256
                                                                    SHA384 SHA512                                              */

    struct {
      __IOM uint32_t HASHH3     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH3_b;
  } ;

  union {
    __IOM uint32_t HASHH4;                      /*!< (@ 0x00000650) H4 data. can only be written in the following
                                                                    HASH_CONTROL modes: SHA1 SHA224 SHA256 SHA384
                                                                    SHA512                                                     */

    struct {
      __IOM uint32_t HASHH4     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH4_b;
  } ;

  union {
    __IOM uint32_t HASHH5;                      /*!< (@ 0x00000654) H5 data. can only be written in the following
                                                                    HASH_CONTROL modes: SHA224 SHA256 SHA384
                                                                    SHA512                                                     */

    struct {
      __IOM uint32_t HASHH5     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH5_b;
  } ;

  union {
    __IOM uint32_t HASHH6;                      /*!< (@ 0x00000658) H6 data. can only be written in the following
                                                                    HASH_CONTROL modes: SHA224 SHA256 SHA384
                                                                    SHA512                                                     */

    struct {
      __IOM uint32_t HASHH6     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH6_b;
  } ;

  union {
    __IOM uint32_t HASHH7;                      /*!< (@ 0x0000065C) H7 data. can only be written in the following
                                                                    HASH_CONTROL modes: SHA224 SHA256 SHA384
                                                                    SHA512                                                     */

    struct {
      __IOM uint32_t HASHH7     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH7_b;
  } ;

  union {
    __IOM uint32_t HASHH8;                      /*!< (@ 0x00000660) H8 data. can only be written in the following
                                                                    HASH_CONTROL modes: SHA384 SHA512                          */

    struct {
      __IOM uint32_t HASHH8     : 32;           /*!< [31..0] 1) Write initial Hash value.                                      */
    } HASHH8_b;
  } ;
  __IM  uint32_t  RESERVED19[8];

  union {
    __IOM uint32_t AUTOHWPADDING;               /*!< (@ 0x00000684) HW padding automatically activated by engine.
                                                                    For the special case of ZERO bytes data
                                                                    vector this register should not be used!
                                                                    instead use HASH_PAD_CFG                                   */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] 0x1 - Enable Automatic HW padding (No need for SW intervention
                                                     by writing PAD_CFG). Note: Not supported for 0 bytes !
                                                     Note: Disable this register when HASH op is done                          */
            uint32_t            : 31;
    } AUTOHWPADDING_b;
  } ;

  union {
    __IOM uint32_t HASHXORDIN;                  /*!< (@ 0x00000688) This register is always xored with the input
                                                                    to the hash engine,it should be 0 if xored
                                                                    is not reqiured .                                          */

    struct {
      __IOM uint32_t HASHXORDATA : 32;          /*!< [31..0] This register holds the value to be xor-ed with hash
                                                     input data.                                                               */
    } HASHXORDIN_b;
  } ;
  __IM  uint32_t  RESERVED20[2];

  union {
    __IOM uint32_t LOADINITSTATE;               /*!< (@ 0x00000694) Indication to HASH that the following data is
                                                                    to be loaded into initial value registers
                                                                    in HASH(H0:H15) or IV to AES MAC                           */

    struct {
      __IOM uint32_t LOAD       : 1;            /*!< [0..0] Load data to initial state registers. digest_iv for hash_aes_mac.
                                                     When done loading data this bit should be reset                           */
            uint32_t            : 31;
    } LOADINITSTATE_b;
  } ;
  __IM  uint32_t  RESERVED21[3];

  union {
    __IOM uint32_t HASHSELAESMAC;               /*!< (@ 0x000006A4) select the AES MAC module rather than the hash
                                                                    module                                                     */

    struct {
      __IOM uint32_t HASHSELAESMAC : 1;         /*!< [0..0] Hash or AES MAC module select.                                     */
      __IOM uint32_t GHASHSEL   : 1;            /*!< [1..1] GHASH select.                                                      */
            uint32_t            : 30;
    } HASHSELAESMAC_b;
  } ;
  __IM  uint32_t  RESERVED22[66];

  union {
    __IOM uint32_t HASHVERSION;                 /*!< (@ 0x000007B0) HASH VERSION Register                                      */

    struct {
      __IOM uint32_t FIXES      : 8;            /*!< [7..0] Fixes field.                                                       */
      __IOM uint32_t MINORVERSIONNUMBER : 4;    /*!< [11..8] minor version number                                              */
      __IOM uint32_t MAJORVERSIONNUMBER : 4;    /*!< [15..12] major version number                                             */
            uint32_t            : 16;
    } HASHVERSION_b;
  } ;
  __IM  uint32_t  RESERVED23[3];

  union {
    __IOM uint32_t HASHCONTROL;                 /*!< (@ 0x000007C0) Selects which HASH mode to run                             */

    struct {
      __IOM uint32_t MODE01     : 2;            /*!< [1..0] bits 1:0 of the HASH mode field. The hash mode field
                                                     possible values are:                                                      */
            uint32_t            : 1;
      __IOM uint32_t MODE3      : 1;            /*!< [3..3] bit 3 of the HASH mode field. The hash mode field possible
                                                     values are:4b0000 - MD5 if present 0x0001 SHA 1 4b0010
                                                     - SHA-256 4b1010 - SHA-224                                                */
            uint32_t            : 28;
    } HASHCONTROL_b;
  } ;

  union {
    __IOM uint32_t HASHPADEN;                   /*!< (@ 0x000007C4) Enables the hash hw padding.                               */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] 0x1 : Enable generation of padding by HW Pad block. 0x0
                                                     : Disable generation of padding by HW Pad block.                          */
            uint32_t            : 31;
    } HASHPADEN_b;
  } ;

  union {
    __IOM uint32_t HASHPADCFG;                  /*!< (@ 0x000007C8) This is a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
            uint32_t            : 2;
      __IOM uint32_t DOPAD      : 1;            /*!< [2..2] Enable Padding generation. must be reset upon completion
                                                     of padding.                                                               */
            uint32_t            : 29;
    } HASHPADCFG_b;
  } ;

  union {
    __IOM uint32_t HASHCURLEN0;                 /*!< (@ 0x000007CC) This register holds the length of current hash
                                                                    operation bit 31:0.                                        */

    struct {
      __IOM uint32_t Length     : 32;           /*!< [31..0] Represent the current length of valid bits where digest
                                                     need to be computed In Bytes.                                             */
    } HASHCURLEN0_b;
  } ;

  union {
    __IOM uint32_t HASHCURLEN1;                 /*!< (@ 0x000007D0) This register holds the length of current hash
                                                                    operation bit 63:32.                                       */

    struct {
      __IOM uint32_t Length     : 32;           /*!< [31..0] Represent the current length of valid bits where digest
                                                     need to be computed In Bytes.                                             */
    } HASHCURLEN1_b;
  } ;
  __IM  uint32_t  RESERVED24[2];

  union {
    __IOM uint32_t HASHPARAM;                   /*!< (@ 0x000007DC) HASH_PARAM Register.                                       */

    struct {
      __IOM uint32_t CW         : 4;            /*!< [3..0] Indicates the number of concurrent words the hash is
                                                     using to compute signature. 1 - One concurrent w(t). 2
                                                     - Two concurrent w(t).                                                    */
      __IOM uint32_t CH         : 4;            /*!< [7..4] Indicate if Hi adders are present for each Hi value or
                                                     1 adder is shared for all Hi. 0 - One Hi value is updated
                                                     at a time 1 - All Hi values are updated at the same time.                 */
      __IOM uint32_t DW         : 4;            /*!< [11..8] Determine the granularity of word size. 0 - 32 bit word
                                                     data. 1 - 64 bit word data.                                               */
      __IOM uint32_t SHA512EXISTS : 1;          /*!< [12..12] Indicate if SHA-512 is present in the design. By default
                                                     SHA-1 and SHA-256 are present. 0 - SHA-1 and SHA-256 are
                                                     present only 1 - SHA-1 and all SHA-2 are present (SHA-256
                                                     SHA-512).                                                                 */
      __IOM uint32_t PADEXISTS  : 1;            /*!< [13..13] Indicate if pad block is present in the design. 0 -
                                                     pad function is not supported by hardware. 1 - pad function
                                                     is supported by hardware.                                                 */
      __IOM uint32_t MD5EXISTS  : 1;            /*!< [14..14] Indicate if MD5 is present in HW                                 */
      __IOM uint32_t HMACEXISTS : 1;            /*!< [15..15] Indicate if HMAC logic is present in the design                  */
      __IOM uint32_t SHA256EXISTS : 1;          /*!< [16..16] Indicate if SHA-256 is present in the design                     */
      __IOM uint32_t HASHCOMPAREEXISTS : 1;     /*!< [17..17] Indicate if COMPARE digest logic is present in the
                                                     design                                                                    */
      __IOM uint32_t DUMPHASHTODOUTEXISTS : 1;  /*!< [18..18] Indicate if HASH to dout is present in the design                */
            uint32_t            : 13;
    } HASHPARAM_b;
  } ;
  __IM  uint32_t  RESERVED25;

  union {
    __IOM uint32_t HASHAESSWRESET;              /*!< (@ 0x000007E4) Software reset of the AES.                                 */

    struct {
      __IOM uint32_t HASHAESSWRESET : 1;        /*!< [0..0] Hash receive reset internally.                                     */
            uint32_t            : 31;
    } HASHAESSWRESET_b;
  } ;

  union {
    __IOM uint32_t HASHENDIANESS;               /*!< (@ 0x000007E8) This register holds the HASH_ENDIANESS configuration.      */

    struct {
      __IOM uint32_t ENDIAN     : 1;            /*!< [0..0] The default value is little-endian. The data and generation
                                                     of padding can be swapped to be big-endian.                               */
            uint32_t            : 31;
    } HASHENDIANESS_b;
  } ;
  __IM  uint32_t  RESERVED26[9];

  union {
    __IOM uint32_t AESCLKENABLE;                /*!< (@ 0x00000810) This is a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] Enable the AES clock.                                              */
            uint32_t            : 31;
    } AESCLKENABLE_b;
  } ;
  __IM  uint32_t  RESERVED27;

  union {
    __IOM uint32_t HASHCLKENABLE;               /*!< (@ 0x00000818) The HASH clock enable register. Note: This is
                                                                    a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] Enable the hash clock.                                             */
            uint32_t            : 31;
    } HASHCLKENABLE_b;
  } ;

  union {
    __IOM uint32_t PKACLKENABLE;                /*!< (@ 0x0000081C) The PKA clock enable register. Note: This is
                                                                    a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] Enable the PKA clock.                                              */
            uint32_t            : 31;
    } PKACLKENABLE_b;
  } ;

  union {
    __IOM uint32_t DMACLKENABLE;                /*!< (@ 0x00000820) DMA_CLK enable register. Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] Enable the DMA clock.                                              */
            uint32_t            : 31;
    } DMACLKENABLE_b;
  } ;

  union {
    __IOM uint32_t CLKSTATUS;                   /*!< (@ 0x00000824) The CryptoCell clocks status register. Note:
                                                                    This is a special register, affected by
                                                                    internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t AESCLKSTATUS : 1;          /*!< [0..0] Status of AES clock enable.                                        */
            uint32_t            : 1;
      __IOM uint32_t HASHCLKSTATUS : 1;         /*!< [2..2] Status of HASH clock clock enable.                                 */
      __IOM uint32_t PKACLKSTATUS : 1;          /*!< [3..3] Status of PKA clock enable.                                        */
            uint32_t            : 3;
      __IOM uint32_t CHACHACLKSTATUS : 1;       /*!< [7..7] Status of CHACHA clock enable.                                     */
      __IOM uint32_t DMACLKSTATUS : 1;          /*!< [8..8] Status of DMA clock enable.                                        */
            uint32_t            : 23;
    } CLKSTATUS_b;
  } ;
  __IM  uint32_t  RESERVED28[12];

  union {
    __IOM uint32_t CHACHACLKENABLE;             /*!< (@ 0x00000858) CHACHA _SALSA clock enable register. Note: This
                                                                    is a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t EN         : 1;            /*!< [0..0] Enable the CHACHA SALSA clock enable.                              */
            uint32_t            : 31;
    } CHACHACLKENABLE_b;
  } ;
  __IM  uint32_t  RESERVED29[41];

  union {
    __IOM uint32_t CRYPTOCTL;                   /*!< (@ 0x00000900) Defines the cryptographic flow.                            */

    struct {
      __IOM uint32_t MODE       : 5;            /*!< [4..0] Determines the active cryptographic engine:                        */
            uint32_t            : 27;
    } CRYPTOCTL_b;
  } ;
  __IM  uint32_t  RESERVED30[3];

  union {
    __IOM uint32_t CRYPTOBUSY;                  /*!< (@ 0x00000910) This register is set when the cryptographic core
                                                                    is busy.                                                   */

    struct {
      __IOM uint32_t CRYPTOBUSY : 1;            /*!< [0..0] Crypto busy status.                                                */
            uint32_t            : 31;
    } CRYPTOBUSY_b;
  } ;
  __IM  uint32_t  RESERVED31[2];

  union {
    __IOM uint32_t HASHBUSY;                    /*!< (@ 0x0000091C) This register is set when the Hash engine is
                                                                    busy.                                                      */

    struct {
      __IOM uint32_t HASHBUSY   : 1;            /*!< [0..0] Hash busy status.                                                  */
            uint32_t            : 31;
    } HASHBUSY_b;
  } ;
  __IM  uint32_t  RESERVED32[4];

  union {
    __IOM uint32_t CONTEXTID;                   /*!< (@ 0x00000930) A general RD_WR register. For Firmware use.                */

    struct {
      __IOM uint32_t CONTEXTID  : 8;            /*!< [7..0] Context ID                                                         */
            uint32_t            : 24;
    } CONTEXTID_b;
  } ;
  __IM  uint32_t  RESERVED33[11];

  union {
    __IOM uint32_t GHASHSUBKEY00;               /*!< (@ 0x00000960) Bits 31:0 of GHASH Key0 (used as the GHASH module
                                                                    key).                                                      */

    struct {
      __IOM uint32_t GHASHSUBKEY00 : 32;        /*!< [31..0] Bits 31:0 of GHASH Key0.                                          */
    } GHASHSUBKEY00_b;
  } ;

  union {
    __IOM uint32_t GHASHSUBKEY01;               /*!< (@ 0x00000964) Bits 63:32 of GHASH Key0 (used as the GHASH module
                                                                    key).                                                      */

    struct {
      __IOM uint32_t GHASHSUBKEY01 : 32;        /*!< [31..0] Bits 63:32 of GHASH Key0.                                         */
    } GHASHSUBKEY01_b;
  } ;

  union {
    __IOM uint32_t GHASHSUBKEY02;               /*!< (@ 0x00000968) Bits 95:64 of GHASH Key0 (used as the GHASH module
                                                                    key).                                                      */

    struct {
      __IOM uint32_t GHASHSUBKEY02 : 32;        /*!< [31..0] Bits 95:64 of GHASH Key0.                                         */
    } GHASHSUBKEY02_b;
  } ;

  union {
    __IOM uint32_t GHASHSUBKEY03;               /*!< (@ 0x0000096C) Bits 127:96 of GHASH Key0 (used as the GHASH
                                                                    module key).                                               */

    struct {
      __IOM uint32_t GHASHSUBKEY03 : 32;        /*!< [31..0] Bits 127:96 of GHASH Key0.                                        */
    } GHASHSUBKEY03_b;
  } ;

  union {
    __IOM uint32_t GHASHIV00;                   /*!< (@ 0x00000970) Bits 31:0 of GHASH_IV0 register. GHASH IV0 is
                                                                    used as the GHASH IV (Initialization Value)
                                                                    register.                                                  */

    struct {
      __IOM uint32_t GHASHIV00  : 32;           /*!< [31..0] Bits 31:0 of GHASH_IV0 register of the GHASH module.
                                                     For the description of GHASH_IV0, see the GHASH_0_0 register
                                                     description                                                               */
    } GHASHIV00_b;
  } ;

  union {
    __IOM uint32_t GHASHIV01;                   /*!< (@ 0x00000974) Bits 63:32 of GHASH_IV0 register. GHASH IV0 is
                                                                    used as the GHASH IV (Initialization Value)
                                                                    register.                                                  */

    struct {
      __IOM uint32_t GHASHIV01  : 32;           /*!< [31..0] Bits 63:32 of GHASH_IV0 register of the GHASH module.             */
    } GHASHIV01_b;
  } ;

  union {
    __IOM uint32_t GHASHIV02;                   /*!< (@ 0x00000978) Bits 95:64 of GHASH_IV0 register. GHASH IV0 is
                                                                    used as the GHASH IV (Initialization Value)
                                                                    register.                                                  */

    struct {
      __IOM uint32_t GHASHIV02  : 32;           /*!< [31..0] Bits 95:64 of GHASH_IV0 register of the GHASH module.             */
    } GHASHIV02_b;
  } ;

  union {
    __IOM uint32_t GHASHIV03;                   /*!< (@ 0x0000097C) Bits 127:96 of GHASH_IV0 register.GHASH IV0 is
                                                                    used as the GHASH IV (Initialization Value)
                                                                    register.                                                  */

    struct {
      __IOM uint32_t GHASHIV03  : 32;           /*!< [31..0] Bits 127:96 of GHASH_IV0 register of the GHASH module.            */
    } GHASHIV03_b;
  } ;

  union {
    __IOM uint32_t GHASHBUSY;                   /*!< (@ 0x00000980) The GHASH module GHASH_BUSY Register. This register
                                                                    is set when the GHASH core is active.                      */

    struct {
      __IOM uint32_t GHASHBUSY  : 1;            /*!< [0..0] GHASH_BUSY Register. This register is set when the GHASH
                                                     core is active                                                            */
            uint32_t            : 31;
    } GHASHBUSY_b;
  } ;

  union {
    __IOM uint32_t GHASHINIT;                   /*!< (@ 0x00000984) Writing to this address sets the GHASH engine
                                                                    to be ready to a new GHASH operation.                      */

    struct {
      __IOM uint32_t GHASHINIT  : 1;            /*!< [0..0] Writing to this address sets the GHASH engine to be ready
                                                     to a new GHASH operation.                                                 */
            uint32_t            : 31;
    } GHASHINIT_b;
  } ;
  __IM  uint32_t  RESERVED34[30];

  union {
    __IOM uint32_t HOSTRGFIRR;                  /*!< (@ 0x00000A00) The Interrupt Request register. Each bit of this
                                                                    register holds the interrupt status of a
                                                                    single interrupt source.                                   */

    struct {
            uint32_t            : 4;
      __IOM uint32_t SRAMTODININT : 1;          /*!< [4..4] The SRAM to DIN DMA done interrupt status. This interrupt
                                                     is asserted when all data was delivered to DIN buffer from
                                                     SRAM.                                                                     */
      __IOM uint32_t DOUTTOSRAMINT : 1;         /*!< [5..5] The DOUT to SRAM DMA done interrupt status. This interrupt
                                                     is asserted when all data was delivered to SRAM buffer
                                                     from DOUT.                                                                */
      __IOM uint32_t MEMTODININT : 1;           /*!< [6..6] The memory to DIN DMA done interrupt status. This interrupt
                                                     is asserted when all data was delivered to DIN buffer from
                                                     memory.                                                                   */
      __IOM uint32_t DOUTTOMEMINT : 1;          /*!< [7..7] The DOUT to memory DMA done interrupt status. This interrupt
                                                     is asserted when all data was delivered to memory buffer
                                                     from DOUT.                                                                */
      __IOM uint32_t AHBERRINT  : 1;            /*!< [8..8] The AXI error interrupt status.                                    */
      __IOM uint32_t PKAEXPINT  : 1;            /*!< [9..9] The PKA end of operation interrupt status.                         */
      __IOM uint32_t RNGINT     : 1;            /*!< [10..10] The RNG interrupt status.                                        */
      __IOM uint32_t SYMDMACOMPLETED : 1;       /*!< [11..11] The GPR interrupt status.                                        */
            uint32_t            : 20;
    } HOSTRGFIRR_b;
  } ;

  union {
    __IOM uint32_t HOSTRGFIMR;                  /*!< (@ 0x00000A04) The Interrupt Mask register. Each bit of this
                                                                    register holds the mask of a single interrupt
                                                                    source.                                                    */

    struct {
            uint32_t            : 4;
      __IOM uint32_t SRAMTODINMASK : 1;         /*!< [4..4] The SRAM to DIN DMA done interrupt mask.                           */
      __IOM uint32_t DOUTTOSRAMMASK : 1;        /*!< [5..5] The DOUT to SRAM DMA done interrupt mask.                          */
      __IOM uint32_t MEMTODINMASK : 1;          /*!< [6..6] The memory to DIN DMA done interrupt mask.                         */
      __IOM uint32_t DOUTTOMEMMASK : 1;         /*!< [7..7] The DOUT to memory DMA done interrupt mask.                        */
      __IOM uint32_t AXIERRMASK : 1;            /*!< [8..8] The AXI error interrupt mask.                                      */
      __IOM uint32_t PKAEXPMASK : 1;            /*!< [9..9] The PKA end of operation interrupt mask.                           */
      __IOM uint32_t RNGINTMASK : 1;            /*!< [10..10] The RNG interrupt mask.                                          */
      __IOM uint32_t SYMDMACOMPLETEDMASK : 1;   /*!< [11..11] The GPR interrupt mask.                                          */
            uint32_t            : 20;
    } HOSTRGFIMR_b;
  } ;

  union {
    __IOM uint32_t HOSTRGFICR;                  /*!< (@ 0x00000A08) Interrupt Clear Register.                                  */

    struct {
            uint32_t            : 4;
      __IOM uint32_t SRAMTODINCLEAR : 1;        /*!< [4..4] The SRAM to DIN DMA done interrupt clear.                          */
      __IOM uint32_t DOUTTOSRAMCLEAR : 1;       /*!< [5..5] The DOUT to SRAM DMA done interrupt clear.                         */
      __IOM uint32_t MEMTODINCLEAR : 1;         /*!< [6..6] The memory to DIN DMA done interrupt clear.                        */
      __IOM uint32_t DOUTTOMEMCLEAR : 1;        /*!< [7..7] The DOUT to memory DMA done interrupt clear.                       */
      __IOM uint32_t AXIERRCLEAR : 1;           /*!< [8..8] The AXI error interrupt clear.                                     */
      __IOM uint32_t PKAEXPCLEAR : 1;           /*!< [9..9] The PKA end of operation interrupt clear.                          */
      __IOM uint32_t RNGINTCLEAR : 1;           /*!< [10..10] The RNG interrupt clear.                                         */
      __IOM uint32_t SYMDMACOMPLETEDCLEAR : 1;  /*!< [11..11] The GPR interrupt clear.                                         */
            uint32_t            : 20;
    } HOSTRGFICR_b;
  } ;

  union {
    __IOM uint32_t HOSTRGFENDIAN;               /*!< (@ 0x00000A0C) This register defines the endianness of the Host-accessible
                                                                    registers. Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
            uint32_t            : 3;
      __IOM uint32_t DOUTWRBG   : 1;            /*!< [3..3] DOUT write endianness:                                             */
            uint32_t            : 3;
      __IOM uint32_t DINRDBG    : 1;            /*!< [7..7] DIN write endianness:                                              */
            uint32_t            : 3;
      __IOM uint32_t DOUTWRWBG  : 1;            /*!< [11..11] DOUT write word endianness:                                      */
            uint32_t            : 3;
      __IOM uint32_t DINRDWBG   : 1;            /*!< [15..15] DIN write word endianness:                                       */
            uint32_t            : 16;
    } HOSTRGFENDIAN_b;
  } ;
  __IM  uint32_t  RESERVED35[5];

  union {
    __IOM uint32_t HOSTRGFSIGNATURE;            /*!< (@ 0x00000A24) This register holds the CryptoCell product signature.      */

    struct {
      __IOM uint32_t HOSTSIGNATURE : 32;        /*!< [31..0] Identification 'signature': always returns a fixed value,
                                                     used by Host driver to verify CryptoCell presence at this
                                                     address.                                                                  */
    } HOSTRGFSIGNATURE_b;
  } ;

  union {
    __IOM uint32_t HOSTBOOT;                    /*!< (@ 0x00000A28) This register holds the values of CryptoCells
                                                                    pre-synthesis flags                                        */

    struct {
      __IOM uint32_t SYNTHESISCONFIG : 1;       /*!< [0..0] POWER_GATING_EXISTS_LOCAL                                          */
      __IOM uint32_t LARGERKEKLOCAL : 1;        /*!< [1..1] LARGE_RKEK_LOCAL                                                   */
      __IOM uint32_t HASHINFUSESLOCAL : 1;      /*!< [2..2] HASH_IN_FUSES_LOCAL                                                */
      __IOM uint32_t EXTMEMSECUREDLOCAL : 1;    /*!< [3..3] EXT_MEM_SECURED_LOCAL                                              */
            uint32_t            : 1;
      __IOM uint32_t RKEKECCEXISTSLOCALN : 1;   /*!< [5..5] RKEK_ECC_EXISTS_LOCAL_N                                            */
      __IOM uint32_t SRAMSIZELOCAL : 3;         /*!< [8..6] SRAM_SIZE_LOCAL                                                    */
      __IOM uint32_t DSCRPTREXISTSLOCAL : 1;    /*!< [9..9] DSCRPTR_EXISTS_LOCAL                                               */
      __IOM uint32_t PAUEXISTSLOCAL : 1;        /*!< [10..10] PAU_EXISTS_LOCAL                                                 */
      __IOM uint32_t RNGEXISTSLOCAL : 1;        /*!< [11..11] RNG_EXISTS_LOCAL                                                 */
      __IOM uint32_t PKAEXISTSLOCAL : 1;        /*!< [12..12] PKA_EXISTS_LOCAL                                                 */
      __IOM uint32_t RC4EXISTSLOCAL : 1;        /*!< [13..13] RC4_EXISTS_LOCAL                                                 */
      __IOM uint32_t SHA512PRSNTLOCAL : 1;      /*!< [14..14] SHA_512_PRSNT_LOCAL                                              */
      __IOM uint32_t SHA256PRSNTLOCAL : 1;      /*!< [15..15] SHA_256_PRSNT_LOCAL                                              */
      __IOM uint32_t MD5PRSNTLOCAL : 1;         /*!< [16..16] MD5_PRSNT_LOCAL                                                  */
      __IOM uint32_t HASHEXISTSLOCAL : 1;       /*!< [17..17] HASH_EXISTS_LOCAL                                                */
      __IOM uint32_t C2EXISTSLOCAL : 1;         /*!< [18..18] C2_EXISTS_LOCAL                                                  */
      __IOM uint32_t DESEXISTSLOCAL : 1;        /*!< [19..19] DES_EXISTS_LOCAL                                                 */
      __IOM uint32_t AESXCBCMACEXISTSLOCAL : 1; /*!< [20..20] AES_XCBC_MAC_EXISTS_LOCAL                                        */
      __IOM uint32_t AESCMACEXISTSLOCAL : 1;    /*!< [21..21] AES_CMAC_EXISTS_LOCAL                                            */
      __IOM uint32_t AESCCMEXISTSLOCAL : 1;     /*!< [22..22] AES_CCM_EXISTS_LOCAL                                             */
      __IOM uint32_t AESXEXHWTCALCLOCAL : 1;    /*!< [23..23] AES_XEX_HW_T_CALC_LOCAL                                          */
      __IOM uint32_t AESXEXEXISTSLOCAL : 1;     /*!< [24..24] AES_XEX_EXISTS_LOCAL                                             */
      __IOM uint32_t CTREXISTSLOCAL : 1;        /*!< [25..25] CTR_EXISTS_LOCAL                                                 */
      __IOM uint32_t AESDINBYTERESOLUTIONLOCAL : 1;/*!< [26..26] AES_DIN_BYTE_RESOLUTION_LOCAL                                 */
      __IOM uint32_t TUNNELINGENBLOCAL : 1;     /*!< [27..27] TUNNELING_ENB_LOCAL                                              */
      __IOM uint32_t SUPPORT256192KEYLOCAL : 1; /*!< [28..28] SUPPORT_256_192_KEY_LOCAL                                        */
      __IOM uint32_t ONLYENCRYPTLOCAL : 1;      /*!< [29..29] ONLY_ENCRYPT_LOCAL                                               */
      __IOM uint32_t AESEXISTSLOCAL : 1;        /*!< [30..30] AES_EXISTS_LOCAL                                                 */
            uint32_t            : 1;
    } HOSTBOOT_b;
  } ;
  __IM  uint32_t  RESERVED36[3];

  union {
    __IOM uint32_t HOSTCRYPTOKEYSEL;            /*!< (@ 0x00000A38) AES hardware key select. Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
      __IOM uint32_t SELCRYPTOKEY : 3;          /*!< [2..0] Select the source of the HW key that is used by the AES
                                                     engine:                                                                   */
            uint32_t            : 29;
    } HOSTCRYPTOKEYSEL_b;
  } ;
  __IM  uint32_t  RESERVED37[15];

  union {
    __IOM uint32_t HOSTCORECLKGATINGENABLE;     /*!< (@ 0x00000A78) This register enables the core clk gating by
                                                                    masking_enabling the cc_idle_state output
                                                                    signal.                                                    */

    struct {
      __IOM uint32_t HOSTCORECLKGATINGENABLE : 1;/*!< [0..0] Enable the core clk gating,                                       */
            uint32_t            : 31;
    } HOSTCORECLKGATINGENABLE_b;
  } ;

  union {
    __IOM uint32_t HOSTCCISIDLE;                /*!< (@ 0x00000A7C) This register holds the idle indication of CC
                                                                    . Note: This is a special register, affected
                                                                    by internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t HOSTCCISIDLE : 1;          /*!< [0..0] Read if CC is idle.                                                */
      __IOM uint32_t HOSTCCISIDLEEVENT : 1;     /*!< [1..1] The event that indicates that CC is idle.                          */
      __IOM uint32_t SYMISBUSY  : 1;            /*!< [2..2] symetric flow is busy                                              */
      __IOM uint32_t AHBISIDLE  : 1;            /*!< [3..3] ahb stste machine is idle                                          */
      __IOM uint32_t NVMARBISIDLE : 1;          /*!< [4..4] nvm arbiter is idle                                                */
      __IOM uint32_t NVMISIDLE  : 1;            /*!< [5..5] nvm is idle                                                        */
      __IOM uint32_t FATALWR    : 1;            /*!< [6..6] fatal write                                                        */
      __IOM uint32_t RNGISIDLE  : 1;            /*!< [7..7] rng is idle                                                        */
      __IOM uint32_t PKAISIDLE  : 1;            /*!< [8..8] pka is idle                                                        */
      __IOM uint32_t CRYPTOISIDLE : 1;          /*!< [9..9] crypto flow is done                                                */
            uint32_t            : 22;
    } HOSTCCISIDLE_b;
  } ;

  union {
    __IOM uint32_t HOSTPOWERDOWN;               /*!< (@ 0x00000A80) This register start the power-down sequence.
                                                                    Note: This is a special register, affected
                                                                    by internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t HOSTPOWERDOWN : 1;         /*!< [0..0] Power down enable register.                                        */
            uint32_t            : 31;
    } HOSTPOWERDOWN_b;
  } ;

  union {
    __IOM uint32_t HOSTREMOVEGHASHENGINE;       /*!< (@ 0x00000A84) These inputs are to be statically tied to 0 or
                                                                    1 by the customers. When such an input is
                                                                    set, the matching engines inputs are tied
                                                                    to zero and its outputs are disconnected,
                                                                    so that the engine will be entirely removed
                                                                    by Synthesis                                               */

    struct {
      __IOM uint32_t HOSTREMOVEGHASHENGINE : 1; /*!< [0..0] Read the Remove_chacha_engine input                                */
            uint32_t            : 31;
    } HOSTREMOVEGHASHENGINE_b;
  } ;

  union {
    __IOM uint32_t HOSTREMOVECHACHAENGINE;      /*!< (@ 0x00000A88) These inputs are to be statically tied to 0 or
                                                                    1 by the customers. When such an input is
                                                                    set, the matching engines inputs are tied
                                                                    to zero and its outputs are disconnected,
                                                                    so that the engine will be entirely removed
                                                                    by Synthesis                                               */

    struct {
      __IOM uint32_t HOSTREMOVECHACHAENGINE : 1;/*!< [0..0] Read the Remove_ghash_engine input                                 */
            uint32_t            : 31;
    } HOSTREMOVECHACHAENGINE_b;
  } ;
  __IM  uint32_t  RESERVED38[29];

  union {
    __IOM uint32_t AHBMSINGLES;                 /*!< (@ 0x00000B00) This register forces the ahb transactions to
                                                                    be always singles.                                         */

    struct {
      __IOM uint32_t AHBSINGLES : 1;            /*!< [0..0] Force ahb singles                                                  */
            uint32_t            : 31;
    } AHBMSINGLES_b;
  } ;

  union {
    __IOM uint32_t AHBMHPROT;                   /*!< (@ 0x00000B04) This register holds the ahb prot value                     */

    struct {
      __IOM uint32_t AHBPROT    : 4;            /*!< [3..0] The ahb prot value                                                 */
            uint32_t            : 28;
    } AHBMHPROT_b;
  } ;

  union {
    __IOM uint32_t AHBMHMASTLOCK;               /*!< (@ 0x00000B08) This register holds ahb hmastlock value                    */

    struct {
      __IOM uint32_t AHBHMASTLOCK : 1;          /*!< [0..0] The hmastlock value.                                               */
            uint32_t            : 31;
    } AHBMHMASTLOCK_b;
  } ;

  union {
    __IOM uint32_t AHBMHNONSEC;                 /*!< (@ 0x00000B0C) This register holds ahb hnonsec value                      */

    struct {
      __IOM uint32_t AHBWRITEHNONSEC : 1;       /*!< [0..0] The hnonsec value for write transaction.                           */
      __IOM uint32_t AHBREADHNONSEC : 1;        /*!< [1..1] The hnonsec value for read transaction.                            */
            uint32_t            : 30;
    } AHBMHNONSEC_b;
  } ;
  __IM  uint32_t  RESERVED39[60];

  union {
    __IOM uint32_t DINBUFFER;                   /*!< (@ 0x00000C00) This address can be used by the CPU to write
                                                                    data directly to the DIN buffer to be sent
                                                                    to engines.                                                */

    struct {
      __IOM uint32_t DINBUFFERDATA : 32;        /*!< [31..0] This register is mapped into 8 addresses in order to
                                                     enable a CPU burst.                                                       */
    } DINBUFFER_b;
  } ;
  __IM  uint32_t  RESERVED40[7];

  union {
    __IOM uint32_t DINMEMDMABUSY;               /*!< (@ 0x00000C20) Indicates whether memory (AXI) source DMA (DIN)
                                                                    is busy.                                                   */

    struct {
      __IOM uint32_t DINMEMDMABUSY : 1;         /*!< [0..0] DIN memory DMA busy                                                */
            uint32_t            : 31;
    } DINMEMDMABUSY_b;
  } ;
  __IM  uint32_t  RESERVED41;

  union {
    __IOM uint32_t SRCLLIWORD0;                 /*!< (@ 0x00000C28) This register is used in direct LLI mode - holds
                                                                    the location of the data source in the memory
                                                                    (AXI).                                                     */

    struct {
      __IOM uint32_t SRCLLIWORD0 : 32;          /*!< [31..0] Source address within memory.                                     */
    } SRCLLIWORD0_b;
  } ;

  union {
    __IOM uint32_t SRCLLIWORD1;                 /*!< (@ 0x00000C2C) This register is used in direct LLI mode - holds
                                                                    the number of bytes to be read from the
                                                                    memory (AXI). Writing to this register triggers
                                                                    the DMA. Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
      __IOM uint32_t BYTESNUM   : 30;           /*!< [29..0] Total number of bytes to read using DMA in this entry             */
      __IOM uint32_t FIRST      : 1;            /*!< [30..30] 0x1 - Indicates the first LLI entry                              */
      __IOM uint32_t LAST       : 1;            /*!< [31..31] 0x1 - Indicates the last LLI entry                               */
    } SRCLLIWORD1_b;
  } ;

  union {
    __IOM uint32_t SRAMSRCADDR;                 /*!< (@ 0x00000C30) Location of data (start address) to be read from
                                                                    SRAM. Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
      __IOM uint32_t SRAMSOURCE : 32;           /*!< [31..0] SRAM source base address of data                                  */
    } SRAMSRCADDR_b;
  } ;

  union {
    __IOM uint32_t DINSRAMBYTESLEN;             /*!< (@ 0x00000C34) This register holds the size of the data (in
                                                                    bytes) to be read from the SRAM. Note: This
                                                                    is a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t BYTESLEN   : 32;           /*!< [31..0] Size of data to read from SRAM (bytes). This is the
                                                     trigger to the SRAM SRC DMA.                                              */
    } DINSRAMBYTESLEN_b;
  } ;

  union {
    __IOM uint32_t DINSRAMDMABUSY;              /*!< (@ 0x00000C38) This register holds the status of the SRAM DMA
                                                                    DIN.                                                       */

    struct {
      __IOM uint32_t BUSY       : 1;            /*!< [0..0] DIN SRAM DMA busy:                                                 */
            uint32_t            : 31;
    } DINSRAMDMABUSY_b;
  } ;

  union {
    __IOM uint32_t DINSRAMENDIANNESS;           /*!< (@ 0x00000C3C) This register defines the endianness of the DIN
                                                                    interface to SRAM.                                         */

    struct {
      __IOM uint32_t SRAMDINENDIANNESS : 1;     /*!< [0..0] Defines the endianness of DIN interface to SRAM:                   */
            uint32_t            : 31;
    } DINSRAMENDIANNESS_b;
  } ;
  __IM  uint32_t  RESERVED42[2];

  union {
    __IOM uint32_t DINCPUDATASIZE;              /*!< (@ 0x00000C48) This register hold the number of bytes to be
                                                                    transmited using external DMA. Note: This
                                                                    is a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t CPUDINSIZE : 16;           /*!< [15..0] When using external DMA, the size of transmited data
                                                     in bytes should be written to this register.                              */
            uint32_t            : 16;
    } DINCPUDATASIZE_b;
  } ;
  __IM  uint32_t  RESERVED43;

  union {
    __IOM uint32_t FIFOINEMPTY;                 /*!< (@ 0x00000C50) DIN FIFO empty indication                                  */

    struct {
      __IOM uint32_t EMPTY      : 1;            /*!< [0..0] 0x1 - FIFO empty                                                   */
            uint32_t            : 31;
    } FIFOINEMPTY_b;
  } ;
  __IM  uint32_t  RESERVED44;

  union {
    __IOM uint32_t DINFIFORSTPNTR;              /*!< (@ 0x00000C58) Writing to this register resets the DIN_FIFO
                                                                    pointers.                                                  */

    struct {
      __IOM uint32_t RST        : 1;            /*!< [0..0] Writing any value to this address resets the DIN_FIFO
                                                     pointers.                                                                 */
            uint32_t            : 31;
    } DINFIFORSTPNTR_b;
  } ;
  __IM  uint32_t  RESERVED45[41];

  union {
    __IOM uint32_t DOUTBUFFER;                  /*!< (@ 0x00000D00) Cryptographic result - CPU can directly access
                                                                    it. Note: This is a special register, affected
                                                                    by internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t DATA       : 32;           /*!< [31..0] DOUT This address can be used by the CPU to read data
                                                     directly from the DOUT buffer.                                            */
    } DOUTBUFFER_b;
  } ;
  __IM  uint32_t  RESERVED46[7];

  union {
    __IOM uint32_t DOUTMEMDMABUSY;              /*!< (@ 0x00000D20) DOUT memory DMA busy - Indicates that memory
                                                                    (AXI) destination DMA (DOUT) is busy,                      */

    struct {
      __IOM uint32_t DOUTMEMDMABUSY : 1;        /*!< [0..0] DOUT memory DMA busy:                                              */
            uint32_t            : 31;
    } DOUTMEMDMABUSY_b;
  } ;
  __IM  uint32_t  RESERVED47;

  union {
    __IOM uint32_t DSTLLIWORD0;                 /*!< (@ 0x00000D28) This register is used in direct LLI mode - holds
                                                                    the location of the data destination in
                                                                    the memory (AXI)                                           */

    struct {
      __IOM uint32_t DSTLLIWORD0 : 32;          /*!< [31..0] Destination address within memory                                 */
    } DSTLLIWORD0_b;
  } ;

  union {
    __IOM uint32_t DSTLLIWORD1;                 /*!< (@ 0x00000D2C) This register is used in direct LLI mode - holds
                                                                    the number of bytes to be written to the
                                                                    memory (AXI). Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
      __IOM uint32_t BYTESNUM   : 30;           /*!< [29..0] Total byte number to be written by DMA in this entry              */
      __IOM uint32_t FIRST      : 1;            /*!< [30..30] 0x1 - Indicates the first LLI entry                              */
      __IOM uint32_t LAST       : 1;            /*!< [31..31] 0x1 - Indicates the last LLI entry                               */
    } DSTLLIWORD1_b;
  } ;

  union {
    __IOM uint32_t SRAMDESTADDR;                /*!< (@ 0x00000D30) Location of result to be sent to in SRAM. Note:
                                                                    This is a special register, affected by
                                                                    internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t SRAMDEST   : 32;           /*!< [31..0] SRAM destination base address for data.                           */
    } SRAMDESTADDR_b;
  } ;

  union {
    __IOM uint32_t DOUTSRAMBYTESLEN;            /*!< (@ 0x00000D34) This register holds the size of the data (in
                                                                    bytes) to be written to the SRAM. Note:
                                                                    This is a special register, affected by
                                                                    internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t BYTESLEN   : 32;           /*!< [31..0] Size of data to write to SRAM (bytes). This is the trigger
                                                     to the SRAM DST DMA.                                                      */
    } DOUTSRAMBYTESLEN_b;
  } ;

  union {
    __IOM uint32_t DOUTSRAMDMABUSY;             /*!< (@ 0x00000D38) This register holds the status of the SRAM DMA
                                                                    DOUT.                                                      */

    struct {
      __IOM uint32_t BUSY       : 1;            /*!< [0..0] DOUT SRAM DMA busy status.                                         */
            uint32_t            : 31;
    } DOUTSRAMDMABUSY_b;
  } ;

  union {
    __IOM uint32_t DOUTSRAMENDIANNESS;          /*!< (@ 0x00000D3C) This register defines the endianness of the DOUT
                                                                    interface from SRAM.                                       */

    struct {
      __IOM uint32_t DOUTSRAMENDIANNESS : 1;    /*!< [0..0] Defines the endianness of DOUT interface from SRAM:                */
            uint32_t            : 31;
    } DOUTSRAMENDIANNESS_b;
  } ;
  __IM  uint32_t  RESERVED48;

  union {
    __IOM uint32_t READALIGNLAST;               /*!< (@ 0x00000D44) Indication that the next read from the CPU is
                                                                    the last one. This is needed only when the
                                                                    data size is NOT modulo 4 (e.g. HASH padding).             */

    struct {
      __IOM uint32_t LAST       : 1;            /*!< [0..0] 0x1 - Flush the read aligner content (used for reading
                                                     the last data).                                                           */
            uint32_t            : 31;
    } READALIGNLAST_b;
  } ;
  __IM  uint32_t  RESERVED49[2];

  union {
    __IOM uint32_t DOUTFIFOEMPTY;               /*!< (@ 0x00000D50) DOUT_FIFO_EMPTY Register.                                  */

    struct {
      __IOM uint32_t DOUTFIFOEMPTY : 1;         /*!< [0..0] DOUT FIFO empty status.                                            */
            uint32_t            : 31;
    } DOUTFIFOEMPTY_b;
  } ;
  __IM  uint32_t  RESERVED50[107];

  union {
    __IOM uint32_t SRAMDATA;                    /*!< (@ 0x00000F00) READ WRITE DATA FROM SRAM. Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
      __IOM uint32_t SRAMDATA   : 32;           /*!< [31..0] 32 bit write or read from SRAM: read - triggers the
                                                     SRAM read DMA address automatically incremented write -
                                                     triggers the SRAM write DMA address automatically incremented             */
    } SRAMDATA_b;
  } ;

  union {
    __IOM uint32_t SRAMADDR;                    /*!< (@ 0x00000F04) first address given to SRAM DMA for read_write
                                                                    transactions from SRAM                                     */

    struct {
      __IOM uint32_t SRAMADDR   : 15;           /*!< [14..0] SRAM starting address                                             */
            uint32_t            : 17;
    } SRAMADDR_b;
  } ;

  union {
    __IOM uint32_t SRAMDATAREADY;               /*!< (@ 0x00000F08) The SRAM content is ready for read in SRAM_DATA.           */

    struct {
      __IOM uint32_t SRAMREADY  : 1;            /*!< [0..0] SRAM content is ready for read in SRAM_DATA.                       */
            uint32_t            : 31;
    } SRAMDATAREADY_b;
  } ;
  __IM  uint32_t  RESERVED51[49];

  union {
    __IOM uint32_t PERIPHERALID4;               /*!< (@ 0x00000FD0) Peripheral ID 4 (PID4).                                    */

    struct {
      __IOM uint32_t DES2JEP106 : 4;            /*!< [3..0] for ARM products.                                                  */
            uint32_t            : 28;
    } PERIPHERALID4_b;
  } ;
  __IM  uint32_t  RESERVED52[3];

  union {
    __IOM uint32_t PERIPHERALID0;               /*!< (@ 0x00000FE0) Peripheral ID 0 (PID0).                                    */

    struct {
      __IOM uint32_t PART0      : 8;            /*!< [7..0] Identification register part number, bits[7:0]                     */
            uint32_t            : 24;
    } PERIPHERALID0_b;
  } ;

  union {
    __IOM uint32_t PERIPHERALID1;               /*!< (@ 0x00000FE4) Peripheral ID 1 (PID1).                                    */

    struct {
      __IOM uint32_t PART1      : 4;            /*!< [3..0] Identification register part number, bits[11:8]                    */
      __IOM uint32_t DES0JEP106 : 4;            /*!< [7..4] for ARM products.                                                  */
            uint32_t            : 24;
    } PERIPHERALID1_b;
  } ;

  union {
    __IOM uint32_t PERIPHERALID2;               /*!< (@ 0x00000FE8) Peripheral ID 2 (PID2).                                    */

    struct {
      __IOM uint32_t DES1JEP106 : 3;            /*!< [2..0] for ARM products.                                                  */
      __IOM uint32_t JEDEC      : 1;            /*!< [3..3] constant 0x1. Indicates that a JEDEC assigned value is
                                                     used.                                                                     */
      __IOM uint32_t REVISION   : 4;            /*!< [7..4] starts at zero and increments for every new IP release.            */
            uint32_t            : 24;
    } PERIPHERALID2_b;
  } ;

  union {
    __IOM uint32_t PERIPHERALID3;               /*!< (@ 0x00000FEC) Peripheral ID 3 (PID3).                                    */

    struct {
      __IOM uint32_t CMOD       : 4;            /*!< [3..0] Customer Modified, normally zero, but if a partner applies
                                                     any changes themselves, they must change this value.                      */
      __IOM uint32_t REVAND     : 4;            /*!< [7..4] starts at zero for every Revision, and increments if
                                                     metal fixes are applied between 2 IP releases.                            */
            uint32_t            : 24;
    } PERIPHERALID3_b;
  } ;

  union {
    __IOM uint32_t COMPONENTID0;                /*!< (@ 0x00000FF0) Component ID0.                                             */

    struct {
      __IOM uint32_t PRMBL0     : 8;            /*!< [7..0] constant 0xD                                                       */
            uint32_t            : 24;
    } COMPONENTID0_b;
  } ;

  union {
    __IOM uint32_t COMPONENTID1;                /*!< (@ 0x00000FF4) Component ID1.                                             */

    struct {
      __IOM uint32_t PRMBL1     : 4;            /*!< [3..0] constant 0x0                                                       */
      __IOM uint32_t CLASS      : 4;            /*!< [7..4] component type 0 0xF for Cryptocell                                */
            uint32_t            : 24;
    } COMPONENTID1_b;
  } ;

  union {
    __IOM uint32_t COMPONENTID2;                /*!< (@ 0x00000FF8) Component ID2.                                             */

    struct {
      __IOM uint32_t PRMBL2     : 8;            /*!< [7..0] constant 0x5                                                       */
            uint32_t            : 24;
    } COMPONENTID2_b;
  } ;

  union {
    __IOM uint32_t COMPONENTID3;                /*!< (@ 0x00000FFC) Component ID3.                                             */

    struct {
      __IOM uint32_t PRMBL3     : 8;            /*!< [7..0] constant 0xB1                                                      */
            uint32_t            : 24;
    } COMPONENTID3_b;
  } ;
  __IM  uint32_t  RESERVED53[896];

  union {
    __IOM uint32_t HOSTDCUEN0;                  /*!< (@ 0x00001E00) The DCU [31:0] enable register. Note: This is
                                                                    a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t HOSTDCUEN0 : 32;           /*!< [31..0] Debug Control Unit (DCU) Enable bits.                             */
    } HOSTDCUEN0_b;
  } ;

  union {
    __IOM uint32_t HOSTDCUEN1;                  /*!< (@ 0x00001E04) The DCU [63:32] enable register. Note: This is
                                                                    a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t HOSTDCUEN1 : 32;           /*!< [31..0] Debug Control Unit (DCU) Enable bits.                             */
    } HOSTDCUEN1_b;
  } ;

  union {
    __IOM uint32_t HOSTDCUEN2;                  /*!< (@ 0x00001E08) The DCU [95:64] enable register. Note: This is
                                                                    a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t HOSTDCUEN2 : 32;           /*!< [31..0] Debug Control Unit (DCU) Enable bits.                             */
    } HOSTDCUEN2_b;
  } ;

  union {
    __IOM uint32_t HOSTDCUEN3;                  /*!< (@ 0x00001E0C) The DCU [1271:96] enable register. Note: This
                                                                    is a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t HOSTDCUEN3 : 32;           /*!< [31..0] Debug Control Unit (DCU) Enable bits.                             */
    } HOSTDCUEN3_b;
  } ;

  union {
    __IOM uint32_t HOSTDCULOCK0;                /*!< (@ 0x00001E10) The DCU lock register. Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
      __IOM uint32_t HOSTDCULOCK0 : 32;         /*!< [31..0] DCU_lock [31:0] register (a dedicated lock register
                                                     per DCU bit).                                                             */
    } HOSTDCULOCK0_b;
  } ;

  union {
    __IOM uint32_t HOSTDCULOCK1;                /*!< (@ 0x00001E14) The DCU lock register. Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
      __IOM uint32_t HOSTDCULOCK1 : 32;         /*!< [31..0] DCU_lock [63:32] register (a dedicated lock register
                                                     per DCU bit).                                                             */
    } HOSTDCULOCK1_b;
  } ;

  union {
    __IOM uint32_t HOSTDCULOCK2;                /*!< (@ 0x00001E18) The DCU lock register. Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
      __IOM uint32_t HOSTDCULOCK2 : 32;         /*!< [31..0] DCU_lock [95:64] register (a dedicated lock register
                                                     per DCU bit).                                                             */
    } HOSTDCULOCK2_b;
  } ;

  union {
    __IOM uint32_t HOSTDCULOCK3;                /*!< (@ 0x00001E1C) The DCU lock register. Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
      __IOM uint32_t HOSTDCULOCK3 : 32;         /*!< [31..0] DCU_lock [127:96] register (a dedicated lock register
                                                     per DCU bit).                                                             */
    } HOSTDCULOCK3_b;
  } ;

  union {
    __IOM uint32_t AOICVDCURESTRICTIONMASK0;    /*!< (@ 0x00001E20) The DCU lock register.                                     */

    struct {
      __IOM uint32_t AOICVDCURESTRICTIONMASK0 : 32;/*!< [31..0] AO_ICV_DCU_RESTRICTION_MASK [31:0] parameter, that will
                                                     be a customer modifiable.                                                 */
    } AOICVDCURESTRICTIONMASK0_b;
  } ;

  union {
    __IOM uint32_t AOICVDCURESTRICTIONMASK1;    /*!< (@ 0x00001E24) The 'ICV_DCU_restriction_mask' parameter is read
                                                                    by FW during the secure debug verification
                                                                    to prevent OEM from setting specific DCUs
                                                                    that protect ICV secrets                                   */

    struct {
      __IOM uint32_t AOICVDCURESTRICTIONMASK1 : 32;/*!< [31..0] AO_ICV_DCU_RESTRICTION_MASK [63:32] parameter, that
                                                     will be a customer modifiable.                                            */
    } AOICVDCURESTRICTIONMASK1_b;
  } ;

  union {
    __IOM uint32_t AOICVDCURESTRICTIONMASK2;    /*!< (@ 0x00001E28) The 'ICV_DCU_restriction_mask' parameter is read
                                                                    by FW during the secure debug verification
                                                                    to prevent OEM from setting specific DCUs
                                                                    that protect ICV secrets                                   */

    struct {
      __IOM uint32_t AOICVDCURESTRICTIONMASK2 : 32;/*!< [31..0] AO_ICV_DCU_RESTRICTION_MASK [95:64] parameter, that
                                                     will be a customer modifiable.                                            */
    } AOICVDCURESTRICTIONMASK2_b;
  } ;

  union {
    __IOM uint32_t AOICVDCURESTRICTIONMASK3;    /*!< (@ 0x00001E2C) The 'ICV_DCU_restriction_mask' parameter is read
                                                                    by FW during the secure debug verification
                                                                    to prevent OEM from setting specific DCUs
                                                                    that protect ICV secrets                                   */

    struct {
      __IOM uint32_t AOICVDCURESTRICTIONMASK3 : 32;/*!< [31..0] AO_ICV_DCU_RESTRICTION_MASK [127:96] parameter, that
                                                     will be a customer modifiable.                                            */
    } AOICVDCURESTRICTIONMASK3_b;
  } ;

  union {
    __IOM uint32_t AOCCSECDEBUGRESET;           /*!< (@ 0x00001E30) The reset-upon-debug indication                            */

    struct {
      __IOM uint32_t AOCCSECDEBUGRESET : 1;     /*!< [0..0] For resets Cerberus, and prevents loading the HW keys
                                                     after that reset                                                          */
            uint32_t            : 31;
    } AOCCSECDEBUGRESET_b;
  } ;

  union {
    __IOM uint32_t HOSTAOLOCKBITS;              /*!< (@ 0x00001E34) These masks will define, per LCS, which DCU bits
                                                                    will be tied to zero, even if the Host tries
                                                                    to set them. Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
      __IOM uint32_t HOSTFATALERR : 1;          /*!< [0..0] When the 'FATAL_ERROR' register is asserted - HW keys
                                                     will not be copied from OTP                                               */
      __IOM uint32_t HOSTKPICVLOCK : 1;         /*!< [1..1] When this FW controlled register is set, the Kpicv HW
                                                     key is masked (to zero).                                                  */
      __IOM uint32_t HOSTKCEICVLOCK : 1;        /*!< [2..2] When this FW controlled register is set, the Kceicv HW
                                                     key is masked (to zero).                                                  */
      __IOM uint32_t HOSTKCPLOCK : 1;           /*!< [3..3] When this FW controlled register is set, the Kcp HW key
                                                     is masked (to zero).                                                      */
      __IOM uint32_t HOSTKCELOCK : 1;           /*!< [4..4] When this FW controlled register is set, the Kce HW key
                                                     is masked (to zero).                                                      */
      __IOM uint32_t HOSTICVRMALOCK : 1;        /*!< [5..5] The ICV_RMA_LOCK register is set-once (per POR).                   */
      __IOM uint32_t RESETUPONDEBUGDISABLE : 1; /*!< [6..6] The RESET_UPON_DEBUG_DISABLE register is set-once (per
                                                     POR).                                                                     */
      __IOM uint32_t HOSTFORCEDFAENABLE : 1;    /*!< [7..7] When this FW controlled register is set, the AES DFA
                                                     countermeasures are enabled_disabled (regardless of the
                                                     AES_DFA_IS_ON register value).                                            */
      __IOM uint32_t HOSTDFAENABLELOCK : 1;     /*!< [8..8] When this FW control is set, the DFA_ENABLE register
                                                     cant be written until the next POR. The DFA_ENABLE_LOCK
                                                     register is set-once (per POR).                                           */
            uint32_t            : 23;
    } HOSTAOLOCKBITS_b;
  } ;

  union {
    __IOM uint32_t AOAPBFILTERING;              /*!< (@ 0x00001E38) This register holds the AO_APB_FILTERING data.
                                                                    Note: This is a special register, affected
                                                                    by internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t ONLYSECACCESSALLOW : 1;    /*!< [0..0] when this FW controlled register is set, the APB slave
                                                     accepts only secure accesses                                              */
      __IOM uint32_t ONLYSECACCESSALLOWLOCK : 1;/*!< [1..1] when this FW controlled register is set, the ONLY_SEC_ACCESS_ALLOWED
                                                     register cant be modified (until the next POR).                           */
      __IOM uint32_t ONLYPRIVACCESSALLOW : 1;   /*!< [2..2] when this FW controlled register is set, the APB slave
                                                     accepts only privileged accesses                                          */
      __IOM uint32_t ONLYPRIVACCESSALLOWLOCK : 1;/*!< [3..3] when this FW controlled register is set, the APBC_ONLY_PRIV_ACCESS_ALLO
                                                     ED register cant be modified (until the next POR)                         */
      __IOM uint32_t APBCONLYSECACCESSALLOW : 1;/*!< [4..4] when this FW controlled register is set, the APB-C slave
                                                     accepts only secure accesses                                              */
      __IOM uint32_t APBCONLYSECACCESSALLOWLOCK : 1;/*!< [5..5] when this FW controlled register is set, the APBC_ONLY_SEC_ACCESS_ALLOW
                                                     D register cant be modified (until the next POR).                         */
      __IOM uint32_t APBCONLYPRIVACCESSALLOW : 1;/*!< [6..6] when this FW controlled register is set, the APB-C slave
                                                     accepts only privileged accesses                                          */
      __IOM uint32_t APBCONLYPRIVACCESSALLOWLOCK : 1;/*!< [7..7] when this FW controlled register is set, the APBC_ONLY_PRIV_ACCESS_ALLO
                                                     ED register cant be modified (until the next POR)                         */
      __IOM uint32_t APBCONLYINSTACCESSALLOW : 1;/*!< [8..8] when this FW controlled register is set, the APB-C slave
                                                     accepts only instruction accesses                                         */
      __IOM uint32_t APBCONLYINSTACCESSALLOWLOCK : 1;/*!< [9..9] when this FW controlled register is set, the APBC_ONLY_INST_ACCESS_ALLO
                                                     ED register cant be modified (until the next POR)                         */
            uint32_t            : 22;
    } AOAPBFILTERING_b;
  } ;

  union {
    __IOM uint32_t AOCCGPPC;                    /*!< (@ 0x00001E3C) holds the AO_CC_GPPC value from AONote: This
                                                                    is a special register, affected by internal
                                                                    logic. Test result of this register is NA.                 */

    struct {
      __IOM uint32_t AOCCGPPC   : 8;            /*!< [7..0] The AO_CC_GPPC value                                               */
            uint32_t            : 24;
    } AOCCGPPC_b;
  } ;

  union {
    __IOM uint32_t HOSTRGFCCSWRST;              /*!< (@ 0x00001E40) Writing to this register generates a general
                                                                    reset to CryptoCell. This reset takes about
                                                                    4 core clock cycles.Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
      __IOM uint32_t HOSTRGFCCSWRST : 1;        /*!< [0..0] Writing 1 to this field generates a general reset to
                                                     CryptoCell.                                                               */
            uint32_t            : 31;
    } HOSTRGFCCSWRST_b;
  } ;
  __IM  uint32_t  RESERVED54[48];

  union {
    __IOM uint32_t AIBFUSEPROGCOMPLETED;        /*!< (@ 0x00001F04) This register reflects the fuse_aib_prog_completed
                                                                    input, which indicates that the fuse programming
                                                                    was completed.Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
      __IOM uint32_t AIBFUSEPROGCOMPLETED : 1;  /*!< [0..0] Indicates if the fuse programming operation has been
                                                     completed.                                                                */
            uint32_t            : 31;
    } AIBFUSEPROGCOMPLETED_b;
  } ;

  union {
    __IOM uint32_t NVMDEBUGSTATUS;              /*!< (@ 0x00001F08) AIB debug status register. Note: This is a special
                                                                    register, affected by internal logic. Test
                                                                    result of this register is NA.                             */

    struct {
            uint32_t            : 1;
      __IOM uint32_t NVMSM      : 3;            /*!< [3..1] Main nvm fsm                                                       */
            uint32_t            : 28;
    } NVMDEBUGSTATUS_b;
  } ;

  union {
    __IOM uint32_t LCSISVALID;                  /*!< (@ 0x00001F0C) Indicates that the LCS register holds a valid
                                                                    value.Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
      __IOM uint32_t LCSISVALIDREG : 1;         /*!< [0..0] Indicates whether LCS is valid.                                    */
            uint32_t            : 31;
    } LCSISVALID_b;
  } ;

  union {
    __IOM uint32_t NVMISIDLE;                   /*!< (@ 0x00001F10) Indicates that the LCS register holds a valid
                                                                    value.Note: This is a special register,
                                                                    affected by internal logic. Test result
                                                                    of this register is NA.                                    */

    struct {
      __IOM uint32_t NVMISIDLEREG : 1;          /*!< [0..0] Indicates whether the NVM manager finishes its operation,
                                                     calculates the LCS, reads the HW keys, compares the number
                                                     of zeros and clears the keys                                              */
            uint32_t            : 31;
    } NVMISIDLE_b;
  } ;

  union {
    __IOM uint32_t LCSREG;                      /*!< (@ 0x00001F14) The lifecycle state register. Note: This is a
                                                                    special register, affected by internal logic.
                                                                    Test result of this register is NA.                        */

    struct {
      __IOM uint32_t LCSREG     : 3;            /*!< [2..0] Indicates the LCS (Lifecycle State) value.                         */
            uint32_t            : 5;
      __IOM uint32_t ERRORKDRZEROCNT : 1;       /*!< [8..8] Indication that the number of zeroes in the loaded KDR
                                                     is not equal to the value set in the manufacture flag.                    */
      __IOM uint32_t ERRORPROVZEROCNT : 1;      /*!< [9..9] Indication that the number of zeroes in the loaded KCP
                                                     is not equal to the value set in the OEM flag.                            */
      __IOM uint32_t ERRORKCEZEROCNT : 1;       /*!< [10..10] Indication that the number of zeroes in the loaded
                                                     KCE is not equal to the value set in the OEM flag.                        */
      __IOM uint32_t ERRORKPICVZEROCNT : 1;     /*!< [11..11] Indication that the number of zeroes in the loaded
                                                     KPICV is not equal to the value set in the manufacture
                                                     flag.                                                                     */
      __IOM uint32_t ERRORKCEICVZEROCNT : 1;    /*!< [12..12] Indication that the number of zeroes in the loaded
                                                     KCEICV is not equal to the value set in the manufacture
                                                     flag.                                                                     */
            uint32_t            : 19;
    } LCSREG_b;
  } ;

  union {
    __IOM uint32_t HOSTSHADOWKDRREG;            /*!< (@ 0x00001F18) This register interface is used to update the
                                                                    RKEK(KDR) registers when the device is in
                                                                    CM or DM mode , it is Write-once (per warm
                                                                    boot) in RMA LCS, The RKEK is updated by
                                                                    shifting .                                                 */

    struct {
      __IOM uint32_t HOSTSHADOWKDRREG : 1;      /*!< [0..0] This field is used to update the KDR registers when the
                                                     device is in CM , DM or RMA mode, The KDR is updated by
                                                     shifting .                                                                */
            uint32_t            : 31;
    } HOSTSHADOWKDRREG_b;
  } ;

  union {
    __IOM uint32_t HOSTSHADOWKCPREG;            /*!< (@ 0x00001F1C) This register interface is used to update the
                                                                    KCP registers when the device is in CM or
                                                                    DM mode, The KCP is updated by shifting                    */

    struct {
      __IOM uint32_t HOSTSHADOWKCPREG : 1;      /*!< [0..0] This field is used to update the KCP registers when the
                                                     device is in CM or DM mode, The KCP is updated by shifting                */
            uint32_t            : 31;
    } HOSTSHADOWKCPREG_b;
  } ;

  union {
    __IOM uint32_t HOSTSHADOWKCEREG;            /*!< (@ 0x00001F20) This register interface is used to update the
                                                                    KCE registers when the device is in CM or
                                                                    DM mode, The KCE is updated by shifting                    */

    struct {
      __IOM uint32_t HOSTSHADOWKCEREG : 1;      /*!< [0..0] This field is used to update the KCE registers when the
                                                     device is in CM or DM mode, The KCE is updated by shifting                */
            uint32_t            : 31;
    } HOSTSHADOWKCEREG_b;
  } ;

  union {
    __IOM uint32_t HOSTSHADOWKPICVREG;          /*!< (@ 0x00001F24) This register interface is used to update the
                                                                    KPICV registers when the device is in CM
                                                                    or DM mode, The KPICV is updated by shifting               */

    struct {
      __IOM uint32_t HOSTSHADOWKPICVREG : 1;    /*!< [0..0] This field is used to update the KPICV registers when
                                                     the device is in CM or DM mode, The KPICV is updated by
                                                     shifting                                                                  */
            uint32_t            : 31;
    } HOSTSHADOWKPICVREG_b;
  } ;

  union {
    __IOM uint32_t HOSTSHADOWKCEICVREG;         /*!< (@ 0x00001F28) This register interface is used to update the
                                                                    KCEICV registers when the device is in CM
                                                                    or DM mode, The KCEICV is updated by shifting              */

    struct {
      __IOM uint32_t HOSTSHADOWKCEICVREG : 1;   /*!< [0..0] This field is used to update the KCEICV registers when
                                                     the device is in CM or DM mode, The KCEICV is updated by
                                                     shifting                                                                  */
            uint32_t            : 31;
    } HOSTSHADOWKCEICVREG_b;
  } ;

  union {
    __IOM uint32_t OTPADDRWIDTHDEF;             /*!< (@ 0x00001F2C) OTP_ADDR_WIDTH parameter, that will define the
                                                                    integrated OTP address width (address in
                                                                    words). The supported sizes are 6 (for 2
                                                                    Kbits),7,8,9,11 (for 64 Kbits). The default
                                                                    value in the provided RTL will be 6.Note:
                                                                    This is a special register, affected by
                                                                    internal logic. Test result of this register
                                                                    is NA.                                                     */

    struct {
      __IOM uint32_t OTPADDRWIDTHDEF : 4;       /*!< [3..0] Holds the OTP_ADDR_WIDTH_DEF value.                                */
            uint32_t            : 28;
    } OTPADDRWIDTHDEF_b;
  } ;
} CRYPTO_Type;                                  /*!< Size = 7984 (0x1f30)                                                      */



/* =========================================================================================================================== */
/* ================                                            DSP                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief DSP Control Interface (DSP)
  */

typedef struct {                                /*!< (@ 0x40100000) DSP Structure                                              */
  __IM  uint32_t  RESERVED[16];

  union {
    __IOM uint32_t MUTEX0;                      /*!< (@ 0x00000040) MUTEX 0                                                    */

    struct {
      __IOM uint32_t MUTEX0     : 3;            /*!< [2..0] Mutex Value (000=resource free, 001=CPU owns mutex, 010=DSP0
                                                     owns mutex, 100=DSP1 owns mutex)                                          */
            uint32_t            : 29;
    } MUTEX0_b;
  } ;

  union {
    __IOM uint32_t MUTEX1;                      /*!< (@ 0x00000044) MUTEX 1                                                    */

    struct {
      __IOM uint32_t MUTEX1     : 3;            /*!< [2..0] Mutex Value (000=resource free, 001=CPU owns mutex, 010=DSP0
                                                     owns mutex, 100=DSP1 owns mutex)                                          */
            uint32_t            : 29;
    } MUTEX1_b;
  } ;

  union {
    __IOM uint32_t MUTEX2;                      /*!< (@ 0x00000048) MUTEX 2                                                    */

    struct {
      __IOM uint32_t MUTEX2     : 3;            /*!< [2..0] Mutex Value (000=resource free, 001=CPU owns mutex, 010=DSP0
                                                     owns mutex, 100=DSP1 owns mutex)                                          */
            uint32_t            : 29;
    } MUTEX2_b;
  } ;

  union {
    __IOM uint32_t MUTEX3;                      /*!< (@ 0x0000004C) MUTEX 3                                                    */

    struct {
      __IOM uint32_t MUTEX3     : 3;            /*!< [2..0] Mutex Value (000=resource free, 001=CPU owns mutex, 010=DSP0
                                                     owns mutex, 100=DSP1 owns mutex)                                          */
            uint32_t            : 29;
    } MUTEX3_b;
  } ;

  union {
    __IOM uint32_t MUTEX4;                      /*!< (@ 0x00000050) MUTEX 4                                                    */

    struct {
      __IOM uint32_t MUTEX4     : 3;            /*!< [2..0] Mutex Value (000=resource free, 001=CPU owns mutex, 010=DSP0
                                                     owns mutex, 100=DSP1 owns mutex)                                          */
            uint32_t            : 29;
    } MUTEX4_b;
  } ;

  union {
    __IOM uint32_t MUTEX5;                      /*!< (@ 0x00000054) MUTEX 5                                                    */

    struct {
      __IOM uint32_t MUTEX5     : 3;            /*!< [2..0] Mutex Value (000=resource free, 001=CPU owns mutex, 010=DSP0
                                                     owns mutex, 100=DSP1 owns mutex)                                          */
            uint32_t            : 29;
    } MUTEX5_b;
  } ;

  union {
    __IOM uint32_t MUTEX6;                      /*!< (@ 0x00000058) MUTEX 6                                                    */

    struct {
      __IOM uint32_t MUTEX6     : 3;            /*!< [2..0] Mutex Value (000=resource free, 001=CPU owns mutex, 010=DSP0
                                                     owns mutex, 100=DSP1 owns mutex)                                          */
            uint32_t            : 29;
    } MUTEX6_b;
  } ;

  union {
    __IOM uint32_t MUTEX7;                      /*!< (@ 0x0000005C) MUTEX 7                                                    */

    struct {
      __IOM uint32_t MUTEX7     : 3;            /*!< [2..0] Mutex Value (000=resource free, 001=CPU owns mutex, 010=DSP0
                                                     owns mutex, 100=DSP1 owns mutex)                                          */
            uint32_t            : 29;
    } MUTEX7_b;
  } ;
  __IM  uint32_t  RESERVED1[8];

  union {
    __IOM uint32_t CPUMBINTSET;                 /*!< (@ 0x00000080) CPU Mailbox Interrupt Set                                  */

    struct {
      __IOM uint32_t CPUMBINTSET : 32;          /*!< [31..0] CPU Mailbox interrupt Set. The corresponding data bit
                                                     will set the interrupt.                                                   */
    } CPUMBINTSET_b;
  } ;

  union {
    __IOM uint32_t CPUMBINTCLR;                 /*!< (@ 0x00000084) CPU Mailbox Interrupt Clear                                */

    struct {
      __IOM uint32_t CPUMBINTCLR : 32;          /*!< [31..0] CPU Mailbox interrupt Clear. The corresponding data
                                                     bit will clear the interrupt.                                             */
    } CPUMBINTCLR_b;
  } ;

  union {
    __IOM uint32_t CPUMBINTSTAT;                /*!< (@ 0x00000088) CPU Mailbox Interrupt Status                               */

    struct {
      __IOM uint32_t CPUMBINTSTAT : 32;         /*!< [31..0] CPU CPU Mailbox interrupt status                                  */
    } CPUMBINTSTAT_b;
  } ;

  union {
    __IOM uint32_t CPUCPUMBDATA;                /*!< (@ 0x0000008C) CPU CPU Mailbox Data                                       */

    struct {
      __IOM uint32_t CPUCPUMBDATA : 32;         /*!< [31..0] CPU CPU Mailbox data                                              */
    } CPUCPUMBDATA_b;
  } ;

  union {
    __IOM uint32_t DSP0CPUMBDATA;               /*!< (@ 0x00000090) DSP0 to CPU Mailbox Data                                   */

    struct {
      __IOM uint32_t DSP0CPUMBDATA : 32;        /*!< [31..0] DSP0 to CPU Mailbox data                                          */
    } DSP0CPUMBDATA_b;
  } ;

  union {
    __IOM uint32_t DSP1CPUMBDATA;               /*!< (@ 0x00000094) DSP1 to CPU Mailbox Data                                   */

    struct {
      __IOM uint32_t DSP1CPUMBDATA : 32;        /*!< [31..0] DSP1 to CPU Mailbox data                                          */
    } DSP1CPUMBDATA_b;
  } ;
  __IM  uint32_t  RESERVED2[2];

  union {
    __IOM uint32_t DSP0MBINTSET;                /*!< (@ 0x000000A0) DSP0 Mailbox Interrupt Set                                 */

    struct {
      __IOM uint32_t DSP0MBINTSET : 32;         /*!< [31..0] DSP0 Mailbox interrupt Set. The corresponding data bit
                                                     will set the interrupt.                                                   */
    } DSP0MBINTSET_b;
  } ;

  union {
    __IOM uint32_t DSP0MBINTCLR;                /*!< (@ 0x000000A4) DSP0 Mailbox Interrupt Clear                               */

    struct {
      __IOM uint32_t DSP0MBINTCLR : 32;         /*!< [31..0] DSP0 Mailbox interrupt Clear. The corresponding data
                                                     bit will clear the interrupt.                                             */
    } DSP0MBINTCLR_b;
  } ;

  union {
    __IOM uint32_t DSP0MBINTSTAT;               /*!< (@ 0x000000A8) DSP 0 Mailbox Interrupt Status                             */

    struct {
      __IOM uint32_t DSP0MBINTSTAT : 32;        /*!< [31..0] DSP 0 CPU Mailbox interrupt                                       */
    } DSP0MBINTSTAT_b;
  } ;

  union {
    __IOM uint32_t CPUDSP0MBDATA;               /*!< (@ 0x000000AC) CPU to DSP 0 Mailbox Data                                  */

    struct {
      __IOM uint32_t CPUDSP0MBDATA : 32;        /*!< [31..0] DSP 0 CPU Mailbox data                                            */
    } CPUDSP0MBDATA_b;
  } ;

  union {
    __IOM uint32_t DSP0DSP0MBDATA;              /*!< (@ 0x000000B0) DSP0 to DSP 0 Mailbox Data                                 */

    struct {
      __IOM uint32_t DSP0DSP0MBDATA : 32;       /*!< [31..0] DSP0 to DSP 0 Mailbox data                                        */
    } DSP0DSP0MBDATA_b;
  } ;

  union {
    __IOM uint32_t DSP1DSP0MBDATA;              /*!< (@ 0x000000B4) DSP1 to DSP 0 Mailbox Data                                 */

    struct {
      __IOM uint32_t DSP1DSP0MBDATA : 32;       /*!< [31..0] DSP1 to DSP 0 Mailbox data                                        */
    } DSP1DSP0MBDATA_b;
  } ;
  __IM  uint32_t  RESERVED3[2];

  union {
    __IOM uint32_t DSP1MBINTSET;                /*!< (@ 0x000000C0) DSP1 Mailbox Interrupt Set                                 */

    struct {
      __IOM uint32_t DSP1MBINTSET : 32;         /*!< [31..0] DSP1 Mailbox interrupt Set. The corresponding data bit
                                                     will set the interrupt.                                                   */
    } DSP1MBINTSET_b;
  } ;

  union {
    __IOM uint32_t DSP1MBINTCLR;                /*!< (@ 0x000000C4) DSP1 Mailbox Interrupt Clear                               */

    struct {
      __IOM uint32_t DSP1MBINTCLR : 32;         /*!< [31..0] DSP1 Mailbox interrupt Clear. The corresponding data
                                                     bit will clear the interrupt.                                             */
    } DSP1MBINTCLR_b;
  } ;

  union {
    __IOM uint32_t DSP1MBINTSTAT;               /*!< (@ 0x000000C8) DSP 1 Mailbox Interrupt Status                             */

    struct {
      __IOM uint32_t DSP1MBINTSTAT : 32;        /*!< [31..0] DSP 1 CPU Mailbox interrupt                                       */
    } DSP1MBINTSTAT_b;
  } ;

  union {
    __IOM uint32_t CPUDSP1MBDATA;               /*!< (@ 0x000000CC) CPU to DSP 1 Mailbox Data                                  */

    struct {
      __IOM uint32_t CPUDSP1MBDATA : 32;        /*!< [31..0] DSP 1 CPU Mailbox data                                            */
    } CPUDSP1MBDATA_b;
  } ;

  union {
    __IOM uint32_t DSP0DSP1MBDATA;              /*!< (@ 0x000000D0) DSP0 to DSP 1 Mailbox Data                                 */

    struct {
      __IOM uint32_t DSP0DSP1MBDATA : 32;       /*!< [31..0] DSP0 to DSP 1 Mailbox data                                        */
    } DSP0DSP1MBDATA_b;
  } ;

  union {
    __IOM uint32_t DSP1DSP1MBDATA;              /*!< (@ 0x000000D4) DSP1 to DSP 1 Mailbox Data                                 */

    struct {
      __IOM uint32_t DSP1DSP1MBDATA : 32;       /*!< [31..0] DSP1 to DSP 1 Mailbox data                                        */
    } DSP1DSP1MBDATA_b;
  } ;
  __IM  uint32_t  RESERVED4[10];

  union {
    __IOM uint32_t DSP0CONTROL;                 /*!< (@ 0x00000100) DSP 0 control settings                                     */

    struct {
      __IOM uint32_t DSP0STATVECSEL : 1;        /*!< [0..0] DSP 0 StatVectorSel                                                */
      __IOM uint32_t DSP0BRESET : 1;            /*!< [1..1] DSP0 BReset. This is the reset used for Xtensa core.
                                                     S/w must clear this reset to use Dsp.                                     */
      __IOM uint32_t DSP0DRESET : 1;            /*!< [2..2] DSP0 DReset. This is the reset used for debug functionality
                                                     like OCD/TRAX etc.                                                        */
      __IOM uint32_t DSP0RUNSTALL : 1;          /*!< [3..3] DSP 0 RunStall. When asserted, DSP 0 will stall until
                                                     bit is cleared.                                                           */
      __IOM uint32_t DSP0IDMATRIG : 2;          /*!< [5..4] DSP 0 IDMA Trigger Control                                         */
            uint32_t            : 2;
      __IOM uint32_t DSP0IDMAXTRIGSRC : 23;     /*!< [30..8] DSP 0 IDMA Cross Trigger Source. All enabled sources
                                                     are ANDed to generate a trigger enable.
                                                     Bit30-12:IRQ18-0 Bit11: IDMATRIGPULSE, Bit10: DSP Timer1,
                                                     Bit9: DSP Timer0, Bit8: alternate DSP iDMA trigger out                    */
            uint32_t            : 1;
    } DSP0CONTROL_b;
  } ;

  union {
    __IOM uint32_t DSP0RESETVEC;                /*!< (@ 0x00000104) DSP 0 Reset Vector                                         */

    struct {
      __IOM uint32_t DSP0RESETVEC : 32;         /*!< [31..0] DSP 0 Reset Vector Address.                                       */
    } DSP0RESETVEC_b;
  } ;

  union {
    __IOM uint32_t DSP0IRQMASK;                 /*!< (@ 0x00000108) DSP 0 IRQ Mask                                             */

    struct {
      __IOM uint32_t DSP0IRQMASK : 23;          /*!< [22..0] DSP 0 IRQ Mask                                                    */
            uint32_t            : 9;
    } DSP0IRQMASK_b;
  } ;

  union {
    __IOM uint32_t DSP0WAKEMASK;                /*!< (@ 0x0000010C) DSP 0 IRQ Wake Mask                                        */

    struct {
      __IOM uint32_t DSP0WAKEMASK : 23;         /*!< [22..0] DSP 0 IRQ Wake Mask                                               */
            uint32_t            : 9;
    } DSP0WAKEMASK_b;
  } ;

  union {
    __IOM uint32_t DSP0RAWIRQSTAT31to0;         /*!< (@ 0x00000110) DSP 0 Raw IRQ31-0 Status                                   */

    struct {
      __IOM uint32_t DSP0RAWIRQSTAT31to0 : 32;  /*!< [31..0] DSP 0 Raw IRQ31-0 Status                                          */
    } DSP0RAWIRQSTAT31to0_b;
  } ;

  union {
    __IOM uint32_t DSP0RAWIRQSTAT63to32;        /*!< (@ 0x00000114) DSP 0 Raw IRQ63-32 Status                                  */

    struct {
      __IOM uint32_t DSP0RAWIRQSTAT63to32 : 32; /*!< [31..0] DSP 0 Raw IRQ63-32 Status                                         */
    } DSP0RAWIRQSTAT63to32_b;
  } ;

  union {
    __IOM uint32_t DSP0RAWIRQSTAT95to64;        /*!< (@ 0x00000118) DSP 0 Raw IRQ95-64 Status                                  */

    struct {
      __IOM uint32_t DSP0RAWIRQSTAT95to64 : 32; /*!< [31..0] DSP 0 Raw IRQ95-64 Status                                         */
    } DSP0RAWIRQSTAT95to64_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t DSP0L2LVLINT;                /*!< (@ 0x00000120) DSP 0 L2 Level Interrupt Mux                               */

    struct {
      __IOM uint32_t DSP0L2LVLINT : 19;         /*!< [18..0] DSP 0 L2 Level Interrupt Mux                                      */
            uint32_t            : 13;
    } DSP0L2LVLINT_b;
  } ;

  union {
    __IOM uint32_t DSP0L3LVLINT;                /*!< (@ 0x00000124) DSP 0 L3 Level Interrupt Mux                               */

    struct {
      __IOM uint32_t DSP0L3LVLINT : 19;         /*!< [18..0] DSP 0 L3 Level Interrupt Mux                                      */
            uint32_t            : 13;
    } DSP0L3LVLINT_b;
  } ;

  union {
    __IOM uint32_t DSP0L4LVLINT;                /*!< (@ 0x00000128) DSP 0 L4 Level Interrupt Mux                               */

    struct {
      __IOM uint32_t DSP0L4LVLINT : 19;         /*!< [18..0] DSP 0 L4 Level Interrupt Mux                                      */
            uint32_t            : 13;
    } DSP0L4LVLINT_b;
  } ;

  union {
    __IOM uint32_t DSP0L5LVLINT;                /*!< (@ 0x0000012C) DSP 0 L5 Level Interrupt Mux                               */

    struct {
      __IOM uint32_t DSP0L5LVLINT : 19;         /*!< [18..0] DSP 0 L5 Level Interrupt Mux                                      */
            uint32_t            : 13;
    } DSP0L5LVLINT_b;
  } ;

  union {
    __IOM uint32_t DSP0IDMATRIGCTL;             /*!< (@ 0x00000130) DSP 0 IDMA Trigger Control and Status                      */

    struct {
      __IOM uint32_t DSP0IDMATRIGSTAT : 1;      /*!< [0..0] DSP 0 iDMA Trigger Status                                          */
            uint32_t            : 3;
      __IOM uint32_t DSP0IDMATRIGPULSE : 1;     /*!< [4..4] DSP 0 iDMA Trigger Pulse - When written a '1', this will
                                                     cause a single step enable (valid only when IDMATRIG is
                                                     set to SSTEP)                                                             */
            uint32_t            : 27;
    } DSP0IDMATRIGCTL_b;
  } ;
  __IM  uint32_t  RESERVED6[3];

  union {
    __IOM uint32_t DSP0INTORMASK31TO0A;         /*!< (@ 0x00000140) DSP0 Interrupt OR Mask A for IRQ31-0                       */

    struct {
      __IOM uint32_t DSP0INTMCUIOORMASKA : 32;  /*!< [31..0] DSP0 MCU IO Interrupt OR Mask A                                   */
    } DSP0INTORMASK31TO0A_b;
  } ;

  union {
    __IOM uint32_t DSP0INTORMASK63TO32A;        /*!< (@ 0x00000144) DSP0 Interrupt OR Mask A for IRQ63-32                      */

    struct {
      __IOM uint32_t DSP0TMRORMASKA : 10;       /*!< [9..0] DSP0 Timer Interrupt OR Mask A                                     */
            uint32_t            : 2;
      __IOM uint32_t DSP0I2SORMASKA : 4;        /*!< [15..12] DSP0 I2S Interrupt OR Mask A                                     */
      __IOM uint32_t DSP0PDMORMASKA : 4;        /*!< [19..16] DSP0 PDM Interrupt OR Mask A                                     */
            uint32_t            : 4;
      __IOM uint32_t DSP0GPIOORMASKA : 6;       /*!< [29..24] DSP0 GPIO Interrupt OR Mask A                                    */
            uint32_t            : 2;
    } DSP0INTORMASK63TO32A_b;
  } ;

  union {
    __IOM uint32_t DSP0INTORMASK95TO64A;        /*!< (@ 0x00000148) DSP0 Interrupt OR Mask A for IRQ95-64                      */

    struct {
      __IOM uint32_t DSP0MBINTORMASKA : 32;     /*!< [31..0] DSP0 Mailbox Interrupt OR Mask A                                  */
    } DSP0INTORMASK95TO64A_b;
  } ;
  __IM  uint32_t  RESERVED7;

  union {
    __IOM uint32_t DSP0INTORMASK31to0B;         /*!< (@ 0x00000150) DSP0 Interrupt OR Mask B for IRQ31-0                       */

    struct {
      __IOM uint32_t DSP0INTMCUIOORMASKB : 32;  /*!< [31..0] DSP0 MCU IO Interrupt OR Mask B                                   */
    } DSP0INTORMASK31to0B_b;
  } ;

  union {
    __IOM uint32_t DSP0INTORMASK63TO32B;        /*!< (@ 0x00000154) DSP0 Interrupt OR Mask A for IRQ63-32                      */

    struct {
      __IOM uint32_t DSP0TMRORMASKB : 10;       /*!< [9..0] DSP0 Timer Interrupt OR Mask B                                     */
            uint32_t            : 2;
      __IOM uint32_t DSP0I2SORMASKB : 4;        /*!< [15..12] DSP0 I2S Interrupt OR Mask B                                     */
      __IOM uint32_t DSP0PDMORMASKB : 4;        /*!< [19..16] DSP0 PDM Interrupt OR Mask B                                     */
            uint32_t            : 4;
      __IOM uint32_t DSP0GPIOORMASKB : 6;       /*!< [29..24] DSP0 GPIO Interrupt OR Mask B                                    */
            uint32_t            : 2;
    } DSP0INTORMASK63TO32B_b;
  } ;

  union {
    __IOM uint32_t DSP0INTORMASK95TO64B;        /*!< (@ 0x00000158) DSP0 Interrupt OR Mask B for IRQ95-64                      */

    struct {
      __IOM uint32_t DSP0MBINTORMASKB : 32;     /*!< [31..0] DSP0 Mailbox Interrupt OR Mask B                                  */
    } DSP0INTORMASK95TO64B_b;
  } ;
  __IM  uint32_t  RESERVED8;

  union {
    __IOM uint32_t DSP0INTENIRQ31TO0;           /*!< (@ 0x00000160) DSP0 INT Enable for IRQ31-0                                */

    struct {
      __IOM uint32_t DSP0INTENIRQ31TO0 : 32;    /*!< [31..0] DSP0 INT Enable for IRQ31-0                                       */
    } DSP0INTENIRQ31TO0_b;
  } ;

  union {
    __IOM uint32_t DSP0INTENIRQ63TO32;          /*!< (@ 0x00000164) DSP0 INT Enable for IRQ63-32                               */

    struct {
      __IOM uint32_t DSP0INTENIRQ63TO32 : 32;   /*!< [31..0] DSP0 INT Enable for IRQ63-32                                      */
    } DSP0INTENIRQ63TO32_b;
  } ;

  union {
    __IOM uint32_t DSP0INTENIRQ95TO64;          /*!< (@ 0x00000168) DSP0 INT Enable for IRQ95-64                               */

    struct {
      __IOM uint32_t DSP0INTENIRQ95TO64 : 32;   /*!< [31..0] DSP0 INT Enable for IRQ95-64                                      */
    } DSP0INTENIRQ95TO64_b;
  } ;
  __IM  uint32_t  RESERVED9[37];

  union {
    __IOM uint32_t DSP1CONTROL;                 /*!< (@ 0x00000200) DSP 1 control settings                                     */

    struct {
      __IOM uint32_t DSP1STATVECSEL : 1;        /*!< [0..0] DSP 1 StatVectorSel                                                */
      __IOM uint32_t DSP1BRESET : 1;            /*!< [1..1] DSP1 BReset. This is the reset used for Xtensa core.
                                                     S/w must clear this reset to use Dsp.                                     */
      __IOM uint32_t DSP1DRESET : 1;            /*!< [2..2] DSP1 DReset. This is the reset used for debug functionality
                                                     like OCD/TRAX etc.                                                        */
      __IOM uint32_t DSP1RUNSTALL : 1;          /*!< [3..3] DSP 1 RunStall. When asserted, DSP 1 will stall until
                                                     bit is cleared.                                                           */
      __IOM uint32_t DSP1IDMATRIG : 2;          /*!< [5..4] DSP 1 IDMA Trigger Control                                         */
            uint32_t            : 2;
      __IOM uint32_t DSP1IDMAXTRIGSRC : 23;     /*!< [30..8] DSP 1 IDMA Cross Trigger Source. All enabled sources
                                                     are ANDed to generate a trigger enable.
                                                     Bit30-12:IRQ18-0 Bit11: IDMATRIGPULSE, Bit10: DSP Timer1,
                                                     Bit9: DSP Timer0, Bit8: alternate DSP iDMA trigger out                    */
            uint32_t            : 1;
    } DSP1CONTROL_b;
  } ;

  union {
    __IOM uint32_t DSP1RESETVEC;                /*!< (@ 0x00000204) DSP 1 Reset Vector                                         */

    struct {
      __IOM uint32_t DSP1RESETVEC : 32;         /*!< [31..0] DSP 1 Reset Vector Address.                                       */
    } DSP1RESETVEC_b;
  } ;

  union {
    __IOM uint32_t DSP1IRQMASK;                 /*!< (@ 0x00000208) DSP 1 IRQ Mask                                             */

    struct {
      __IOM uint32_t DSP1IRQMASK : 23;          /*!< [22..0] DSP 1 IRQ Mask                                                    */
            uint32_t            : 9;
    } DSP1IRQMASK_b;
  } ;

  union {
    __IOM uint32_t DSP1WAKEMASK;                /*!< (@ 0x0000020C) DSP 1 IRQ Wake Mask                                        */

    struct {
      __IOM uint32_t DSP1WAKEMASK : 23;         /*!< [22..0] DSP 1 IRQ Wake Mask                                               */
            uint32_t            : 9;
    } DSP1WAKEMASK_b;
  } ;

  union {
    __IOM uint32_t DSP1RAWIRQSTAT31to0;         /*!< (@ 0x00000210) DSP 1 Raw IRQ31-0 Status                                   */

    struct {
      __IOM uint32_t DSP1RAWIRQSTAT31to0 : 32;  /*!< [31..0] DSP 1 Raw IRQ31-0 Status                                          */
    } DSP1RAWIRQSTAT31to0_b;
  } ;

  union {
    __IOM uint32_t DSP1RAWIRQSTAT63to32;        /*!< (@ 0x00000214) DSP 1 Raw IRQ63-32 Status                                  */

    struct {
      __IOM uint32_t DSP1RAWIRQSTAT63to32 : 32; /*!< [31..0] DSP 1 Raw IRQ63-32 Status                                         */
    } DSP1RAWIRQSTAT63to32_b;
  } ;

  union {
    __IOM uint32_t DSP1RAWIRQSTAT95to64;        /*!< (@ 0x00000218) DSP 1 Raw IRQ95-64 Status                                  */

    struct {
      __IOM uint32_t DSP1RAWIRQSTAT95to64 : 32; /*!< [31..0] DSP 1 Raw IRQ95-64 Status                                         */
    } DSP1RAWIRQSTAT95to64_b;
  } ;
  __IM  uint32_t  RESERVED10;

  union {
    __IOM uint32_t DSP1L2LVLINT;                /*!< (@ 0x00000220) DSP 1 L2 Level Interrupt Mux                               */

    struct {
      __IOM uint32_t DSP1L2LVLINT : 19;         /*!< [18..0] DSP 1 L2 Level Interrupt Mux                                      */
            uint32_t            : 13;
    } DSP1L2LVLINT_b;
  } ;

  union {
    __IOM uint32_t DSP1L3LVLINT;                /*!< (@ 0x00000224) DSP 1 L3 Level Interrupt Mux                               */

    struct {
      __IOM uint32_t DSP1L3LVLINT : 19;         /*!< [18..0] DSP 1 L3 Level Interrupt Mux                                      */
            uint32_t            : 13;
    } DSP1L3LVLINT_b;
  } ;

  union {
    __IOM uint32_t DSP1L4LVLINT;                /*!< (@ 0x00000228) DSP 1 L4 Level Interrupt Mux                               */

    struct {
      __IOM uint32_t DSP1L4LVLINT : 19;         /*!< [18..0] DSP 1 L4 Level Interrupt Mux                                      */
            uint32_t            : 13;
    } DSP1L4LVLINT_b;
  } ;

  union {
    __IOM uint32_t DSP1L5LVLINT;                /*!< (@ 0x0000022C) DSP 1 L5 Level Interrupt Mux                               */

    struct {
      __IOM uint32_t DSP1L5LVLINT : 19;         /*!< [18..0] DSP 1 L5 Level Interrupt Mux                                      */
            uint32_t            : 13;
    } DSP1L5LVLINT_b;
  } ;

  union {
    __IOM uint32_t DSP1IDMATRIGCTL;             /*!< (@ 0x00000230) DSP 1 IDMA Trigger Control and Status                      */

    struct {
      __IOM uint32_t DSP1IDMATRIGSTAT : 1;      /*!< [0..0] DSP 1 iDMA Trigger Status                                          */
            uint32_t            : 3;
      __IOM uint32_t DSP1IDMATRIGPULSE : 1;     /*!< [4..4] DSP 1 iDMA Trigger Pulse - When written a '1', this will
                                                     cause a single step enable (valid only when IDMATRIG is
                                                     set to SSTEP)                                                             */
            uint32_t            : 27;
    } DSP1IDMATRIGCTL_b;
  } ;
  __IM  uint32_t  RESERVED11[3];

  union {
    __IOM uint32_t DSP1INTORMASK31TO0A;         /*!< (@ 0x00000240) DSP1 Interrupt OR Mask A for IRQ31-0                       */

    struct {
      __IOM uint32_t DSP1INTMCUIOORMASKA : 32;  /*!< [31..0] DSP1 MCU IO Interrupt OR Mask A                                   */
    } DSP1INTORMASK31TO0A_b;
  } ;

  union {
    __IOM uint32_t DSP1INTORMASK63TO32A;        /*!< (@ 0x00000244) DSP1 Interrupt OR Mask A for IRQ63-32                      */

    struct {
      __IOM uint32_t DSP1TMRORMASKA : 10;       /*!< [9..0] DSP1 Timer Interrupt OR Mask A                                     */
            uint32_t            : 2;
      __IOM uint32_t DSP1I2SORMASKA : 4;        /*!< [15..12] DSP1 I2S Interrupt OR Mask A                                     */
      __IOM uint32_t DSP1PDMORMASKA : 4;        /*!< [19..16] DSP1 PDM Interrupt OR Mask A                                     */
            uint32_t            : 4;
      __IOM uint32_t DSP1GPIOORMASKA : 6;       /*!< [29..24] DSP1 GPIO Interrupt OR Mask A                                    */
            uint32_t            : 2;
    } DSP1INTORMASK63TO32A_b;
  } ;

  union {
    __IOM uint32_t DSP1INTORMASK95TO64A;        /*!< (@ 0x00000248) DSP1 Interrupt OR Mask A for IRQ95-64                      */

    struct {
      __IOM uint32_t DSP1MBINTORMASKA : 32;     /*!< [31..0] DSP1 Mailbox Interrupt OR Mask A                                  */
    } DSP1INTORMASK95TO64A_b;
  } ;
  __IM  uint32_t  RESERVED12;

  union {
    __IOM uint32_t DSP1INTORMASK31to0B;         /*!< (@ 0x00000250) DSP1 Interrupt OR Mask B for IRQ31-0                       */

    struct {
      __IOM uint32_t DSP1INTMCUIOORMASKB : 32;  /*!< [31..0] DSP1 MCU IO Interrupt OR Mask B                                   */
    } DSP1INTORMASK31to0B_b;
  } ;

  union {
    __IOM uint32_t DSP1INTORMASK63TO32B;        /*!< (@ 0x00000254) DSP1 Interrupt OR Mask A for IRQ63-32                      */

    struct {
      __IOM uint32_t DSP1TMRORMASKB : 10;       /*!< [9..0] DSP1 Timer Interrupt OR Mask B                                     */
            uint32_t            : 2;
      __IOM uint32_t DSP1I2SORMASKB : 4;        /*!< [15..12] DSP1 I2S Interrupt OR Mask B                                     */
      __IOM uint32_t DSP1PDMORMASKB : 4;        /*!< [19..16] DSP1 PDM Interrupt OR Mask B                                     */
            uint32_t            : 4;
      __IOM uint32_t DSP1GPIOORMASKB : 6;       /*!< [29..24] DSP1 GPIO Interrupt OR Mask B                                    */
            uint32_t            : 2;
    } DSP1INTORMASK63TO32B_b;
  } ;

  union {
    __IOM uint32_t DSP1INTORMASK95TO64B;        /*!< (@ 0x00000258) DSP1 Interrupt OR Mask B for IRQ95-64                      */

    struct {
      __IOM uint32_t DSP1MBINTORMASKB : 32;     /*!< [31..0] DSP1 Mailbox Interrupt OR Mask B                                  */
    } DSP1INTORMASK95TO64B_b;
  } ;
  __IM  uint32_t  RESERVED13;

  union {
    __IOM uint32_t DSP1INTENIRQ31TO0;           /*!< (@ 0x00000260) DSP1 INT Enable for IRQ31-0                                */

    struct {
      __IOM uint32_t DSP1INTENIRQ31TO0 : 32;    /*!< [31..0] DSP1 INT Enable for IRQ31-0                                       */
    } DSP1INTENIRQ31TO0_b;
  } ;

  union {
    __IOM uint32_t DSP1INTENIRQ63TO32;          /*!< (@ 0x00000264) DSP1 INT Enable for IRQ63-32                               */

    struct {
      __IOM uint32_t DSP1INTENIRQ63TO32 : 32;   /*!< [31..0] DSP1 INT Enable for IRQ63-32                                      */
    } DSP1INTENIRQ63TO32_b;
  } ;

  union {
    __IOM uint32_t DSP1INTENIRQ95TO64;          /*!< (@ 0x00000268) DSP1 INT Enable for IRQ95-64                               */

    struct {
      __IOM uint32_t DSP1INTENIRQ95TO64 : 32;   /*!< [31..0] DSP1 INT Enable for IRQ95-64                                      */
    } DSP1INTENIRQ95TO64_b;
  } ;
} DSP_Type;                                     /*!< Size = 620 (0x26c)                                                        */



/* =========================================================================================================================== */
/* ================                                           FPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Fast PIO access (FPIO)
  */

typedef struct {                                /*!< (@ 0x48001000) FPIO Structure                                             */

  union {
    __IOM uint32_t RD0;                         /*!< (@ 0x00000000) GPIO Input 0 (31-0)                                        */

    struct {
      __IOM uint32_t RD0        : 32;           /*!< [31..0] GPIO31-0 Reads pin state - read only. Returns the pad
                                                     pin state for pins 0-31 if the PINCFG's input enable (INPEN)
                                                     is active and RDZERO is inactive.                                         */
    } RD0_b;
  } ;

  union {
    __IOM uint32_t RD1;                         /*!< (@ 0x00000004) GPIO Input 1 (63-32)                                       */

    struct {
      __IOM uint32_t RD1        : 32;           /*!< [31..0] GPIO63-32 Reads pin state - read only. Returns the pad
                                                     pin state for pins 0-31 if the PINCFG's input enable (INPEN)
                                                     is active and RDZERO is inactive.                                         */
    } RD1_b;
  } ;

  union {
    __IOM uint32_t RD2;                         /*!< (@ 0x00000008) GPIO Input 2 (95-64)                                       */

    struct {
      __IOM uint32_t RD2        : 32;           /*!< [31..0] GPIO95-64 Reads pin state - read only. Returns the pad
                                                     pin state for pins 0-31 if the PINCFG's input enable (INPEN)
                                                     is active and RDZERO is inactive.                                         */
    } RD2_b;
  } ;

  union {
    __IOM uint32_t RD3;                         /*!< (@ 0x0000000C) GPIO Input 3 (127-96)                                      */

    struct {
      __IOM uint32_t RD3        : 32;           /*!< [31..0] GPIO127-96 Reads pin state - read only. Returns the
                                                     pad pin state for pins 0-31 if the PINCFG's input enable
                                                     (INPEN) is active and RDZERO is inactive.                                 */
    } RD3_b;
  } ;

  union {
    __IOM uint32_t WT0;                         /*!< (@ 0x00000010) GPIO Output 0 (31-0)                                       */

    struct {
      __IOM uint32_t WT0        : 32;           /*!< [31..0] GPIO31-0 Reads or writes pin state. Writes of 1 bits
                                                     set output pad signal if the GPIO is enabled for output.
                                                     Reads return status, including sets/clears through the
                                                     WTS and WTC registers.                                                    */
    } WT0_b;
  } ;

  union {
    __IOM uint32_t WT1;                         /*!< (@ 0x00000014) GPIO Output 1 (63-32)                                      */

    struct {
      __IOM uint32_t WT1        : 32;           /*!< [31..0] GPIO63-32 Reads or writes pin state. Writes of 1 bits
                                                     set output pad signal if the GPIO is enabled for output.
                                                     Reads return status, including sets/clears through the
                                                     WTS and WTC registers.                                                    */
    } WT1_b;
  } ;

  union {
    __IOM uint32_t WT2;                         /*!< (@ 0x00000018) GPIO Output 2 (95-64)                                      */

    struct {
      __IOM uint32_t WT2        : 32;           /*!< [31..0] GPIO95-64 Reads or writes pin state. Writes of 1 bits
                                                     set output pad signal if the GPIO is enabled for output.
                                                     Reads return status, including sets/clears through the
                                                     WTS and WTC registers.                                                    */
    } WT2_b;
  } ;

  union {
    __IOM uint32_t WT3;                         /*!< (@ 0x0000001C) GPIO Output 3 (127-96)                                     */

    struct {
      __IOM uint32_t WT3        : 32;           /*!< [31..0] GPIO127-96 Reads or writes pin state. Writes of 1 bits
                                                     set output pad signal if the GPIO is enabled for output.
                                                     Reads return status, including sets/clears through the
                                                     WTS and WTC registers.                                                    */
    } WT3_b;
  } ;

  union {
    __IOM uint32_t WTS0;                        /*!< (@ 0x00000020) GPIO Output Set 0 (31-0)                                   */

    struct {
      __IOM uint32_t WTS0       : 32;           /*!< [31..0] GPIO31-0 Sets pin state. Writing a 1 to any bit sets
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT Register.                                       */
    } WTS0_b;
  } ;

  union {
    __IOM uint32_t WTS1;                        /*!< (@ 0x00000024) GPIO Output Set 1 (63-32)                                  */

    struct {
      __IOM uint32_t WTS1       : 32;           /*!< [31..0] GPIO63-32 Sets pin state. Writing a 1 to any bit sets
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT Register.                                       */
    } WTS1_b;
  } ;

  union {
    __IOM uint32_t WTS2;                        /*!< (@ 0x00000028) GPIO Output Set 2 (95-64)                                  */

    struct {
      __IOM uint32_t WTS2       : 32;           /*!< [31..0] GPIO95-64 Sets pin state. Writing a 1 to any bit sets
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT Register.                                       */
    } WTS2_b;
  } ;

  union {
    __IOM uint32_t WTS3;                        /*!< (@ 0x0000002C) GPIO Output Set 3 (127-96)                                 */

    struct {
      __IOM uint32_t WTS3       : 32;           /*!< [31..0] GPIO127-96 Sets pin state. Writing a 1 to any bit sets
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT Register.                                       */
    } WTS3_b;
  } ;

  union {
    __IOM uint32_t WTC0;                        /*!< (@ 0x00000030) GPIO Output Clear 0 (31-0)                                 */

    struct {
      __IOM uint32_t WTC0       : 32;           /*!< [31..0] GPIO31-0 Clears pin state. Writing a 1 to any bit clears
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT register.                                       */
    } WTC0_b;
  } ;

  union {
    __IOM uint32_t WTC1;                        /*!< (@ 0x00000034) GPIO Output Clear 1 (63-32)                                */

    struct {
      __IOM uint32_t WTC1       : 32;           /*!< [31..0] GPIO63-32 Clears pin state. Writing a 1 to any bit clears
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT register.                                       */
    } WTC1_b;
  } ;

  union {
    __IOM uint32_t WTC2;                        /*!< (@ 0x00000038) GPIO Output Clear 2 (95-64)                                */

    struct {
      __IOM uint32_t WTC2       : 32;           /*!< [31..0] GPIO95-64 Clears pin state. Writing a 1 to any bit clears
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT register.                                       */
    } WTC2_b;
  } ;

  union {
    __IOM uint32_t WTC3;                        /*!< (@ 0x0000003C) GPIO Output Clear 3 (127-96)                               */

    struct {
      __IOM uint32_t WTC3       : 32;           /*!< [31..0] GPIO127-96 Clears pin state. Writing a 1 to any bit
                                                     clears the corresponding bit in the WT register if the
                                                     GPIO is enabled for output. Writing a value of 0 has no
                                                     effect on the corresponding bit in the WT register. Status
                                                     reads should be made via the WT register.                                 */
    } WTC3_b;
  } ;

  union {
    __IOM uint32_t EN0;                         /*!< (@ 0x00000040) GPIO Enable 0 (31-0)                                       */

    struct {
      __IOM uint32_t EN0        : 32;           /*!< [31..0] GPIO31-0 Enables tri-state pin output. Writing a 1 to
                                                     any bit enables, and writing a 0 to any bit disables, the
                                                     output for the corresponding GPIO. Reads return output
                                                     enable/disable status of GPIO.                                            */
    } EN0_b;
  } ;

  union {
    __IOM uint32_t EN1;                         /*!< (@ 0x00000044) GPIO Enable 1 (63-32)                                      */

    struct {
      __IOM uint32_t EN1        : 32;           /*!< [31..0] GPIO63-32 Enables tri-state pin output. Writing a 1
                                                     to any bit enables, and writing a 0 to any bit disables,
                                                     the output for the corresponding GPIO. Reads return output
                                                     enable/disable status of GPIO.                                            */
    } EN1_b;
  } ;

  union {
    __IOM uint32_t EN2;                         /*!< (@ 0x00000048) GPIO Enable 2 (95-64)                                      */

    struct {
      __IOM uint32_t EN2        : 32;           /*!< [31..0] GPIO95-64 Enables tri-state pin output. Writing a 1
                                                     to any bit enables, and writing a 0 to any bit disables,
                                                     the output for the corresponding GPIO. Reads return output
                                                     enable/disable status of GPIO.                                            */
    } EN2_b;
  } ;

  union {
    __IOM uint32_t EN3;                         /*!< (@ 0x0000004C) GPIO Enable 3 (127-96)                                     */

    struct {
      __IOM uint32_t EN3        : 32;           /*!< [31..0] GPIO127-96 Enables tri-state pin output. Writing a 1
                                                     to any bit enables, and writing a 0 to any bit disables,
                                                     the output for the corresponding GPIO. Reads return output
                                                     enable/disable status of GPIO.                                            */
    } EN3_b;
  } ;

  union {
    __IOM uint32_t ENS0;                        /*!< (@ 0x00000050) GPIO Enable Set 0 (31-0)                                   */

    struct {
      __IOM uint32_t ENS0       : 32;           /*!< [31..0] GPIO31-0 Sets pin tri-state output enables. Writing
                                                     a 1 to any bit sets the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENS0_b;
  } ;

  union {
    __IOM uint32_t ENS1;                        /*!< (@ 0x00000054) GPIO Enable Set 1 (63-32)                                  */

    struct {
      __IOM uint32_t ENS1       : 32;           /*!< [31..0] GPIO63-32 Sets pin tri-state output enables. Writing
                                                     a 1 to any bit sets the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENS1_b;
  } ;

  union {
    __IOM uint32_t ENS2;                        /*!< (@ 0x00000058) GPIO Enable Set 2 (95-64)                                  */

    struct {
      __IOM uint32_t ENS2       : 32;           /*!< [31..0] GPIO95-64 Sets pin tri-state output enables. Writing
                                                     a 1 to any bit sets the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENS2_b;
  } ;

  union {
    __IOM uint32_t ENS3;                        /*!< (@ 0x0000005C) GPIO Enable Set 3 (127-96)                                 */

    struct {
      __IOM uint32_t ENS3       : 32;           /*!< [31..0] GPIO127-96 Sets pin tri-state output enables. Writing
                                                     a 1 to any bit sets the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENS3_b;
  } ;

  union {
    __IOM uint32_t ENC0;                        /*!< (@ 0x00000060) GPIO Enable Clear 0 (31-0)                                 */

    struct {
      __IOM uint32_t ENC0       : 32;           /*!< [31..0] GPIO31-0 Clears pin tri-state output enables. Writing
                                                     a 1 to any bit clears the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENC0_b;
  } ;

  union {
    __IOM uint32_t ENC1;                        /*!< (@ 0x00000064) GPIO Enable Clear 1 (63-32)                                */

    struct {
      __IOM uint32_t ENC1       : 32;           /*!< [31..0] GPIO63-32 Clears pin tri-state output enables. Writing
                                                     a 1 to any bit clears the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENC1_b;
  } ;

  union {
    __IOM uint32_t ENC2;                        /*!< (@ 0x00000068) GPIO Enable Clear 2 (95-64)                                */

    struct {
      __IOM uint32_t ENC2       : 32;           /*!< [31..0] GPIO95-64 Clears pin tri-state output enables. Writing
                                                     a 1 to any bit clears the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENC2_b;
  } ;

  union {
    __IOM uint32_t ENC3;                        /*!< (@ 0x0000006C) GPIO Enable Clear 3 (127-96)                               */

    struct {
      __IOM uint32_t ENC3       : 32;           /*!< [31..0] GPIO127-96 Clears pin tri-state output enables. Writing
                                                     a 1 to any bit clears the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENC3_b;
  } ;
} FPIO_Type;                                    /*!< Size = 112 (0x70)                                                         */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose IO (GPIO)
  */

typedef struct {                                /*!< (@ 0x40010000) GPIO Structure                                             */

  union {
    __IOM uint32_t PINCFG0;                     /*!< (@ 0x00000000) Controls the operation of GPIO pin 0.                      */

    struct {
      __IOM uint32_t FNCSEL0    : 4;            /*!< [3..0] Function select for GPIO pin 0                                     */
      __IOM uint32_t INPEN0     : 1;            /*!< [4..4] Input enable for GPIO 0                                            */
      __IOM uint32_t RDZERO0    : 1;            /*!< [5..5] Return 0 for read data on GPIO 0                                   */
      __IOM uint32_t IRPTEN0    : 2;            /*!< [7..6] Interrupt enable for GPIO 0                                        */
      __IOM uint32_t OUTCFG0    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 0                               */
      __IOM uint32_t DS0        : 2;            /*!< [11..10] Drive strength selection for GPIO 0                              */
      __IOM uint32_t SR0        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG0   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 0                         */
      __IOM uint32_t NCESRC0    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 0, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL0    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 0                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN0      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN0      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG0_b;
  } ;

  union {
    __IOM uint32_t PINCFG1;                     /*!< (@ 0x00000004) Controls the operation of GPIO pin 1.                      */

    struct {
      __IOM uint32_t FNCSEL1    : 4;            /*!< [3..0] Function select for GPIO pin 1                                     */
      __IOM uint32_t INPEN1     : 1;            /*!< [4..4] Input enable for GPIO 1                                            */
      __IOM uint32_t RDZERO1    : 1;            /*!< [5..5] Return 0 for read data on GPIO 1                                   */
      __IOM uint32_t IRPTEN1    : 2;            /*!< [7..6] Interrupt enable for GPIO 1                                        */
      __IOM uint32_t OUTCFG1    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 1                               */
      __IOM uint32_t DS1        : 2;            /*!< [11..10] Drive strength selection for GPIO 1                              */
      __IOM uint32_t SR1        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG1   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 1                         */
      __IOM uint32_t NCESRC1    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 1, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL1    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 1                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN1      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN1      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG1_b;
  } ;

  union {
    __IOM uint32_t PINCFG2;                     /*!< (@ 0x00000008) Controls the operation of GPIO pin 2.                      */

    struct {
      __IOM uint32_t FNCSEL2    : 4;            /*!< [3..0] Function select for GPIO pin 2                                     */
      __IOM uint32_t INPEN2     : 1;            /*!< [4..4] Input enable for GPIO 2                                            */
      __IOM uint32_t RDZERO2    : 1;            /*!< [5..5] Return 0 for read data on GPIO 2                                   */
      __IOM uint32_t IRPTEN2    : 2;            /*!< [7..6] Interrupt enable for GPIO 2                                        */
      __IOM uint32_t OUTCFG2    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 2                               */
      __IOM uint32_t DS2        : 2;            /*!< [11..10] Drive strength selection for GPIO 2                              */
      __IOM uint32_t SR2        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG2   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 2                         */
      __IOM uint32_t NCESRC2    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 2, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL2    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 2                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN2      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN2      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG2_b;
  } ;

  union {
    __IOM uint32_t PINCFG3;                     /*!< (@ 0x0000000C) Controls the operation of GPIO pin 3.                      */

    struct {
      __IOM uint32_t FNCSEL3    : 4;            /*!< [3..0] Function select for GPIO pin 3                                     */
      __IOM uint32_t INPEN3     : 1;            /*!< [4..4] Input enable for GPIO 3                                            */
      __IOM uint32_t RDZERO3    : 1;            /*!< [5..5] Return 0 for read data on GPIO 3                                   */
      __IOM uint32_t IRPTEN3    : 2;            /*!< [7..6] Interrupt enable for GPIO 3                                        */
      __IOM uint32_t OUTCFG3    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 3                               */
      __IOM uint32_t DS3        : 2;            /*!< [11..10] Drive strength selection for GPIO 3                              */
      __IOM uint32_t SR3        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG3   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 3                         */
      __IOM uint32_t NCESRC3    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 3, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL3    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 3                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN3      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN3      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG3_b;
  } ;

  union {
    __IOM uint32_t PINCFG4;                     /*!< (@ 0x00000010) Controls the operation of GPIO pin 4.                      */

    struct {
      __IOM uint32_t FNCSEL4    : 4;            /*!< [3..0] Function select for GPIO pin 4                                     */
      __IOM uint32_t INPEN4     : 1;            /*!< [4..4] Input enable for GPIO 4                                            */
      __IOM uint32_t RDZERO4    : 1;            /*!< [5..5] Return 0 for read data on GPIO 4                                   */
      __IOM uint32_t IRPTEN4    : 2;            /*!< [7..6] Interrupt enable for GPIO 4                                        */
      __IOM uint32_t OUTCFG4    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 4                               */
      __IOM uint32_t DS4        : 2;            /*!< [11..10] Drive strength selection for GPIO 4                              */
      __IOM uint32_t SR4        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG4   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 4                         */
      __IOM uint32_t NCESRC4    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 4, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL4    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 4                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN4      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN4      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG4_b;
  } ;

  union {
    __IOM uint32_t PINCFG5;                     /*!< (@ 0x00000014) Controls the operation of GPIO pin 5.                      */

    struct {
      __IOM uint32_t FNCSEL5    : 4;            /*!< [3..0] Function select for GPIO pin 5                                     */
      __IOM uint32_t INPEN5     : 1;            /*!< [4..4] Input enable for GPIO 5                                            */
      __IOM uint32_t RDZERO5    : 1;            /*!< [5..5] Return 0 for read data on GPIO 5                                   */
      __IOM uint32_t IRPTEN5    : 2;            /*!< [7..6] Interrupt enable for GPIO 5                                        */
      __IOM uint32_t OUTCFG5    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 5                               */
      __IOM uint32_t DS5        : 2;            /*!< [11..10] Drive strength selection for GPIO 5                              */
      __IOM uint32_t SR5        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG5   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 5                         */
      __IOM uint32_t NCESRC5    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 5, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL5    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 5                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN5      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN5      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG5_b;
  } ;

  union {
    __IOM uint32_t PINCFG6;                     /*!< (@ 0x00000018) Controls the operation of GPIO pin 6.                      */

    struct {
      __IOM uint32_t FNCSEL6    : 4;            /*!< [3..0] Function select for GPIO pin 6                                     */
      __IOM uint32_t INPEN6     : 1;            /*!< [4..4] Input enable for GPIO 6                                            */
      __IOM uint32_t RDZERO6    : 1;            /*!< [5..5] Return 0 for read data on GPIO 6                                   */
      __IOM uint32_t IRPTEN6    : 2;            /*!< [7..6] Interrupt enable for GPIO 6                                        */
      __IOM uint32_t OUTCFG6    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 6                               */
      __IOM uint32_t DS6        : 2;            /*!< [11..10] Drive strength selection for GPIO 6                              */
      __IOM uint32_t SR6        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG6   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 6                         */
      __IOM uint32_t NCESRC6    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 6, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL6    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 6                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN6      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN6      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG6_b;
  } ;

  union {
    __IOM uint32_t PINCFG7;                     /*!< (@ 0x0000001C) Controls the operation of GPIO pin 7.                      */

    struct {
      __IOM uint32_t FNCSEL7    : 4;            /*!< [3..0] Function select for GPIO pin 7                                     */
      __IOM uint32_t INPEN7     : 1;            /*!< [4..4] Input enable for GPIO 7                                            */
      __IOM uint32_t RDZERO7    : 1;            /*!< [5..5] Return 0 for read data on GPIO 7                                   */
      __IOM uint32_t IRPTEN7    : 2;            /*!< [7..6] Interrupt enable for GPIO 7                                        */
      __IOM uint32_t OUTCFG7    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 7                               */
      __IOM uint32_t DS7        : 2;            /*!< [11..10] Drive strength selection for GPIO 7                              */
      __IOM uint32_t SR7        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG7   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 7                         */
      __IOM uint32_t NCESRC7    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 7, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL7    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 7                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN7      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN7      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG7_b;
  } ;

  union {
    __IOM uint32_t PINCFG8;                     /*!< (@ 0x00000020) Controls the operation of GPIO pin 8.                      */

    struct {
      __IOM uint32_t FNCSEL8    : 4;            /*!< [3..0] Function select for GPIO pin 8                                     */
      __IOM uint32_t INPEN8     : 1;            /*!< [4..4] Input enable for GPIO 8                                            */
      __IOM uint32_t RDZERO8    : 1;            /*!< [5..5] Return 0 for read data on GPIO 8                                   */
      __IOM uint32_t IRPTEN8    : 2;            /*!< [7..6] Interrupt enable for GPIO 8                                        */
      __IOM uint32_t OUTCFG8    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 8                               */
      __IOM uint32_t DS8        : 2;            /*!< [11..10] Drive strength selection for GPIO 8                              */
      __IOM uint32_t SR8        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG8   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 8                         */
      __IOM uint32_t NCESRC8    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 8, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL8    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 8                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN8      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN8      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG8_b;
  } ;

  union {
    __IOM uint32_t PINCFG9;                     /*!< (@ 0x00000024) Controls the operation of GPIO pin 9.                      */

    struct {
      __IOM uint32_t FNCSEL9    : 4;            /*!< [3..0] Function select for GPIO pin 9                                     */
      __IOM uint32_t INPEN9     : 1;            /*!< [4..4] Input enable for GPIO 9                                            */
      __IOM uint32_t RDZERO9    : 1;            /*!< [5..5] Return 0 for read data on GPIO 9                                   */
      __IOM uint32_t IRPTEN9    : 2;            /*!< [7..6] Interrupt enable for GPIO 9                                        */
      __IOM uint32_t OUTCFG9    : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 9                               */
      __IOM uint32_t DS9        : 2;            /*!< [11..10] Drive strength selection for GPIO 9                              */
      __IOM uint32_t SR9        : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG9   : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 9                         */
      __IOM uint32_t NCESRC9    : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 9, DISP control signals DE,
                                                     CSX, and CS. Polarity is determined by CE_POLARITY field                  */
      __IOM uint32_t NCEPOL9    : 1;            /*!< [22..22] Polarity select for NCE for GPIO 9                               */
            uint32_t            : 3;
      __IOM uint32_t FIEN9      : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN9      : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG9_b;
  } ;

  union {
    __IOM uint32_t PINCFG10;                    /*!< (@ 0x00000028) Controls the operation of GPIO pin 10.                     */

    struct {
      __IOM uint32_t FNCSEL10   : 4;            /*!< [3..0] Function select for GPIO pin 10                                    */
      __IOM uint32_t INPEN10    : 1;            /*!< [4..4] Input enable for GPIO 10                                           */
      __IOM uint32_t RDZERO10   : 1;            /*!< [5..5] Return 0 for read data on GPIO 10                                  */
      __IOM uint32_t IRPTEN10   : 2;            /*!< [7..6] Interrupt enable for GPIO 10                                       */
      __IOM uint32_t OUTCFG10   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 10                              */
      __IOM uint32_t DS10       : 2;            /*!< [11..10] Drive strength selection for GPIO 10                             */
      __IOM uint32_t SR10       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG10  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 10                        */
      __IOM uint32_t NCESRC10   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 10, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL10   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 10                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN10     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN10     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG10_b;
  } ;

  union {
    __IOM uint32_t PINCFG11;                    /*!< (@ 0x0000002C) Controls the operation of GPIO pin 11.                     */

    struct {
      __IOM uint32_t FNCSEL11   : 4;            /*!< [3..0] Function select for GPIO pin 11                                    */
      __IOM uint32_t INPEN11    : 1;            /*!< [4..4] Input enable for GPIO 11                                           */
      __IOM uint32_t RDZERO11   : 1;            /*!< [5..5] Return 0 for read data on GPIO 11                                  */
      __IOM uint32_t IRPTEN11   : 2;            /*!< [7..6] Interrupt enable for GPIO 11                                       */
      __IOM uint32_t OUTCFG11   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 11                              */
      __IOM uint32_t DS11       : 2;            /*!< [11..10] Drive strength selection for GPIO 11                             */
      __IOM uint32_t SR11       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG11  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 11                        */
      __IOM uint32_t NCESRC11   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 11, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL11   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 11                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN11     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN11     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG11_b;
  } ;

  union {
    __IOM uint32_t PINCFG12;                    /*!< (@ 0x00000030) Controls the operation of GPIO pin 12.                     */

    struct {
      __IOM uint32_t FNCSEL12   : 4;            /*!< [3..0] Function select for GPIO pin 12                                    */
      __IOM uint32_t INPEN12    : 1;            /*!< [4..4] Input enable for GPIO 12                                           */
      __IOM uint32_t RDZERO12   : 1;            /*!< [5..5] Return 0 for read data on GPIO 12                                  */
      __IOM uint32_t IRPTEN12   : 2;            /*!< [7..6] Interrupt enable for GPIO 12                                       */
      __IOM uint32_t OUTCFG12   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 12                              */
      __IOM uint32_t DS12       : 2;            /*!< [11..10] Drive strength selection for GPIO 12                             */
      __IOM uint32_t SR12       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG12  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 12                        */
      __IOM uint32_t NCESRC12   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 12, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL12   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 12                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN12     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN12     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG12_b;
  } ;

  union {
    __IOM uint32_t PINCFG13;                    /*!< (@ 0x00000034) Controls the operation of GPIO pin 13.                     */

    struct {
      __IOM uint32_t FNCSEL13   : 4;            /*!< [3..0] Function select for GPIO pin 13                                    */
      __IOM uint32_t INPEN13    : 1;            /*!< [4..4] Input enable for GPIO 13                                           */
      __IOM uint32_t RDZERO13   : 1;            /*!< [5..5] Return 0 for read data on GPIO 13                                  */
      __IOM uint32_t IRPTEN13   : 2;            /*!< [7..6] Interrupt enable for GPIO 13                                       */
      __IOM uint32_t OUTCFG13   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 13                              */
      __IOM uint32_t DS13       : 2;            /*!< [11..10] Drive strength selection for GPIO 13                             */
      __IOM uint32_t SR13       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG13  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 13                        */
      __IOM uint32_t NCESRC13   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 13, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL13   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 13                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN13     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN13     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG13_b;
  } ;

  union {
    __IOM uint32_t PINCFG14;                    /*!< (@ 0x00000038) Controls the operation of GPIO pin 14.                     */

    struct {
      __IOM uint32_t FNCSEL14   : 4;            /*!< [3..0] Function select for GPIO pin 14                                    */
      __IOM uint32_t INPEN14    : 1;            /*!< [4..4] Input enable for GPIO 14                                           */
      __IOM uint32_t RDZERO14   : 1;            /*!< [5..5] Return 0 for read data on GPIO 14                                  */
      __IOM uint32_t IRPTEN14   : 2;            /*!< [7..6] Interrupt enable for GPIO 14                                       */
      __IOM uint32_t OUTCFG14   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 14                              */
      __IOM uint32_t DS14       : 2;            /*!< [11..10] Drive strength selection for GPIO 14                             */
      __IOM uint32_t SR14       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG14  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 14                        */
      __IOM uint32_t NCESRC14   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 14, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL14   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 14                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN14     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN14     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG14_b;
  } ;

  union {
    __IOM uint32_t PINCFG15;                    /*!< (@ 0x0000003C) Controls the operation of GPIO pin 15.                     */

    struct {
      __IOM uint32_t FNCSEL15   : 4;            /*!< [3..0] Function select for GPIO pin 15                                    */
      __IOM uint32_t INPEN15    : 1;            /*!< [4..4] Input enable for GPIO 15                                           */
      __IOM uint32_t RDZERO15   : 1;            /*!< [5..5] Return 0 for read data on GPIO 15                                  */
      __IOM uint32_t IRPTEN15   : 2;            /*!< [7..6] Interrupt enable for GPIO 15                                       */
      __IOM uint32_t OUTCFG15   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 15                              */
      __IOM uint32_t DS15       : 2;            /*!< [11..10] Drive strength selection for GPIO 15                             */
      __IOM uint32_t SR15       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG15  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 15                        */
      __IOM uint32_t NCESRC15   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 15, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL15   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 15                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN15     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN15     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG15_b;
  } ;

  union {
    __IOM uint32_t PINCFG16;                    /*!< (@ 0x00000040) Controls the operation of GPIO pin 16.                     */

    struct {
      __IOM uint32_t FNCSEL16   : 4;            /*!< [3..0] Function select for GPIO pin 16                                    */
      __IOM uint32_t INPEN16    : 1;            /*!< [4..4] Input enable for GPIO 16                                           */
      __IOM uint32_t RDZERO16   : 1;            /*!< [5..5] Return 0 for read data on GPIO 16                                  */
      __IOM uint32_t IRPTEN16   : 2;            /*!< [7..6] Interrupt enable for GPIO 16                                       */
      __IOM uint32_t OUTCFG16   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 16                              */
      __IOM uint32_t DS16       : 2;            /*!< [11..10] Drive strength selection for GPIO 16                             */
      __IOM uint32_t SR16       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG16  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 16                        */
      __IOM uint32_t NCESRC16   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 16, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL16   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 16                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN16     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN16     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG16_b;
  } ;

  union {
    __IOM uint32_t PINCFG17;                    /*!< (@ 0x00000044) Controls the operation of GPIO pin 17.                     */

    struct {
      __IOM uint32_t FNCSEL17   : 4;            /*!< [3..0] Function select for GPIO pin 17                                    */
      __IOM uint32_t INPEN17    : 1;            /*!< [4..4] Input enable for GPIO 17                                           */
      __IOM uint32_t RDZERO17   : 1;            /*!< [5..5] Return 0 for read data on GPIO 17                                  */
      __IOM uint32_t IRPTEN17   : 2;            /*!< [7..6] Interrupt enable for GPIO 17                                       */
      __IOM uint32_t OUTCFG17   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 17                              */
      __IOM uint32_t DS17       : 2;            /*!< [11..10] Drive strength selection for GPIO 17                             */
      __IOM uint32_t SR17       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG17  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 17                        */
      __IOM uint32_t NCESRC17   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 17, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL17   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 17                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN17     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN17     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG17_b;
  } ;

  union {
    __IOM uint32_t PINCFG18;                    /*!< (@ 0x00000048) Controls the operation of GPIO pin 18.                     */

    struct {
      __IOM uint32_t FNCSEL18   : 4;            /*!< [3..0] Function select for GPIO pin 18                                    */
      __IOM uint32_t INPEN18    : 1;            /*!< [4..4] Input enable for GPIO 18                                           */
      __IOM uint32_t RDZERO18   : 1;            /*!< [5..5] Return 0 for read data on GPIO 18                                  */
      __IOM uint32_t IRPTEN18   : 2;            /*!< [7..6] Interrupt enable for GPIO 18                                       */
      __IOM uint32_t OUTCFG18   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 18                              */
      __IOM uint32_t DS18       : 2;            /*!< [11..10] Drive strength selection for GPIO 18                             */
      __IOM uint32_t SR18       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG18  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 18                        */
      __IOM uint32_t NCESRC18   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 18, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL18   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 18                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN18     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN18     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG18_b;
  } ;

  union {
    __IOM uint32_t PINCFG19;                    /*!< (@ 0x0000004C) Controls the operation of GPIO pin 19.                     */

    struct {
      __IOM uint32_t FNCSEL19   : 4;            /*!< [3..0] Function select for GPIO pin 19                                    */
      __IOM uint32_t INPEN19    : 1;            /*!< [4..4] Input enable for GPIO 19                                           */
      __IOM uint32_t RDZERO19   : 1;            /*!< [5..5] Return 0 for read data on GPIO 19                                  */
      __IOM uint32_t IRPTEN19   : 2;            /*!< [7..6] Interrupt enable for GPIO 19                                       */
      __IOM uint32_t OUTCFG19   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 19                              */
      __IOM uint32_t DS19       : 2;            /*!< [11..10] Drive strength selection for GPIO 19                             */
      __IOM uint32_t SR19       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG19  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 19                        */
      __IOM uint32_t NCESRC19   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 19, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL19   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 19                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN19     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN19     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG19_b;
  } ;

  union {
    __IOM uint32_t PINCFG20;                    /*!< (@ 0x00000050) Controls the operation of GPIO pin 20.                     */

    struct {
      __IOM uint32_t FNCSEL20   : 4;            /*!< [3..0] Function select for GPIO pin 20                                    */
      __IOM uint32_t INPEN20    : 1;            /*!< [4..4] Input enable for GPIO 20                                           */
      __IOM uint32_t RDZERO20   : 1;            /*!< [5..5] Return 0 for read data on GPIO 20                                  */
      __IOM uint32_t IRPTEN20   : 2;            /*!< [7..6] Interrupt enable for GPIO 20                                       */
      __IOM uint32_t OUTCFG20   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 20                              */
      __IOM uint32_t DS20       : 2;            /*!< [11..10] Drive strength selection for GPIO 20                             */
      __IOM uint32_t SR20       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG20  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 20                        */
      __IOM uint32_t NCESRC20   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 20, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL20   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 20                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN20     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN20     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG20_b;
  } ;

  union {
    __IOM uint32_t PINCFG21;                    /*!< (@ 0x00000054) Controls the operation of GPIO pin 21.                     */

    struct {
      __IOM uint32_t FNCSEL21   : 4;            /*!< [3..0] Function select for GPIO pin 21                                    */
      __IOM uint32_t INPEN21    : 1;            /*!< [4..4] Input enable for GPIO 21                                           */
      __IOM uint32_t RDZERO21   : 1;            /*!< [5..5] Return 0 for read data on GPIO 21                                  */
      __IOM uint32_t IRPTEN21   : 2;            /*!< [7..6] Interrupt enable for GPIO 21                                       */
      __IOM uint32_t OUTCFG21   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 21                              */
      __IOM uint32_t DS21       : 2;            /*!< [11..10] Drive strength selection for GPIO 21                             */
      __IOM uint32_t SR21       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG21  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 21                        */
      __IOM uint32_t NCESRC21   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 21, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL21   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 21                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN21     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN21     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG21_b;
  } ;

  union {
    __IOM uint32_t PINCFG22;                    /*!< (@ 0x00000058) Controls the operation of GPIO pin 22.                     */

    struct {
      __IOM uint32_t FNCSEL22   : 4;            /*!< [3..0] Function select for GPIO pin 22                                    */
      __IOM uint32_t INPEN22    : 1;            /*!< [4..4] Input enable for GPIO 22                                           */
      __IOM uint32_t RDZERO22   : 1;            /*!< [5..5] Return 0 for read data on GPIO 22                                  */
      __IOM uint32_t IRPTEN22   : 2;            /*!< [7..6] Interrupt enable for GPIO 22                                       */
      __IOM uint32_t OUTCFG22   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 22                              */
      __IOM uint32_t DS22       : 2;            /*!< [11..10] Drive strength selection for GPIO 22                             */
      __IOM uint32_t SR22       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG22  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 22                        */
      __IOM uint32_t NCESRC22   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 22, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL22   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 22                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN22     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN22     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG22_b;
  } ;

  union {
    __IOM uint32_t PINCFG23;                    /*!< (@ 0x0000005C) Controls the operation of GPIO pin 23.                     */

    struct {
      __IOM uint32_t FNCSEL23   : 4;            /*!< [3..0] Function select for GPIO pin 23                                    */
      __IOM uint32_t INPEN23    : 1;            /*!< [4..4] Input enable for GPIO 23                                           */
      __IOM uint32_t RDZERO23   : 1;            /*!< [5..5] Return 0 for read data on GPIO 23                                  */
      __IOM uint32_t IRPTEN23   : 2;            /*!< [7..6] Interrupt enable for GPIO 23                                       */
      __IOM uint32_t OUTCFG23   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 23                              */
      __IOM uint32_t DS23       : 2;            /*!< [11..10] Drive strength selection for GPIO 23                             */
      __IOM uint32_t SR23       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG23  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 23                        */
      __IOM uint32_t NCESRC23   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 23, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL23   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 23                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN23     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN23     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG23_b;
  } ;

  union {
    __IOM uint32_t PINCFG24;                    /*!< (@ 0x00000060) Controls the operation of GPIO pin 24.                     */

    struct {
      __IOM uint32_t FNCSEL24   : 4;            /*!< [3..0] Function select for GPIO pin 24                                    */
      __IOM uint32_t INPEN24    : 1;            /*!< [4..4] Input enable for GPIO 24                                           */
      __IOM uint32_t RDZERO24   : 1;            /*!< [5..5] Return 0 for read data on GPIO 24                                  */
      __IOM uint32_t IRPTEN24   : 2;            /*!< [7..6] Interrupt enable for GPIO 24                                       */
      __IOM uint32_t OUTCFG24   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 24                              */
      __IOM uint32_t DS24       : 2;            /*!< [11..10] Drive strength selection for GPIO 24                             */
      __IOM uint32_t SR24       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG24  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 24                        */
      __IOM uint32_t NCESRC24   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 24, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL24   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 24                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN24     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN24     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG24_b;
  } ;

  union {
    __IOM uint32_t PINCFG25;                    /*!< (@ 0x00000064) Controls the operation of GPIO pin 25.                     */

    struct {
      __IOM uint32_t FNCSEL25   : 4;            /*!< [3..0] Function select for GPIO pin 25                                    */
      __IOM uint32_t INPEN25    : 1;            /*!< [4..4] Input enable for GPIO 25                                           */
      __IOM uint32_t RDZERO25   : 1;            /*!< [5..5] Return 0 for read data on GPIO 25                                  */
      __IOM uint32_t IRPTEN25   : 2;            /*!< [7..6] Interrupt enable for GPIO 25                                       */
      __IOM uint32_t OUTCFG25   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 25                              */
      __IOM uint32_t DS25       : 2;            /*!< [11..10] Drive strength selection for GPIO 25                             */
      __IOM uint32_t SR25       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG25  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 25                        */
      __IOM uint32_t NCESRC25   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 25, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL25   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 25                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN25     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN25     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG25_b;
  } ;

  union {
    __IOM uint32_t PINCFG26;                    /*!< (@ 0x00000068) Controls the operation of GPIO pin 26.                     */

    struct {
      __IOM uint32_t FNCSEL26   : 4;            /*!< [3..0] Function select for GPIO pin 26                                    */
      __IOM uint32_t INPEN26    : 1;            /*!< [4..4] Input enable for GPIO 26                                           */
      __IOM uint32_t RDZERO26   : 1;            /*!< [5..5] Return 0 for read data on GPIO 26                                  */
      __IOM uint32_t IRPTEN26   : 2;            /*!< [7..6] Interrupt enable for GPIO 26                                       */
      __IOM uint32_t OUTCFG26   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 26                              */
      __IOM uint32_t DS26       : 2;            /*!< [11..10] Drive strength selection for GPIO 26                             */
      __IOM uint32_t SR26       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG26  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 26                        */
      __IOM uint32_t NCESRC26   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 26, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL26   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 26                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN26     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN26     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG26_b;
  } ;

  union {
    __IOM uint32_t PINCFG27;                    /*!< (@ 0x0000006C) Controls the operation of GPIO pin 27.                     */

    struct {
      __IOM uint32_t FNCSEL27   : 4;            /*!< [3..0] Function select for GPIO pin 27                                    */
      __IOM uint32_t INPEN27    : 1;            /*!< [4..4] Input enable for GPIO 27                                           */
      __IOM uint32_t RDZERO27   : 1;            /*!< [5..5] Return 0 for read data on GPIO 27                                  */
      __IOM uint32_t IRPTEN27   : 2;            /*!< [7..6] Interrupt enable for GPIO 27                                       */
      __IOM uint32_t OUTCFG27   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 27                              */
      __IOM uint32_t DS27       : 2;            /*!< [11..10] Drive strength selection for GPIO 27                             */
      __IOM uint32_t SR27       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG27  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 27                        */
      __IOM uint32_t NCESRC27   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 27, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL27   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 27                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN27     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN27     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG27_b;
  } ;

  union {
    __IOM uint32_t PINCFG28;                    /*!< (@ 0x00000070) Controls the operation of GPIO pin 28.                     */

    struct {
      __IOM uint32_t FNCSEL28   : 4;            /*!< [3..0] Function select for GPIO pin 28                                    */
      __IOM uint32_t INPEN28    : 1;            /*!< [4..4] Input enable for GPIO 28                                           */
      __IOM uint32_t RDZERO28   : 1;            /*!< [5..5] Return 0 for read data on GPIO 28                                  */
      __IOM uint32_t IRPTEN28   : 2;            /*!< [7..6] Interrupt enable for GPIO 28                                       */
      __IOM uint32_t OUTCFG28   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 28                              */
      __IOM uint32_t DS28       : 2;            /*!< [11..10] Drive strength selection for GPIO 28                             */
      __IOM uint32_t SR28       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG28  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 28                        */
      __IOM uint32_t NCESRC28   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 28, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL28   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 28                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN28     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN28     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG28_b;
  } ;

  union {
    __IOM uint32_t PINCFG29;                    /*!< (@ 0x00000074) Controls the operation of GPIO pin 29.                     */

    struct {
      __IOM uint32_t FNCSEL29   : 4;            /*!< [3..0] Function select for GPIO pin 29                                    */
      __IOM uint32_t INPEN29    : 1;            /*!< [4..4] Input enable for GPIO 29                                           */
      __IOM uint32_t RDZERO29   : 1;            /*!< [5..5] Return 0 for read data on GPIO 29                                  */
      __IOM uint32_t IRPTEN29   : 2;            /*!< [7..6] Interrupt enable for GPIO 29                                       */
      __IOM uint32_t OUTCFG29   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 29                              */
      __IOM uint32_t DS29       : 2;            /*!< [11..10] Drive strength selection for GPIO 29                             */
      __IOM uint32_t SR29       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG29  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 29                        */
      __IOM uint32_t NCESRC29   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 29, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL29   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 29                              */
            uint32_t            : 2;
      __IOM uint32_t VSSPWRSWEN29 : 1;          /*!< [25..25] VSS power switch enable. Enable VSS power switch when
                                                     driving pad signal to 0 for GPIO 29                                       */
      __IOM uint32_t FIEN29     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN29     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG29_b;
  } ;

  union {
    __IOM uint32_t PINCFG30;                    /*!< (@ 0x00000078) Controls the operation of GPIO pin 30.                     */

    struct {
      __IOM uint32_t FNCSEL30   : 4;            /*!< [3..0] Function select for GPIO pin 30                                    */
      __IOM uint32_t INPEN30    : 1;            /*!< [4..4] Input enable for GPIO 30                                           */
      __IOM uint32_t RDZERO30   : 1;            /*!< [5..5] Return 0 for read data on GPIO 30                                  */
      __IOM uint32_t IRPTEN30   : 2;            /*!< [7..6] Interrupt enable for GPIO 30                                       */
      __IOM uint32_t OUTCFG30   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 30                              */
      __IOM uint32_t DS30       : 2;            /*!< [11..10] Drive strength selection for GPIO 30                             */
      __IOM uint32_t SR30       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG30  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 30                        */
      __IOM uint32_t NCESRC30   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 30, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL30   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 30                              */
            uint32_t            : 2;
      __IOM uint32_t VDDPWRSWEN30 : 1;          /*!< [25..25] VDD power switch enable. Enable VDD power switch when
                                                     driving pad signal to 1 for GPIO 30                                       */
      __IOM uint32_t FIEN30     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN30     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG30_b;
  } ;

  union {
    __IOM uint32_t PINCFG31;                    /*!< (@ 0x0000007C) Controls the operation of GPIO pin 31.                     */

    struct {
      __IOM uint32_t FNCSEL31   : 4;            /*!< [3..0] Function select for GPIO pin 31                                    */
      __IOM uint32_t INPEN31    : 1;            /*!< [4..4] Input enable for GPIO 31                                           */
      __IOM uint32_t RDZERO31   : 1;            /*!< [5..5] Return 0 for read data on GPIO 31                                  */
      __IOM uint32_t IRPTEN31   : 2;            /*!< [7..6] Interrupt enable for GPIO 31                                       */
      __IOM uint32_t OUTCFG31   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 31                              */
      __IOM uint32_t DS31       : 2;            /*!< [11..10] Drive strength selection for GPIO 31                             */
      __IOM uint32_t SR31       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG31  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 31                        */
      __IOM uint32_t NCESRC31   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 31, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL31   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 31                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN31     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN31     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG31_b;
  } ;

  union {
    __IOM uint32_t PINCFG32;                    /*!< (@ 0x00000080) Controls the operation of GPIO pin 32.                     */

    struct {
      __IOM uint32_t FNCSEL32   : 4;            /*!< [3..0] Function select for GPIO pin 32                                    */
      __IOM uint32_t INPEN32    : 1;            /*!< [4..4] Input enable for GPIO 32                                           */
      __IOM uint32_t RDZERO32   : 1;            /*!< [5..5] Return 0 for read data on GPIO 32                                  */
      __IOM uint32_t IRPTEN32   : 2;            /*!< [7..6] Interrupt enable for GPIO 32                                       */
      __IOM uint32_t OUTCFG32   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 32                              */
      __IOM uint32_t DS32       : 2;            /*!< [11..10] Drive strength selection for GPIO 32                             */
      __IOM uint32_t SR32       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG32  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 32                        */
      __IOM uint32_t NCESRC32   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 32, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL32   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 32                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN32     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN32     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG32_b;
  } ;

  union {
    __IOM uint32_t PINCFG33;                    /*!< (@ 0x00000084) Controls the operation of GPIO pin 33.                     */

    struct {
      __IOM uint32_t FNCSEL33   : 4;            /*!< [3..0] Function select for GPIO pin 33                                    */
      __IOM uint32_t INPEN33    : 1;            /*!< [4..4] Input enable for GPIO 33                                           */
      __IOM uint32_t RDZERO33   : 1;            /*!< [5..5] Return 0 for read data on GPIO 33                                  */
      __IOM uint32_t IRPTEN33   : 2;            /*!< [7..6] Interrupt enable for GPIO 33                                       */
      __IOM uint32_t OUTCFG33   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 33                              */
      __IOM uint32_t DS33       : 2;            /*!< [11..10] Drive strength selection for GPIO 33                             */
      __IOM uint32_t SR33       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG33  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 33                        */
      __IOM uint32_t NCESRC33   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 33, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL33   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 33                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN33     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN33     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG33_b;
  } ;

  union {
    __IOM uint32_t PINCFG34;                    /*!< (@ 0x00000088) Controls the operation of GPIO pin 34.                     */

    struct {
      __IOM uint32_t FNCSEL34   : 4;            /*!< [3..0] Function select for GPIO pin 34                                    */
      __IOM uint32_t INPEN34    : 1;            /*!< [4..4] Input enable for GPIO 34                                           */
      __IOM uint32_t RDZERO34   : 1;            /*!< [5..5] Return 0 for read data on GPIO 34                                  */
      __IOM uint32_t IRPTEN34   : 2;            /*!< [7..6] Interrupt enable for GPIO 34                                       */
      __IOM uint32_t OUTCFG34   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 34                              */
      __IOM uint32_t DS34       : 2;            /*!< [11..10] Drive strength selection for GPIO 34                             */
      __IOM uint32_t SR34       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG34  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 34                        */
      __IOM uint32_t NCESRC34   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 34, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL34   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 34                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN34     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN34     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG34_b;
  } ;

  union {
    __IOM uint32_t PINCFG35;                    /*!< (@ 0x0000008C) Controls the operation of GPIO pin 35.                     */

    struct {
      __IOM uint32_t FNCSEL35   : 4;            /*!< [3..0] Function select for GPIO pin 35                                    */
      __IOM uint32_t INPEN35    : 1;            /*!< [4..4] Input enable for GPIO 35                                           */
      __IOM uint32_t RDZERO35   : 1;            /*!< [5..5] Return 0 for read data on GPIO 35                                  */
      __IOM uint32_t IRPTEN35   : 2;            /*!< [7..6] Interrupt enable for GPIO 35                                       */
      __IOM uint32_t OUTCFG35   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 35                              */
      __IOM uint32_t DS35       : 2;            /*!< [11..10] Drive strength selection for GPIO 35                             */
      __IOM uint32_t SR35       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG35  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 35                        */
      __IOM uint32_t NCESRC35   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 35, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL35   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 35                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN35     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN35     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG35_b;
  } ;

  union {
    __IOM uint32_t PINCFG36;                    /*!< (@ 0x00000090) Controls the operation of GPIO pin 36.                     */

    struct {
      __IOM uint32_t FNCSEL36   : 4;            /*!< [3..0] Function select for GPIO pin 36                                    */
      __IOM uint32_t INPEN36    : 1;            /*!< [4..4] Input enable for GPIO 36                                           */
      __IOM uint32_t RDZERO36   : 1;            /*!< [5..5] Return 0 for read data on GPIO 36                                  */
      __IOM uint32_t IRPTEN36   : 2;            /*!< [7..6] Interrupt enable for GPIO 36                                       */
      __IOM uint32_t OUTCFG36   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 36                              */
      __IOM uint32_t DS36       : 2;            /*!< [11..10] Drive strength selection for GPIO 36                             */
      __IOM uint32_t SR36       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG36  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 36                        */
      __IOM uint32_t NCESRC36   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 36, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL36   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 36                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN36     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN36     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG36_b;
  } ;

  union {
    __IOM uint32_t PINCFG37;                    /*!< (@ 0x00000094) Controls the operation of GPIO pin 37.                     */

    struct {
      __IOM uint32_t FNCSEL37   : 4;            /*!< [3..0] Function select for GPIO pin 37                                    */
      __IOM uint32_t INPEN37    : 1;            /*!< [4..4] Input enable for GPIO 37                                           */
      __IOM uint32_t RDZERO37   : 1;            /*!< [5..5] Return 0 for read data on GPIO 37                                  */
      __IOM uint32_t IRPTEN37   : 2;            /*!< [7..6] Interrupt enable for GPIO 37                                       */
      __IOM uint32_t OUTCFG37   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 37                              */
      __IOM uint32_t DS37       : 2;            /*!< [11..10] Drive strength selection for GPIO 37                             */
      __IOM uint32_t SR37       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG37  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 37                        */
      __IOM uint32_t NCESRC37   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 37, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL37   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 37                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN37     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN37     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG37_b;
  } ;

  union {
    __IOM uint32_t PINCFG38;                    /*!< (@ 0x00000098) Controls the operation of GPIO pin 38.                     */

    struct {
      __IOM uint32_t FNCSEL38   : 4;            /*!< [3..0] Function select for GPIO pin 38                                    */
      __IOM uint32_t INPEN38    : 1;            /*!< [4..4] Input enable for GPIO 38                                           */
      __IOM uint32_t RDZERO38   : 1;            /*!< [5..5] Return 0 for read data on GPIO 38                                  */
      __IOM uint32_t IRPTEN38   : 2;            /*!< [7..6] Interrupt enable for GPIO 38                                       */
      __IOM uint32_t OUTCFG38   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 38                              */
      __IOM uint32_t DS38       : 2;            /*!< [11..10] Drive strength selection for GPIO 38                             */
      __IOM uint32_t SR38       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG38  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 38                        */
      __IOM uint32_t NCESRC38   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 38, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL38   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 38                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN38     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN38     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG38_b;
  } ;

  union {
    __IOM uint32_t PINCFG39;                    /*!< (@ 0x0000009C) Controls the operation of GPIO pin 39.                     */

    struct {
      __IOM uint32_t FNCSEL39   : 4;            /*!< [3..0] Function select for GPIO pin 39                                    */
      __IOM uint32_t INPEN39    : 1;            /*!< [4..4] Input enable for GPIO 39                                           */
      __IOM uint32_t RDZERO39   : 1;            /*!< [5..5] Return 0 for read data on GPIO 39                                  */
      __IOM uint32_t IRPTEN39   : 2;            /*!< [7..6] Interrupt enable for GPIO 39                                       */
      __IOM uint32_t OUTCFG39   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 39                              */
      __IOM uint32_t DS39       : 2;            /*!< [11..10] Drive strength selection for GPIO 39                             */
      __IOM uint32_t SR39       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG39  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 39                        */
      __IOM uint32_t NCESRC39   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 39, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL39   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 39                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN39     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN39     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG39_b;
  } ;

  union {
    __IOM uint32_t PINCFG40;                    /*!< (@ 0x000000A0) Controls the operation of GPIO pin 40.                     */

    struct {
      __IOM uint32_t FNCSEL40   : 4;            /*!< [3..0] Function select for GPIO pin 40                                    */
      __IOM uint32_t INPEN40    : 1;            /*!< [4..4] Input enable for GPIO 40                                           */
      __IOM uint32_t RDZERO40   : 1;            /*!< [5..5] Return 0 for read data on GPIO 40                                  */
      __IOM uint32_t IRPTEN40   : 2;            /*!< [7..6] Interrupt enable for GPIO 40                                       */
      __IOM uint32_t OUTCFG40   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 40                              */
      __IOM uint32_t DS40       : 2;            /*!< [11..10] Drive strength selection for GPIO 40                             */
      __IOM uint32_t SR40       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG40  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 40                        */
      __IOM uint32_t NCESRC40   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 40, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL40   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 40                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN40     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN40     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG40_b;
  } ;

  union {
    __IOM uint32_t PINCFG41;                    /*!< (@ 0x000000A4) Controls the operation of GPIO pin 41.                     */

    struct {
      __IOM uint32_t FNCSEL41   : 4;            /*!< [3..0] Function select for GPIO pin 41                                    */
      __IOM uint32_t INPEN41    : 1;            /*!< [4..4] Input enable for GPIO 41                                           */
      __IOM uint32_t RDZERO41   : 1;            /*!< [5..5] Return 0 for read data on GPIO 41                                  */
      __IOM uint32_t IRPTEN41   : 2;            /*!< [7..6] Interrupt enable for GPIO 41                                       */
      __IOM uint32_t OUTCFG41   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 41                              */
      __IOM uint32_t DS41       : 2;            /*!< [11..10] Drive strength selection for GPIO 41                             */
      __IOM uint32_t SR41       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG41  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 41                        */
      __IOM uint32_t NCESRC41   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 41, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL41   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 41                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN41     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN41     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG41_b;
  } ;

  union {
    __IOM uint32_t PINCFG42;                    /*!< (@ 0x000000A8) Controls the operation of GPIO pin 42.                     */

    struct {
      __IOM uint32_t FNCSEL42   : 4;            /*!< [3..0] Function select for GPIO pin 42                                    */
      __IOM uint32_t INPEN42    : 1;            /*!< [4..4] Input enable for GPIO 42                                           */
      __IOM uint32_t RDZERO42   : 1;            /*!< [5..5] Return 0 for read data on GPIO 42                                  */
      __IOM uint32_t IRPTEN42   : 2;            /*!< [7..6] Interrupt enable for GPIO 42                                       */
      __IOM uint32_t OUTCFG42   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 42                              */
      __IOM uint32_t DS42       : 2;            /*!< [11..10] Drive strength selection for GPIO 42                             */
      __IOM uint32_t SR42       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG42  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 42                        */
      __IOM uint32_t NCESRC42   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 42, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL42   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 42                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN42     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN42     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG42_b;
  } ;

  union {
    __IOM uint32_t PINCFG43;                    /*!< (@ 0x000000AC) Controls the operation of GPIO pin 43.                     */

    struct {
      __IOM uint32_t FNCSEL43   : 4;            /*!< [3..0] Function select for GPIO pin 43                                    */
      __IOM uint32_t INPEN43    : 1;            /*!< [4..4] Input enable for GPIO 43                                           */
      __IOM uint32_t RDZERO43   : 1;            /*!< [5..5] Return 0 for read data on GPIO 43                                  */
      __IOM uint32_t IRPTEN43   : 2;            /*!< [7..6] Interrupt enable for GPIO 43                                       */
      __IOM uint32_t OUTCFG43   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 43                              */
      __IOM uint32_t DS43       : 2;            /*!< [11..10] Drive strength selection for GPIO 43                             */
      __IOM uint32_t SR43       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG43  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 43                        */
      __IOM uint32_t NCESRC43   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 43, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL43   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 43                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN43     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN43     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG43_b;
  } ;

  union {
    __IOM uint32_t PINCFG44;                    /*!< (@ 0x000000B0) Controls the operation of GPIO pin 44.                     */

    struct {
      __IOM uint32_t FNCSEL44   : 4;            /*!< [3..0] Function select for GPIO pin 44                                    */
      __IOM uint32_t INPEN44    : 1;            /*!< [4..4] Input enable for GPIO 44                                           */
      __IOM uint32_t RDZERO44   : 1;            /*!< [5..5] Return 0 for read data on GPIO 44                                  */
      __IOM uint32_t IRPTEN44   : 2;            /*!< [7..6] Interrupt enable for GPIO 44                                       */
      __IOM uint32_t OUTCFG44   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 44                              */
      __IOM uint32_t DS44       : 2;            /*!< [11..10] Drive strength selection for GPIO 44                             */
      __IOM uint32_t SR44       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG44  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 44                        */
      __IOM uint32_t NCESRC44   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 44, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL44   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 44                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN44     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN44     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG44_b;
  } ;

  union {
    __IOM uint32_t PINCFG45;                    /*!< (@ 0x000000B4) Controls the operation of GPIO pin 45.                     */

    struct {
      __IOM uint32_t FNCSEL45   : 4;            /*!< [3..0] Function select for GPIO pin 45                                    */
      __IOM uint32_t INPEN45    : 1;            /*!< [4..4] Input enable for GPIO 45                                           */
      __IOM uint32_t RDZERO45   : 1;            /*!< [5..5] Return 0 for read data on GPIO 45                                  */
      __IOM uint32_t IRPTEN45   : 2;            /*!< [7..6] Interrupt enable for GPIO 45                                       */
      __IOM uint32_t OUTCFG45   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 45                              */
      __IOM uint32_t DS45       : 2;            /*!< [11..10] Drive strength selection for GPIO 45                             */
      __IOM uint32_t SR45       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG45  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 45                        */
      __IOM uint32_t NCESRC45   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 45, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL45   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 45                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN45     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN45     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG45_b;
  } ;

  union {
    __IOM uint32_t PINCFG46;                    /*!< (@ 0x000000B8) Controls the operation of GPIO pin 46.                     */

    struct {
      __IOM uint32_t FNCSEL46   : 4;            /*!< [3..0] Function select for GPIO pin 46                                    */
      __IOM uint32_t INPEN46    : 1;            /*!< [4..4] Input enable for GPIO 46                                           */
      __IOM uint32_t RDZERO46   : 1;            /*!< [5..5] Return 0 for read data on GPIO 46                                  */
      __IOM uint32_t IRPTEN46   : 2;            /*!< [7..6] Interrupt enable for GPIO 46                                       */
      __IOM uint32_t OUTCFG46   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 46                              */
      __IOM uint32_t DS46       : 2;            /*!< [11..10] Drive strength selection for GPIO 46                             */
      __IOM uint32_t SR46       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG46  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 46                        */
      __IOM uint32_t NCESRC46   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 46, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL46   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 46                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN46     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN46     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG46_b;
  } ;

  union {
    __IOM uint32_t PINCFG47;                    /*!< (@ 0x000000BC) Controls the operation of GPIO pin 47.                     */

    struct {
      __IOM uint32_t FNCSEL47   : 4;            /*!< [3..0] Function select for GPIO pin 47                                    */
      __IOM uint32_t INPEN47    : 1;            /*!< [4..4] Input enable for GPIO 47                                           */
      __IOM uint32_t RDZERO47   : 1;            /*!< [5..5] Return 0 for read data on GPIO 47                                  */
      __IOM uint32_t IRPTEN47   : 2;            /*!< [7..6] Interrupt enable for GPIO 47                                       */
      __IOM uint32_t OUTCFG47   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 47                              */
      __IOM uint32_t DS47       : 2;            /*!< [11..10] Drive strength selection for GPIO 47                             */
      __IOM uint32_t SR47       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG47  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 47                        */
      __IOM uint32_t NCESRC47   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 47, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL47   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 47                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN47     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN47     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG47_b;
  } ;

  union {
    __IOM uint32_t PINCFG48;                    /*!< (@ 0x000000C0) Controls the operation of GPIO pin 48.                     */

    struct {
      __IOM uint32_t FNCSEL48   : 4;            /*!< [3..0] Function select for GPIO pin 48                                    */
      __IOM uint32_t INPEN48    : 1;            /*!< [4..4] Input enable for GPIO 48                                           */
      __IOM uint32_t RDZERO48   : 1;            /*!< [5..5] Return 0 for read data on GPIO 48                                  */
      __IOM uint32_t IRPTEN48   : 2;            /*!< [7..6] Interrupt enable for GPIO 48                                       */
      __IOM uint32_t OUTCFG48   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 48                              */
      __IOM uint32_t DS48       : 2;            /*!< [11..10] Drive strength selection for GPIO 48                             */
      __IOM uint32_t SR48       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG48  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 48                        */
      __IOM uint32_t NCESRC48   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 48, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL48   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 48                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN48     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN48     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG48_b;
  } ;

  union {
    __IOM uint32_t PINCFG49;                    /*!< (@ 0x000000C4) Controls the operation of GPIO pin 49.                     */

    struct {
      __IOM uint32_t FNCSEL49   : 4;            /*!< [3..0] Function select for GPIO pin 49                                    */
      __IOM uint32_t INPEN49    : 1;            /*!< [4..4] Input enable for GPIO 49                                           */
      __IOM uint32_t RDZERO49   : 1;            /*!< [5..5] Return 0 for read data on GPIO 49                                  */
      __IOM uint32_t IRPTEN49   : 2;            /*!< [7..6] Interrupt enable for GPIO 49                                       */
      __IOM uint32_t OUTCFG49   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 49                              */
      __IOM uint32_t DS49       : 2;            /*!< [11..10] Drive strength selection for GPIO 49                             */
      __IOM uint32_t SR49       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG49  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 49                        */
      __IOM uint32_t NCESRC49   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 49, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL49   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 49                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN49     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN49     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG49_b;
  } ;

  union {
    __IOM uint32_t PINCFG50;                    /*!< (@ 0x000000C8) Controls the operation of GPIO pin 50.                     */

    struct {
      __IOM uint32_t FNCSEL50   : 4;            /*!< [3..0] Function select for GPIO pin 50                                    */
      __IOM uint32_t INPEN50    : 1;            /*!< [4..4] Input enable for GPIO 50                                           */
      __IOM uint32_t RDZERO50   : 1;            /*!< [5..5] Return 0 for read data on GPIO 50                                  */
      __IOM uint32_t IRPTEN50   : 2;            /*!< [7..6] Interrupt enable for GPIO 50                                       */
      __IOM uint32_t OUTCFG50   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 50                              */
      __IOM uint32_t DS50       : 2;            /*!< [11..10] Drive strength selection for GPIO 50                             */
      __IOM uint32_t SR50       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG50  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 50                        */
      __IOM uint32_t NCESRC50   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 50, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL50   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 50                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN50     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN50     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG50_b;
  } ;

  union {
    __IOM uint32_t PINCFG51;                    /*!< (@ 0x000000CC) Controls the operation of GPIO pin 51.                     */

    struct {
      __IOM uint32_t FNCSEL51   : 4;            /*!< [3..0] Function select for GPIO pin 51                                    */
      __IOM uint32_t INPEN51    : 1;            /*!< [4..4] Input enable for GPIO 51                                           */
      __IOM uint32_t RDZERO51   : 1;            /*!< [5..5] Return 0 for read data on GPIO 51                                  */
      __IOM uint32_t IRPTEN51   : 2;            /*!< [7..6] Interrupt enable for GPIO 51                                       */
      __IOM uint32_t OUTCFG51   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 51                              */
      __IOM uint32_t DS51       : 2;            /*!< [11..10] Drive strength selection for GPIO 51                             */
      __IOM uint32_t SR51       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG51  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 51                        */
      __IOM uint32_t NCESRC51   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 51, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL51   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 51                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN51     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN51     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG51_b;
  } ;

  union {
    __IOM uint32_t PINCFG52;                    /*!< (@ 0x000000D0) Controls the operation of GPIO pin 52.                     */

    struct {
      __IOM uint32_t FNCSEL52   : 4;            /*!< [3..0] Function select for GPIO pin 52                                    */
      __IOM uint32_t INPEN52    : 1;            /*!< [4..4] Input enable for GPIO 52                                           */
      __IOM uint32_t RDZERO52   : 1;            /*!< [5..5] Return 0 for read data on GPIO 52                                  */
      __IOM uint32_t IRPTEN52   : 2;            /*!< [7..6] Interrupt enable for GPIO 52                                       */
      __IOM uint32_t OUTCFG52   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 52                              */
      __IOM uint32_t DS52       : 2;            /*!< [11..10] Drive strength selection for GPIO 52                             */
      __IOM uint32_t SR52       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG52  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 52                        */
      __IOM uint32_t NCESRC52   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 52, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL52   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 52                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN52     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN52     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG52_b;
  } ;

  union {
    __IOM uint32_t PINCFG53;                    /*!< (@ 0x000000D4) Controls the operation of GPIO pin 53.                     */

    struct {
      __IOM uint32_t FNCSEL53   : 4;            /*!< [3..0] Function select for GPIO pin 53                                    */
      __IOM uint32_t INPEN53    : 1;            /*!< [4..4] Input enable for GPIO 53                                           */
      __IOM uint32_t RDZERO53   : 1;            /*!< [5..5] Return 0 for read data on GPIO 53                                  */
      __IOM uint32_t IRPTEN53   : 2;            /*!< [7..6] Interrupt enable for GPIO 53                                       */
      __IOM uint32_t OUTCFG53   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 53                              */
      __IOM uint32_t DS53       : 2;            /*!< [11..10] Drive strength selection for GPIO 53                             */
      __IOM uint32_t SR53       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG53  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 53                        */
      __IOM uint32_t NCESRC53   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 53, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL53   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 53                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN53     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN53     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG53_b;
  } ;

  union {
    __IOM uint32_t PINCFG54;                    /*!< (@ 0x000000D8) Controls the operation of GPIO pin 54.                     */

    struct {
      __IOM uint32_t FNCSEL54   : 4;            /*!< [3..0] Function select for GPIO pin 54                                    */
      __IOM uint32_t INPEN54    : 1;            /*!< [4..4] Input enable for GPIO 54                                           */
      __IOM uint32_t RDZERO54   : 1;            /*!< [5..5] Return 0 for read data on GPIO 54                                  */
      __IOM uint32_t IRPTEN54   : 2;            /*!< [7..6] Interrupt enable for GPIO 54                                       */
      __IOM uint32_t OUTCFG54   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 54                              */
      __IOM uint32_t DS54       : 2;            /*!< [11..10] Drive strength selection for GPIO 54                             */
      __IOM uint32_t SR54       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG54  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 54                        */
      __IOM uint32_t NCESRC54   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 54, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL54   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 54                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN54     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN54     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG54_b;
  } ;

  union {
    __IOM uint32_t PINCFG55;                    /*!< (@ 0x000000DC) Controls the operation of GPIO pin 55.                     */

    struct {
      __IOM uint32_t FNCSEL55   : 4;            /*!< [3..0] Function select for GPIO pin 55                                    */
      __IOM uint32_t INPEN55    : 1;            /*!< [4..4] Input enable for GPIO 55                                           */
      __IOM uint32_t RDZERO55   : 1;            /*!< [5..5] Return 0 for read data on GPIO 55                                  */
      __IOM uint32_t IRPTEN55   : 2;            /*!< [7..6] Interrupt enable for GPIO 55                                       */
      __IOM uint32_t OUTCFG55   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 55                              */
      __IOM uint32_t DS55       : 2;            /*!< [11..10] Drive strength selection for GPIO 55                             */
      __IOM uint32_t SR55       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG55  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 55                        */
      __IOM uint32_t NCESRC55   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 55, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL55   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 55                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN55     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN55     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG55_b;
  } ;

  union {
    __IOM uint32_t PINCFG56;                    /*!< (@ 0x000000E0) Controls the operation of GPIO pin 56.                     */

    struct {
      __IOM uint32_t FNCSEL56   : 4;            /*!< [3..0] Function select for GPIO pin 56                                    */
      __IOM uint32_t INPEN56    : 1;            /*!< [4..4] Input enable for GPIO 56                                           */
      __IOM uint32_t RDZERO56   : 1;            /*!< [5..5] Return 0 for read data on GPIO 56                                  */
      __IOM uint32_t IRPTEN56   : 2;            /*!< [7..6] Interrupt enable for GPIO 56                                       */
      __IOM uint32_t OUTCFG56   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 56                              */
      __IOM uint32_t DS56       : 2;            /*!< [11..10] Drive strength selection for GPIO 56                             */
      __IOM uint32_t SR56       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG56  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 56                        */
      __IOM uint32_t NCESRC56   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 56, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL56   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 56                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN56     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN56     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG56_b;
  } ;

  union {
    __IOM uint32_t PINCFG57;                    /*!< (@ 0x000000E4) Controls the operation of GPIO pin 57.                     */

    struct {
      __IOM uint32_t FNCSEL57   : 4;            /*!< [3..0] Function select for GPIO pin 57                                    */
      __IOM uint32_t INPEN57    : 1;            /*!< [4..4] Input enable for GPIO 57                                           */
      __IOM uint32_t RDZERO57   : 1;            /*!< [5..5] Return 0 for read data on GPIO 57                                  */
      __IOM uint32_t IRPTEN57   : 2;            /*!< [7..6] Interrupt enable for GPIO 57                                       */
      __IOM uint32_t OUTCFG57   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 57                              */
      __IOM uint32_t DS57       : 2;            /*!< [11..10] Drive strength selection for GPIO 57                             */
      __IOM uint32_t SR57       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG57  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 57                        */
      __IOM uint32_t NCESRC57   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 57, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL57   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 57                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN57     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN57     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG57_b;
  } ;

  union {
    __IOM uint32_t PINCFG58;                    /*!< (@ 0x000000E8) Controls the operation of GPIO pin 58.                     */

    struct {
      __IOM uint32_t FNCSEL58   : 4;            /*!< [3..0] Function select for GPIO pin 58                                    */
      __IOM uint32_t INPEN58    : 1;            /*!< [4..4] Input enable for GPIO 58                                           */
      __IOM uint32_t RDZERO58   : 1;            /*!< [5..5] Return 0 for read data on GPIO 58                                  */
      __IOM uint32_t IRPTEN58   : 2;            /*!< [7..6] Interrupt enable for GPIO 58                                       */
      __IOM uint32_t OUTCFG58   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 58                              */
      __IOM uint32_t DS58       : 2;            /*!< [11..10] Drive strength selection for GPIO 58                             */
      __IOM uint32_t SR58       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG58  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 58                        */
      __IOM uint32_t NCESRC58   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 58, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL58   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 58                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN58     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN58     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG58_b;
  } ;

  union {
    __IOM uint32_t PINCFG59;                    /*!< (@ 0x000000EC) Controls the operation of GPIO pin 59.                     */

    struct {
      __IOM uint32_t FNCSEL59   : 4;            /*!< [3..0] Function select for GPIO pin 59                                    */
      __IOM uint32_t INPEN59    : 1;            /*!< [4..4] Input enable for GPIO 59                                           */
      __IOM uint32_t RDZERO59   : 1;            /*!< [5..5] Return 0 for read data on GPIO 59                                  */
      __IOM uint32_t IRPTEN59   : 2;            /*!< [7..6] Interrupt enable for GPIO 59                                       */
      __IOM uint32_t OUTCFG59   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 59                              */
      __IOM uint32_t DS59       : 2;            /*!< [11..10] Drive strength selection for GPIO 59                             */
      __IOM uint32_t SR59       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG59  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 59                        */
      __IOM uint32_t NCESRC59   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 59, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL59   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 59                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN59     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN59     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG59_b;
  } ;

  union {
    __IOM uint32_t PINCFG60;                    /*!< (@ 0x000000F0) Controls the operation of GPIO pin 60.                     */

    struct {
      __IOM uint32_t FNCSEL60   : 4;            /*!< [3..0] Function select for GPIO pin 60                                    */
      __IOM uint32_t INPEN60    : 1;            /*!< [4..4] Input enable for GPIO 60                                           */
      __IOM uint32_t RDZERO60   : 1;            /*!< [5..5] Return 0 for read data on GPIO 60                                  */
      __IOM uint32_t IRPTEN60   : 2;            /*!< [7..6] Interrupt enable for GPIO 60                                       */
      __IOM uint32_t OUTCFG60   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 60                              */
      __IOM uint32_t DS60       : 2;            /*!< [11..10] Drive strength selection for GPIO 60                             */
      __IOM uint32_t SR60       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG60  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 60                        */
      __IOM uint32_t NCESRC60   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 60, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL60   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 60                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN60     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN60     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG60_b;
  } ;

  union {
    __IOM uint32_t PINCFG61;                    /*!< (@ 0x000000F4) Controls the operation of GPIO pin 61.                     */

    struct {
      __IOM uint32_t FNCSEL61   : 4;            /*!< [3..0] Function select for GPIO pin 61                                    */
      __IOM uint32_t INPEN61    : 1;            /*!< [4..4] Input enable for GPIO 61                                           */
      __IOM uint32_t RDZERO61   : 1;            /*!< [5..5] Return 0 for read data on GPIO 61                                  */
      __IOM uint32_t IRPTEN61   : 2;            /*!< [7..6] Interrupt enable for GPIO 61                                       */
      __IOM uint32_t OUTCFG61   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 61                              */
      __IOM uint32_t DS61       : 2;            /*!< [11..10] Drive strength selection for GPIO 61                             */
      __IOM uint32_t SR61       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG61  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 61                        */
      __IOM uint32_t NCESRC61   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 61, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL61   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 61                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN61     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN61     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG61_b;
  } ;

  union {
    __IOM uint32_t PINCFG62;                    /*!< (@ 0x000000F8) Controls the operation of GPIO pin 62.                     */

    struct {
      __IOM uint32_t FNCSEL62   : 4;            /*!< [3..0] Function select for GPIO pin 62                                    */
      __IOM uint32_t INPEN62    : 1;            /*!< [4..4] Input enable for GPIO 62                                           */
      __IOM uint32_t RDZERO62   : 1;            /*!< [5..5] Return 0 for read data on GPIO 62                                  */
      __IOM uint32_t IRPTEN62   : 2;            /*!< [7..6] Interrupt enable for GPIO 62                                       */
      __IOM uint32_t OUTCFG62   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 62                              */
      __IOM uint32_t DS62       : 2;            /*!< [11..10] Drive strength selection for GPIO 62                             */
      __IOM uint32_t SR62       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG62  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 62                        */
      __IOM uint32_t NCESRC62   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 62, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL62   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 62                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN62     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN62     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG62_b;
  } ;

  union {
    __IOM uint32_t PINCFG63;                    /*!< (@ 0x000000FC) Controls the operation of GPIO pin 63.                     */

    struct {
      __IOM uint32_t FNCSEL63   : 4;            /*!< [3..0] Function select for GPIO pin 63                                    */
      __IOM uint32_t INPEN63    : 1;            /*!< [4..4] Input enable for GPIO 63                                           */
      __IOM uint32_t RDZERO63   : 1;            /*!< [5..5] Return 0 for read data on GPIO 63                                  */
      __IOM uint32_t IRPTEN63   : 2;            /*!< [7..6] Interrupt enable for GPIO 63                                       */
      __IOM uint32_t OUTCFG63   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 63                              */
      __IOM uint32_t DS63       : 2;            /*!< [11..10] Drive strength selection for GPIO 63                             */
      __IOM uint32_t SR63       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG63  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 63                        */
      __IOM uint32_t NCESRC63   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 63, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL63   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 63                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN63     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN63     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG63_b;
  } ;

  union {
    __IOM uint32_t PINCFG64;                    /*!< (@ 0x00000100) Controls the operation of GPIO pin 64.                     */

    struct {
      __IOM uint32_t FNCSEL64   : 4;            /*!< [3..0] Function select for GPIO pin 64                                    */
      __IOM uint32_t INPEN64    : 1;            /*!< [4..4] Input enable for GPIO 64                                           */
      __IOM uint32_t RDZERO64   : 1;            /*!< [5..5] Return 0 for read data on GPIO 64                                  */
      __IOM uint32_t IRPTEN64   : 2;            /*!< [7..6] Interrupt enable for GPIO 64                                       */
      __IOM uint32_t OUTCFG64   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 64                              */
      __IOM uint32_t DS64       : 2;            /*!< [11..10] Drive strength selection for GPIO 64                             */
      __IOM uint32_t SR64       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG64  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 64                        */
      __IOM uint32_t NCESRC64   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 64, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL64   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 64                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN64     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN64     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG64_b;
  } ;

  union {
    __IOM uint32_t PINCFG65;                    /*!< (@ 0x00000104) Controls the operation of GPIO pin 65.                     */

    struct {
      __IOM uint32_t FNCSEL65   : 4;            /*!< [3..0] Function select for GPIO pin 65                                    */
      __IOM uint32_t INPEN65    : 1;            /*!< [4..4] Input enable for GPIO 65                                           */
      __IOM uint32_t RDZERO65   : 1;            /*!< [5..5] Return 0 for read data on GPIO 65                                  */
      __IOM uint32_t IRPTEN65   : 2;            /*!< [7..6] Interrupt enable for GPIO 65                                       */
      __IOM uint32_t OUTCFG65   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 65                              */
      __IOM uint32_t DS65       : 2;            /*!< [11..10] Drive strength selection for GPIO 65                             */
      __IOM uint32_t SR65       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG65  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 65                        */
      __IOM uint32_t NCESRC65   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 65, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL65   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 65                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN65     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN65     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG65_b;
  } ;

  union {
    __IOM uint32_t PINCFG66;                    /*!< (@ 0x00000108) Controls the operation of GPIO pin 66.                     */

    struct {
      __IOM uint32_t FNCSEL66   : 4;            /*!< [3..0] Function select for GPIO pin 66                                    */
      __IOM uint32_t INPEN66    : 1;            /*!< [4..4] Input enable for GPIO 66                                           */
      __IOM uint32_t RDZERO66   : 1;            /*!< [5..5] Return 0 for read data on GPIO 66                                  */
      __IOM uint32_t IRPTEN66   : 2;            /*!< [7..6] Interrupt enable for GPIO 66                                       */
      __IOM uint32_t OUTCFG66   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 66                              */
      __IOM uint32_t DS66       : 2;            /*!< [11..10] Drive strength selection for GPIO 66                             */
      __IOM uint32_t SR66       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG66  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 66                        */
      __IOM uint32_t NCESRC66   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 66, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL66   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 66                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN66     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN66     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG66_b;
  } ;

  union {
    __IOM uint32_t PINCFG67;                    /*!< (@ 0x0000010C) Controls the operation of GPIO pin 67.                     */

    struct {
      __IOM uint32_t FNCSEL67   : 4;            /*!< [3..0] Function select for GPIO pin 67                                    */
      __IOM uint32_t INPEN67    : 1;            /*!< [4..4] Input enable for GPIO 67                                           */
      __IOM uint32_t RDZERO67   : 1;            /*!< [5..5] Return 0 for read data on GPIO 67                                  */
      __IOM uint32_t IRPTEN67   : 2;            /*!< [7..6] Interrupt enable for GPIO 67                                       */
      __IOM uint32_t OUTCFG67   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 67                              */
      __IOM uint32_t DS67       : 2;            /*!< [11..10] Drive strength selection for GPIO 67                             */
      __IOM uint32_t SR67       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG67  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 67                        */
      __IOM uint32_t NCESRC67   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 67, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL67   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 67                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN67     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN67     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG67_b;
  } ;

  union {
    __IOM uint32_t PINCFG68;                    /*!< (@ 0x00000110) Controls the operation of GPIO pin 68.                     */

    struct {
      __IOM uint32_t FNCSEL68   : 4;            /*!< [3..0] Function select for GPIO pin 68                                    */
      __IOM uint32_t INPEN68    : 1;            /*!< [4..4] Input enable for GPIO 68                                           */
      __IOM uint32_t RDZERO68   : 1;            /*!< [5..5] Return 0 for read data on GPIO 68                                  */
      __IOM uint32_t IRPTEN68   : 2;            /*!< [7..6] Interrupt enable for GPIO 68                                       */
      __IOM uint32_t OUTCFG68   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 68                              */
      __IOM uint32_t DS68       : 2;            /*!< [11..10] Drive strength selection for GPIO 68                             */
      __IOM uint32_t SR68       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG68  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 68                        */
      __IOM uint32_t NCESRC68   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 68, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL68   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 68                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN68     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN68     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG68_b;
  } ;

  union {
    __IOM uint32_t PINCFG69;                    /*!< (@ 0x00000114) Controls the operation of GPIO pin 69.                     */

    struct {
      __IOM uint32_t FNCSEL69   : 4;            /*!< [3..0] Function select for GPIO pin 69                                    */
      __IOM uint32_t INPEN69    : 1;            /*!< [4..4] Input enable for GPIO 69                                           */
      __IOM uint32_t RDZERO69   : 1;            /*!< [5..5] Return 0 for read data on GPIO 69                                  */
      __IOM uint32_t IRPTEN69   : 2;            /*!< [7..6] Interrupt enable for GPIO 69                                       */
      __IOM uint32_t OUTCFG69   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 69                              */
      __IOM uint32_t DS69       : 2;            /*!< [11..10] Drive strength selection for GPIO 69                             */
      __IOM uint32_t SR69       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG69  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 69                        */
      __IOM uint32_t NCESRC69   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 69, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL69   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 69                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN69     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN69     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG69_b;
  } ;

  union {
    __IOM uint32_t PINCFG70;                    /*!< (@ 0x00000118) Controls the operation of GPIO pin 70.                     */

    struct {
      __IOM uint32_t FNCSEL70   : 4;            /*!< [3..0] Function select for GPIO pin 70                                    */
      __IOM uint32_t INPEN70    : 1;            /*!< [4..4] Input enable for GPIO 70                                           */
      __IOM uint32_t RDZERO70   : 1;            /*!< [5..5] Return 0 for read data on GPIO 70                                  */
      __IOM uint32_t IRPTEN70   : 2;            /*!< [7..6] Interrupt enable for GPIO 70                                       */
      __IOM uint32_t OUTCFG70   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 70                              */
      __IOM uint32_t DS70       : 2;            /*!< [11..10] Drive strength selection for GPIO 70                             */
      __IOM uint32_t SR70       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG70  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 70                        */
      __IOM uint32_t NCESRC70   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 70, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL70   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 70                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN70     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN70     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG70_b;
  } ;

  union {
    __IOM uint32_t PINCFG71;                    /*!< (@ 0x0000011C) Controls the operation of GPIO pin 71.                     */

    struct {
      __IOM uint32_t FNCSEL71   : 4;            /*!< [3..0] Function select for GPIO pin 71                                    */
      __IOM uint32_t INPEN71    : 1;            /*!< [4..4] Input enable for GPIO 71                                           */
      __IOM uint32_t RDZERO71   : 1;            /*!< [5..5] Return 0 for read data on GPIO 71                                  */
      __IOM uint32_t IRPTEN71   : 2;            /*!< [7..6] Interrupt enable for GPIO 71                                       */
      __IOM uint32_t OUTCFG71   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 71                              */
      __IOM uint32_t DS71       : 2;            /*!< [11..10] Drive strength selection for GPIO 71                             */
      __IOM uint32_t SR71       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG71  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 71                        */
      __IOM uint32_t NCESRC71   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 71, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL71   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 71                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN71     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN71     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG71_b;
  } ;

  union {
    __IOM uint32_t PINCFG72;                    /*!< (@ 0x00000120) Controls the operation of GPIO pin 72.                     */

    struct {
      __IOM uint32_t FNCSEL72   : 4;            /*!< [3..0] Function select for GPIO pin 72                                    */
      __IOM uint32_t INPEN72    : 1;            /*!< [4..4] Input enable for GPIO 72                                           */
      __IOM uint32_t RDZERO72   : 1;            /*!< [5..5] Return 0 for read data on GPIO 72                                  */
      __IOM uint32_t IRPTEN72   : 2;            /*!< [7..6] Interrupt enable for GPIO 72                                       */
      __IOM uint32_t OUTCFG72   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 72                              */
      __IOM uint32_t DS72       : 2;            /*!< [11..10] Drive strength selection for GPIO 72                             */
      __IOM uint32_t SR72       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG72  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 72                        */
      __IOM uint32_t NCESRC72   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 72, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL72   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 72                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN72     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN72     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG72_b;
  } ;

  union {
    __IOM uint32_t PINCFG73;                    /*!< (@ 0x00000124) Controls the operation of GPIO pin 73.                     */

    struct {
      __IOM uint32_t FNCSEL73   : 4;            /*!< [3..0] Function select for GPIO pin 73                                    */
      __IOM uint32_t INPEN73    : 1;            /*!< [4..4] Input enable for GPIO 73                                           */
      __IOM uint32_t RDZERO73   : 1;            /*!< [5..5] Return 0 for read data on GPIO 73                                  */
      __IOM uint32_t IRPTEN73   : 2;            /*!< [7..6] Interrupt enable for GPIO 73                                       */
      __IOM uint32_t OUTCFG73   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 73                              */
      __IOM uint32_t DS73       : 2;            /*!< [11..10] Drive strength selection for GPIO 73                             */
      __IOM uint32_t SR73       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG73  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 73                        */
      __IOM uint32_t NCESRC73   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 73, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL73   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 73                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN73     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN73     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG73_b;
  } ;

  union {
    __IOM uint32_t PINCFG74;                    /*!< (@ 0x00000128) Controls the operation of GPIO pin 74.                     */

    struct {
      __IOM uint32_t FNCSEL74   : 4;            /*!< [3..0] Function select for GPIO pin 74                                    */
      __IOM uint32_t INPEN74    : 1;            /*!< [4..4] Input enable for GPIO 74                                           */
      __IOM uint32_t RDZERO74   : 1;            /*!< [5..5] Return 0 for read data on GPIO 74                                  */
      __IOM uint32_t IRPTEN74   : 2;            /*!< [7..6] Interrupt enable for GPIO 74                                       */
      __IOM uint32_t OUTCFG74   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 74                              */
      __IOM uint32_t DS74       : 2;            /*!< [11..10] Drive strength selection for GPIO 74                             */
      __IOM uint32_t SR74       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG74  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 74                        */
      __IOM uint32_t NCESRC74   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 74, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL74   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 74                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN74     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN74     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG74_b;
  } ;

  union {
    __IOM uint32_t PINCFG75;                    /*!< (@ 0x0000012C) Controls the operation of GPIO pin 75.                     */

    struct {
      __IOM uint32_t FNCSEL75   : 4;            /*!< [3..0] Function select for GPIO pin 75                                    */
      __IOM uint32_t INPEN75    : 1;            /*!< [4..4] Input enable for GPIO 75                                           */
      __IOM uint32_t RDZERO75   : 1;            /*!< [5..5] Return 0 for read data on GPIO 75                                  */
      __IOM uint32_t IRPTEN75   : 2;            /*!< [7..6] Interrupt enable for GPIO 75                                       */
      __IOM uint32_t OUTCFG75   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 75                              */
      __IOM uint32_t DS75       : 2;            /*!< [11..10] Drive strength selection for GPIO 75                             */
      __IOM uint32_t SR75       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG75  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 75                        */
      __IOM uint32_t NCESRC75   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 75, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL75   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 75                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN75     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN75     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG75_b;
  } ;

  union {
    __IOM uint32_t PINCFG76;                    /*!< (@ 0x00000130) Controls the operation of GPIO pin 76.                     */

    struct {
      __IOM uint32_t FNCSEL76   : 4;            /*!< [3..0] Function select for GPIO pin 76                                    */
      __IOM uint32_t INPEN76    : 1;            /*!< [4..4] Input enable for GPIO 76                                           */
      __IOM uint32_t RDZERO76   : 1;            /*!< [5..5] Return 0 for read data on GPIO 76                                  */
      __IOM uint32_t IRPTEN76   : 2;            /*!< [7..6] Interrupt enable for GPIO 76                                       */
      __IOM uint32_t OUTCFG76   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 76                              */
      __IOM uint32_t DS76       : 2;            /*!< [11..10] Drive strength selection for GPIO 76                             */
      __IOM uint32_t SR76       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG76  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 76                        */
      __IOM uint32_t NCESRC76   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 76, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL76   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 76                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN76     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN76     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG76_b;
  } ;

  union {
    __IOM uint32_t PINCFG77;                    /*!< (@ 0x00000134) Controls the operation of GPIO pin 77.                     */

    struct {
      __IOM uint32_t FNCSEL77   : 4;            /*!< [3..0] Function select for GPIO pin 77                                    */
      __IOM uint32_t INPEN77    : 1;            /*!< [4..4] Input enable for GPIO 77                                           */
      __IOM uint32_t RDZERO77   : 1;            /*!< [5..5] Return 0 for read data on GPIO 77                                  */
      __IOM uint32_t IRPTEN77   : 2;            /*!< [7..6] Interrupt enable for GPIO 77                                       */
      __IOM uint32_t OUTCFG77   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 77                              */
      __IOM uint32_t DS77       : 2;            /*!< [11..10] Drive strength selection for GPIO 77                             */
      __IOM uint32_t SR77       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG77  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 77                        */
      __IOM uint32_t NCESRC77   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 77, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL77   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 77                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN77     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN77     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG77_b;
  } ;

  union {
    __IOM uint32_t PINCFG78;                    /*!< (@ 0x00000138) Controls the operation of GPIO pin 78.                     */

    struct {
      __IOM uint32_t FNCSEL78   : 4;            /*!< [3..0] Function select for GPIO pin 78                                    */
      __IOM uint32_t INPEN78    : 1;            /*!< [4..4] Input enable for GPIO 78                                           */
      __IOM uint32_t RDZERO78   : 1;            /*!< [5..5] Return 0 for read data on GPIO 78                                  */
      __IOM uint32_t IRPTEN78   : 2;            /*!< [7..6] Interrupt enable for GPIO 78                                       */
      __IOM uint32_t OUTCFG78   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 78                              */
      __IOM uint32_t DS78       : 2;            /*!< [11..10] Drive strength selection for GPIO 78                             */
      __IOM uint32_t SR78       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG78  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 78                        */
      __IOM uint32_t NCESRC78   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 78, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL78   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 78                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN78     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN78     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG78_b;
  } ;

  union {
    __IOM uint32_t PINCFG79;                    /*!< (@ 0x0000013C) Controls the operation of GPIO pin 79.                     */

    struct {
      __IOM uint32_t FNCSEL79   : 4;            /*!< [3..0] Function select for GPIO pin 79                                    */
      __IOM uint32_t INPEN79    : 1;            /*!< [4..4] Input enable for GPIO 79                                           */
      __IOM uint32_t RDZERO79   : 1;            /*!< [5..5] Return 0 for read data on GPIO 79                                  */
      __IOM uint32_t IRPTEN79   : 2;            /*!< [7..6] Interrupt enable for GPIO 79                                       */
      __IOM uint32_t OUTCFG79   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 79                              */
      __IOM uint32_t DS79       : 2;            /*!< [11..10] Drive strength selection for GPIO 79                             */
      __IOM uint32_t SR79       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG79  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 79                        */
      __IOM uint32_t NCESRC79   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 79, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL79   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 79                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN79     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN79     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG79_b;
  } ;

  union {
    __IOM uint32_t PINCFG80;                    /*!< (@ 0x00000140) Controls the operation of GPIO pin 80.                     */

    struct {
      __IOM uint32_t FNCSEL80   : 4;            /*!< [3..0] Function select for GPIO pin 80                                    */
      __IOM uint32_t INPEN80    : 1;            /*!< [4..4] Input enable for GPIO 80                                           */
      __IOM uint32_t RDZERO80   : 1;            /*!< [5..5] Return 0 for read data on GPIO 80                                  */
      __IOM uint32_t IRPTEN80   : 2;            /*!< [7..6] Interrupt enable for GPIO 80                                       */
      __IOM uint32_t OUTCFG80   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 80                              */
      __IOM uint32_t DS80       : 2;            /*!< [11..10] Drive strength selection for GPIO 80                             */
      __IOM uint32_t SR80       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG80  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 80                        */
      __IOM uint32_t NCESRC80   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 80, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL80   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 80                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN80     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN80     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG80_b;
  } ;

  union {
    __IOM uint32_t PINCFG81;                    /*!< (@ 0x00000144) Controls the operation of GPIO pin 81.                     */

    struct {
      __IOM uint32_t FNCSEL81   : 4;            /*!< [3..0] Function select for GPIO pin 81                                    */
      __IOM uint32_t INPEN81    : 1;            /*!< [4..4] Input enable for GPIO 81                                           */
      __IOM uint32_t RDZERO81   : 1;            /*!< [5..5] Return 0 for read data on GPIO 81                                  */
      __IOM uint32_t IRPTEN81   : 2;            /*!< [7..6] Interrupt enable for GPIO 81                                       */
      __IOM uint32_t OUTCFG81   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 81                              */
      __IOM uint32_t DS81       : 2;            /*!< [11..10] Drive strength selection for GPIO 81                             */
      __IOM uint32_t SR81       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG81  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 81                        */
      __IOM uint32_t NCESRC81   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 81, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL81   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 81                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN81     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN81     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG81_b;
  } ;

  union {
    __IOM uint32_t PINCFG82;                    /*!< (@ 0x00000148) Controls the operation of GPIO pin 82.                     */

    struct {
      __IOM uint32_t FNCSEL82   : 4;            /*!< [3..0] Function select for GPIO pin 82                                    */
      __IOM uint32_t INPEN82    : 1;            /*!< [4..4] Input enable for GPIO 82                                           */
      __IOM uint32_t RDZERO82   : 1;            /*!< [5..5] Return 0 for read data on GPIO 82                                  */
      __IOM uint32_t IRPTEN82   : 2;            /*!< [7..6] Interrupt enable for GPIO 82                                       */
      __IOM uint32_t OUTCFG82   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 82                              */
      __IOM uint32_t DS82       : 2;            /*!< [11..10] Drive strength selection for GPIO 82                             */
      __IOM uint32_t SR82       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG82  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 82                        */
      __IOM uint32_t NCESRC82   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 82, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL82   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 82                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN82     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN82     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG82_b;
  } ;

  union {
    __IOM uint32_t PINCFG83;                    /*!< (@ 0x0000014C) Controls the operation of GPIO pin 83.                     */

    struct {
      __IOM uint32_t FNCSEL83   : 4;            /*!< [3..0] Function select for GPIO pin 83                                    */
      __IOM uint32_t INPEN83    : 1;            /*!< [4..4] Input enable for GPIO 83                                           */
      __IOM uint32_t RDZERO83   : 1;            /*!< [5..5] Return 0 for read data on GPIO 83                                  */
      __IOM uint32_t IRPTEN83   : 2;            /*!< [7..6] Interrupt enable for GPIO 83                                       */
      __IOM uint32_t OUTCFG83   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 83                              */
      __IOM uint32_t DS83       : 2;            /*!< [11..10] Drive strength selection for GPIO 83                             */
      __IOM uint32_t SR83       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG83  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 83                        */
      __IOM uint32_t NCESRC83   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 83, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL83   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 83                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN83     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN83     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG83_b;
  } ;

  union {
    __IOM uint32_t PINCFG84;                    /*!< (@ 0x00000150) Controls the operation of GPIO pin 84.                     */

    struct {
      __IOM uint32_t FNCSEL84   : 4;            /*!< [3..0] Function select for GPIO pin 84                                    */
      __IOM uint32_t INPEN84    : 1;            /*!< [4..4] Input enable for GPIO 84                                           */
      __IOM uint32_t RDZERO84   : 1;            /*!< [5..5] Return 0 for read data on GPIO 84                                  */
      __IOM uint32_t IRPTEN84   : 2;            /*!< [7..6] Interrupt enable for GPIO 84                                       */
      __IOM uint32_t OUTCFG84   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 84                              */
      __IOM uint32_t DS84       : 2;            /*!< [11..10] Drive strength selection for GPIO 84                             */
      __IOM uint32_t SR84       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG84  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 84                        */
      __IOM uint32_t NCESRC84   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 84, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL84   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 84                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN84     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN84     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG84_b;
  } ;

  union {
    __IOM uint32_t PINCFG85;                    /*!< (@ 0x00000154) Controls the operation of GPIO pin 85.                     */

    struct {
      __IOM uint32_t FNCSEL85   : 4;            /*!< [3..0] Function select for GPIO pin 85                                    */
      __IOM uint32_t INPEN85    : 1;            /*!< [4..4] Input enable for GPIO 85                                           */
      __IOM uint32_t RDZERO85   : 1;            /*!< [5..5] Return 0 for read data on GPIO 85                                  */
      __IOM uint32_t IRPTEN85   : 2;            /*!< [7..6] Interrupt enable for GPIO 85                                       */
      __IOM uint32_t OUTCFG85   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 85                              */
      __IOM uint32_t DS85       : 2;            /*!< [11..10] Drive strength selection for GPIO 85                             */
      __IOM uint32_t SR85       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG85  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 85                        */
      __IOM uint32_t NCESRC85   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 85, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL85   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 85                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN85     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN85     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG85_b;
  } ;

  union {
    __IOM uint32_t PINCFG86;                    /*!< (@ 0x00000158) Controls the operation of GPIO pin 86.                     */

    struct {
      __IOM uint32_t FNCSEL86   : 4;            /*!< [3..0] Function select for GPIO pin 86                                    */
      __IOM uint32_t INPEN86    : 1;            /*!< [4..4] Input enable for GPIO 86                                           */
      __IOM uint32_t RDZERO86   : 1;            /*!< [5..5] Return 0 for read data on GPIO 86                                  */
      __IOM uint32_t IRPTEN86   : 2;            /*!< [7..6] Interrupt enable for GPIO 86                                       */
      __IOM uint32_t OUTCFG86   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 86                              */
      __IOM uint32_t DS86       : 2;            /*!< [11..10] Drive strength selection for GPIO 86                             */
      __IOM uint32_t SR86       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG86  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 86                        */
      __IOM uint32_t NCESRC86   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 86, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL86   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 86                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN86     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN86     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG86_b;
  } ;

  union {
    __IOM uint32_t PINCFG87;                    /*!< (@ 0x0000015C) Controls the operation of GPIO pin 87.                     */

    struct {
      __IOM uint32_t FNCSEL87   : 4;            /*!< [3..0] Function select for GPIO pin 87                                    */
      __IOM uint32_t INPEN87    : 1;            /*!< [4..4] Input enable for GPIO 87                                           */
      __IOM uint32_t RDZERO87   : 1;            /*!< [5..5] Return 0 for read data on GPIO 87                                  */
      __IOM uint32_t IRPTEN87   : 2;            /*!< [7..6] Interrupt enable for GPIO 87                                       */
      __IOM uint32_t OUTCFG87   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 87                              */
      __IOM uint32_t DS87       : 2;            /*!< [11..10] Drive strength selection for GPIO 87                             */
      __IOM uint32_t SR87       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG87  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 87                        */
      __IOM uint32_t NCESRC87   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 87, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL87   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 87                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN87     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN87     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG87_b;
  } ;

  union {
    __IOM uint32_t PINCFG88;                    /*!< (@ 0x00000160) Controls the operation of GPIO pin 88.                     */

    struct {
      __IOM uint32_t FNCSEL88   : 4;            /*!< [3..0] Function select for GPIO pin 88                                    */
      __IOM uint32_t INPEN88    : 1;            /*!< [4..4] Input enable for GPIO 88                                           */
      __IOM uint32_t RDZERO88   : 1;            /*!< [5..5] Return 0 for read data on GPIO 88                                  */
      __IOM uint32_t IRPTEN88   : 2;            /*!< [7..6] Interrupt enable for GPIO 88                                       */
      __IOM uint32_t OUTCFG88   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 88                              */
      __IOM uint32_t DS88       : 2;            /*!< [11..10] Drive strength selection for GPIO 88                             */
      __IOM uint32_t SR88       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG88  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 88                        */
      __IOM uint32_t NCESRC88   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 88, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL88   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 88                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN88     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN88     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG88_b;
  } ;

  union {
    __IOM uint32_t PINCFG89;                    /*!< (@ 0x00000164) Controls the operation of GPIO pin 89.                     */

    struct {
      __IOM uint32_t FNCSEL89   : 4;            /*!< [3..0] Function select for GPIO pin 89                                    */
      __IOM uint32_t INPEN89    : 1;            /*!< [4..4] Input enable for GPIO 89                                           */
      __IOM uint32_t RDZERO89   : 1;            /*!< [5..5] Return 0 for read data on GPIO 89                                  */
      __IOM uint32_t IRPTEN89   : 2;            /*!< [7..6] Interrupt enable for GPIO 89                                       */
      __IOM uint32_t OUTCFG89   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 89                              */
      __IOM uint32_t DS89       : 2;            /*!< [11..10] Drive strength selection for GPIO 89                             */
      __IOM uint32_t SR89       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG89  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 89                        */
      __IOM uint32_t NCESRC89   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 89, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL89   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 89                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN89     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN89     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG89_b;
  } ;

  union {
    __IOM uint32_t PINCFG90;                    /*!< (@ 0x00000168) Controls the operation of GPIO pin 90.                     */

    struct {
      __IOM uint32_t FNCSEL90   : 4;            /*!< [3..0] Function select for GPIO pin 90                                    */
      __IOM uint32_t INPEN90    : 1;            /*!< [4..4] Input enable for GPIO 90                                           */
      __IOM uint32_t RDZERO90   : 1;            /*!< [5..5] Return 0 for read data on GPIO 90                                  */
      __IOM uint32_t IRPTEN90   : 2;            /*!< [7..6] Interrupt enable for GPIO 90                                       */
      __IOM uint32_t OUTCFG90   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 90                              */
      __IOM uint32_t DS90       : 2;            /*!< [11..10] Drive strength selection for GPIO 90                             */
      __IOM uint32_t SR90       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG90  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 90                        */
      __IOM uint32_t NCESRC90   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 90, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL90   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 90                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN90     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN90     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG90_b;
  } ;

  union {
    __IOM uint32_t PINCFG91;                    /*!< (@ 0x0000016C) Controls the operation of GPIO pin 91.                     */

    struct {
      __IOM uint32_t FNCSEL91   : 4;            /*!< [3..0] Function select for GPIO pin 91                                    */
      __IOM uint32_t INPEN91    : 1;            /*!< [4..4] Input enable for GPIO 91                                           */
      __IOM uint32_t RDZERO91   : 1;            /*!< [5..5] Return 0 for read data on GPIO 91                                  */
      __IOM uint32_t IRPTEN91   : 2;            /*!< [7..6] Interrupt enable for GPIO 91                                       */
      __IOM uint32_t OUTCFG91   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 91                              */
      __IOM uint32_t DS91       : 2;            /*!< [11..10] Drive strength selection for GPIO 91                             */
      __IOM uint32_t SR91       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG91  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 91                        */
      __IOM uint32_t NCESRC91   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 91, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL91   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 91                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN91     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN91     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG91_b;
  } ;

  union {
    __IOM uint32_t PINCFG92;                    /*!< (@ 0x00000170) Controls the operation of GPIO pin 92.                     */

    struct {
      __IOM uint32_t FNCSEL92   : 4;            /*!< [3..0] Function select for GPIO pin 92                                    */
      __IOM uint32_t INPEN92    : 1;            /*!< [4..4] Input enable for GPIO 92                                           */
      __IOM uint32_t RDZERO92   : 1;            /*!< [5..5] Return 0 for read data on GPIO 92                                  */
      __IOM uint32_t IRPTEN92   : 2;            /*!< [7..6] Interrupt enable for GPIO 92                                       */
      __IOM uint32_t OUTCFG92   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 92                              */
      __IOM uint32_t DS92       : 2;            /*!< [11..10] Drive strength selection for GPIO 92                             */
      __IOM uint32_t SR92       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG92  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 92                        */
      __IOM uint32_t NCESRC92   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 92, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL92   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 92                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN92     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN92     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG92_b;
  } ;

  union {
    __IOM uint32_t PINCFG93;                    /*!< (@ 0x00000174) Controls the operation of GPIO pin 93.                     */

    struct {
      __IOM uint32_t FNCSEL93   : 4;            /*!< [3..0] Function select for GPIO pin 93                                    */
      __IOM uint32_t INPEN93    : 1;            /*!< [4..4] Input enable for GPIO 93                                           */
      __IOM uint32_t RDZERO93   : 1;            /*!< [5..5] Return 0 for read data on GPIO 93                                  */
      __IOM uint32_t IRPTEN93   : 2;            /*!< [7..6] Interrupt enable for GPIO 93                                       */
      __IOM uint32_t OUTCFG93   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 93                              */
      __IOM uint32_t DS93       : 2;            /*!< [11..10] Drive strength selection for GPIO 93                             */
      __IOM uint32_t SR93       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG93  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 93                        */
      __IOM uint32_t NCESRC93   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 93, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL93   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 93                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN93     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN93     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG93_b;
  } ;

  union {
    __IOM uint32_t PINCFG94;                    /*!< (@ 0x00000178) Controls the operation of GPIO pin 94.                     */

    struct {
      __IOM uint32_t FNCSEL94   : 4;            /*!< [3..0] Function select for GPIO pin 94                                    */
      __IOM uint32_t INPEN94    : 1;            /*!< [4..4] Input enable for GPIO 94                                           */
      __IOM uint32_t RDZERO94   : 1;            /*!< [5..5] Return 0 for read data on GPIO 94                                  */
      __IOM uint32_t IRPTEN94   : 2;            /*!< [7..6] Interrupt enable for GPIO 94                                       */
      __IOM uint32_t OUTCFG94   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 94                              */
      __IOM uint32_t DS94       : 2;            /*!< [11..10] Drive strength selection for GPIO 94                             */
      __IOM uint32_t SR94       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG94  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 94                        */
      __IOM uint32_t NCESRC94   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 94, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL94   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 94                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN94     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN94     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG94_b;
  } ;

  union {
    __IOM uint32_t PINCFG95;                    /*!< (@ 0x0000017C) Controls the operation of GPIO pin 95.                     */

    struct {
      __IOM uint32_t FNCSEL95   : 4;            /*!< [3..0] Function select for GPIO pin 95                                    */
      __IOM uint32_t INPEN95    : 1;            /*!< [4..4] Input enable for GPIO 95                                           */
      __IOM uint32_t RDZERO95   : 1;            /*!< [5..5] Return 0 for read data on GPIO 95                                  */
      __IOM uint32_t IRPTEN95   : 2;            /*!< [7..6] Interrupt enable for GPIO 95                                       */
      __IOM uint32_t OUTCFG95   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 95                              */
      __IOM uint32_t DS95       : 2;            /*!< [11..10] Drive strength selection for GPIO 95                             */
      __IOM uint32_t SR95       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG95  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 95                        */
      __IOM uint32_t NCESRC95   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 95, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL95   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 95                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN95     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN95     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG95_b;
  } ;

  union {
    __IOM uint32_t PINCFG96;                    /*!< (@ 0x00000180) Controls the operation of GPIO pin 96.                     */

    struct {
      __IOM uint32_t FNCSEL96   : 4;            /*!< [3..0] Function select for GPIO pin 96                                    */
      __IOM uint32_t INPEN96    : 1;            /*!< [4..4] Input enable for GPIO 96                                           */
      __IOM uint32_t RDZERO96   : 1;            /*!< [5..5] Return 0 for read data on GPIO 96                                  */
      __IOM uint32_t IRPTEN96   : 2;            /*!< [7..6] Interrupt enable for GPIO 96                                       */
      __IOM uint32_t OUTCFG96   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 96                              */
      __IOM uint32_t DS96       : 2;            /*!< [11..10] Drive strength selection for GPIO 96                             */
      __IOM uint32_t SR96       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG96  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 96                        */
      __IOM uint32_t NCESRC96   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 96, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL96   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 96                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN96     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN96     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG96_b;
  } ;

  union {
    __IOM uint32_t PINCFG97;                    /*!< (@ 0x00000184) Controls the operation of GPIO pin 97.                     */

    struct {
      __IOM uint32_t FNCSEL97   : 4;            /*!< [3..0] Function select for GPIO pin 97                                    */
      __IOM uint32_t INPEN97    : 1;            /*!< [4..4] Input enable for GPIO 97                                           */
      __IOM uint32_t RDZERO97   : 1;            /*!< [5..5] Return 0 for read data on GPIO 97                                  */
      __IOM uint32_t IRPTEN97   : 2;            /*!< [7..6] Interrupt enable for GPIO 97                                       */
      __IOM uint32_t OUTCFG97   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 97                              */
      __IOM uint32_t DS97       : 2;            /*!< [11..10] Drive strength selection for GPIO 97                             */
      __IOM uint32_t SR97       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG97  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 97                        */
      __IOM uint32_t NCESRC97   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 97, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL97   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 97                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN97     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN97     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG97_b;
  } ;

  union {
    __IOM uint32_t PINCFG98;                    /*!< (@ 0x00000188) Controls the operation of GPIO pin 98.                     */

    struct {
      __IOM uint32_t FNCSEL98   : 4;            /*!< [3..0] Function select for GPIO pin 98                                    */
      __IOM uint32_t INPEN98    : 1;            /*!< [4..4] Input enable for GPIO 98                                           */
      __IOM uint32_t RDZERO98   : 1;            /*!< [5..5] Return 0 for read data on GPIO 98                                  */
      __IOM uint32_t IRPTEN98   : 2;            /*!< [7..6] Interrupt enable for GPIO 98                                       */
      __IOM uint32_t OUTCFG98   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 98                              */
      __IOM uint32_t DS98       : 2;            /*!< [11..10] Drive strength selection for GPIO 98                             */
      __IOM uint32_t SR98       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG98  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 98                        */
      __IOM uint32_t NCESRC98   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 98, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL98   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 98                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN98     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN98     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG98_b;
  } ;

  union {
    __IOM uint32_t PINCFG99;                    /*!< (@ 0x0000018C) Controls the operation of GPIO pin 99.                     */

    struct {
      __IOM uint32_t FNCSEL99   : 4;            /*!< [3..0] Function select for GPIO pin 99                                    */
      __IOM uint32_t INPEN99    : 1;            /*!< [4..4] Input enable for GPIO 99                                           */
      __IOM uint32_t RDZERO99   : 1;            /*!< [5..5] Return 0 for read data on GPIO 99                                  */
      __IOM uint32_t IRPTEN99   : 2;            /*!< [7..6] Interrupt enable for GPIO 99                                       */
      __IOM uint32_t OUTCFG99   : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 99                              */
      __IOM uint32_t DS99       : 2;            /*!< [11..10] Drive strength selection for GPIO 99                             */
      __IOM uint32_t SR99       : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG99  : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 99                        */
      __IOM uint32_t NCESRC99   : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 99, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL99   : 1;            /*!< [22..22] Polarity select for NCE for GPIO 99                              */
            uint32_t            : 3;
      __IOM uint32_t FIEN99     : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN99     : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG99_b;
  } ;

  union {
    __IOM uint32_t PINCFG100;                   /*!< (@ 0x00000190) Controls the operation of GPIO pin 100.                    */

    struct {
      __IOM uint32_t FNCSEL100  : 4;            /*!< [3..0] Function select for GPIO pin 100                                   */
      __IOM uint32_t INPEN100   : 1;            /*!< [4..4] Input enable for GPIO 100                                          */
      __IOM uint32_t RDZERO100  : 1;            /*!< [5..5] Return 0 for read data on GPIO 100                                 */
      __IOM uint32_t IRPTEN100  : 2;            /*!< [7..6] Interrupt enable for GPIO 100                                      */
      __IOM uint32_t OUTCFG100  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 100                             */
      __IOM uint32_t DS100      : 2;            /*!< [11..10] Drive strength selection for GPIO 100                            */
      __IOM uint32_t SR100      : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG100 : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 100                       */
      __IOM uint32_t NCESRC100  : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 100, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL100  : 1;            /*!< [22..22] Polarity select for NCE for GPIO 100                             */
            uint32_t            : 3;
      __IOM uint32_t FIEN100    : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN100    : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG100_b;
  } ;

  union {
    __IOM uint32_t PINCFG101;                   /*!< (@ 0x00000194) Controls the operation of GPIO pin 101.                    */

    struct {
      __IOM uint32_t FNCSEL101  : 4;            /*!< [3..0] Function select for GPIO pin 101                                   */
      __IOM uint32_t INPEN101   : 1;            /*!< [4..4] Input enable for GPIO 101                                          */
      __IOM uint32_t RDZERO101  : 1;            /*!< [5..5] Return 0 for read data on GPIO 101                                 */
      __IOM uint32_t IRPTEN101  : 2;            /*!< [7..6] Interrupt enable for GPIO 101                                      */
      __IOM uint32_t OUTCFG101  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 101                             */
      __IOM uint32_t DS101      : 2;            /*!< [11..10] Drive strength selection for GPIO 101                            */
      __IOM uint32_t SR101      : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG101 : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 101                       */
      __IOM uint32_t NCESRC101  : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 101, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL101  : 1;            /*!< [22..22] Polarity select for NCE for GPIO 101                             */
            uint32_t            : 3;
      __IOM uint32_t FIEN101    : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN101    : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG101_b;
  } ;

  union {
    __IOM uint32_t PINCFG102;                   /*!< (@ 0x00000198) Controls the operation of GPIO pin 102.                    */

    struct {
      __IOM uint32_t FNCSEL102  : 4;            /*!< [3..0] Function select for GPIO pin 102                                   */
      __IOM uint32_t INPEN102   : 1;            /*!< [4..4] Input enable for GPIO 102                                          */
      __IOM uint32_t RDZERO102  : 1;            /*!< [5..5] Return 0 for read data on GPIO 102                                 */
      __IOM uint32_t IRPTEN102  : 2;            /*!< [7..6] Interrupt enable for GPIO 102                                      */
      __IOM uint32_t OUTCFG102  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 102                             */
      __IOM uint32_t DS102      : 2;            /*!< [11..10] Drive strength selection for GPIO 102                            */
      __IOM uint32_t SR102      : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG102 : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 102                       */
      __IOM uint32_t NCESRC102  : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 102, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL102  : 1;            /*!< [22..22] Polarity select for NCE for GPIO 102                             */
            uint32_t            : 3;
      __IOM uint32_t FIEN102    : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN102    : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG102_b;
  } ;

  union {
    __IOM uint32_t PINCFG103;                   /*!< (@ 0x0000019C) Controls the operation of GPIO pin 103.                    */

    struct {
      __IOM uint32_t FNCSEL103  : 4;            /*!< [3..0] Function select for GPIO pin 103                                   */
      __IOM uint32_t INPEN103   : 1;            /*!< [4..4] Input enable for GPIO 103                                          */
      __IOM uint32_t RDZERO103  : 1;            /*!< [5..5] Return 0 for read data on GPIO 103                                 */
      __IOM uint32_t IRPTEN103  : 2;            /*!< [7..6] Interrupt enable for GPIO 103                                      */
      __IOM uint32_t OUTCFG103  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 103                             */
      __IOM uint32_t DS103      : 2;            /*!< [11..10] Drive strength selection for GPIO 103                            */
      __IOM uint32_t SR103      : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG103 : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 103                       */
      __IOM uint32_t NCESRC103  : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 103, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL103  : 1;            /*!< [22..22] Polarity select for NCE for GPIO 103                             */
            uint32_t            : 3;
      __IOM uint32_t FIEN103    : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN103    : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG103_b;
  } ;

  union {
    __IOM uint32_t PINCFG104;                   /*!< (@ 0x000001A0) Controls the operation of GPIO pin 104.                    */

    struct {
      __IOM uint32_t FNCSEL104  : 4;            /*!< [3..0] Function select for GPIO pin 104                                   */
      __IOM uint32_t INPEN104   : 1;            /*!< [4..4] Input enable for GPIO 104                                          */
      __IOM uint32_t RDZERO104  : 1;            /*!< [5..5] Return 0 for read data on GPIO 104                                 */
      __IOM uint32_t IRPTEN104  : 2;            /*!< [7..6] Interrupt enable for GPIO 104                                      */
      __IOM uint32_t OUTCFG104  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 104                             */
      __IOM uint32_t DS104      : 2;            /*!< [11..10] Drive strength selection for GPIO 104                            */
      __IOM uint32_t SR104      : 1;            /*!< [12..12] Configure the slew rate                                          */
      __IOM uint32_t PULLCFG104 : 3;            /*!< [15..13] Pullup/Pulldown configuration for GPIO 104                       */
      __IOM uint32_t NCESRC104  : 6;            /*!< [21..16] IOMSTR/MSPI N Chip Select 104, DISP control signals
                                                     DE, CSX, and CS. Polarity is determined by CE_POLARITY
                                                     field                                                                     */
      __IOM uint32_t NCEPOL104  : 1;            /*!< [22..22] Polarity select for NCE for GPIO 104                             */
            uint32_t            : 3;
      __IOM uint32_t FIEN104    : 1;            /*!< [26..26] Force input enable active regardless of function selected.
                                                     Otherwise the selected function will enable the input only
                                                     when needed                                                               */
      __IOM uint32_t FOEN104    : 1;            /*!< [27..27] Force output enable active regardless of function selected.
                                                     Otherwise the selected function will enable the output
                                                     only when needed                                                          */
            uint32_t            : 4;
    } PINCFG104_b;
  } ;

  union {
    __IOM uint32_t PINCFG105;                   /*!< (@ 0x000001A4) Controls the operation of virtual GPIO pin 105.            */

    struct {
      __IOM uint32_t FNCSEL105  : 4;            /*!< [3..0] Function select for GPIO pin 105                                   */
      __IOM uint32_t INPEN105   : 1;            /*!< [4..4] Input enable for GPIO 105                                          */
      __IOM uint32_t RDZERO105  : 1;            /*!< [5..5] Return 0 for read data on GPIO 105                                 */
      __IOM uint32_t IRPTEN105  : 2;            /*!< [7..6] Interrupt enable for GPIO 105                                      */
      __IOM uint32_t OUTCFG105  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 105                             */
            uint32_t            : 22;
    } PINCFG105_b;
  } ;

  union {
    __IOM uint32_t PINCFG106;                   /*!< (@ 0x000001A8) Controls the operation of virtual GPIO pin 106.            */

    struct {
      __IOM uint32_t FNCSEL106  : 4;            /*!< [3..0] Function select for GPIO pin 106                                   */
      __IOM uint32_t INPEN106   : 1;            /*!< [4..4] Input enable for GPIO 106                                          */
      __IOM uint32_t RDZERO106  : 1;            /*!< [5..5] Return 0 for read data on GPIO 106                                 */
      __IOM uint32_t IRPTEN106  : 2;            /*!< [7..6] Interrupt enable for GPIO 106                                      */
      __IOM uint32_t OUTCFG106  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 106                             */
            uint32_t            : 22;
    } PINCFG106_b;
  } ;

  union {
    __IOM uint32_t PINCFG107;                   /*!< (@ 0x000001AC) Controls the operation of virtual GPIO pin 107.            */

    struct {
      __IOM uint32_t FNCSEL107  : 4;            /*!< [3..0] Function select for GPIO pin 107                                   */
      __IOM uint32_t INPEN107   : 1;            /*!< [4..4] Input enable for GPIO 107                                          */
      __IOM uint32_t RDZERO107  : 1;            /*!< [5..5] Return 0 for read data on GPIO 107                                 */
      __IOM uint32_t IRPTEN107  : 2;            /*!< [7..6] Interrupt enable for GPIO 107                                      */
      __IOM uint32_t OUTCFG107  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 107                             */
            uint32_t            : 22;
    } PINCFG107_b;
  } ;

  union {
    __IOM uint32_t PINCFG108;                   /*!< (@ 0x000001B0) Controls the operation of virtual GPIO pin 108.            */

    struct {
      __IOM uint32_t FNCSEL108  : 4;            /*!< [3..0] Function select for GPIO pin 108                                   */
      __IOM uint32_t INPEN108   : 1;            /*!< [4..4] Input enable for GPIO 108                                          */
      __IOM uint32_t RDZERO108  : 1;            /*!< [5..5] Return 0 for read data on GPIO 108                                 */
      __IOM uint32_t IRPTEN108  : 2;            /*!< [7..6] Interrupt enable for GPIO 108                                      */
      __IOM uint32_t OUTCFG108  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 108                             */
            uint32_t            : 22;
    } PINCFG108_b;
  } ;

  union {
    __IOM uint32_t PINCFG109;                   /*!< (@ 0x000001B4) Controls the operation of virtual GPIO pin 109.            */

    struct {
      __IOM uint32_t FNCSEL109  : 4;            /*!< [3..0] Function select for GPIO pin 109                                   */
      __IOM uint32_t INPEN109   : 1;            /*!< [4..4] Input enable for GPIO 109                                          */
      __IOM uint32_t RDZERO109  : 1;            /*!< [5..5] Return 0 for read data on GPIO 109                                 */
      __IOM uint32_t IRPTEN109  : 2;            /*!< [7..6] Interrupt enable for GPIO 109                                      */
      __IOM uint32_t OUTCFG109  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 109                             */
            uint32_t            : 22;
    } PINCFG109_b;
  } ;

  union {
    __IOM uint32_t PINCFG110;                   /*!< (@ 0x000001B8) Controls the operation of virtual GPIO pin 110.            */

    struct {
      __IOM uint32_t FNCSEL110  : 4;            /*!< [3..0] Function select for GPIO pin 110                                   */
      __IOM uint32_t INPEN110   : 1;            /*!< [4..4] Input enable for GPIO 110                                          */
      __IOM uint32_t RDZERO110  : 1;            /*!< [5..5] Return 0 for read data on GPIO 110                                 */
      __IOM uint32_t IRPTEN110  : 2;            /*!< [7..6] Interrupt enable for GPIO 110                                      */
      __IOM uint32_t OUTCFG110  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 110                             */
            uint32_t            : 22;
    } PINCFG110_b;
  } ;

  union {
    __IOM uint32_t PINCFG111;                   /*!< (@ 0x000001BC) Controls the operation of virtual GPIO pin 111.            */

    struct {
      __IOM uint32_t FNCSEL111  : 4;            /*!< [3..0] Function select for GPIO pin 111                                   */
      __IOM uint32_t INPEN111   : 1;            /*!< [4..4] Input enable for GPIO 111                                          */
      __IOM uint32_t RDZERO111  : 1;            /*!< [5..5] Return 0 for read data on GPIO 111                                 */
      __IOM uint32_t IRPTEN111  : 2;            /*!< [7..6] Interrupt enable for GPIO 111                                      */
      __IOM uint32_t OUTCFG111  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 111                             */
            uint32_t            : 22;
    } PINCFG111_b;
  } ;

  union {
    __IOM uint32_t PINCFG112;                   /*!< (@ 0x000001C0) Controls the operation of virtual GPIO pin 112.            */

    struct {
      __IOM uint32_t FNCSEL112  : 4;            /*!< [3..0] Function select for GPIO pin 112                                   */
      __IOM uint32_t INPEN112   : 1;            /*!< [4..4] Input enable for GPIO 112                                          */
      __IOM uint32_t RDZERO112  : 1;            /*!< [5..5] Return 0 for read data on GPIO 112                                 */
      __IOM uint32_t IRPTEN112  : 2;            /*!< [7..6] Interrupt enable for GPIO 112                                      */
      __IOM uint32_t OUTCFG112  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 112                             */
            uint32_t            : 22;
    } PINCFG112_b;
  } ;

  union {
    __IOM uint32_t PINCFG113;                   /*!< (@ 0x000001C4) Controls the operation of virtual GPIO pin 113.            */

    struct {
      __IOM uint32_t FNCSEL113  : 4;            /*!< [3..0] Function select for GPIO pin 113                                   */
      __IOM uint32_t INPEN113   : 1;            /*!< [4..4] Input enable for GPIO 113                                          */
      __IOM uint32_t RDZERO113  : 1;            /*!< [5..5] Return 0 for read data on GPIO 113                                 */
      __IOM uint32_t IRPTEN113  : 2;            /*!< [7..6] Interrupt enable for GPIO 113                                      */
      __IOM uint32_t OUTCFG113  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 113                             */
            uint32_t            : 22;
    } PINCFG113_b;
  } ;

  union {
    __IOM uint32_t PINCFG114;                   /*!< (@ 0x000001C8) Controls the operation of virtual GPIO pin 114.            */

    struct {
      __IOM uint32_t FNCSEL114  : 4;            /*!< [3..0] Function select for GPIO pin 114                                   */
      __IOM uint32_t INPEN114   : 1;            /*!< [4..4] Input enable for GPIO 114                                          */
      __IOM uint32_t RDZERO114  : 1;            /*!< [5..5] Return 0 for read data on GPIO 114                                 */
      __IOM uint32_t IRPTEN114  : 2;            /*!< [7..6] Interrupt enable for GPIO 114                                      */
      __IOM uint32_t OUTCFG114  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 114                             */
            uint32_t            : 22;
    } PINCFG114_b;
  } ;

  union {
    __IOM uint32_t PINCFG115;                   /*!< (@ 0x000001CC) Controls the operation of virtual GPIO pin 115.            */

    struct {
      __IOM uint32_t FNCSEL115  : 4;            /*!< [3..0] Function select for GPIO pin 115                                   */
      __IOM uint32_t INPEN115   : 1;            /*!< [4..4] Input enable for GPIO 115                                          */
      __IOM uint32_t RDZERO115  : 1;            /*!< [5..5] Return 0 for read data on GPIO 115                                 */
      __IOM uint32_t IRPTEN115  : 2;            /*!< [7..6] Interrupt enable for GPIO 115                                      */
      __IOM uint32_t OUTCFG115  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 115                             */
            uint32_t            : 22;
    } PINCFG115_b;
  } ;

  union {
    __IOM uint32_t PINCFG116;                   /*!< (@ 0x000001D0) Controls the operation of virtual GPIO pin 116.            */

    struct {
      __IOM uint32_t FNCSEL116  : 4;            /*!< [3..0] Function select for GPIO pin 116                                   */
      __IOM uint32_t INPEN116   : 1;            /*!< [4..4] Input enable for GPIO 116                                          */
      __IOM uint32_t RDZERO116  : 1;            /*!< [5..5] Return 0 for read data on GPIO 116                                 */
      __IOM uint32_t IRPTEN116  : 2;            /*!< [7..6] Interrupt enable for GPIO 116                                      */
      __IOM uint32_t OUTCFG116  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 116                             */
            uint32_t            : 22;
    } PINCFG116_b;
  } ;

  union {
    __IOM uint32_t PINCFG117;                   /*!< (@ 0x000001D4) Controls the operation of virtual GPIO pin 117.            */

    struct {
      __IOM uint32_t FNCSEL117  : 4;            /*!< [3..0] Function select for GPIO pin 117                                   */
      __IOM uint32_t INPEN117   : 1;            /*!< [4..4] Input enable for GPIO 117                                          */
      __IOM uint32_t RDZERO117  : 1;            /*!< [5..5] Return 0 for read data on GPIO 117                                 */
      __IOM uint32_t IRPTEN117  : 2;            /*!< [7..6] Interrupt enable for GPIO 117                                      */
      __IOM uint32_t OUTCFG117  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 117                             */
            uint32_t            : 22;
    } PINCFG117_b;
  } ;

  union {
    __IOM uint32_t PINCFG118;                   /*!< (@ 0x000001D8) Controls the operation of virtual GPIO pin 118.            */

    struct {
      __IOM uint32_t FNCSEL118  : 4;            /*!< [3..0] Function select for GPIO pin 118                                   */
      __IOM uint32_t INPEN118   : 1;            /*!< [4..4] Input enable for GPIO 118                                          */
      __IOM uint32_t RDZERO118  : 1;            /*!< [5..5] Return 0 for read data on GPIO 118                                 */
      __IOM uint32_t IRPTEN118  : 2;            /*!< [7..6] Interrupt enable for GPIO 118                                      */
      __IOM uint32_t OUTCFG118  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 118                             */
            uint32_t            : 22;
    } PINCFG118_b;
  } ;

  union {
    __IOM uint32_t PINCFG119;                   /*!< (@ 0x000001DC) Controls the operation of virtual GPIO pin 119.            */

    struct {
      __IOM uint32_t FNCSEL119  : 4;            /*!< [3..0] Function select for GPIO pin 119                                   */
      __IOM uint32_t INPEN119   : 1;            /*!< [4..4] Input enable for GPIO 119                                          */
      __IOM uint32_t RDZERO119  : 1;            /*!< [5..5] Return 0 for read data on GPIO 119                                 */
      __IOM uint32_t IRPTEN119  : 2;            /*!< [7..6] Interrupt enable for GPIO 119                                      */
      __IOM uint32_t OUTCFG119  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 119                             */
            uint32_t            : 22;
    } PINCFG119_b;
  } ;

  union {
    __IOM uint32_t PINCFG120;                   /*!< (@ 0x000001E0) Controls the operation of virtual GPIO pin 120.            */

    struct {
      __IOM uint32_t FNCSEL120  : 4;            /*!< [3..0] Function select for GPIO pin 120                                   */
      __IOM uint32_t INPEN120   : 1;            /*!< [4..4] Input enable for GPIO 120                                          */
      __IOM uint32_t RDZERO120  : 1;            /*!< [5..5] Return 0 for read data on GPIO 120                                 */
      __IOM uint32_t IRPTEN120  : 2;            /*!< [7..6] Interrupt enable for GPIO 120                                      */
      __IOM uint32_t OUTCFG120  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 120                             */
            uint32_t            : 22;
    } PINCFG120_b;
  } ;

  union {
    __IOM uint32_t PINCFG121;                   /*!< (@ 0x000001E4) Controls the operation of virtual GPIO pin 121.            */

    struct {
      __IOM uint32_t FNCSEL121  : 4;            /*!< [3..0] Function select for GPIO pin 121                                   */
      __IOM uint32_t INPEN121   : 1;            /*!< [4..4] Input enable for GPIO 121                                          */
      __IOM uint32_t RDZERO121  : 1;            /*!< [5..5] Return 0 for read data on GPIO 121                                 */
      __IOM uint32_t IRPTEN121  : 2;            /*!< [7..6] Interrupt enable for GPIO 121                                      */
      __IOM uint32_t OUTCFG121  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 121                             */
            uint32_t            : 22;
    } PINCFG121_b;
  } ;

  union {
    __IOM uint32_t PINCFG122;                   /*!< (@ 0x000001E8) Controls the operation of virtual GPIO pin 122.            */

    struct {
      __IOM uint32_t FNCSEL122  : 4;            /*!< [3..0] Function select for GPIO pin 122                                   */
      __IOM uint32_t INPEN122   : 1;            /*!< [4..4] Input enable for GPIO 122                                          */
      __IOM uint32_t RDZERO122  : 1;            /*!< [5..5] Return 0 for read data on GPIO 122                                 */
      __IOM uint32_t IRPTEN122  : 2;            /*!< [7..6] Interrupt enable for GPIO 122                                      */
      __IOM uint32_t OUTCFG122  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 122                             */
            uint32_t            : 22;
    } PINCFG122_b;
  } ;

  union {
    __IOM uint32_t PINCFG123;                   /*!< (@ 0x000001EC) Controls the operation of virtual GPIO pin 123.            */

    struct {
      __IOM uint32_t FNCSEL123  : 4;            /*!< [3..0] Function select for GPIO pin 123                                   */
      __IOM uint32_t INPEN123   : 1;            /*!< [4..4] Input enable for GPIO 123                                          */
      __IOM uint32_t RDZERO123  : 1;            /*!< [5..5] Return 0 for read data on GPIO 123                                 */
      __IOM uint32_t IRPTEN123  : 2;            /*!< [7..6] Interrupt enable for GPIO 123                                      */
      __IOM uint32_t OUTCFG123  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 123                             */
            uint32_t            : 22;
    } PINCFG123_b;
  } ;

  union {
    __IOM uint32_t PINCFG124;                   /*!< (@ 0x000001F0) Controls the operation of virtual GPIO pin 124.            */

    struct {
      __IOM uint32_t FNCSEL124  : 4;            /*!< [3..0] Function select for GPIO pin 124                                   */
      __IOM uint32_t INPEN124   : 1;            /*!< [4..4] Input enable for GPIO 124                                          */
      __IOM uint32_t RDZERO124  : 1;            /*!< [5..5] Return 0 for read data on GPIO 124                                 */
      __IOM uint32_t IRPTEN124  : 2;            /*!< [7..6] Interrupt enable for GPIO 124                                      */
      __IOM uint32_t OUTCFG124  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 124                             */
            uint32_t            : 22;
    } PINCFG124_b;
  } ;

  union {
    __IOM uint32_t PINCFG125;                   /*!< (@ 0x000001F4) Controls the operation of virtual GPIO pin 125.            */

    struct {
      __IOM uint32_t FNCSEL125  : 4;            /*!< [3..0] Function select for GPIO pin 125                                   */
      __IOM uint32_t INPEN125   : 1;            /*!< [4..4] Input enable for GPIO 125                                          */
      __IOM uint32_t RDZERO125  : 1;            /*!< [5..5] Return 0 for read data on GPIO 125                                 */
      __IOM uint32_t IRPTEN125  : 2;            /*!< [7..6] Interrupt enable for GPIO 125                                      */
      __IOM uint32_t OUTCFG125  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 125                             */
            uint32_t            : 22;
    } PINCFG125_b;
  } ;

  union {
    __IOM uint32_t PINCFG126;                   /*!< (@ 0x000001F8) Controls the operation of virtual GPIO pin 126.            */

    struct {
      __IOM uint32_t FNCSEL126  : 4;            /*!< [3..0] Function select for GPIO pin 126                                   */
      __IOM uint32_t INPEN126   : 1;            /*!< [4..4] Input enable for GPIO 126                                          */
      __IOM uint32_t RDZERO126  : 1;            /*!< [5..5] Return 0 for read data on GPIO 126                                 */
      __IOM uint32_t IRPTEN126  : 2;            /*!< [7..6] Interrupt enable for GPIO 126                                      */
      __IOM uint32_t OUTCFG126  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 126                             */
            uint32_t            : 22;
    } PINCFG126_b;
  } ;

  union {
    __IOM uint32_t PINCFG127;                   /*!< (@ 0x000001FC) Controls the operation of virtual GPIO pin 127.            */

    struct {
      __IOM uint32_t FNCSEL127  : 4;            /*!< [3..0] Function select for GPIO pin 127                                   */
      __IOM uint32_t INPEN127   : 1;            /*!< [4..4] Input enable for GPIO 127                                          */
      __IOM uint32_t RDZERO127  : 1;            /*!< [5..5] Return 0 for read data on GPIO 127                                 */
      __IOM uint32_t IRPTEN127  : 2;            /*!< [7..6] Interrupt enable for GPIO 127                                      */
      __IOM uint32_t OUTCFG127  : 2;            /*!< [9..8] Pin IO mode selection for GPIO pin 127                             */
            uint32_t            : 22;
    } PINCFG127_b;
  } ;

  union {
    __IOM uint32_t PADKEY;                      /*!< (@ 0x00000200) Lock state of the PINCFG and GPIO configuration
                                                                    registers. Write a value of 0x73 to unlock
                                                                    write access to the PAD and GPIO.                          */

    struct {
      __IOM uint32_t PADKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } PADKEY_b;
  } ;

  union {
    __IOM uint32_t RD0;                         /*!< (@ 0x00000204) GPIO Input 0 (31-0)                                        */

    struct {
      __IOM uint32_t RD0        : 32;           /*!< [31..0] GPIO31-0 Reads pin state - read only. Returns the pad
                                                     pin state for pins 0-31 if the PINCFG's input enable (INPEN)
                                                     is active and RDZERO is inactive.                                         */
    } RD0_b;
  } ;

  union {
    __IOM uint32_t RD1;                         /*!< (@ 0x00000208) GPIO Input 1 (63-32)                                       */

    struct {
      __IOM uint32_t RD1        : 32;           /*!< [31..0] GPIO63-32 Reads pin state - read only. Returns the pad
                                                     pin state for pins 0-31 if the PINCFG's input enable (INPEN)
                                                     is active and RDZERO is inactive.                                         */
    } RD1_b;
  } ;

  union {
    __IOM uint32_t RD2;                         /*!< (@ 0x0000020C) GPIO Input 2 (95-64)                                       */

    struct {
      __IOM uint32_t RD2        : 32;           /*!< [31..0] GPIO95-64 Reads pin state - read only. Returns the pad
                                                     pin state for pins 0-31 if the PINCFG's input enable (INPEN)
                                                     is active and RDZERO is inactive.                                         */
    } RD2_b;
  } ;

  union {
    __IOM uint32_t RD3;                         /*!< (@ 0x00000210) GPIO Input 3 (127-96)                                      */

    struct {
      __IOM uint32_t RD3        : 32;           /*!< [31..0] GPIO127-96 Reads pin state - read only. Returns the
                                                     pad pin state for pins 0-31 if the PINCFG's input enable
                                                     (INPEN) is active and RDZERO is inactive.                                 */
    } RD3_b;
  } ;

  union {
    __IOM uint32_t WT0;                         /*!< (@ 0x00000214) GPIO Output 0 (31-0)                                       */

    struct {
      __IOM uint32_t WT0        : 32;           /*!< [31..0] GPIO31-0 Reads or writes pin state. Writes of 1 bits
                                                     set output pad signal if the GPIO is enabled for output.
                                                     Reads return status, including sets/clears through the
                                                     WTS and WTC registers.                                                    */
    } WT0_b;
  } ;

  union {
    __IOM uint32_t WT1;                         /*!< (@ 0x00000218) GPIO Output 1 (63-32)                                      */

    struct {
      __IOM uint32_t WT1        : 32;           /*!< [31..0] GPIO63-32 Reads or writes pin state. Writes of 1 bits
                                                     set output pad signal if the GPIO is enabled for output.
                                                     Reads return status, including sets/clears through the
                                                     WTS and WTC registers.                                                    */
    } WT1_b;
  } ;

  union {
    __IOM uint32_t WT2;                         /*!< (@ 0x0000021C) GPIO Output 2 (95-64)                                      */

    struct {
      __IOM uint32_t WT2        : 32;           /*!< [31..0] GPIO95-64 Reads or writes pin state. Writes of 1 bits
                                                     set output pad signal if the GPIO is enabled for output.
                                                     Reads return status, including sets/clears through the
                                                     WTS and WTC registers.                                                    */
    } WT2_b;
  } ;

  union {
    __IOM uint32_t WT3;                         /*!< (@ 0x00000220) GPIO Output 3 (127-96)                                     */

    struct {
      __IOM uint32_t WT3        : 32;           /*!< [31..0] GPIO127-96 Reads or writes pin state. Writes of 1 bits
                                                     set output pad signal if the GPIO is enabled for output.
                                                     Reads return status, including sets/clears through the
                                                     WTS and WTC registers.                                                    */
    } WT3_b;
  } ;

  union {
    __IOM uint32_t WTS0;                        /*!< (@ 0x00000224) GPIO Output Set 0 (31-0)                                   */

    struct {
      __IOM uint32_t WTS0       : 32;           /*!< [31..0] GPIO31-0 Sets pin state. Writing a 1 to any bit sets
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT Register.                                       */
    } WTS0_b;
  } ;

  union {
    __IOM uint32_t WTS1;                        /*!< (@ 0x00000228) GPIO Output Set 1 (63-32)                                  */

    struct {
      __IOM uint32_t WTS1       : 32;           /*!< [31..0] GPIO63-32 Sets pin state. Writing a 1 to any bit sets
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT Register.                                       */
    } WTS1_b;
  } ;

  union {
    __IOM uint32_t WTS2;                        /*!< (@ 0x0000022C) GPIO Output Set 2 (95-64)                                  */

    struct {
      __IOM uint32_t WTS2       : 32;           /*!< [31..0] GPIO95-64 Sets pin state. Writing a 1 to any bit sets
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT Register.                                       */
    } WTS2_b;
  } ;

  union {
    __IOM uint32_t WTS3;                        /*!< (@ 0x00000230) GPIO Output Set 3 (127-96)                                 */

    struct {
      __IOM uint32_t WTS3       : 32;           /*!< [31..0] GPIO127-96 Sets pin state. Writing a 1 to any bit sets
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT Register.                                       */
    } WTS3_b;
  } ;

  union {
    __IOM uint32_t WTC0;                        /*!< (@ 0x00000234) GPIO Output Clear 0 (31-0)                                 */

    struct {
      __IOM uint32_t WTC0       : 32;           /*!< [31..0] GPIO31-0 Clears pin state. Writing a 1 to any bit clears
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT register.                                       */
    } WTC0_b;
  } ;

  union {
    __IOM uint32_t WTC1;                        /*!< (@ 0x00000238) GPIO Output Clear 1 (63-32)                                */

    struct {
      __IOM uint32_t WTC1       : 32;           /*!< [31..0] GPIO63-32 Clears pin state. Writing a 1 to any bit clears
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT register.                                       */
    } WTC1_b;
  } ;

  union {
    __IOM uint32_t WTC2;                        /*!< (@ 0x0000023C) GPIO Output Clear 2 (95-64)                                */

    struct {
      __IOM uint32_t WTC2       : 32;           /*!< [31..0] GPIO95-64 Clears pin state. Writing a 1 to any bit clears
                                                     the corresponding bit in the WT register if the GPIO is
                                                     enabled for output. Writing a value of 0 has no effect
                                                     on the corresponding bit in the WT register. Status reads
                                                     should be made via the WT register.                                       */
    } WTC2_b;
  } ;

  union {
    __IOM uint32_t WTC3;                        /*!< (@ 0x00000240) GPIO Output Clear 3 (127-96)                               */

    struct {
      __IOM uint32_t WTC3       : 32;           /*!< [31..0] GPIO127-96 Clears pin state. Writing a 1 to any bit
                                                     clears the corresponding bit in the WT register if the
                                                     GPIO is enabled for output. Writing a value of 0 has no
                                                     effect on the corresponding bit in the WT register. Status
                                                     reads should be made via the WT register.                                 */
    } WTC3_b;
  } ;

  union {
    __IOM uint32_t EN0;                         /*!< (@ 0x00000244) GPIO Enable 0 (31-0)                                       */

    struct {
      __IOM uint32_t EN0        : 32;           /*!< [31..0] GPIO31-0 Enables tri-state pin output. Writing a 1 to
                                                     any bit enables, and writing a 0 to any bit disables, the
                                                     output for the corresponding GPIO. Reads return output
                                                     enable/disable status of GPIO.                                            */
    } EN0_b;
  } ;

  union {
    __IOM uint32_t EN1;                         /*!< (@ 0x00000248) GPIO Enable 1 (63-32)                                      */

    struct {
      __IOM uint32_t EN1        : 32;           /*!< [31..0] GPIO63-32 Enables tri-state pin output. Writing a 1
                                                     to any bit enables, and writing a 0 to any bit disables,
                                                     the output for the corresponding GPIO. Reads return output
                                                     enable/disable status of GPIO.                                            */
    } EN1_b;
  } ;

  union {
    __IOM uint32_t EN2;                         /*!< (@ 0x0000024C) GPIO Enable 2 (95-64)                                      */

    struct {
      __IOM uint32_t EN2        : 32;           /*!< [31..0] GPIO95-64 Enables tri-state pin output. Writing a 1
                                                     to any bit enables, and writing a 0 to any bit disables,
                                                     the output for the corresponding GPIO. Reads return output
                                                     enable/disable status of GPIO.                                            */
    } EN2_b;
  } ;

  union {
    __IOM uint32_t EN3;                         /*!< (@ 0x00000250) GPIO Enable 3 (127-96)                                     */

    struct {
      __IOM uint32_t EN3        : 32;           /*!< [31..0] GPIO127-96 Enables tri-state pin output. Writing a 1
                                                     to any bit enables, and writing a 0 to any bit disables,
                                                     the output for the corresponding GPIO. Reads return output
                                                     enable/disable status of GPIO.                                            */
    } EN3_b;
  } ;

  union {
    __IOM uint32_t ENS0;                        /*!< (@ 0x00000254) GPIO Enable Set 0 (31-0)                                   */

    struct {
      __IOM uint32_t ENS0       : 32;           /*!< [31..0] GPIO31-0 Sets pin tri-state output enables. Writing
                                                     a 1 to any bit sets the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENS0_b;
  } ;

  union {
    __IOM uint32_t ENS1;                        /*!< (@ 0x00000258) GPIO Enable Set 1 (63-32)                                  */

    struct {
      __IOM uint32_t ENS1       : 32;           /*!< [31..0] GPIO63-32 Sets pin tri-state output enables. Writing
                                                     a 1 to any bit sets the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENS1_b;
  } ;

  union {
    __IOM uint32_t ENS2;                        /*!< (@ 0x0000025C) GPIO Enable Set 2 (95-64)                                  */

    struct {
      __IOM uint32_t ENS2       : 32;           /*!< [31..0] GPIO95-64 Sets pin tri-state output enables. Writing
                                                     a 1 to any bit sets the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENS2_b;
  } ;

  union {
    __IOM uint32_t ENS3;                        /*!< (@ 0x00000260) GPIO Enable Set 3 (127-96)                                 */

    struct {
      __IOM uint32_t ENS3       : 32;           /*!< [31..0] GPIO127-96 Sets pin tri-state output enables. Writing
                                                     a 1 to any bit sets the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENS3_b;
  } ;

  union {
    __IOM uint32_t ENC0;                        /*!< (@ 0x00000264) GPIO Enable Clear 0 (31-0)                                 */

    struct {
      __IOM uint32_t ENC0       : 32;           /*!< [31..0] GPIO31-0 Clears pin tri-state output enables. Writing
                                                     a 1 to any bit clears the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENC0_b;
  } ;

  union {
    __IOM uint32_t ENC1;                        /*!< (@ 0x00000268) GPIO Enable Clear 1 (63-32)                                */

    struct {
      __IOM uint32_t ENC1       : 32;           /*!< [31..0] GPIO63-32 Clears pin tri-state output enables. Writing
                                                     a 1 to any bit clears the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENC1_b;
  } ;

  union {
    __IOM uint32_t ENC2;                        /*!< (@ 0x0000026C) GPIO Enable Clear 2 (95-64)                                */

    struct {
      __IOM uint32_t ENC2       : 32;           /*!< [31..0] GPIO95-64 Clears pin tri-state output enables. Writing
                                                     a 1 to any bit clears the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENC2_b;
  } ;

  union {
    __IOM uint32_t ENC3;                        /*!< (@ 0x00000270) GPIO Enable Clear 3 (127-96)                               */

    struct {
      __IOM uint32_t ENC3       : 32;           /*!< [31..0] GPIO127-96 Clears pin tri-state output enables. Writing
                                                     a 1 to any bit clears the corresponding bit in the EN register.
                                                     Writing a value of 0 has no effect on the corresponding
                                                     bit in the EN register. Status reads should be made to
                                                     the EN Register.                                                          */
    } ENC3_b;
  } ;

  union {
    __IOM uint32_t IOM0IRQ;                     /*!< (@ 0x00000274) IOM0 IRQ select for flow control.                          */

    struct {
      __IOM uint32_t IOM0IRQ    : 7;            /*!< [6..0] IOM0 IRQ pad select.                                               */
            uint32_t            : 25;
    } IOM0IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM1IRQ;                     /*!< (@ 0x00000278) IOM1 IRQ select for flow control.                          */

    struct {
      __IOM uint32_t IOM1IRQ    : 7;            /*!< [6..0] IOM1 IRQ pad select.                                               */
            uint32_t            : 25;
    } IOM1IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM2IRQ;                     /*!< (@ 0x0000027C) IOM2 IRQ select for flow control.                          */

    struct {
      __IOM uint32_t IOM2IRQ    : 7;            /*!< [6..0] IOM2 IRQ pad select.                                               */
            uint32_t            : 25;
    } IOM2IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM3IRQ;                     /*!< (@ 0x00000280) IOM3 IRQ select for flow control.                          */

    struct {
      __IOM uint32_t IOM3IRQ    : 7;            /*!< [6..0] IOM3 IRQ pad select.                                               */
            uint32_t            : 25;
    } IOM3IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM4IRQ;                     /*!< (@ 0x00000284) IOM4 IRQ select for flow control.                          */

    struct {
      __IOM uint32_t IOM4IRQ    : 7;            /*!< [6..0] IOM4 IRQ pad select.                                               */
            uint32_t            : 25;
    } IOM4IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM5IRQ;                     /*!< (@ 0x00000288) IOM5 IRQ select for flow control.                          */

    struct {
      __IOM uint32_t IOM5IRQ    : 7;            /*!< [6..0] IOM5 IRQ pad select.                                               */
            uint32_t            : 25;
    } IOM5IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM6IRQ;                     /*!< (@ 0x0000028C) IOM6 IRQ select for flow control.                          */

    struct {
      __IOM uint32_t IOM6IRQ    : 7;            /*!< [6..0] IOM6 IRQ pad select.                                               */
            uint32_t            : 25;
    } IOM6IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM7IRQ;                     /*!< (@ 0x00000290) IOM7 IRQ select for flow control.                          */

    struct {
      __IOM uint32_t IOM7IRQ    : 7;            /*!< [6..0] IOM7 IRQ pad select.                                               */
            uint32_t            : 25;
    } IOM7IRQ_b;
  } ;

  union {
    __IOM uint32_t SDIFCDWP;                    /*!< (@ 0x00000294) SDIF CD and WP Select.                                     */

    struct {
      __IOM uint32_t SDIFCD     : 7;            /*!< [6..0] SDIF CD pad select.                                                */
            uint32_t            : 1;
      __IOM uint32_t SDIFWP     : 7;            /*!< [14..8] SDIF WP pad select.                                               */
            uint32_t            : 17;
    } SDIFCDWP_b;
  } ;

  union {
    __IOM uint32_t OBSDATA;                     /*!< (@ 0x00000298) GPIO Observation mode sample                               */

    struct {
      __IOM uint32_t OBSDATA    : 16;           /*!< [15..0] Sample of the data output on the GPIO observation port.
                                                     May have async sampling issues, as the data is not synronized
                                                     to the read operation. Intended for debug purposes only.                  */
            uint32_t            : 16;
    } OBSDATA_b;
  } ;

  union {
    __IOM uint32_t IEOBS0;                      /*!< (@ 0x0000029C) Read only. Reflects the value of the input enable
                                                                    signals for pads 31-0 sent to the pad.                     */

    struct {
      __IOM uint32_t IEDATA0    : 32;           /*!< [31..0] 1 indicates the input_en is active and the value of
                                                     the pad will be trasmitted to the internal logic within
                                                     the device.                                                               */
    } IEOBS0_b;
  } ;

  union {
    __IOM uint32_t IEOBS1;                      /*!< (@ 0x000002A0) Read only. Reflects the value of the input enable
                                                                    signals for pads 63-32 sent to the pad.                    */

    struct {
      __IOM uint32_t IEDATA1    : 32;           /*!< [31..0] 1 indicates the input_en is active and the value of
                                                     the pad will be trasmitted to the internal logic within
                                                     the device.                                                               */
    } IEOBS1_b;
  } ;

  union {
    __IOM uint32_t IEOBS2;                      /*!< (@ 0x000002A4) Read only. Reflects the value of the input enable
                                                                    signals for pads 95-64 sent to the pad.                    */

    struct {
      __IOM uint32_t IEDATA2    : 32;           /*!< [31..0] 1 indicates the input_en is active and the value of
                                                     the pad will be trasmitted to the internal logic within
                                                     the device.                                                               */
    } IEOBS2_b;
  } ;

  union {
    __IOM uint32_t IEOBS3;                      /*!< (@ 0x000002A8) Read only. Reflects the value of the input enable
                                                                    signals for pads 127-96 sent to the pad.                   */

    struct {
      __IOM uint32_t IEDATA3    : 32;           /*!< [31..0] 1 indicates the input_en is active and the value of
                                                     the pad will be trasmitted to the internal logic within
                                                     the device.                                                               */
    } IEOBS3_b;
  } ;

  union {
    __IOM uint32_t OEOBS0;                      /*!< (@ 0x000002AC) Read only. Reflects the value of the output enable
                                                                    signals for pads 31-0 sent to the pad.                     */

    struct {
      __IOM uint32_t OEDATA0    : 32;           /*!< [31..0] The signal is negative active, and a value of 0 indicates
                                                     the output_en_ is active and the MCU will be driving the
                                                     pad.                                                                      */
    } OEOBS0_b;
  } ;

  union {
    __IOM uint32_t OEOBS1;                      /*!< (@ 0x000002B0) Read only. Reflects the value of the output enable
                                                                    signals for pads 63-32 sent to the pad.                    */

    struct {
      __IOM uint32_t OEDATA1    : 32;           /*!< [31..0] The signal is negative active, and a value of 0 indicates
                                                     the output_en_ is active and the MCU will be driving the
                                                     pad.                                                                      */
    } OEOBS1_b;
  } ;

  union {
    __IOM uint32_t OEOBS2;                      /*!< (@ 0x000002B4) Read only. Reflects the value of the output enable
                                                                    signals for pads 95-64 sent to the pad.                    */

    struct {
      __IOM uint32_t OEDATA2    : 32;           /*!< [31..0] The signal is negative active, and a value of 0 indicates
                                                     the output_en_ is active and the MCU will be driving the
                                                     pad.                                                                      */
    } OEOBS2_b;
  } ;

  union {
    __IOM uint32_t OEOBS3;                      /*!< (@ 0x000002B8) Read only. Reflects the value of the output enable
                                                                    signals for pads 127-96 sent to the pad.                   */

    struct {
      __IOM uint32_t OEDATA3    : 32;           /*!< [31..0] The signal is negative active, and a value of 0 indicates
                                                     the output_en_ is active and the MCU will be driving the
                                                     pad.                                                                      */
    } OEOBS3_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t MCUN0INT0EN;                 /*!< (@ 0x000002C0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t MCUN0GPIO0 : 1;            /*!< [0..0] GPIO0 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO1 : 1;            /*!< [1..1] GPIO1 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO2 : 1;            /*!< [2..2] GPIO2 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO3 : 1;            /*!< [3..3] GPIO3 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO4 : 1;            /*!< [4..4] GPIO4 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO5 : 1;            /*!< [5..5] GPIO5 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO6 : 1;            /*!< [6..6] GPIO6 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO7 : 1;            /*!< [7..7] GPIO7 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO8 : 1;            /*!< [8..8] GPIO8 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO9 : 1;            /*!< [9..9] GPIO9 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO10 : 1;           /*!< [10..10] GPIO10 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO11 : 1;           /*!< [11..11] GPIO11 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO12 : 1;           /*!< [12..12] GPIO12 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO13 : 1;           /*!< [13..13] GPIO13 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO14 : 1;           /*!< [14..14] GPIO14 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO15 : 1;           /*!< [15..15] GPIO15 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO16 : 1;           /*!< [16..16] GPIO16 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO17 : 1;           /*!< [17..17] GPIO17 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO18 : 1;           /*!< [18..18] GPIO18 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO19 : 1;           /*!< [19..19] GPIO19 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO20 : 1;           /*!< [20..20] GPIO20 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO21 : 1;           /*!< [21..21] GPIO21 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO22 : 1;           /*!< [22..22] GPIO22 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO23 : 1;           /*!< [23..23] GPIO23 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO24 : 1;           /*!< [24..24] GPIO24 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO25 : 1;           /*!< [25..25] GPIO25 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO26 : 1;           /*!< [26..26] GPIO26 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO27 : 1;           /*!< [27..27] GPIO27 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO28 : 1;           /*!< [28..28] GPIO28 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO29 : 1;           /*!< [29..29] GPIO29 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO30 : 1;           /*!< [30..30] GPIO30 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO31 : 1;           /*!< [31..31] GPIO31 MCU N0-priority interrupt.                                */
    } MCUN0INT0EN_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT0STAT;               /*!< (@ 0x000002C4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t MCUN0GPIO0 : 1;            /*!< [0..0] GPIO0 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO1 : 1;            /*!< [1..1] GPIO1 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO2 : 1;            /*!< [2..2] GPIO2 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO3 : 1;            /*!< [3..3] GPIO3 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO4 : 1;            /*!< [4..4] GPIO4 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO5 : 1;            /*!< [5..5] GPIO5 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO6 : 1;            /*!< [6..6] GPIO6 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO7 : 1;            /*!< [7..7] GPIO7 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO8 : 1;            /*!< [8..8] GPIO8 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO9 : 1;            /*!< [9..9] GPIO9 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO10 : 1;           /*!< [10..10] GPIO10 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO11 : 1;           /*!< [11..11] GPIO11 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO12 : 1;           /*!< [12..12] GPIO12 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO13 : 1;           /*!< [13..13] GPIO13 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO14 : 1;           /*!< [14..14] GPIO14 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO15 : 1;           /*!< [15..15] GPIO15 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO16 : 1;           /*!< [16..16] GPIO16 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO17 : 1;           /*!< [17..17] GPIO17 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO18 : 1;           /*!< [18..18] GPIO18 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO19 : 1;           /*!< [19..19] GPIO19 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO20 : 1;           /*!< [20..20] GPIO20 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO21 : 1;           /*!< [21..21] GPIO21 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO22 : 1;           /*!< [22..22] GPIO22 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO23 : 1;           /*!< [23..23] GPIO23 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO24 : 1;           /*!< [24..24] GPIO24 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO25 : 1;           /*!< [25..25] GPIO25 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO26 : 1;           /*!< [26..26] GPIO26 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO27 : 1;           /*!< [27..27] GPIO27 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO28 : 1;           /*!< [28..28] GPIO28 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO29 : 1;           /*!< [29..29] GPIO29 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO30 : 1;           /*!< [30..30] GPIO30 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO31 : 1;           /*!< [31..31] GPIO31 MCU N0-priority interrupt.                                */
    } MCUN0INT0STAT_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT0CLR;                /*!< (@ 0x000002C8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t MCUN0GPIO0 : 1;            /*!< [0..0] GPIO0 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO1 : 1;            /*!< [1..1] GPIO1 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO2 : 1;            /*!< [2..2] GPIO2 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO3 : 1;            /*!< [3..3] GPIO3 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO4 : 1;            /*!< [4..4] GPIO4 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO5 : 1;            /*!< [5..5] GPIO5 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO6 : 1;            /*!< [6..6] GPIO6 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO7 : 1;            /*!< [7..7] GPIO7 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO8 : 1;            /*!< [8..8] GPIO8 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO9 : 1;            /*!< [9..9] GPIO9 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO10 : 1;           /*!< [10..10] GPIO10 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO11 : 1;           /*!< [11..11] GPIO11 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO12 : 1;           /*!< [12..12] GPIO12 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO13 : 1;           /*!< [13..13] GPIO13 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO14 : 1;           /*!< [14..14] GPIO14 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO15 : 1;           /*!< [15..15] GPIO15 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO16 : 1;           /*!< [16..16] GPIO16 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO17 : 1;           /*!< [17..17] GPIO17 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO18 : 1;           /*!< [18..18] GPIO18 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO19 : 1;           /*!< [19..19] GPIO19 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO20 : 1;           /*!< [20..20] GPIO20 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO21 : 1;           /*!< [21..21] GPIO21 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO22 : 1;           /*!< [22..22] GPIO22 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO23 : 1;           /*!< [23..23] GPIO23 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO24 : 1;           /*!< [24..24] GPIO24 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO25 : 1;           /*!< [25..25] GPIO25 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO26 : 1;           /*!< [26..26] GPIO26 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO27 : 1;           /*!< [27..27] GPIO27 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO28 : 1;           /*!< [28..28] GPIO28 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO29 : 1;           /*!< [29..29] GPIO29 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO30 : 1;           /*!< [30..30] GPIO30 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO31 : 1;           /*!< [31..31] GPIO31 MCU N0-priority interrupt.                                */
    } MCUN0INT0CLR_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT0SET;                /*!< (@ 0x000002CC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t MCUN0GPIO0 : 1;            /*!< [0..0] GPIO0 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO1 : 1;            /*!< [1..1] GPIO1 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO2 : 1;            /*!< [2..2] GPIO2 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO3 : 1;            /*!< [3..3] GPIO3 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO4 : 1;            /*!< [4..4] GPIO4 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO5 : 1;            /*!< [5..5] GPIO5 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO6 : 1;            /*!< [6..6] GPIO6 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO7 : 1;            /*!< [7..7] GPIO7 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO8 : 1;            /*!< [8..8] GPIO8 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO9 : 1;            /*!< [9..9] GPIO9 MCU N0-priority interrupt.                                   */
      __IOM uint32_t MCUN0GPIO10 : 1;           /*!< [10..10] GPIO10 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO11 : 1;           /*!< [11..11] GPIO11 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO12 : 1;           /*!< [12..12] GPIO12 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO13 : 1;           /*!< [13..13] GPIO13 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO14 : 1;           /*!< [14..14] GPIO14 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO15 : 1;           /*!< [15..15] GPIO15 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO16 : 1;           /*!< [16..16] GPIO16 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO17 : 1;           /*!< [17..17] GPIO17 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO18 : 1;           /*!< [18..18] GPIO18 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO19 : 1;           /*!< [19..19] GPIO19 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO20 : 1;           /*!< [20..20] GPIO20 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO21 : 1;           /*!< [21..21] GPIO21 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO22 : 1;           /*!< [22..22] GPIO22 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO23 : 1;           /*!< [23..23] GPIO23 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO24 : 1;           /*!< [24..24] GPIO24 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO25 : 1;           /*!< [25..25] GPIO25 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO26 : 1;           /*!< [26..26] GPIO26 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO27 : 1;           /*!< [27..27] GPIO27 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO28 : 1;           /*!< [28..28] GPIO28 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO29 : 1;           /*!< [29..29] GPIO29 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO30 : 1;           /*!< [30..30] GPIO30 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO31 : 1;           /*!< [31..31] GPIO31 MCU N0-priority interrupt.                                */
    } MCUN0INT0SET_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT1EN;                 /*!< (@ 0x000002D0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t MCUN0GPIO32 : 1;           /*!< [0..0] GPIO32 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO33 : 1;           /*!< [1..1] GPIO33 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO34 : 1;           /*!< [2..2] GPIO34 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO35 : 1;           /*!< [3..3] GPIO35 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO36 : 1;           /*!< [4..4] GPIO36 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO37 : 1;           /*!< [5..5] GPIO37 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO38 : 1;           /*!< [6..6] GPIO38 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO39 : 1;           /*!< [7..7] GPIO39 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO40 : 1;           /*!< [8..8] GPIO40 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO41 : 1;           /*!< [9..9] GPIO41 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO42 : 1;           /*!< [10..10] GPIO42 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO43 : 1;           /*!< [11..11] GPIO43 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO44 : 1;           /*!< [12..12] GPIO44 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO45 : 1;           /*!< [13..13] GPIO45 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO46 : 1;           /*!< [14..14] GPIO46 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO47 : 1;           /*!< [15..15] GPIO47 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO48 : 1;           /*!< [16..16] GPIO48 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO49 : 1;           /*!< [17..17] GPIO49 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO50 : 1;           /*!< [18..18] GPIO50 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO51 : 1;           /*!< [19..19] GPIO51 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO52 : 1;           /*!< [20..20] GPIO52 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO53 : 1;           /*!< [21..21] GPIO53 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO54 : 1;           /*!< [22..22] GPIO54 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO55 : 1;           /*!< [23..23] GPIO55 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO56 : 1;           /*!< [24..24] GPIO56 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO57 : 1;           /*!< [25..25] GPIO57 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO58 : 1;           /*!< [26..26] GPIO58 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO59 : 1;           /*!< [27..27] GPIO59 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO60 : 1;           /*!< [28..28] GPIO60 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO61 : 1;           /*!< [29..29] GPIO61 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO62 : 1;           /*!< [30..30] GPIO62 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO63 : 1;           /*!< [31..31] GPIO63 MCU N0-priority interrupt.                                */
    } MCUN0INT1EN_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT1STAT;               /*!< (@ 0x000002D4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t MCUN0GPIO32 : 1;           /*!< [0..0] GPIO32 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO33 : 1;           /*!< [1..1] GPIO33 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO34 : 1;           /*!< [2..2] GPIO34 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO35 : 1;           /*!< [3..3] GPIO35 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO36 : 1;           /*!< [4..4] GPIO36 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO37 : 1;           /*!< [5..5] GPIO37 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO38 : 1;           /*!< [6..6] GPIO38 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO39 : 1;           /*!< [7..7] GPIO39 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO40 : 1;           /*!< [8..8] GPIO40 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO41 : 1;           /*!< [9..9] GPIO41 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO42 : 1;           /*!< [10..10] GPIO42 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO43 : 1;           /*!< [11..11] GPIO43 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO44 : 1;           /*!< [12..12] GPIO44 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO45 : 1;           /*!< [13..13] GPIO45 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO46 : 1;           /*!< [14..14] GPIO46 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO47 : 1;           /*!< [15..15] GPIO47 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO48 : 1;           /*!< [16..16] GPIO48 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO49 : 1;           /*!< [17..17] GPIO49 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO50 : 1;           /*!< [18..18] GPIO50 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO51 : 1;           /*!< [19..19] GPIO51 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO52 : 1;           /*!< [20..20] GPIO52 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO53 : 1;           /*!< [21..21] GPIO53 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO54 : 1;           /*!< [22..22] GPIO54 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO55 : 1;           /*!< [23..23] GPIO55 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO56 : 1;           /*!< [24..24] GPIO56 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO57 : 1;           /*!< [25..25] GPIO57 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO58 : 1;           /*!< [26..26] GPIO58 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO59 : 1;           /*!< [27..27] GPIO59 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO60 : 1;           /*!< [28..28] GPIO60 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO61 : 1;           /*!< [29..29] GPIO61 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO62 : 1;           /*!< [30..30] GPIO62 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO63 : 1;           /*!< [31..31] GPIO63 MCU N0-priority interrupt.                                */
    } MCUN0INT1STAT_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT1CLR;                /*!< (@ 0x000002D8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t MCUN0GPIO32 : 1;           /*!< [0..0] GPIO32 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO33 : 1;           /*!< [1..1] GPIO33 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO34 : 1;           /*!< [2..2] GPIO34 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO35 : 1;           /*!< [3..3] GPIO35 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO36 : 1;           /*!< [4..4] GPIO36 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO37 : 1;           /*!< [5..5] GPIO37 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO38 : 1;           /*!< [6..6] GPIO38 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO39 : 1;           /*!< [7..7] GPIO39 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO40 : 1;           /*!< [8..8] GPIO40 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO41 : 1;           /*!< [9..9] GPIO41 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO42 : 1;           /*!< [10..10] GPIO42 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO43 : 1;           /*!< [11..11] GPIO43 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO44 : 1;           /*!< [12..12] GPIO44 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO45 : 1;           /*!< [13..13] GPIO45 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO46 : 1;           /*!< [14..14] GPIO46 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO47 : 1;           /*!< [15..15] GPIO47 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO48 : 1;           /*!< [16..16] GPIO48 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO49 : 1;           /*!< [17..17] GPIO49 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO50 : 1;           /*!< [18..18] GPIO50 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO51 : 1;           /*!< [19..19] GPIO51 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO52 : 1;           /*!< [20..20] GPIO52 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO53 : 1;           /*!< [21..21] GPIO53 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO54 : 1;           /*!< [22..22] GPIO54 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO55 : 1;           /*!< [23..23] GPIO55 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO56 : 1;           /*!< [24..24] GPIO56 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO57 : 1;           /*!< [25..25] GPIO57 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO58 : 1;           /*!< [26..26] GPIO58 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO59 : 1;           /*!< [27..27] GPIO59 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO60 : 1;           /*!< [28..28] GPIO60 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO61 : 1;           /*!< [29..29] GPIO61 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO62 : 1;           /*!< [30..30] GPIO62 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO63 : 1;           /*!< [31..31] GPIO63 MCU N0-priority interrupt.                                */
    } MCUN0INT1CLR_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT1SET;                /*!< (@ 0x000002DC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t MCUN0GPIO32 : 1;           /*!< [0..0] GPIO32 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO33 : 1;           /*!< [1..1] GPIO33 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO34 : 1;           /*!< [2..2] GPIO34 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO35 : 1;           /*!< [3..3] GPIO35 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO36 : 1;           /*!< [4..4] GPIO36 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO37 : 1;           /*!< [5..5] GPIO37 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO38 : 1;           /*!< [6..6] GPIO38 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO39 : 1;           /*!< [7..7] GPIO39 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO40 : 1;           /*!< [8..8] GPIO40 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO41 : 1;           /*!< [9..9] GPIO41 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO42 : 1;           /*!< [10..10] GPIO42 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO43 : 1;           /*!< [11..11] GPIO43 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO44 : 1;           /*!< [12..12] GPIO44 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO45 : 1;           /*!< [13..13] GPIO45 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO46 : 1;           /*!< [14..14] GPIO46 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO47 : 1;           /*!< [15..15] GPIO47 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO48 : 1;           /*!< [16..16] GPIO48 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO49 : 1;           /*!< [17..17] GPIO49 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO50 : 1;           /*!< [18..18] GPIO50 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO51 : 1;           /*!< [19..19] GPIO51 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO52 : 1;           /*!< [20..20] GPIO52 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO53 : 1;           /*!< [21..21] GPIO53 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO54 : 1;           /*!< [22..22] GPIO54 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO55 : 1;           /*!< [23..23] GPIO55 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO56 : 1;           /*!< [24..24] GPIO56 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO57 : 1;           /*!< [25..25] GPIO57 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO58 : 1;           /*!< [26..26] GPIO58 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO59 : 1;           /*!< [27..27] GPIO59 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO60 : 1;           /*!< [28..28] GPIO60 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO61 : 1;           /*!< [29..29] GPIO61 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO62 : 1;           /*!< [30..30] GPIO62 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO63 : 1;           /*!< [31..31] GPIO63 MCU N0-priority interrupt.                                */
    } MCUN0INT1SET_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT2EN;                 /*!< (@ 0x000002E0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t MCUN0GPIO64 : 1;           /*!< [0..0] GPIO64 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO65 : 1;           /*!< [1..1] GPIO65 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO66 : 1;           /*!< [2..2] GPIO66 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO67 : 1;           /*!< [3..3] GPIO67 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO68 : 1;           /*!< [4..4] GPIO68 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO69 : 1;           /*!< [5..5] GPIO69 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO70 : 1;           /*!< [6..6] GPIO70 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO71 : 1;           /*!< [7..7] GPIO71 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO72 : 1;           /*!< [8..8] GPIO72 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO73 : 1;           /*!< [9..9] GPIO73 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO74 : 1;           /*!< [10..10] GPIO74 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO75 : 1;           /*!< [11..11] GPIO75 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO76 : 1;           /*!< [12..12] GPIO76 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO77 : 1;           /*!< [13..13] GPIO77 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO78 : 1;           /*!< [14..14] GPIO78 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO79 : 1;           /*!< [15..15] GPIO79 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO80 : 1;           /*!< [16..16] GPIO80 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO81 : 1;           /*!< [17..17] GPIO81 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO82 : 1;           /*!< [18..18] GPIO82 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO83 : 1;           /*!< [19..19] GPIO83 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO84 : 1;           /*!< [20..20] GPIO84 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO85 : 1;           /*!< [21..21] GPIO85 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO86 : 1;           /*!< [22..22] GPIO86 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO87 : 1;           /*!< [23..23] GPIO87 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO88 : 1;           /*!< [24..24] GPIO88 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO89 : 1;           /*!< [25..25] GPIO89 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO90 : 1;           /*!< [26..26] GPIO90 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO91 : 1;           /*!< [27..27] GPIO91 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO92 : 1;           /*!< [28..28] GPIO92 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO93 : 1;           /*!< [29..29] GPIO93 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO94 : 1;           /*!< [30..30] GPIO94 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO95 : 1;           /*!< [31..31] GPIO95 MCU N0-priority interrupt.                                */
    } MCUN0INT2EN_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT2STAT;               /*!< (@ 0x000002E4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t MCUN0GPIO64 : 1;           /*!< [0..0] GPIO64 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO65 : 1;           /*!< [1..1] GPIO65 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO66 : 1;           /*!< [2..2] GPIO66 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO67 : 1;           /*!< [3..3] GPIO67 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO68 : 1;           /*!< [4..4] GPIO68 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO69 : 1;           /*!< [5..5] GPIO69 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO70 : 1;           /*!< [6..6] GPIO70 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO71 : 1;           /*!< [7..7] GPIO71 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO72 : 1;           /*!< [8..8] GPIO72 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO73 : 1;           /*!< [9..9] GPIO73 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO74 : 1;           /*!< [10..10] GPIO74 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO75 : 1;           /*!< [11..11] GPIO75 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO76 : 1;           /*!< [12..12] GPIO76 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO77 : 1;           /*!< [13..13] GPIO77 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO78 : 1;           /*!< [14..14] GPIO78 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO79 : 1;           /*!< [15..15] GPIO79 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO80 : 1;           /*!< [16..16] GPIO80 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO81 : 1;           /*!< [17..17] GPIO81 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO82 : 1;           /*!< [18..18] GPIO82 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO83 : 1;           /*!< [19..19] GPIO83 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO84 : 1;           /*!< [20..20] GPIO84 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO85 : 1;           /*!< [21..21] GPIO85 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO86 : 1;           /*!< [22..22] GPIO86 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO87 : 1;           /*!< [23..23] GPIO87 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO88 : 1;           /*!< [24..24] GPIO88 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO89 : 1;           /*!< [25..25] GPIO89 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO90 : 1;           /*!< [26..26] GPIO90 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO91 : 1;           /*!< [27..27] GPIO91 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO92 : 1;           /*!< [28..28] GPIO92 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO93 : 1;           /*!< [29..29] GPIO93 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO94 : 1;           /*!< [30..30] GPIO94 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO95 : 1;           /*!< [31..31] GPIO95 MCU N0-priority interrupt.                                */
    } MCUN0INT2STAT_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT2CLR;                /*!< (@ 0x000002E8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t MCUN0GPIO64 : 1;           /*!< [0..0] GPIO64 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO65 : 1;           /*!< [1..1] GPIO65 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO66 : 1;           /*!< [2..2] GPIO66 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO67 : 1;           /*!< [3..3] GPIO67 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO68 : 1;           /*!< [4..4] GPIO68 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO69 : 1;           /*!< [5..5] GPIO69 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO70 : 1;           /*!< [6..6] GPIO70 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO71 : 1;           /*!< [7..7] GPIO71 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO72 : 1;           /*!< [8..8] GPIO72 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO73 : 1;           /*!< [9..9] GPIO73 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO74 : 1;           /*!< [10..10] GPIO74 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO75 : 1;           /*!< [11..11] GPIO75 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO76 : 1;           /*!< [12..12] GPIO76 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO77 : 1;           /*!< [13..13] GPIO77 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO78 : 1;           /*!< [14..14] GPIO78 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO79 : 1;           /*!< [15..15] GPIO79 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO80 : 1;           /*!< [16..16] GPIO80 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO81 : 1;           /*!< [17..17] GPIO81 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO82 : 1;           /*!< [18..18] GPIO82 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO83 : 1;           /*!< [19..19] GPIO83 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO84 : 1;           /*!< [20..20] GPIO84 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO85 : 1;           /*!< [21..21] GPIO85 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO86 : 1;           /*!< [22..22] GPIO86 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO87 : 1;           /*!< [23..23] GPIO87 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO88 : 1;           /*!< [24..24] GPIO88 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO89 : 1;           /*!< [25..25] GPIO89 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO90 : 1;           /*!< [26..26] GPIO90 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO91 : 1;           /*!< [27..27] GPIO91 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO92 : 1;           /*!< [28..28] GPIO92 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO93 : 1;           /*!< [29..29] GPIO93 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO94 : 1;           /*!< [30..30] GPIO94 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO95 : 1;           /*!< [31..31] GPIO95 MCU N0-priority interrupt.                                */
    } MCUN0INT2CLR_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT2SET;                /*!< (@ 0x000002EC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t MCUN0GPIO64 : 1;           /*!< [0..0] GPIO64 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO65 : 1;           /*!< [1..1] GPIO65 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO66 : 1;           /*!< [2..2] GPIO66 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO67 : 1;           /*!< [3..3] GPIO67 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO68 : 1;           /*!< [4..4] GPIO68 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO69 : 1;           /*!< [5..5] GPIO69 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO70 : 1;           /*!< [6..6] GPIO70 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO71 : 1;           /*!< [7..7] GPIO71 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO72 : 1;           /*!< [8..8] GPIO72 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO73 : 1;           /*!< [9..9] GPIO73 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO74 : 1;           /*!< [10..10] GPIO74 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO75 : 1;           /*!< [11..11] GPIO75 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO76 : 1;           /*!< [12..12] GPIO76 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO77 : 1;           /*!< [13..13] GPIO77 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO78 : 1;           /*!< [14..14] GPIO78 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO79 : 1;           /*!< [15..15] GPIO79 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO80 : 1;           /*!< [16..16] GPIO80 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO81 : 1;           /*!< [17..17] GPIO81 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO82 : 1;           /*!< [18..18] GPIO82 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO83 : 1;           /*!< [19..19] GPIO83 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO84 : 1;           /*!< [20..20] GPIO84 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO85 : 1;           /*!< [21..21] GPIO85 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO86 : 1;           /*!< [22..22] GPIO86 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO87 : 1;           /*!< [23..23] GPIO87 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO88 : 1;           /*!< [24..24] GPIO88 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO89 : 1;           /*!< [25..25] GPIO89 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO90 : 1;           /*!< [26..26] GPIO90 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO91 : 1;           /*!< [27..27] GPIO91 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO92 : 1;           /*!< [28..28] GPIO92 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO93 : 1;           /*!< [29..29] GPIO93 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO94 : 1;           /*!< [30..30] GPIO94 MCU N0-priority interrupt.                                */
      __IOM uint32_t MCUN0GPIO95 : 1;           /*!< [31..31] GPIO95 MCU N0-priority interrupt.                                */
    } MCUN0INT2SET_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT3EN;                 /*!< (@ 0x000002F0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t MCUN0GPIO96 : 1;           /*!< [0..0] GPIO96 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO97 : 1;           /*!< [1..1] GPIO97 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO98 : 1;           /*!< [2..2] GPIO98 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO99 : 1;           /*!< [3..3] GPIO99 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO100 : 1;          /*!< [4..4] GPIO100 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO101 : 1;          /*!< [5..5] GPIO101 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO102 : 1;          /*!< [6..6] GPIO102 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO103 : 1;          /*!< [7..7] GPIO103 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO104 : 1;          /*!< [8..8] GPIO104 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO105 : 1;          /*!< [9..9] GPIO105 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO106 : 1;          /*!< [10..10] GPIO106 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO107 : 1;          /*!< [11..11] GPIO107 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO108 : 1;          /*!< [12..12] GPIO108 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO109 : 1;          /*!< [13..13] GPIO109 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO110 : 1;          /*!< [14..14] GPIO110 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO111 : 1;          /*!< [15..15] GPIO111 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO112 : 1;          /*!< [16..16] GPIO112 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO113 : 1;          /*!< [17..17] GPIO113 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO114 : 1;          /*!< [18..18] GPIO114 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO115 : 1;          /*!< [19..19] GPIO115 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO116 : 1;          /*!< [20..20] GPIO116 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO117 : 1;          /*!< [21..21] GPIO117 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO118 : 1;          /*!< [22..22] GPIO118 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO119 : 1;          /*!< [23..23] GPIO119 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO120 : 1;          /*!< [24..24] GPIO120 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO121 : 1;          /*!< [25..25] GPIO121 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO122 : 1;          /*!< [26..26] GPIO122 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO123 : 1;          /*!< [27..27] GPIO123 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO124 : 1;          /*!< [28..28] GPIO124 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO125 : 1;          /*!< [29..29] GPIO125 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO126 : 1;          /*!< [30..30] GPIO126 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO127 : 1;          /*!< [31..31] GPIO127 MCU N0-priority interrupt.                               */
    } MCUN0INT3EN_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT3STAT;               /*!< (@ 0x000002F4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t MCUN0GPIO96 : 1;           /*!< [0..0] GPIO96 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO97 : 1;           /*!< [1..1] GPIO97 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO98 : 1;           /*!< [2..2] GPIO98 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO99 : 1;           /*!< [3..3] GPIO99 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO100 : 1;          /*!< [4..4] GPIO100 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO101 : 1;          /*!< [5..5] GPIO101 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO102 : 1;          /*!< [6..6] GPIO102 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO103 : 1;          /*!< [7..7] GPIO103 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO104 : 1;          /*!< [8..8] GPIO104 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO105 : 1;          /*!< [9..9] GPIO105 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO106 : 1;          /*!< [10..10] GPIO106 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO107 : 1;          /*!< [11..11] GPIO107 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO108 : 1;          /*!< [12..12] GPIO108 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO109 : 1;          /*!< [13..13] GPIO109 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO110 : 1;          /*!< [14..14] GPIO110 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO111 : 1;          /*!< [15..15] GPIO111 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO112 : 1;          /*!< [16..16] GPIO112 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO113 : 1;          /*!< [17..17] GPIO113 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO114 : 1;          /*!< [18..18] GPIO114 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO115 : 1;          /*!< [19..19] GPIO115 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO116 : 1;          /*!< [20..20] GPIO116 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO117 : 1;          /*!< [21..21] GPIO117 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO118 : 1;          /*!< [22..22] GPIO118 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO119 : 1;          /*!< [23..23] GPIO119 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO120 : 1;          /*!< [24..24] GPIO120 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO121 : 1;          /*!< [25..25] GPIO121 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO122 : 1;          /*!< [26..26] GPIO122 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO123 : 1;          /*!< [27..27] GPIO123 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO124 : 1;          /*!< [28..28] GPIO124 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO125 : 1;          /*!< [29..29] GPIO125 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO126 : 1;          /*!< [30..30] GPIO126 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO127 : 1;          /*!< [31..31] GPIO127 MCU N0-priority interrupt.                               */
    } MCUN0INT3STAT_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT3CLR;                /*!< (@ 0x000002F8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t MCUN0GPIO96 : 1;           /*!< [0..0] GPIO96 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO97 : 1;           /*!< [1..1] GPIO97 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO98 : 1;           /*!< [2..2] GPIO98 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO99 : 1;           /*!< [3..3] GPIO99 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO100 : 1;          /*!< [4..4] GPIO100 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO101 : 1;          /*!< [5..5] GPIO101 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO102 : 1;          /*!< [6..6] GPIO102 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO103 : 1;          /*!< [7..7] GPIO103 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO104 : 1;          /*!< [8..8] GPIO104 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO105 : 1;          /*!< [9..9] GPIO105 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO106 : 1;          /*!< [10..10] GPIO106 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO107 : 1;          /*!< [11..11] GPIO107 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO108 : 1;          /*!< [12..12] GPIO108 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO109 : 1;          /*!< [13..13] GPIO109 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO110 : 1;          /*!< [14..14] GPIO110 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO111 : 1;          /*!< [15..15] GPIO111 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO112 : 1;          /*!< [16..16] GPIO112 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO113 : 1;          /*!< [17..17] GPIO113 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO114 : 1;          /*!< [18..18] GPIO114 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO115 : 1;          /*!< [19..19] GPIO115 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO116 : 1;          /*!< [20..20] GPIO116 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO117 : 1;          /*!< [21..21] GPIO117 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO118 : 1;          /*!< [22..22] GPIO118 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO119 : 1;          /*!< [23..23] GPIO119 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO120 : 1;          /*!< [24..24] GPIO120 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO121 : 1;          /*!< [25..25] GPIO121 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO122 : 1;          /*!< [26..26] GPIO122 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO123 : 1;          /*!< [27..27] GPIO123 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO124 : 1;          /*!< [28..28] GPIO124 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO125 : 1;          /*!< [29..29] GPIO125 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO126 : 1;          /*!< [30..30] GPIO126 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO127 : 1;          /*!< [31..31] GPIO127 MCU N0-priority interrupt.                               */
    } MCUN0INT3CLR_b;
  } ;

  union {
    __IOM uint32_t MCUN0INT3SET;                /*!< (@ 0x000002FC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t MCUN0GPIO96 : 1;           /*!< [0..0] GPIO96 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO97 : 1;           /*!< [1..1] GPIO97 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO98 : 1;           /*!< [2..2] GPIO98 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO99 : 1;           /*!< [3..3] GPIO99 MCU N0-priority interrupt.                                  */
      __IOM uint32_t MCUN0GPIO100 : 1;          /*!< [4..4] GPIO100 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO101 : 1;          /*!< [5..5] GPIO101 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO102 : 1;          /*!< [6..6] GPIO102 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO103 : 1;          /*!< [7..7] GPIO103 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO104 : 1;          /*!< [8..8] GPIO104 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO105 : 1;          /*!< [9..9] GPIO105 MCU N0-priority interrupt.                                 */
      __IOM uint32_t MCUN0GPIO106 : 1;          /*!< [10..10] GPIO106 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO107 : 1;          /*!< [11..11] GPIO107 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO108 : 1;          /*!< [12..12] GPIO108 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO109 : 1;          /*!< [13..13] GPIO109 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO110 : 1;          /*!< [14..14] GPIO110 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO111 : 1;          /*!< [15..15] GPIO111 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO112 : 1;          /*!< [16..16] GPIO112 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO113 : 1;          /*!< [17..17] GPIO113 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO114 : 1;          /*!< [18..18] GPIO114 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO115 : 1;          /*!< [19..19] GPIO115 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO116 : 1;          /*!< [20..20] GPIO116 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO117 : 1;          /*!< [21..21] GPIO117 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO118 : 1;          /*!< [22..22] GPIO118 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO119 : 1;          /*!< [23..23] GPIO119 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO120 : 1;          /*!< [24..24] GPIO120 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO121 : 1;          /*!< [25..25] GPIO121 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO122 : 1;          /*!< [26..26] GPIO122 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO123 : 1;          /*!< [27..27] GPIO123 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO124 : 1;          /*!< [28..28] GPIO124 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO125 : 1;          /*!< [29..29] GPIO125 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO126 : 1;          /*!< [30..30] GPIO126 MCU N0-priority interrupt.                               */
      __IOM uint32_t MCUN0GPIO127 : 1;          /*!< [31..31] GPIO127 MCU N0-priority interrupt.                               */
    } MCUN0INT3SET_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT0EN;                 /*!< (@ 0x00000300) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t MCUN1GPIO0 : 1;            /*!< [0..0] GPIO0 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO1 : 1;            /*!< [1..1] GPIO1 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO2 : 1;            /*!< [2..2] GPIO2 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO3 : 1;            /*!< [3..3] GPIO3 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO4 : 1;            /*!< [4..4] GPIO4 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO5 : 1;            /*!< [5..5] GPIO5 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO6 : 1;            /*!< [6..6] GPIO6 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO7 : 1;            /*!< [7..7] GPIO7 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO8 : 1;            /*!< [8..8] GPIO8 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO9 : 1;            /*!< [9..9] GPIO9 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO10 : 1;           /*!< [10..10] GPIO10 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO11 : 1;           /*!< [11..11] GPIO11 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO12 : 1;           /*!< [12..12] GPIO12 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO13 : 1;           /*!< [13..13] GPIO13 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO14 : 1;           /*!< [14..14] GPIO14 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO15 : 1;           /*!< [15..15] GPIO15 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO16 : 1;           /*!< [16..16] GPIO16 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO17 : 1;           /*!< [17..17] GPIO17 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO18 : 1;           /*!< [18..18] GPIO18 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO19 : 1;           /*!< [19..19] GPIO19 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO20 : 1;           /*!< [20..20] GPIO20 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO21 : 1;           /*!< [21..21] GPIO21 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO22 : 1;           /*!< [22..22] GPIO22 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO23 : 1;           /*!< [23..23] GPIO23 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO24 : 1;           /*!< [24..24] GPIO24 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO25 : 1;           /*!< [25..25] GPIO25 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO26 : 1;           /*!< [26..26] GPIO26 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO27 : 1;           /*!< [27..27] GPIO27 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO28 : 1;           /*!< [28..28] GPIO28 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO29 : 1;           /*!< [29..29] GPIO29 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO30 : 1;           /*!< [30..30] GPIO30 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO31 : 1;           /*!< [31..31] GPIO31 MCU N1-priority interrupt.                                */
    } MCUN1INT0EN_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT0STAT;               /*!< (@ 0x00000304) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t MCUN1GPIO0 : 1;            /*!< [0..0] GPIO0 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO1 : 1;            /*!< [1..1] GPIO1 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO2 : 1;            /*!< [2..2] GPIO2 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO3 : 1;            /*!< [3..3] GPIO3 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO4 : 1;            /*!< [4..4] GPIO4 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO5 : 1;            /*!< [5..5] GPIO5 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO6 : 1;            /*!< [6..6] GPIO6 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO7 : 1;            /*!< [7..7] GPIO7 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO8 : 1;            /*!< [8..8] GPIO8 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO9 : 1;            /*!< [9..9] GPIO9 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO10 : 1;           /*!< [10..10] GPIO10 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO11 : 1;           /*!< [11..11] GPIO11 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO12 : 1;           /*!< [12..12] GPIO12 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO13 : 1;           /*!< [13..13] GPIO13 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO14 : 1;           /*!< [14..14] GPIO14 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO15 : 1;           /*!< [15..15] GPIO15 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO16 : 1;           /*!< [16..16] GPIO16 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO17 : 1;           /*!< [17..17] GPIO17 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO18 : 1;           /*!< [18..18] GPIO18 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO19 : 1;           /*!< [19..19] GPIO19 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO20 : 1;           /*!< [20..20] GPIO20 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO21 : 1;           /*!< [21..21] GPIO21 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO22 : 1;           /*!< [22..22] GPIO22 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO23 : 1;           /*!< [23..23] GPIO23 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO24 : 1;           /*!< [24..24] GPIO24 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO25 : 1;           /*!< [25..25] GPIO25 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO26 : 1;           /*!< [26..26] GPIO26 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO27 : 1;           /*!< [27..27] GPIO27 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO28 : 1;           /*!< [28..28] GPIO28 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO29 : 1;           /*!< [29..29] GPIO29 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO30 : 1;           /*!< [30..30] GPIO30 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO31 : 1;           /*!< [31..31] GPIO31 MCU N1-priority interrupt.                                */
    } MCUN1INT0STAT_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT0CLR;                /*!< (@ 0x00000308) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t MCUN1GPIO0 : 1;            /*!< [0..0] GPIO0 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO1 : 1;            /*!< [1..1] GPIO1 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO2 : 1;            /*!< [2..2] GPIO2 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO3 : 1;            /*!< [3..3] GPIO3 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO4 : 1;            /*!< [4..4] GPIO4 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO5 : 1;            /*!< [5..5] GPIO5 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO6 : 1;            /*!< [6..6] GPIO6 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO7 : 1;            /*!< [7..7] GPIO7 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO8 : 1;            /*!< [8..8] GPIO8 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO9 : 1;            /*!< [9..9] GPIO9 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO10 : 1;           /*!< [10..10] GPIO10 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO11 : 1;           /*!< [11..11] GPIO11 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO12 : 1;           /*!< [12..12] GPIO12 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO13 : 1;           /*!< [13..13] GPIO13 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO14 : 1;           /*!< [14..14] GPIO14 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO15 : 1;           /*!< [15..15] GPIO15 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO16 : 1;           /*!< [16..16] GPIO16 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO17 : 1;           /*!< [17..17] GPIO17 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO18 : 1;           /*!< [18..18] GPIO18 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO19 : 1;           /*!< [19..19] GPIO19 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO20 : 1;           /*!< [20..20] GPIO20 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO21 : 1;           /*!< [21..21] GPIO21 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO22 : 1;           /*!< [22..22] GPIO22 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO23 : 1;           /*!< [23..23] GPIO23 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO24 : 1;           /*!< [24..24] GPIO24 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO25 : 1;           /*!< [25..25] GPIO25 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO26 : 1;           /*!< [26..26] GPIO26 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO27 : 1;           /*!< [27..27] GPIO27 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO28 : 1;           /*!< [28..28] GPIO28 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO29 : 1;           /*!< [29..29] GPIO29 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO30 : 1;           /*!< [30..30] GPIO30 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO31 : 1;           /*!< [31..31] GPIO31 MCU N1-priority interrupt.                                */
    } MCUN1INT0CLR_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT0SET;                /*!< (@ 0x0000030C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t MCUN1GPIO0 : 1;            /*!< [0..0] GPIO0 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO1 : 1;            /*!< [1..1] GPIO1 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO2 : 1;            /*!< [2..2] GPIO2 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO3 : 1;            /*!< [3..3] GPIO3 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO4 : 1;            /*!< [4..4] GPIO4 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO5 : 1;            /*!< [5..5] GPIO5 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO6 : 1;            /*!< [6..6] GPIO6 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO7 : 1;            /*!< [7..7] GPIO7 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO8 : 1;            /*!< [8..8] GPIO8 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO9 : 1;            /*!< [9..9] GPIO9 MCU N1-priority interrupt.                                   */
      __IOM uint32_t MCUN1GPIO10 : 1;           /*!< [10..10] GPIO10 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO11 : 1;           /*!< [11..11] GPIO11 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO12 : 1;           /*!< [12..12] GPIO12 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO13 : 1;           /*!< [13..13] GPIO13 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO14 : 1;           /*!< [14..14] GPIO14 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO15 : 1;           /*!< [15..15] GPIO15 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO16 : 1;           /*!< [16..16] GPIO16 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO17 : 1;           /*!< [17..17] GPIO17 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO18 : 1;           /*!< [18..18] GPIO18 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO19 : 1;           /*!< [19..19] GPIO19 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO20 : 1;           /*!< [20..20] GPIO20 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO21 : 1;           /*!< [21..21] GPIO21 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO22 : 1;           /*!< [22..22] GPIO22 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO23 : 1;           /*!< [23..23] GPIO23 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO24 : 1;           /*!< [24..24] GPIO24 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO25 : 1;           /*!< [25..25] GPIO25 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO26 : 1;           /*!< [26..26] GPIO26 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO27 : 1;           /*!< [27..27] GPIO27 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO28 : 1;           /*!< [28..28] GPIO28 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO29 : 1;           /*!< [29..29] GPIO29 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO30 : 1;           /*!< [30..30] GPIO30 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO31 : 1;           /*!< [31..31] GPIO31 MCU N1-priority interrupt.                                */
    } MCUN1INT0SET_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT1EN;                 /*!< (@ 0x00000310) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t MCUN1GPIO32 : 1;           /*!< [0..0] GPIO32 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO33 : 1;           /*!< [1..1] GPIO33 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO34 : 1;           /*!< [2..2] GPIO34 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO35 : 1;           /*!< [3..3] GPIO35 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO36 : 1;           /*!< [4..4] GPIO36 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO37 : 1;           /*!< [5..5] GPIO37 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO38 : 1;           /*!< [6..6] GPIO38 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO39 : 1;           /*!< [7..7] GPIO39 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO40 : 1;           /*!< [8..8] GPIO40 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO41 : 1;           /*!< [9..9] GPIO41 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO42 : 1;           /*!< [10..10] GPIO42 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO43 : 1;           /*!< [11..11] GPIO43 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO44 : 1;           /*!< [12..12] GPIO44 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO45 : 1;           /*!< [13..13] GPIO45 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO46 : 1;           /*!< [14..14] GPIO46 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO47 : 1;           /*!< [15..15] GPIO47 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO48 : 1;           /*!< [16..16] GPIO48 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO49 : 1;           /*!< [17..17] GPIO49 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO50 : 1;           /*!< [18..18] GPIO50 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO51 : 1;           /*!< [19..19] GPIO51 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO52 : 1;           /*!< [20..20] GPIO52 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO53 : 1;           /*!< [21..21] GPIO53 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO54 : 1;           /*!< [22..22] GPIO54 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO55 : 1;           /*!< [23..23] GPIO55 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO56 : 1;           /*!< [24..24] GPIO56 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO57 : 1;           /*!< [25..25] GPIO57 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO58 : 1;           /*!< [26..26] GPIO58 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO59 : 1;           /*!< [27..27] GPIO59 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO60 : 1;           /*!< [28..28] GPIO60 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO61 : 1;           /*!< [29..29] GPIO61 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO62 : 1;           /*!< [30..30] GPIO62 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO63 : 1;           /*!< [31..31] GPIO63 MCU N1-priority interrupt.                                */
    } MCUN1INT1EN_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT1STAT;               /*!< (@ 0x00000314) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t MCUN1GPIO32 : 1;           /*!< [0..0] GPIO32 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO33 : 1;           /*!< [1..1] GPIO33 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO34 : 1;           /*!< [2..2] GPIO34 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO35 : 1;           /*!< [3..3] GPIO35 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO36 : 1;           /*!< [4..4] GPIO36 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO37 : 1;           /*!< [5..5] GPIO37 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO38 : 1;           /*!< [6..6] GPIO38 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO39 : 1;           /*!< [7..7] GPIO39 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO40 : 1;           /*!< [8..8] GPIO40 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO41 : 1;           /*!< [9..9] GPIO41 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO42 : 1;           /*!< [10..10] GPIO42 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO43 : 1;           /*!< [11..11] GPIO43 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO44 : 1;           /*!< [12..12] GPIO44 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO45 : 1;           /*!< [13..13] GPIO45 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO46 : 1;           /*!< [14..14] GPIO46 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO47 : 1;           /*!< [15..15] GPIO47 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO48 : 1;           /*!< [16..16] GPIO48 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO49 : 1;           /*!< [17..17] GPIO49 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO50 : 1;           /*!< [18..18] GPIO50 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO51 : 1;           /*!< [19..19] GPIO51 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO52 : 1;           /*!< [20..20] GPIO52 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO53 : 1;           /*!< [21..21] GPIO53 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO54 : 1;           /*!< [22..22] GPIO54 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO55 : 1;           /*!< [23..23] GPIO55 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO56 : 1;           /*!< [24..24] GPIO56 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO57 : 1;           /*!< [25..25] GPIO57 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO58 : 1;           /*!< [26..26] GPIO58 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO59 : 1;           /*!< [27..27] GPIO59 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO60 : 1;           /*!< [28..28] GPIO60 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO61 : 1;           /*!< [29..29] GPIO61 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO62 : 1;           /*!< [30..30] GPIO62 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO63 : 1;           /*!< [31..31] GPIO63 MCU N1-priority interrupt.                                */
    } MCUN1INT1STAT_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT1CLR;                /*!< (@ 0x00000318) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t MCUN1GPIO32 : 1;           /*!< [0..0] GPIO32 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO33 : 1;           /*!< [1..1] GPIO33 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO34 : 1;           /*!< [2..2] GPIO34 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO35 : 1;           /*!< [3..3] GPIO35 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO36 : 1;           /*!< [4..4] GPIO36 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO37 : 1;           /*!< [5..5] GPIO37 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO38 : 1;           /*!< [6..6] GPIO38 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO39 : 1;           /*!< [7..7] GPIO39 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO40 : 1;           /*!< [8..8] GPIO40 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO41 : 1;           /*!< [9..9] GPIO41 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO42 : 1;           /*!< [10..10] GPIO42 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO43 : 1;           /*!< [11..11] GPIO43 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO44 : 1;           /*!< [12..12] GPIO44 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO45 : 1;           /*!< [13..13] GPIO45 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO46 : 1;           /*!< [14..14] GPIO46 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO47 : 1;           /*!< [15..15] GPIO47 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO48 : 1;           /*!< [16..16] GPIO48 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO49 : 1;           /*!< [17..17] GPIO49 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO50 : 1;           /*!< [18..18] GPIO50 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO51 : 1;           /*!< [19..19] GPIO51 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO52 : 1;           /*!< [20..20] GPIO52 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO53 : 1;           /*!< [21..21] GPIO53 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO54 : 1;           /*!< [22..22] GPIO54 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO55 : 1;           /*!< [23..23] GPIO55 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO56 : 1;           /*!< [24..24] GPIO56 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO57 : 1;           /*!< [25..25] GPIO57 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO58 : 1;           /*!< [26..26] GPIO58 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO59 : 1;           /*!< [27..27] GPIO59 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO60 : 1;           /*!< [28..28] GPIO60 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO61 : 1;           /*!< [29..29] GPIO61 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO62 : 1;           /*!< [30..30] GPIO62 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO63 : 1;           /*!< [31..31] GPIO63 MCU N1-priority interrupt.                                */
    } MCUN1INT1CLR_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT1SET;                /*!< (@ 0x0000031C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t MCUN1GPIO32 : 1;           /*!< [0..0] GPIO32 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO33 : 1;           /*!< [1..1] GPIO33 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO34 : 1;           /*!< [2..2] GPIO34 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO35 : 1;           /*!< [3..3] GPIO35 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO36 : 1;           /*!< [4..4] GPIO36 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO37 : 1;           /*!< [5..5] GPIO37 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO38 : 1;           /*!< [6..6] GPIO38 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO39 : 1;           /*!< [7..7] GPIO39 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO40 : 1;           /*!< [8..8] GPIO40 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO41 : 1;           /*!< [9..9] GPIO41 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO42 : 1;           /*!< [10..10] GPIO42 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO43 : 1;           /*!< [11..11] GPIO43 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO44 : 1;           /*!< [12..12] GPIO44 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO45 : 1;           /*!< [13..13] GPIO45 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO46 : 1;           /*!< [14..14] GPIO46 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO47 : 1;           /*!< [15..15] GPIO47 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO48 : 1;           /*!< [16..16] GPIO48 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO49 : 1;           /*!< [17..17] GPIO49 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO50 : 1;           /*!< [18..18] GPIO50 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO51 : 1;           /*!< [19..19] GPIO51 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO52 : 1;           /*!< [20..20] GPIO52 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO53 : 1;           /*!< [21..21] GPIO53 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO54 : 1;           /*!< [22..22] GPIO54 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO55 : 1;           /*!< [23..23] GPIO55 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO56 : 1;           /*!< [24..24] GPIO56 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO57 : 1;           /*!< [25..25] GPIO57 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO58 : 1;           /*!< [26..26] GPIO58 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO59 : 1;           /*!< [27..27] GPIO59 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO60 : 1;           /*!< [28..28] GPIO60 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO61 : 1;           /*!< [29..29] GPIO61 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO62 : 1;           /*!< [30..30] GPIO62 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO63 : 1;           /*!< [31..31] GPIO63 MCU N1-priority interrupt.                                */
    } MCUN1INT1SET_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT2EN;                 /*!< (@ 0x00000320) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t MCUN1GPIO64 : 1;           /*!< [0..0] GPIO64 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO65 : 1;           /*!< [1..1] GPIO65 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO66 : 1;           /*!< [2..2] GPIO66 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO67 : 1;           /*!< [3..3] GPIO67 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO68 : 1;           /*!< [4..4] GPIO68 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO69 : 1;           /*!< [5..5] GPIO69 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO70 : 1;           /*!< [6..6] GPIO70 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO71 : 1;           /*!< [7..7] GPIO71 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO72 : 1;           /*!< [8..8] GPIO72 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO73 : 1;           /*!< [9..9] GPIO73 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO74 : 1;           /*!< [10..10] GPIO74 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO75 : 1;           /*!< [11..11] GPIO75 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO76 : 1;           /*!< [12..12] GPIO76 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO77 : 1;           /*!< [13..13] GPIO77 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO78 : 1;           /*!< [14..14] GPIO78 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO79 : 1;           /*!< [15..15] GPIO79 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO80 : 1;           /*!< [16..16] GPIO80 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO81 : 1;           /*!< [17..17] GPIO81 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO82 : 1;           /*!< [18..18] GPIO82 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO83 : 1;           /*!< [19..19] GPIO83 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO84 : 1;           /*!< [20..20] GPIO84 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO85 : 1;           /*!< [21..21] GPIO85 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO86 : 1;           /*!< [22..22] GPIO86 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO87 : 1;           /*!< [23..23] GPIO87 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO88 : 1;           /*!< [24..24] GPIO88 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO89 : 1;           /*!< [25..25] GPIO89 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO90 : 1;           /*!< [26..26] GPIO90 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO91 : 1;           /*!< [27..27] GPIO91 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO92 : 1;           /*!< [28..28] GPIO92 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO93 : 1;           /*!< [29..29] GPIO93 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO94 : 1;           /*!< [30..30] GPIO94 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO95 : 1;           /*!< [31..31] GPIO95 MCU N1-priority interrupt.                                */
    } MCUN1INT2EN_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT2STAT;               /*!< (@ 0x00000324) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t MCUN1GPIO64 : 1;           /*!< [0..0] GPIO64 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO65 : 1;           /*!< [1..1] GPIO65 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO66 : 1;           /*!< [2..2] GPIO66 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO67 : 1;           /*!< [3..3] GPIO67 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO68 : 1;           /*!< [4..4] GPIO68 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO69 : 1;           /*!< [5..5] GPIO69 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO70 : 1;           /*!< [6..6] GPIO70 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO71 : 1;           /*!< [7..7] GPIO71 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO72 : 1;           /*!< [8..8] GPIO72 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO73 : 1;           /*!< [9..9] GPIO73 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO74 : 1;           /*!< [10..10] GPIO74 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO75 : 1;           /*!< [11..11] GPIO75 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO76 : 1;           /*!< [12..12] GPIO76 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO77 : 1;           /*!< [13..13] GPIO77 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO78 : 1;           /*!< [14..14] GPIO78 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO79 : 1;           /*!< [15..15] GPIO79 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO80 : 1;           /*!< [16..16] GPIO80 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO81 : 1;           /*!< [17..17] GPIO81 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO82 : 1;           /*!< [18..18] GPIO82 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO83 : 1;           /*!< [19..19] GPIO83 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO84 : 1;           /*!< [20..20] GPIO84 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO85 : 1;           /*!< [21..21] GPIO85 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO86 : 1;           /*!< [22..22] GPIO86 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO87 : 1;           /*!< [23..23] GPIO87 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO88 : 1;           /*!< [24..24] GPIO88 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO89 : 1;           /*!< [25..25] GPIO89 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO90 : 1;           /*!< [26..26] GPIO90 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO91 : 1;           /*!< [27..27] GPIO91 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO92 : 1;           /*!< [28..28] GPIO92 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO93 : 1;           /*!< [29..29] GPIO93 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO94 : 1;           /*!< [30..30] GPIO94 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO95 : 1;           /*!< [31..31] GPIO95 MCU N1-priority interrupt.                                */
    } MCUN1INT2STAT_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT2CLR;                /*!< (@ 0x00000328) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t MCUN1GPIO64 : 1;           /*!< [0..0] GPIO64 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO65 : 1;           /*!< [1..1] GPIO65 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO66 : 1;           /*!< [2..2] GPIO66 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO67 : 1;           /*!< [3..3] GPIO67 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO68 : 1;           /*!< [4..4] GPIO68 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO69 : 1;           /*!< [5..5] GPIO69 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO70 : 1;           /*!< [6..6] GPIO70 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO71 : 1;           /*!< [7..7] GPIO71 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO72 : 1;           /*!< [8..8] GPIO72 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO73 : 1;           /*!< [9..9] GPIO73 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO74 : 1;           /*!< [10..10] GPIO74 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO75 : 1;           /*!< [11..11] GPIO75 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO76 : 1;           /*!< [12..12] GPIO76 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO77 : 1;           /*!< [13..13] GPIO77 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO78 : 1;           /*!< [14..14] GPIO78 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO79 : 1;           /*!< [15..15] GPIO79 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO80 : 1;           /*!< [16..16] GPIO80 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO81 : 1;           /*!< [17..17] GPIO81 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO82 : 1;           /*!< [18..18] GPIO82 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO83 : 1;           /*!< [19..19] GPIO83 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO84 : 1;           /*!< [20..20] GPIO84 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO85 : 1;           /*!< [21..21] GPIO85 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO86 : 1;           /*!< [22..22] GPIO86 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO87 : 1;           /*!< [23..23] GPIO87 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO88 : 1;           /*!< [24..24] GPIO88 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO89 : 1;           /*!< [25..25] GPIO89 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO90 : 1;           /*!< [26..26] GPIO90 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO91 : 1;           /*!< [27..27] GPIO91 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO92 : 1;           /*!< [28..28] GPIO92 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO93 : 1;           /*!< [29..29] GPIO93 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO94 : 1;           /*!< [30..30] GPIO94 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO95 : 1;           /*!< [31..31] GPIO95 MCU N1-priority interrupt.                                */
    } MCUN1INT2CLR_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT2SET;                /*!< (@ 0x0000032C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t MCUN1GPIO64 : 1;           /*!< [0..0] GPIO64 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO65 : 1;           /*!< [1..1] GPIO65 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO66 : 1;           /*!< [2..2] GPIO66 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO67 : 1;           /*!< [3..3] GPIO67 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO68 : 1;           /*!< [4..4] GPIO68 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO69 : 1;           /*!< [5..5] GPIO69 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO70 : 1;           /*!< [6..6] GPIO70 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO71 : 1;           /*!< [7..7] GPIO71 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO72 : 1;           /*!< [8..8] GPIO72 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO73 : 1;           /*!< [9..9] GPIO73 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO74 : 1;           /*!< [10..10] GPIO74 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO75 : 1;           /*!< [11..11] GPIO75 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO76 : 1;           /*!< [12..12] GPIO76 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO77 : 1;           /*!< [13..13] GPIO77 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO78 : 1;           /*!< [14..14] GPIO78 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO79 : 1;           /*!< [15..15] GPIO79 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO80 : 1;           /*!< [16..16] GPIO80 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO81 : 1;           /*!< [17..17] GPIO81 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO82 : 1;           /*!< [18..18] GPIO82 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO83 : 1;           /*!< [19..19] GPIO83 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO84 : 1;           /*!< [20..20] GPIO84 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO85 : 1;           /*!< [21..21] GPIO85 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO86 : 1;           /*!< [22..22] GPIO86 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO87 : 1;           /*!< [23..23] GPIO87 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO88 : 1;           /*!< [24..24] GPIO88 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO89 : 1;           /*!< [25..25] GPIO89 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO90 : 1;           /*!< [26..26] GPIO90 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO91 : 1;           /*!< [27..27] GPIO91 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO92 : 1;           /*!< [28..28] GPIO92 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO93 : 1;           /*!< [29..29] GPIO93 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO94 : 1;           /*!< [30..30] GPIO94 MCU N1-priority interrupt.                                */
      __IOM uint32_t MCUN1GPIO95 : 1;           /*!< [31..31] GPIO95 MCU N1-priority interrupt.                                */
    } MCUN1INT2SET_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT3EN;                 /*!< (@ 0x00000330) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t MCUN1GPIO96 : 1;           /*!< [0..0] GPIO96 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO97 : 1;           /*!< [1..1] GPIO97 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO98 : 1;           /*!< [2..2] GPIO98 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO99 : 1;           /*!< [3..3] GPIO99 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO100 : 1;          /*!< [4..4] GPIO100 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO101 : 1;          /*!< [5..5] GPIO101 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO102 : 1;          /*!< [6..6] GPIO102 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO103 : 1;          /*!< [7..7] GPIO103 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO104 : 1;          /*!< [8..8] GPIO104 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO105 : 1;          /*!< [9..9] GPIO105 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO106 : 1;          /*!< [10..10] GPIO106 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO107 : 1;          /*!< [11..11] GPIO107 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO108 : 1;          /*!< [12..12] GPIO108 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO109 : 1;          /*!< [13..13] GPIO109 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO110 : 1;          /*!< [14..14] GPIO110 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO111 : 1;          /*!< [15..15] GPIO111 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO112 : 1;          /*!< [16..16] GPIO112 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO113 : 1;          /*!< [17..17] GPIO113 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO114 : 1;          /*!< [18..18] GPIO114 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO115 : 1;          /*!< [19..19] GPIO115 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO116 : 1;          /*!< [20..20] GPIO116 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO117 : 1;          /*!< [21..21] GPIO117 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO118 : 1;          /*!< [22..22] GPIO118 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO119 : 1;          /*!< [23..23] GPIO119 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO120 : 1;          /*!< [24..24] GPIO120 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO121 : 1;          /*!< [25..25] GPIO121 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO122 : 1;          /*!< [26..26] GPIO122 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO123 : 1;          /*!< [27..27] GPIO123 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO124 : 1;          /*!< [28..28] GPIO124 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO125 : 1;          /*!< [29..29] GPIO125 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO126 : 1;          /*!< [30..30] GPIO126 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO127 : 1;          /*!< [31..31] GPIO127 MCU N1-priority interrupt.                               */
    } MCUN1INT3EN_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT3STAT;               /*!< (@ 0x00000334) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t MCUN1GPIO96 : 1;           /*!< [0..0] GPIO96 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO97 : 1;           /*!< [1..1] GPIO97 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO98 : 1;           /*!< [2..2] GPIO98 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO99 : 1;           /*!< [3..3] GPIO99 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO100 : 1;          /*!< [4..4] GPIO100 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO101 : 1;          /*!< [5..5] GPIO101 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO102 : 1;          /*!< [6..6] GPIO102 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO103 : 1;          /*!< [7..7] GPIO103 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO104 : 1;          /*!< [8..8] GPIO104 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO105 : 1;          /*!< [9..9] GPIO105 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO106 : 1;          /*!< [10..10] GPIO106 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO107 : 1;          /*!< [11..11] GPIO107 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO108 : 1;          /*!< [12..12] GPIO108 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO109 : 1;          /*!< [13..13] GPIO109 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO110 : 1;          /*!< [14..14] GPIO110 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO111 : 1;          /*!< [15..15] GPIO111 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO112 : 1;          /*!< [16..16] GPIO112 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO113 : 1;          /*!< [17..17] GPIO113 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO114 : 1;          /*!< [18..18] GPIO114 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO115 : 1;          /*!< [19..19] GPIO115 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO116 : 1;          /*!< [20..20] GPIO116 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO117 : 1;          /*!< [21..21] GPIO117 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO118 : 1;          /*!< [22..22] GPIO118 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO119 : 1;          /*!< [23..23] GPIO119 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO120 : 1;          /*!< [24..24] GPIO120 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO121 : 1;          /*!< [25..25] GPIO121 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO122 : 1;          /*!< [26..26] GPIO122 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO123 : 1;          /*!< [27..27] GPIO123 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO124 : 1;          /*!< [28..28] GPIO124 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO125 : 1;          /*!< [29..29] GPIO125 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO126 : 1;          /*!< [30..30] GPIO126 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO127 : 1;          /*!< [31..31] GPIO127 MCU N1-priority interrupt.                               */
    } MCUN1INT3STAT_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT3CLR;                /*!< (@ 0x00000338) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t MCUN1GPIO96 : 1;           /*!< [0..0] GPIO96 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO97 : 1;           /*!< [1..1] GPIO97 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO98 : 1;           /*!< [2..2] GPIO98 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO99 : 1;           /*!< [3..3] GPIO99 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO100 : 1;          /*!< [4..4] GPIO100 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO101 : 1;          /*!< [5..5] GPIO101 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO102 : 1;          /*!< [6..6] GPIO102 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO103 : 1;          /*!< [7..7] GPIO103 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO104 : 1;          /*!< [8..8] GPIO104 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO105 : 1;          /*!< [9..9] GPIO105 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO106 : 1;          /*!< [10..10] GPIO106 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO107 : 1;          /*!< [11..11] GPIO107 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO108 : 1;          /*!< [12..12] GPIO108 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO109 : 1;          /*!< [13..13] GPIO109 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO110 : 1;          /*!< [14..14] GPIO110 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO111 : 1;          /*!< [15..15] GPIO111 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO112 : 1;          /*!< [16..16] GPIO112 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO113 : 1;          /*!< [17..17] GPIO113 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO114 : 1;          /*!< [18..18] GPIO114 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO115 : 1;          /*!< [19..19] GPIO115 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO116 : 1;          /*!< [20..20] GPIO116 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO117 : 1;          /*!< [21..21] GPIO117 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO118 : 1;          /*!< [22..22] GPIO118 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO119 : 1;          /*!< [23..23] GPIO119 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO120 : 1;          /*!< [24..24] GPIO120 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO121 : 1;          /*!< [25..25] GPIO121 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO122 : 1;          /*!< [26..26] GPIO122 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO123 : 1;          /*!< [27..27] GPIO123 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO124 : 1;          /*!< [28..28] GPIO124 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO125 : 1;          /*!< [29..29] GPIO125 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO126 : 1;          /*!< [30..30] GPIO126 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO127 : 1;          /*!< [31..31] GPIO127 MCU N1-priority interrupt.                               */
    } MCUN1INT3CLR_b;
  } ;

  union {
    __IOM uint32_t MCUN1INT3SET;                /*!< (@ 0x0000033C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t MCUN1GPIO96 : 1;           /*!< [0..0] GPIO96 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO97 : 1;           /*!< [1..1] GPIO97 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO98 : 1;           /*!< [2..2] GPIO98 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO99 : 1;           /*!< [3..3] GPIO99 MCU N1-priority interrupt.                                  */
      __IOM uint32_t MCUN1GPIO100 : 1;          /*!< [4..4] GPIO100 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO101 : 1;          /*!< [5..5] GPIO101 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO102 : 1;          /*!< [6..6] GPIO102 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO103 : 1;          /*!< [7..7] GPIO103 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO104 : 1;          /*!< [8..8] GPIO104 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO105 : 1;          /*!< [9..9] GPIO105 MCU N1-priority interrupt.                                 */
      __IOM uint32_t MCUN1GPIO106 : 1;          /*!< [10..10] GPIO106 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO107 : 1;          /*!< [11..11] GPIO107 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO108 : 1;          /*!< [12..12] GPIO108 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO109 : 1;          /*!< [13..13] GPIO109 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO110 : 1;          /*!< [14..14] GPIO110 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO111 : 1;          /*!< [15..15] GPIO111 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO112 : 1;          /*!< [16..16] GPIO112 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO113 : 1;          /*!< [17..17] GPIO113 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO114 : 1;          /*!< [18..18] GPIO114 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO115 : 1;          /*!< [19..19] GPIO115 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO116 : 1;          /*!< [20..20] GPIO116 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO117 : 1;          /*!< [21..21] GPIO117 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO118 : 1;          /*!< [22..22] GPIO118 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO119 : 1;          /*!< [23..23] GPIO119 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO120 : 1;          /*!< [24..24] GPIO120 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO121 : 1;          /*!< [25..25] GPIO121 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO122 : 1;          /*!< [26..26] GPIO122 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO123 : 1;          /*!< [27..27] GPIO123 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO124 : 1;          /*!< [28..28] GPIO124 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO125 : 1;          /*!< [29..29] GPIO125 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO126 : 1;          /*!< [30..30] GPIO126 MCU N1-priority interrupt.                               */
      __IOM uint32_t MCUN1GPIO127 : 1;          /*!< [31..31] GPIO127 MCU N1-priority interrupt.                               */
    } MCUN1INT3SET_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT0EN;                /*!< (@ 0x00000340) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP0N0GPIO0 : 1;           /*!< [0..0] GPIO0 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO1 : 1;           /*!< [1..1] GPIO1 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO2 : 1;           /*!< [2..2] GPIO2 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO3 : 1;           /*!< [3..3] GPIO3 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO4 : 1;           /*!< [4..4] GPIO4 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO5 : 1;           /*!< [5..5] GPIO5 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO6 : 1;           /*!< [6..6] GPIO6 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO7 : 1;           /*!< [7..7] GPIO7 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO8 : 1;           /*!< [8..8] GPIO8 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO9 : 1;           /*!< [9..9] GPIO9 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO10 : 1;          /*!< [10..10] GPIO10 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO11 : 1;          /*!< [11..11] GPIO11 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO12 : 1;          /*!< [12..12] GPIO12 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO13 : 1;          /*!< [13..13] GPIO13 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO14 : 1;          /*!< [14..14] GPIO14 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO15 : 1;          /*!< [15..15] GPIO15 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO16 : 1;          /*!< [16..16] GPIO16 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO17 : 1;          /*!< [17..17] GPIO17 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO18 : 1;          /*!< [18..18] GPIO18 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO19 : 1;          /*!< [19..19] GPIO19 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO20 : 1;          /*!< [20..20] GPIO20 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO21 : 1;          /*!< [21..21] GPIO21 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO22 : 1;          /*!< [22..22] GPIO22 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO23 : 1;          /*!< [23..23] GPIO23 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO24 : 1;          /*!< [24..24] GPIO24 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO25 : 1;          /*!< [25..25] GPIO25 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO26 : 1;          /*!< [26..26] GPIO26 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO27 : 1;          /*!< [27..27] GPIO27 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO28 : 1;          /*!< [28..28] GPIO28 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO29 : 1;          /*!< [29..29] GPIO29 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO30 : 1;          /*!< [30..30] GPIO30 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO31 : 1;          /*!< [31..31] GPIO31 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT0EN_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT0STAT;              /*!< (@ 0x00000344) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP0N0GPIO0 : 1;           /*!< [0..0] GPIO0 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO1 : 1;           /*!< [1..1] GPIO1 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO2 : 1;           /*!< [2..2] GPIO2 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO3 : 1;           /*!< [3..3] GPIO3 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO4 : 1;           /*!< [4..4] GPIO4 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO5 : 1;           /*!< [5..5] GPIO5 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO6 : 1;           /*!< [6..6] GPIO6 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO7 : 1;           /*!< [7..7] GPIO7 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO8 : 1;           /*!< [8..8] GPIO8 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO9 : 1;           /*!< [9..9] GPIO9 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO10 : 1;          /*!< [10..10] GPIO10 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO11 : 1;          /*!< [11..11] GPIO11 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO12 : 1;          /*!< [12..12] GPIO12 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO13 : 1;          /*!< [13..13] GPIO13 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO14 : 1;          /*!< [14..14] GPIO14 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO15 : 1;          /*!< [15..15] GPIO15 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO16 : 1;          /*!< [16..16] GPIO16 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO17 : 1;          /*!< [17..17] GPIO17 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO18 : 1;          /*!< [18..18] GPIO18 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO19 : 1;          /*!< [19..19] GPIO19 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO20 : 1;          /*!< [20..20] GPIO20 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO21 : 1;          /*!< [21..21] GPIO21 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO22 : 1;          /*!< [22..22] GPIO22 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO23 : 1;          /*!< [23..23] GPIO23 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO24 : 1;          /*!< [24..24] GPIO24 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO25 : 1;          /*!< [25..25] GPIO25 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO26 : 1;          /*!< [26..26] GPIO26 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO27 : 1;          /*!< [27..27] GPIO27 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO28 : 1;          /*!< [28..28] GPIO28 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO29 : 1;          /*!< [29..29] GPIO29 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO30 : 1;          /*!< [30..30] GPIO30 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO31 : 1;          /*!< [31..31] GPIO31 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT0STAT_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT0CLR;               /*!< (@ 0x00000348) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP0N0GPIO0 : 1;           /*!< [0..0] GPIO0 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO1 : 1;           /*!< [1..1] GPIO1 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO2 : 1;           /*!< [2..2] GPIO2 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO3 : 1;           /*!< [3..3] GPIO3 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO4 : 1;           /*!< [4..4] GPIO4 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO5 : 1;           /*!< [5..5] GPIO5 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO6 : 1;           /*!< [6..6] GPIO6 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO7 : 1;           /*!< [7..7] GPIO7 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO8 : 1;           /*!< [8..8] GPIO8 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO9 : 1;           /*!< [9..9] GPIO9 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO10 : 1;          /*!< [10..10] GPIO10 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO11 : 1;          /*!< [11..11] GPIO11 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO12 : 1;          /*!< [12..12] GPIO12 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO13 : 1;          /*!< [13..13] GPIO13 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO14 : 1;          /*!< [14..14] GPIO14 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO15 : 1;          /*!< [15..15] GPIO15 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO16 : 1;          /*!< [16..16] GPIO16 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO17 : 1;          /*!< [17..17] GPIO17 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO18 : 1;          /*!< [18..18] GPIO18 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO19 : 1;          /*!< [19..19] GPIO19 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO20 : 1;          /*!< [20..20] GPIO20 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO21 : 1;          /*!< [21..21] GPIO21 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO22 : 1;          /*!< [22..22] GPIO22 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO23 : 1;          /*!< [23..23] GPIO23 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO24 : 1;          /*!< [24..24] GPIO24 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO25 : 1;          /*!< [25..25] GPIO25 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO26 : 1;          /*!< [26..26] GPIO26 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO27 : 1;          /*!< [27..27] GPIO27 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO28 : 1;          /*!< [28..28] GPIO28 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO29 : 1;          /*!< [29..29] GPIO29 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO30 : 1;          /*!< [30..30] GPIO30 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO31 : 1;          /*!< [31..31] GPIO31 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT0CLR_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT0SET;               /*!< (@ 0x0000034C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP0N0GPIO0 : 1;           /*!< [0..0] GPIO0 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO1 : 1;           /*!< [1..1] GPIO1 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO2 : 1;           /*!< [2..2] GPIO2 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO3 : 1;           /*!< [3..3] GPIO3 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO4 : 1;           /*!< [4..4] GPIO4 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO5 : 1;           /*!< [5..5] GPIO5 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO6 : 1;           /*!< [6..6] GPIO6 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO7 : 1;           /*!< [7..7] GPIO7 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO8 : 1;           /*!< [8..8] GPIO8 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO9 : 1;           /*!< [9..9] GPIO9 DSP0 N0-priority interrupt.                                  */
      __IOM uint32_t DSP0N0GPIO10 : 1;          /*!< [10..10] GPIO10 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO11 : 1;          /*!< [11..11] GPIO11 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO12 : 1;          /*!< [12..12] GPIO12 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO13 : 1;          /*!< [13..13] GPIO13 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO14 : 1;          /*!< [14..14] GPIO14 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO15 : 1;          /*!< [15..15] GPIO15 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO16 : 1;          /*!< [16..16] GPIO16 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO17 : 1;          /*!< [17..17] GPIO17 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO18 : 1;          /*!< [18..18] GPIO18 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO19 : 1;          /*!< [19..19] GPIO19 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO20 : 1;          /*!< [20..20] GPIO20 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO21 : 1;          /*!< [21..21] GPIO21 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO22 : 1;          /*!< [22..22] GPIO22 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO23 : 1;          /*!< [23..23] GPIO23 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO24 : 1;          /*!< [24..24] GPIO24 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO25 : 1;          /*!< [25..25] GPIO25 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO26 : 1;          /*!< [26..26] GPIO26 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO27 : 1;          /*!< [27..27] GPIO27 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO28 : 1;          /*!< [28..28] GPIO28 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO29 : 1;          /*!< [29..29] GPIO29 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO30 : 1;          /*!< [30..30] GPIO30 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO31 : 1;          /*!< [31..31] GPIO31 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT0SET_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT1EN;                /*!< (@ 0x00000350) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP0N0GPIO32 : 1;          /*!< [0..0] GPIO32 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO33 : 1;          /*!< [1..1] GPIO33 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO34 : 1;          /*!< [2..2] GPIO34 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO35 : 1;          /*!< [3..3] GPIO35 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO36 : 1;          /*!< [4..4] GPIO36 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO37 : 1;          /*!< [5..5] GPIO37 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO38 : 1;          /*!< [6..6] GPIO38 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO39 : 1;          /*!< [7..7] GPIO39 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO40 : 1;          /*!< [8..8] GPIO40 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO41 : 1;          /*!< [9..9] GPIO41 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO42 : 1;          /*!< [10..10] GPIO42 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO43 : 1;          /*!< [11..11] GPIO43 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO44 : 1;          /*!< [12..12] GPIO44 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO45 : 1;          /*!< [13..13] GPIO45 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO46 : 1;          /*!< [14..14] GPIO46 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO47 : 1;          /*!< [15..15] GPIO47 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO48 : 1;          /*!< [16..16] GPIO48 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO49 : 1;          /*!< [17..17] GPIO49 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO50 : 1;          /*!< [18..18] GPIO50 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO51 : 1;          /*!< [19..19] GPIO51 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO52 : 1;          /*!< [20..20] GPIO52 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO53 : 1;          /*!< [21..21] GPIO53 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO54 : 1;          /*!< [22..22] GPIO54 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO55 : 1;          /*!< [23..23] GPIO55 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO56 : 1;          /*!< [24..24] GPIO56 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO57 : 1;          /*!< [25..25] GPIO57 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO58 : 1;          /*!< [26..26] GPIO58 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO59 : 1;          /*!< [27..27] GPIO59 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO60 : 1;          /*!< [28..28] GPIO60 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO61 : 1;          /*!< [29..29] GPIO61 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO62 : 1;          /*!< [30..30] GPIO62 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO63 : 1;          /*!< [31..31] GPIO63 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT1EN_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT1STAT;              /*!< (@ 0x00000354) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP0N0GPIO32 : 1;          /*!< [0..0] GPIO32 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO33 : 1;          /*!< [1..1] GPIO33 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO34 : 1;          /*!< [2..2] GPIO34 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO35 : 1;          /*!< [3..3] GPIO35 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO36 : 1;          /*!< [4..4] GPIO36 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO37 : 1;          /*!< [5..5] GPIO37 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO38 : 1;          /*!< [6..6] GPIO38 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO39 : 1;          /*!< [7..7] GPIO39 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO40 : 1;          /*!< [8..8] GPIO40 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO41 : 1;          /*!< [9..9] GPIO41 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO42 : 1;          /*!< [10..10] GPIO42 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO43 : 1;          /*!< [11..11] GPIO43 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO44 : 1;          /*!< [12..12] GPIO44 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO45 : 1;          /*!< [13..13] GPIO45 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO46 : 1;          /*!< [14..14] GPIO46 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO47 : 1;          /*!< [15..15] GPIO47 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO48 : 1;          /*!< [16..16] GPIO48 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO49 : 1;          /*!< [17..17] GPIO49 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO50 : 1;          /*!< [18..18] GPIO50 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO51 : 1;          /*!< [19..19] GPIO51 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO52 : 1;          /*!< [20..20] GPIO52 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO53 : 1;          /*!< [21..21] GPIO53 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO54 : 1;          /*!< [22..22] GPIO54 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO55 : 1;          /*!< [23..23] GPIO55 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO56 : 1;          /*!< [24..24] GPIO56 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO57 : 1;          /*!< [25..25] GPIO57 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO58 : 1;          /*!< [26..26] GPIO58 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO59 : 1;          /*!< [27..27] GPIO59 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO60 : 1;          /*!< [28..28] GPIO60 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO61 : 1;          /*!< [29..29] GPIO61 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO62 : 1;          /*!< [30..30] GPIO62 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO63 : 1;          /*!< [31..31] GPIO63 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT1STAT_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT1CLR;               /*!< (@ 0x00000358) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP0N0GPIO32 : 1;          /*!< [0..0] GPIO32 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO33 : 1;          /*!< [1..1] GPIO33 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO34 : 1;          /*!< [2..2] GPIO34 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO35 : 1;          /*!< [3..3] GPIO35 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO36 : 1;          /*!< [4..4] GPIO36 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO37 : 1;          /*!< [5..5] GPIO37 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO38 : 1;          /*!< [6..6] GPIO38 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO39 : 1;          /*!< [7..7] GPIO39 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO40 : 1;          /*!< [8..8] GPIO40 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO41 : 1;          /*!< [9..9] GPIO41 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO42 : 1;          /*!< [10..10] GPIO42 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO43 : 1;          /*!< [11..11] GPIO43 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO44 : 1;          /*!< [12..12] GPIO44 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO45 : 1;          /*!< [13..13] GPIO45 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO46 : 1;          /*!< [14..14] GPIO46 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO47 : 1;          /*!< [15..15] GPIO47 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO48 : 1;          /*!< [16..16] GPIO48 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO49 : 1;          /*!< [17..17] GPIO49 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO50 : 1;          /*!< [18..18] GPIO50 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO51 : 1;          /*!< [19..19] GPIO51 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO52 : 1;          /*!< [20..20] GPIO52 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO53 : 1;          /*!< [21..21] GPIO53 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO54 : 1;          /*!< [22..22] GPIO54 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO55 : 1;          /*!< [23..23] GPIO55 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO56 : 1;          /*!< [24..24] GPIO56 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO57 : 1;          /*!< [25..25] GPIO57 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO58 : 1;          /*!< [26..26] GPIO58 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO59 : 1;          /*!< [27..27] GPIO59 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO60 : 1;          /*!< [28..28] GPIO60 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO61 : 1;          /*!< [29..29] GPIO61 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO62 : 1;          /*!< [30..30] GPIO62 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO63 : 1;          /*!< [31..31] GPIO63 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT1CLR_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT1SET;               /*!< (@ 0x0000035C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP0N0GPIO32 : 1;          /*!< [0..0] GPIO32 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO33 : 1;          /*!< [1..1] GPIO33 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO34 : 1;          /*!< [2..2] GPIO34 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO35 : 1;          /*!< [3..3] GPIO35 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO36 : 1;          /*!< [4..4] GPIO36 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO37 : 1;          /*!< [5..5] GPIO37 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO38 : 1;          /*!< [6..6] GPIO38 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO39 : 1;          /*!< [7..7] GPIO39 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO40 : 1;          /*!< [8..8] GPIO40 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO41 : 1;          /*!< [9..9] GPIO41 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO42 : 1;          /*!< [10..10] GPIO42 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO43 : 1;          /*!< [11..11] GPIO43 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO44 : 1;          /*!< [12..12] GPIO44 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO45 : 1;          /*!< [13..13] GPIO45 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO46 : 1;          /*!< [14..14] GPIO46 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO47 : 1;          /*!< [15..15] GPIO47 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO48 : 1;          /*!< [16..16] GPIO48 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO49 : 1;          /*!< [17..17] GPIO49 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO50 : 1;          /*!< [18..18] GPIO50 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO51 : 1;          /*!< [19..19] GPIO51 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO52 : 1;          /*!< [20..20] GPIO52 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO53 : 1;          /*!< [21..21] GPIO53 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO54 : 1;          /*!< [22..22] GPIO54 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO55 : 1;          /*!< [23..23] GPIO55 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO56 : 1;          /*!< [24..24] GPIO56 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO57 : 1;          /*!< [25..25] GPIO57 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO58 : 1;          /*!< [26..26] GPIO58 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO59 : 1;          /*!< [27..27] GPIO59 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO60 : 1;          /*!< [28..28] GPIO60 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO61 : 1;          /*!< [29..29] GPIO61 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO62 : 1;          /*!< [30..30] GPIO62 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO63 : 1;          /*!< [31..31] GPIO63 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT1SET_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT2EN;                /*!< (@ 0x00000360) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP0N0GPIO64 : 1;          /*!< [0..0] GPIO64 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO65 : 1;          /*!< [1..1] GPIO65 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO66 : 1;          /*!< [2..2] GPIO66 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO67 : 1;          /*!< [3..3] GPIO67 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO68 : 1;          /*!< [4..4] GPIO68 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO69 : 1;          /*!< [5..5] GPIO69 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO70 : 1;          /*!< [6..6] GPIO70 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO71 : 1;          /*!< [7..7] GPIO71 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO72 : 1;          /*!< [8..8] GPIO72 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO73 : 1;          /*!< [9..9] GPIO73 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO74 : 1;          /*!< [10..10] GPIO74 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO75 : 1;          /*!< [11..11] GPIO75 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO76 : 1;          /*!< [12..12] GPIO76 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO77 : 1;          /*!< [13..13] GPIO77 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO78 : 1;          /*!< [14..14] GPIO78 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO79 : 1;          /*!< [15..15] GPIO79 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO80 : 1;          /*!< [16..16] GPIO80 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO81 : 1;          /*!< [17..17] GPIO81 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO82 : 1;          /*!< [18..18] GPIO82 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO83 : 1;          /*!< [19..19] GPIO83 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO84 : 1;          /*!< [20..20] GPIO84 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO85 : 1;          /*!< [21..21] GPIO85 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO86 : 1;          /*!< [22..22] GPIO86 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO87 : 1;          /*!< [23..23] GPIO87 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO88 : 1;          /*!< [24..24] GPIO88 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO89 : 1;          /*!< [25..25] GPIO89 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO90 : 1;          /*!< [26..26] GPIO90 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO91 : 1;          /*!< [27..27] GPIO91 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO92 : 1;          /*!< [28..28] GPIO92 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO93 : 1;          /*!< [29..29] GPIO93 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO94 : 1;          /*!< [30..30] GPIO94 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO95 : 1;          /*!< [31..31] GPIO95 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT2EN_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT2STAT;              /*!< (@ 0x00000364) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP0N0GPIO64 : 1;          /*!< [0..0] GPIO64 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO65 : 1;          /*!< [1..1] GPIO65 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO66 : 1;          /*!< [2..2] GPIO66 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO67 : 1;          /*!< [3..3] GPIO67 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO68 : 1;          /*!< [4..4] GPIO68 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO69 : 1;          /*!< [5..5] GPIO69 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO70 : 1;          /*!< [6..6] GPIO70 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO71 : 1;          /*!< [7..7] GPIO71 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO72 : 1;          /*!< [8..8] GPIO72 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO73 : 1;          /*!< [9..9] GPIO73 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO74 : 1;          /*!< [10..10] GPIO74 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO75 : 1;          /*!< [11..11] GPIO75 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO76 : 1;          /*!< [12..12] GPIO76 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO77 : 1;          /*!< [13..13] GPIO77 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO78 : 1;          /*!< [14..14] GPIO78 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO79 : 1;          /*!< [15..15] GPIO79 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO80 : 1;          /*!< [16..16] GPIO80 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO81 : 1;          /*!< [17..17] GPIO81 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO82 : 1;          /*!< [18..18] GPIO82 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO83 : 1;          /*!< [19..19] GPIO83 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO84 : 1;          /*!< [20..20] GPIO84 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO85 : 1;          /*!< [21..21] GPIO85 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO86 : 1;          /*!< [22..22] GPIO86 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO87 : 1;          /*!< [23..23] GPIO87 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO88 : 1;          /*!< [24..24] GPIO88 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO89 : 1;          /*!< [25..25] GPIO89 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO90 : 1;          /*!< [26..26] GPIO90 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO91 : 1;          /*!< [27..27] GPIO91 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO92 : 1;          /*!< [28..28] GPIO92 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO93 : 1;          /*!< [29..29] GPIO93 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO94 : 1;          /*!< [30..30] GPIO94 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO95 : 1;          /*!< [31..31] GPIO95 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT2STAT_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT2CLR;               /*!< (@ 0x00000368) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP0N0GPIO64 : 1;          /*!< [0..0] GPIO64 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO65 : 1;          /*!< [1..1] GPIO65 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO66 : 1;          /*!< [2..2] GPIO66 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO67 : 1;          /*!< [3..3] GPIO67 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO68 : 1;          /*!< [4..4] GPIO68 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO69 : 1;          /*!< [5..5] GPIO69 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO70 : 1;          /*!< [6..6] GPIO70 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO71 : 1;          /*!< [7..7] GPIO71 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO72 : 1;          /*!< [8..8] GPIO72 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO73 : 1;          /*!< [9..9] GPIO73 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO74 : 1;          /*!< [10..10] GPIO74 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO75 : 1;          /*!< [11..11] GPIO75 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO76 : 1;          /*!< [12..12] GPIO76 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO77 : 1;          /*!< [13..13] GPIO77 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO78 : 1;          /*!< [14..14] GPIO78 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO79 : 1;          /*!< [15..15] GPIO79 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO80 : 1;          /*!< [16..16] GPIO80 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO81 : 1;          /*!< [17..17] GPIO81 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO82 : 1;          /*!< [18..18] GPIO82 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO83 : 1;          /*!< [19..19] GPIO83 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO84 : 1;          /*!< [20..20] GPIO84 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO85 : 1;          /*!< [21..21] GPIO85 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO86 : 1;          /*!< [22..22] GPIO86 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO87 : 1;          /*!< [23..23] GPIO87 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO88 : 1;          /*!< [24..24] GPIO88 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO89 : 1;          /*!< [25..25] GPIO89 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO90 : 1;          /*!< [26..26] GPIO90 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO91 : 1;          /*!< [27..27] GPIO91 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO92 : 1;          /*!< [28..28] GPIO92 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO93 : 1;          /*!< [29..29] GPIO93 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO94 : 1;          /*!< [30..30] GPIO94 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO95 : 1;          /*!< [31..31] GPIO95 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT2CLR_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT2SET;               /*!< (@ 0x0000036C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP0N0GPIO64 : 1;          /*!< [0..0] GPIO64 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO65 : 1;          /*!< [1..1] GPIO65 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO66 : 1;          /*!< [2..2] GPIO66 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO67 : 1;          /*!< [3..3] GPIO67 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO68 : 1;          /*!< [4..4] GPIO68 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO69 : 1;          /*!< [5..5] GPIO69 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO70 : 1;          /*!< [6..6] GPIO70 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO71 : 1;          /*!< [7..7] GPIO71 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO72 : 1;          /*!< [8..8] GPIO72 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO73 : 1;          /*!< [9..9] GPIO73 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO74 : 1;          /*!< [10..10] GPIO74 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO75 : 1;          /*!< [11..11] GPIO75 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO76 : 1;          /*!< [12..12] GPIO76 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO77 : 1;          /*!< [13..13] GPIO77 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO78 : 1;          /*!< [14..14] GPIO78 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO79 : 1;          /*!< [15..15] GPIO79 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO80 : 1;          /*!< [16..16] GPIO80 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO81 : 1;          /*!< [17..17] GPIO81 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO82 : 1;          /*!< [18..18] GPIO82 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO83 : 1;          /*!< [19..19] GPIO83 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO84 : 1;          /*!< [20..20] GPIO84 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO85 : 1;          /*!< [21..21] GPIO85 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO86 : 1;          /*!< [22..22] GPIO86 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO87 : 1;          /*!< [23..23] GPIO87 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO88 : 1;          /*!< [24..24] GPIO88 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO89 : 1;          /*!< [25..25] GPIO89 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO90 : 1;          /*!< [26..26] GPIO90 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO91 : 1;          /*!< [27..27] GPIO91 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO92 : 1;          /*!< [28..28] GPIO92 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO93 : 1;          /*!< [29..29] GPIO93 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO94 : 1;          /*!< [30..30] GPIO94 DSP0 N0-priority interrupt.                               */
      __IOM uint32_t DSP0N0GPIO95 : 1;          /*!< [31..31] GPIO95 DSP0 N0-priority interrupt.                               */
    } DSP0N0INT2SET_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT3EN;                /*!< (@ 0x00000370) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP0N0GPIO96 : 1;          /*!< [0..0] GPIO96 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO97 : 1;          /*!< [1..1] GPIO97 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO98 : 1;          /*!< [2..2] GPIO98 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO99 : 1;          /*!< [3..3] GPIO99 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO100 : 1;         /*!< [4..4] GPIO100 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO101 : 1;         /*!< [5..5] GPIO101 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO102 : 1;         /*!< [6..6] GPIO102 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO103 : 1;         /*!< [7..7] GPIO103 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO104 : 1;         /*!< [8..8] GPIO104 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO105 : 1;         /*!< [9..9] GPIO105 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO106 : 1;         /*!< [10..10] GPIO106 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO107 : 1;         /*!< [11..11] GPIO107 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO108 : 1;         /*!< [12..12] GPIO108 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO109 : 1;         /*!< [13..13] GPIO109 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO110 : 1;         /*!< [14..14] GPIO110 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO111 : 1;         /*!< [15..15] GPIO111 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO112 : 1;         /*!< [16..16] GPIO112 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO113 : 1;         /*!< [17..17] GPIO113 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO114 : 1;         /*!< [18..18] GPIO114 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO115 : 1;         /*!< [19..19] GPIO115 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO116 : 1;         /*!< [20..20] GPIO116 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO117 : 1;         /*!< [21..21] GPIO117 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO118 : 1;         /*!< [22..22] GPIO118 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO119 : 1;         /*!< [23..23] GPIO119 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO120 : 1;         /*!< [24..24] GPIO120 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO121 : 1;         /*!< [25..25] GPIO121 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO122 : 1;         /*!< [26..26] GPIO122 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO123 : 1;         /*!< [27..27] GPIO123 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO124 : 1;         /*!< [28..28] GPIO124 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO125 : 1;         /*!< [29..29] GPIO125 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO126 : 1;         /*!< [30..30] GPIO126 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO127 : 1;         /*!< [31..31] GPIO127 DSP0 N0-priority interrupt.                              */
    } DSP0N0INT3EN_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT3STAT;              /*!< (@ 0x00000374) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP0N0GPIO96 : 1;          /*!< [0..0] GPIO96 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO97 : 1;          /*!< [1..1] GPIO97 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO98 : 1;          /*!< [2..2] GPIO98 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO99 : 1;          /*!< [3..3] GPIO99 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO100 : 1;         /*!< [4..4] GPIO100 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO101 : 1;         /*!< [5..5] GPIO101 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO102 : 1;         /*!< [6..6] GPIO102 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO103 : 1;         /*!< [7..7] GPIO103 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO104 : 1;         /*!< [8..8] GPIO104 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO105 : 1;         /*!< [9..9] GPIO105 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO106 : 1;         /*!< [10..10] GPIO106 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO107 : 1;         /*!< [11..11] GPIO107 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO108 : 1;         /*!< [12..12] GPIO108 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO109 : 1;         /*!< [13..13] GPIO109 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO110 : 1;         /*!< [14..14] GPIO110 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO111 : 1;         /*!< [15..15] GPIO111 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO112 : 1;         /*!< [16..16] GPIO112 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO113 : 1;         /*!< [17..17] GPIO113 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO114 : 1;         /*!< [18..18] GPIO114 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO115 : 1;         /*!< [19..19] GPIO115 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO116 : 1;         /*!< [20..20] GPIO116 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO117 : 1;         /*!< [21..21] GPIO117 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO118 : 1;         /*!< [22..22] GPIO118 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO119 : 1;         /*!< [23..23] GPIO119 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO120 : 1;         /*!< [24..24] GPIO120 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO121 : 1;         /*!< [25..25] GPIO121 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO122 : 1;         /*!< [26..26] GPIO122 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO123 : 1;         /*!< [27..27] GPIO123 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO124 : 1;         /*!< [28..28] GPIO124 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO125 : 1;         /*!< [29..29] GPIO125 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO126 : 1;         /*!< [30..30] GPIO126 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO127 : 1;         /*!< [31..31] GPIO127 DSP0 N0-priority interrupt.                              */
    } DSP0N0INT3STAT_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT3CLR;               /*!< (@ 0x00000378) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP0N0GPIO96 : 1;          /*!< [0..0] GPIO96 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO97 : 1;          /*!< [1..1] GPIO97 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO98 : 1;          /*!< [2..2] GPIO98 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO99 : 1;          /*!< [3..3] GPIO99 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO100 : 1;         /*!< [4..4] GPIO100 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO101 : 1;         /*!< [5..5] GPIO101 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO102 : 1;         /*!< [6..6] GPIO102 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO103 : 1;         /*!< [7..7] GPIO103 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO104 : 1;         /*!< [8..8] GPIO104 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO105 : 1;         /*!< [9..9] GPIO105 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO106 : 1;         /*!< [10..10] GPIO106 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO107 : 1;         /*!< [11..11] GPIO107 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO108 : 1;         /*!< [12..12] GPIO108 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO109 : 1;         /*!< [13..13] GPIO109 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO110 : 1;         /*!< [14..14] GPIO110 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO111 : 1;         /*!< [15..15] GPIO111 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO112 : 1;         /*!< [16..16] GPIO112 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO113 : 1;         /*!< [17..17] GPIO113 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO114 : 1;         /*!< [18..18] GPIO114 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO115 : 1;         /*!< [19..19] GPIO115 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO116 : 1;         /*!< [20..20] GPIO116 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO117 : 1;         /*!< [21..21] GPIO117 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO118 : 1;         /*!< [22..22] GPIO118 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO119 : 1;         /*!< [23..23] GPIO119 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO120 : 1;         /*!< [24..24] GPIO120 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO121 : 1;         /*!< [25..25] GPIO121 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO122 : 1;         /*!< [26..26] GPIO122 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO123 : 1;         /*!< [27..27] GPIO123 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO124 : 1;         /*!< [28..28] GPIO124 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO125 : 1;         /*!< [29..29] GPIO125 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO126 : 1;         /*!< [30..30] GPIO126 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO127 : 1;         /*!< [31..31] GPIO127 DSP0 N0-priority interrupt.                              */
    } DSP0N0INT3CLR_b;
  } ;

  union {
    __IOM uint32_t DSP0N0INT3SET;               /*!< (@ 0x0000037C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP0N0GPIO96 : 1;          /*!< [0..0] GPIO96 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO97 : 1;          /*!< [1..1] GPIO97 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO98 : 1;          /*!< [2..2] GPIO98 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO99 : 1;          /*!< [3..3] GPIO99 DSP0 N0-priority interrupt.                                 */
      __IOM uint32_t DSP0N0GPIO100 : 1;         /*!< [4..4] GPIO100 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO101 : 1;         /*!< [5..5] GPIO101 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO102 : 1;         /*!< [6..6] GPIO102 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO103 : 1;         /*!< [7..7] GPIO103 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO104 : 1;         /*!< [8..8] GPIO104 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO105 : 1;         /*!< [9..9] GPIO105 DSP0 N0-priority interrupt.                                */
      __IOM uint32_t DSP0N0GPIO106 : 1;         /*!< [10..10] GPIO106 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO107 : 1;         /*!< [11..11] GPIO107 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO108 : 1;         /*!< [12..12] GPIO108 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO109 : 1;         /*!< [13..13] GPIO109 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO110 : 1;         /*!< [14..14] GPIO110 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO111 : 1;         /*!< [15..15] GPIO111 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO112 : 1;         /*!< [16..16] GPIO112 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO113 : 1;         /*!< [17..17] GPIO113 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO114 : 1;         /*!< [18..18] GPIO114 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO115 : 1;         /*!< [19..19] GPIO115 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO116 : 1;         /*!< [20..20] GPIO116 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO117 : 1;         /*!< [21..21] GPIO117 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO118 : 1;         /*!< [22..22] GPIO118 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO119 : 1;         /*!< [23..23] GPIO119 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO120 : 1;         /*!< [24..24] GPIO120 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO121 : 1;         /*!< [25..25] GPIO121 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO122 : 1;         /*!< [26..26] GPIO122 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO123 : 1;         /*!< [27..27] GPIO123 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO124 : 1;         /*!< [28..28] GPIO124 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO125 : 1;         /*!< [29..29] GPIO125 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO126 : 1;         /*!< [30..30] GPIO126 DSP0 N0-priority interrupt.                              */
      __IOM uint32_t DSP0N0GPIO127 : 1;         /*!< [31..31] GPIO127 DSP0 N0-priority interrupt.                              */
    } DSP0N0INT3SET_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT0EN;                /*!< (@ 0x00000380) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP0N1GPIO0 : 1;           /*!< [0..0] GPIO0 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO1 : 1;           /*!< [1..1] GPIO1 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO2 : 1;           /*!< [2..2] GPIO2 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO3 : 1;           /*!< [3..3] GPIO3 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO4 : 1;           /*!< [4..4] GPIO4 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO5 : 1;           /*!< [5..5] GPIO5 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO6 : 1;           /*!< [6..6] GPIO6 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO7 : 1;           /*!< [7..7] GPIO7 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO8 : 1;           /*!< [8..8] GPIO8 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO9 : 1;           /*!< [9..9] GPIO9 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO10 : 1;          /*!< [10..10] GPIO10 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO11 : 1;          /*!< [11..11] GPIO11 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO12 : 1;          /*!< [12..12] GPIO12 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO13 : 1;          /*!< [13..13] GPIO13 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO14 : 1;          /*!< [14..14] GPIO14 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO15 : 1;          /*!< [15..15] GPIO15 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO16 : 1;          /*!< [16..16] GPIO16 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO17 : 1;          /*!< [17..17] GPIO17 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO18 : 1;          /*!< [18..18] GPIO18 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO19 : 1;          /*!< [19..19] GPIO19 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO20 : 1;          /*!< [20..20] GPIO20 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO21 : 1;          /*!< [21..21] GPIO21 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO22 : 1;          /*!< [22..22] GPIO22 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO23 : 1;          /*!< [23..23] GPIO23 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO24 : 1;          /*!< [24..24] GPIO24 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO25 : 1;          /*!< [25..25] GPIO25 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO26 : 1;          /*!< [26..26] GPIO26 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO27 : 1;          /*!< [27..27] GPIO27 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO28 : 1;          /*!< [28..28] GPIO28 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO29 : 1;          /*!< [29..29] GPIO29 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO30 : 1;          /*!< [30..30] GPIO30 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO31 : 1;          /*!< [31..31] GPIO31 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT0EN_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT0STAT;              /*!< (@ 0x00000384) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP0N1GPIO0 : 1;           /*!< [0..0] GPIO0 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO1 : 1;           /*!< [1..1] GPIO1 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO2 : 1;           /*!< [2..2] GPIO2 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO3 : 1;           /*!< [3..3] GPIO3 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO4 : 1;           /*!< [4..4] GPIO4 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO5 : 1;           /*!< [5..5] GPIO5 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO6 : 1;           /*!< [6..6] GPIO6 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO7 : 1;           /*!< [7..7] GPIO7 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO8 : 1;           /*!< [8..8] GPIO8 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO9 : 1;           /*!< [9..9] GPIO9 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO10 : 1;          /*!< [10..10] GPIO10 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO11 : 1;          /*!< [11..11] GPIO11 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO12 : 1;          /*!< [12..12] GPIO12 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO13 : 1;          /*!< [13..13] GPIO13 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO14 : 1;          /*!< [14..14] GPIO14 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO15 : 1;          /*!< [15..15] GPIO15 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO16 : 1;          /*!< [16..16] GPIO16 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO17 : 1;          /*!< [17..17] GPIO17 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO18 : 1;          /*!< [18..18] GPIO18 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO19 : 1;          /*!< [19..19] GPIO19 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO20 : 1;          /*!< [20..20] GPIO20 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO21 : 1;          /*!< [21..21] GPIO21 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO22 : 1;          /*!< [22..22] GPIO22 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO23 : 1;          /*!< [23..23] GPIO23 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO24 : 1;          /*!< [24..24] GPIO24 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO25 : 1;          /*!< [25..25] GPIO25 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO26 : 1;          /*!< [26..26] GPIO26 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO27 : 1;          /*!< [27..27] GPIO27 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO28 : 1;          /*!< [28..28] GPIO28 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO29 : 1;          /*!< [29..29] GPIO29 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO30 : 1;          /*!< [30..30] GPIO30 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO31 : 1;          /*!< [31..31] GPIO31 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT0STAT_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT0CLR;               /*!< (@ 0x00000388) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP0N1GPIO0 : 1;           /*!< [0..0] GPIO0 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO1 : 1;           /*!< [1..1] GPIO1 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO2 : 1;           /*!< [2..2] GPIO2 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO3 : 1;           /*!< [3..3] GPIO3 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO4 : 1;           /*!< [4..4] GPIO4 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO5 : 1;           /*!< [5..5] GPIO5 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO6 : 1;           /*!< [6..6] GPIO6 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO7 : 1;           /*!< [7..7] GPIO7 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO8 : 1;           /*!< [8..8] GPIO8 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO9 : 1;           /*!< [9..9] GPIO9 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO10 : 1;          /*!< [10..10] GPIO10 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO11 : 1;          /*!< [11..11] GPIO11 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO12 : 1;          /*!< [12..12] GPIO12 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO13 : 1;          /*!< [13..13] GPIO13 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO14 : 1;          /*!< [14..14] GPIO14 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO15 : 1;          /*!< [15..15] GPIO15 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO16 : 1;          /*!< [16..16] GPIO16 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO17 : 1;          /*!< [17..17] GPIO17 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO18 : 1;          /*!< [18..18] GPIO18 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO19 : 1;          /*!< [19..19] GPIO19 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO20 : 1;          /*!< [20..20] GPIO20 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO21 : 1;          /*!< [21..21] GPIO21 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO22 : 1;          /*!< [22..22] GPIO22 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO23 : 1;          /*!< [23..23] GPIO23 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO24 : 1;          /*!< [24..24] GPIO24 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO25 : 1;          /*!< [25..25] GPIO25 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO26 : 1;          /*!< [26..26] GPIO26 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO27 : 1;          /*!< [27..27] GPIO27 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO28 : 1;          /*!< [28..28] GPIO28 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO29 : 1;          /*!< [29..29] GPIO29 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO30 : 1;          /*!< [30..30] GPIO30 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO31 : 1;          /*!< [31..31] GPIO31 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT0CLR_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT0SET;               /*!< (@ 0x0000038C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP0N1GPIO0 : 1;           /*!< [0..0] GPIO0 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO1 : 1;           /*!< [1..1] GPIO1 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO2 : 1;           /*!< [2..2] GPIO2 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO3 : 1;           /*!< [3..3] GPIO3 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO4 : 1;           /*!< [4..4] GPIO4 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO5 : 1;           /*!< [5..5] GPIO5 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO6 : 1;           /*!< [6..6] GPIO6 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO7 : 1;           /*!< [7..7] GPIO7 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO8 : 1;           /*!< [8..8] GPIO8 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO9 : 1;           /*!< [9..9] GPIO9 DSP0 N1-priority interrupt.                                  */
      __IOM uint32_t DSP0N1GPIO10 : 1;          /*!< [10..10] GPIO10 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO11 : 1;          /*!< [11..11] GPIO11 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO12 : 1;          /*!< [12..12] GPIO12 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO13 : 1;          /*!< [13..13] GPIO13 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO14 : 1;          /*!< [14..14] GPIO14 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO15 : 1;          /*!< [15..15] GPIO15 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO16 : 1;          /*!< [16..16] GPIO16 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO17 : 1;          /*!< [17..17] GPIO17 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO18 : 1;          /*!< [18..18] GPIO18 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO19 : 1;          /*!< [19..19] GPIO19 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO20 : 1;          /*!< [20..20] GPIO20 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO21 : 1;          /*!< [21..21] GPIO21 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO22 : 1;          /*!< [22..22] GPIO22 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO23 : 1;          /*!< [23..23] GPIO23 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO24 : 1;          /*!< [24..24] GPIO24 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO25 : 1;          /*!< [25..25] GPIO25 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO26 : 1;          /*!< [26..26] GPIO26 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO27 : 1;          /*!< [27..27] GPIO27 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO28 : 1;          /*!< [28..28] GPIO28 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO29 : 1;          /*!< [29..29] GPIO29 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO30 : 1;          /*!< [30..30] GPIO30 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO31 : 1;          /*!< [31..31] GPIO31 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT0SET_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT1EN;                /*!< (@ 0x00000390) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP0N1GPIO32 : 1;          /*!< [0..0] GPIO32 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO33 : 1;          /*!< [1..1] GPIO33 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO34 : 1;          /*!< [2..2] GPIO34 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO35 : 1;          /*!< [3..3] GPIO35 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO36 : 1;          /*!< [4..4] GPIO36 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO37 : 1;          /*!< [5..5] GPIO37 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO38 : 1;          /*!< [6..6] GPIO38 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO39 : 1;          /*!< [7..7] GPIO39 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO40 : 1;          /*!< [8..8] GPIO40 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO41 : 1;          /*!< [9..9] GPIO41 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO42 : 1;          /*!< [10..10] GPIO42 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO43 : 1;          /*!< [11..11] GPIO43 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO44 : 1;          /*!< [12..12] GPIO44 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO45 : 1;          /*!< [13..13] GPIO45 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO46 : 1;          /*!< [14..14] GPIO46 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO47 : 1;          /*!< [15..15] GPIO47 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO48 : 1;          /*!< [16..16] GPIO48 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO49 : 1;          /*!< [17..17] GPIO49 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO50 : 1;          /*!< [18..18] GPIO50 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO51 : 1;          /*!< [19..19] GPIO51 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO52 : 1;          /*!< [20..20] GPIO52 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO53 : 1;          /*!< [21..21] GPIO53 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO54 : 1;          /*!< [22..22] GPIO54 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO55 : 1;          /*!< [23..23] GPIO55 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO56 : 1;          /*!< [24..24] GPIO56 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO57 : 1;          /*!< [25..25] GPIO57 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO58 : 1;          /*!< [26..26] GPIO58 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO59 : 1;          /*!< [27..27] GPIO59 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO60 : 1;          /*!< [28..28] GPIO60 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO61 : 1;          /*!< [29..29] GPIO61 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO62 : 1;          /*!< [30..30] GPIO62 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO63 : 1;          /*!< [31..31] GPIO63 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT1EN_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT1STAT;              /*!< (@ 0x00000394) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP0N1GPIO32 : 1;          /*!< [0..0] GPIO32 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO33 : 1;          /*!< [1..1] GPIO33 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO34 : 1;          /*!< [2..2] GPIO34 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO35 : 1;          /*!< [3..3] GPIO35 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO36 : 1;          /*!< [4..4] GPIO36 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO37 : 1;          /*!< [5..5] GPIO37 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO38 : 1;          /*!< [6..6] GPIO38 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO39 : 1;          /*!< [7..7] GPIO39 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO40 : 1;          /*!< [8..8] GPIO40 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO41 : 1;          /*!< [9..9] GPIO41 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO42 : 1;          /*!< [10..10] GPIO42 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO43 : 1;          /*!< [11..11] GPIO43 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO44 : 1;          /*!< [12..12] GPIO44 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO45 : 1;          /*!< [13..13] GPIO45 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO46 : 1;          /*!< [14..14] GPIO46 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO47 : 1;          /*!< [15..15] GPIO47 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO48 : 1;          /*!< [16..16] GPIO48 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO49 : 1;          /*!< [17..17] GPIO49 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO50 : 1;          /*!< [18..18] GPIO50 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO51 : 1;          /*!< [19..19] GPIO51 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO52 : 1;          /*!< [20..20] GPIO52 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO53 : 1;          /*!< [21..21] GPIO53 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO54 : 1;          /*!< [22..22] GPIO54 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO55 : 1;          /*!< [23..23] GPIO55 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO56 : 1;          /*!< [24..24] GPIO56 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO57 : 1;          /*!< [25..25] GPIO57 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO58 : 1;          /*!< [26..26] GPIO58 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO59 : 1;          /*!< [27..27] GPIO59 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO60 : 1;          /*!< [28..28] GPIO60 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO61 : 1;          /*!< [29..29] GPIO61 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO62 : 1;          /*!< [30..30] GPIO62 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO63 : 1;          /*!< [31..31] GPIO63 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT1STAT_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT1CLR;               /*!< (@ 0x00000398) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP0N1GPIO32 : 1;          /*!< [0..0] GPIO32 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO33 : 1;          /*!< [1..1] GPIO33 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO34 : 1;          /*!< [2..2] GPIO34 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO35 : 1;          /*!< [3..3] GPIO35 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO36 : 1;          /*!< [4..4] GPIO36 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO37 : 1;          /*!< [5..5] GPIO37 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO38 : 1;          /*!< [6..6] GPIO38 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO39 : 1;          /*!< [7..7] GPIO39 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO40 : 1;          /*!< [8..8] GPIO40 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO41 : 1;          /*!< [9..9] GPIO41 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO42 : 1;          /*!< [10..10] GPIO42 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO43 : 1;          /*!< [11..11] GPIO43 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO44 : 1;          /*!< [12..12] GPIO44 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO45 : 1;          /*!< [13..13] GPIO45 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO46 : 1;          /*!< [14..14] GPIO46 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO47 : 1;          /*!< [15..15] GPIO47 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO48 : 1;          /*!< [16..16] GPIO48 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO49 : 1;          /*!< [17..17] GPIO49 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO50 : 1;          /*!< [18..18] GPIO50 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO51 : 1;          /*!< [19..19] GPIO51 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO52 : 1;          /*!< [20..20] GPIO52 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO53 : 1;          /*!< [21..21] GPIO53 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO54 : 1;          /*!< [22..22] GPIO54 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO55 : 1;          /*!< [23..23] GPIO55 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO56 : 1;          /*!< [24..24] GPIO56 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO57 : 1;          /*!< [25..25] GPIO57 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO58 : 1;          /*!< [26..26] GPIO58 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO59 : 1;          /*!< [27..27] GPIO59 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO60 : 1;          /*!< [28..28] GPIO60 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO61 : 1;          /*!< [29..29] GPIO61 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO62 : 1;          /*!< [30..30] GPIO62 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO63 : 1;          /*!< [31..31] GPIO63 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT1CLR_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT1SET;               /*!< (@ 0x0000039C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP0N1GPIO32 : 1;          /*!< [0..0] GPIO32 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO33 : 1;          /*!< [1..1] GPIO33 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO34 : 1;          /*!< [2..2] GPIO34 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO35 : 1;          /*!< [3..3] GPIO35 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO36 : 1;          /*!< [4..4] GPIO36 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO37 : 1;          /*!< [5..5] GPIO37 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO38 : 1;          /*!< [6..6] GPIO38 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO39 : 1;          /*!< [7..7] GPIO39 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO40 : 1;          /*!< [8..8] GPIO40 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO41 : 1;          /*!< [9..9] GPIO41 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO42 : 1;          /*!< [10..10] GPIO42 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO43 : 1;          /*!< [11..11] GPIO43 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO44 : 1;          /*!< [12..12] GPIO44 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO45 : 1;          /*!< [13..13] GPIO45 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO46 : 1;          /*!< [14..14] GPIO46 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO47 : 1;          /*!< [15..15] GPIO47 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO48 : 1;          /*!< [16..16] GPIO48 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO49 : 1;          /*!< [17..17] GPIO49 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO50 : 1;          /*!< [18..18] GPIO50 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO51 : 1;          /*!< [19..19] GPIO51 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO52 : 1;          /*!< [20..20] GPIO52 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO53 : 1;          /*!< [21..21] GPIO53 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO54 : 1;          /*!< [22..22] GPIO54 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO55 : 1;          /*!< [23..23] GPIO55 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO56 : 1;          /*!< [24..24] GPIO56 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO57 : 1;          /*!< [25..25] GPIO57 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO58 : 1;          /*!< [26..26] GPIO58 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO59 : 1;          /*!< [27..27] GPIO59 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO60 : 1;          /*!< [28..28] GPIO60 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO61 : 1;          /*!< [29..29] GPIO61 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO62 : 1;          /*!< [30..30] GPIO62 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO63 : 1;          /*!< [31..31] GPIO63 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT1SET_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT2EN;                /*!< (@ 0x000003A0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP0N1GPIO64 : 1;          /*!< [0..0] GPIO64 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO65 : 1;          /*!< [1..1] GPIO65 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO66 : 1;          /*!< [2..2] GPIO66 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO67 : 1;          /*!< [3..3] GPIO67 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO68 : 1;          /*!< [4..4] GPIO68 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO69 : 1;          /*!< [5..5] GPIO69 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO70 : 1;          /*!< [6..6] GPIO70 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO71 : 1;          /*!< [7..7] GPIO71 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO72 : 1;          /*!< [8..8] GPIO72 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO73 : 1;          /*!< [9..9] GPIO73 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO74 : 1;          /*!< [10..10] GPIO74 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO75 : 1;          /*!< [11..11] GPIO75 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO76 : 1;          /*!< [12..12] GPIO76 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO77 : 1;          /*!< [13..13] GPIO77 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO78 : 1;          /*!< [14..14] GPIO78 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO79 : 1;          /*!< [15..15] GPIO79 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO80 : 1;          /*!< [16..16] GPIO80 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO81 : 1;          /*!< [17..17] GPIO81 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO82 : 1;          /*!< [18..18] GPIO82 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO83 : 1;          /*!< [19..19] GPIO83 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO84 : 1;          /*!< [20..20] GPIO84 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO85 : 1;          /*!< [21..21] GPIO85 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO86 : 1;          /*!< [22..22] GPIO86 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO87 : 1;          /*!< [23..23] GPIO87 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO88 : 1;          /*!< [24..24] GPIO88 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO89 : 1;          /*!< [25..25] GPIO89 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO90 : 1;          /*!< [26..26] GPIO90 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO91 : 1;          /*!< [27..27] GPIO91 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO92 : 1;          /*!< [28..28] GPIO92 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO93 : 1;          /*!< [29..29] GPIO93 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO94 : 1;          /*!< [30..30] GPIO94 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO95 : 1;          /*!< [31..31] GPIO95 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT2EN_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT2STAT;              /*!< (@ 0x000003A4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP0N1GPIO64 : 1;          /*!< [0..0] GPIO64 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO65 : 1;          /*!< [1..1] GPIO65 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO66 : 1;          /*!< [2..2] GPIO66 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO67 : 1;          /*!< [3..3] GPIO67 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO68 : 1;          /*!< [4..4] GPIO68 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO69 : 1;          /*!< [5..5] GPIO69 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO70 : 1;          /*!< [6..6] GPIO70 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO71 : 1;          /*!< [7..7] GPIO71 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO72 : 1;          /*!< [8..8] GPIO72 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO73 : 1;          /*!< [9..9] GPIO73 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO74 : 1;          /*!< [10..10] GPIO74 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO75 : 1;          /*!< [11..11] GPIO75 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO76 : 1;          /*!< [12..12] GPIO76 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO77 : 1;          /*!< [13..13] GPIO77 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO78 : 1;          /*!< [14..14] GPIO78 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO79 : 1;          /*!< [15..15] GPIO79 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO80 : 1;          /*!< [16..16] GPIO80 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO81 : 1;          /*!< [17..17] GPIO81 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO82 : 1;          /*!< [18..18] GPIO82 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO83 : 1;          /*!< [19..19] GPIO83 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO84 : 1;          /*!< [20..20] GPIO84 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO85 : 1;          /*!< [21..21] GPIO85 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO86 : 1;          /*!< [22..22] GPIO86 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO87 : 1;          /*!< [23..23] GPIO87 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO88 : 1;          /*!< [24..24] GPIO88 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO89 : 1;          /*!< [25..25] GPIO89 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO90 : 1;          /*!< [26..26] GPIO90 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO91 : 1;          /*!< [27..27] GPIO91 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO92 : 1;          /*!< [28..28] GPIO92 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO93 : 1;          /*!< [29..29] GPIO93 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO94 : 1;          /*!< [30..30] GPIO94 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO95 : 1;          /*!< [31..31] GPIO95 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT2STAT_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT2CLR;               /*!< (@ 0x000003A8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP0N1GPIO64 : 1;          /*!< [0..0] GPIO64 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO65 : 1;          /*!< [1..1] GPIO65 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO66 : 1;          /*!< [2..2] GPIO66 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO67 : 1;          /*!< [3..3] GPIO67 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO68 : 1;          /*!< [4..4] GPIO68 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO69 : 1;          /*!< [5..5] GPIO69 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO70 : 1;          /*!< [6..6] GPIO70 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO71 : 1;          /*!< [7..7] GPIO71 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO72 : 1;          /*!< [8..8] GPIO72 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO73 : 1;          /*!< [9..9] GPIO73 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO74 : 1;          /*!< [10..10] GPIO74 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO75 : 1;          /*!< [11..11] GPIO75 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO76 : 1;          /*!< [12..12] GPIO76 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO77 : 1;          /*!< [13..13] GPIO77 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO78 : 1;          /*!< [14..14] GPIO78 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO79 : 1;          /*!< [15..15] GPIO79 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO80 : 1;          /*!< [16..16] GPIO80 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO81 : 1;          /*!< [17..17] GPIO81 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO82 : 1;          /*!< [18..18] GPIO82 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO83 : 1;          /*!< [19..19] GPIO83 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO84 : 1;          /*!< [20..20] GPIO84 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO85 : 1;          /*!< [21..21] GPIO85 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO86 : 1;          /*!< [22..22] GPIO86 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO87 : 1;          /*!< [23..23] GPIO87 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO88 : 1;          /*!< [24..24] GPIO88 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO89 : 1;          /*!< [25..25] GPIO89 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO90 : 1;          /*!< [26..26] GPIO90 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO91 : 1;          /*!< [27..27] GPIO91 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO92 : 1;          /*!< [28..28] GPIO92 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO93 : 1;          /*!< [29..29] GPIO93 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO94 : 1;          /*!< [30..30] GPIO94 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO95 : 1;          /*!< [31..31] GPIO95 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT2CLR_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT2SET;               /*!< (@ 0x000003AC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP0N1GPIO64 : 1;          /*!< [0..0] GPIO64 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO65 : 1;          /*!< [1..1] GPIO65 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO66 : 1;          /*!< [2..2] GPIO66 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO67 : 1;          /*!< [3..3] GPIO67 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO68 : 1;          /*!< [4..4] GPIO68 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO69 : 1;          /*!< [5..5] GPIO69 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO70 : 1;          /*!< [6..6] GPIO70 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO71 : 1;          /*!< [7..7] GPIO71 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO72 : 1;          /*!< [8..8] GPIO72 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO73 : 1;          /*!< [9..9] GPIO73 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO74 : 1;          /*!< [10..10] GPIO74 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO75 : 1;          /*!< [11..11] GPIO75 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO76 : 1;          /*!< [12..12] GPIO76 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO77 : 1;          /*!< [13..13] GPIO77 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO78 : 1;          /*!< [14..14] GPIO78 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO79 : 1;          /*!< [15..15] GPIO79 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO80 : 1;          /*!< [16..16] GPIO80 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO81 : 1;          /*!< [17..17] GPIO81 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO82 : 1;          /*!< [18..18] GPIO82 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO83 : 1;          /*!< [19..19] GPIO83 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO84 : 1;          /*!< [20..20] GPIO84 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO85 : 1;          /*!< [21..21] GPIO85 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO86 : 1;          /*!< [22..22] GPIO86 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO87 : 1;          /*!< [23..23] GPIO87 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO88 : 1;          /*!< [24..24] GPIO88 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO89 : 1;          /*!< [25..25] GPIO89 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO90 : 1;          /*!< [26..26] GPIO90 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO91 : 1;          /*!< [27..27] GPIO91 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO92 : 1;          /*!< [28..28] GPIO92 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO93 : 1;          /*!< [29..29] GPIO93 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO94 : 1;          /*!< [30..30] GPIO94 DSP0 N1-priority interrupt.                               */
      __IOM uint32_t DSP0N1GPIO95 : 1;          /*!< [31..31] GPIO95 DSP0 N1-priority interrupt.                               */
    } DSP0N1INT2SET_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT3EN;                /*!< (@ 0x000003B0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP0N1GPIO96 : 1;          /*!< [0..0] GPIO96 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO97 : 1;          /*!< [1..1] GPIO97 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO98 : 1;          /*!< [2..2] GPIO98 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO99 : 1;          /*!< [3..3] GPIO99 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO100 : 1;         /*!< [4..4] GPIO100 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO101 : 1;         /*!< [5..5] GPIO101 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO102 : 1;         /*!< [6..6] GPIO102 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO103 : 1;         /*!< [7..7] GPIO103 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO104 : 1;         /*!< [8..8] GPIO104 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO105 : 1;         /*!< [9..9] GPIO105 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO106 : 1;         /*!< [10..10] GPIO106 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO107 : 1;         /*!< [11..11] GPIO107 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO108 : 1;         /*!< [12..12] GPIO108 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO109 : 1;         /*!< [13..13] GPIO109 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO110 : 1;         /*!< [14..14] GPIO110 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO111 : 1;         /*!< [15..15] GPIO111 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO112 : 1;         /*!< [16..16] GPIO112 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO113 : 1;         /*!< [17..17] GPIO113 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO114 : 1;         /*!< [18..18] GPIO114 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO115 : 1;         /*!< [19..19] GPIO115 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO116 : 1;         /*!< [20..20] GPIO116 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO117 : 1;         /*!< [21..21] GPIO117 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO118 : 1;         /*!< [22..22] GPIO118 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO119 : 1;         /*!< [23..23] GPIO119 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO120 : 1;         /*!< [24..24] GPIO120 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO121 : 1;         /*!< [25..25] GPIO121 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO122 : 1;         /*!< [26..26] GPIO122 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO123 : 1;         /*!< [27..27] GPIO123 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO124 : 1;         /*!< [28..28] GPIO124 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO125 : 1;         /*!< [29..29] GPIO125 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO126 : 1;         /*!< [30..30] GPIO126 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO127 : 1;         /*!< [31..31] GPIO127 DSP0 N1-priority interrupt.                              */
    } DSP0N1INT3EN_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT3STAT;              /*!< (@ 0x000003B4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP0N1GPIO96 : 1;          /*!< [0..0] GPIO96 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO97 : 1;          /*!< [1..1] GPIO97 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO98 : 1;          /*!< [2..2] GPIO98 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO99 : 1;          /*!< [3..3] GPIO99 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO100 : 1;         /*!< [4..4] GPIO100 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO101 : 1;         /*!< [5..5] GPIO101 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO102 : 1;         /*!< [6..6] GPIO102 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO103 : 1;         /*!< [7..7] GPIO103 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO104 : 1;         /*!< [8..8] GPIO104 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO105 : 1;         /*!< [9..9] GPIO105 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO106 : 1;         /*!< [10..10] GPIO106 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO107 : 1;         /*!< [11..11] GPIO107 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO108 : 1;         /*!< [12..12] GPIO108 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO109 : 1;         /*!< [13..13] GPIO109 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO110 : 1;         /*!< [14..14] GPIO110 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO111 : 1;         /*!< [15..15] GPIO111 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO112 : 1;         /*!< [16..16] GPIO112 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO113 : 1;         /*!< [17..17] GPIO113 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO114 : 1;         /*!< [18..18] GPIO114 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO115 : 1;         /*!< [19..19] GPIO115 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO116 : 1;         /*!< [20..20] GPIO116 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO117 : 1;         /*!< [21..21] GPIO117 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO118 : 1;         /*!< [22..22] GPIO118 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO119 : 1;         /*!< [23..23] GPIO119 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO120 : 1;         /*!< [24..24] GPIO120 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO121 : 1;         /*!< [25..25] GPIO121 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO122 : 1;         /*!< [26..26] GPIO122 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO123 : 1;         /*!< [27..27] GPIO123 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO124 : 1;         /*!< [28..28] GPIO124 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO125 : 1;         /*!< [29..29] GPIO125 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO126 : 1;         /*!< [30..30] GPIO126 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO127 : 1;         /*!< [31..31] GPIO127 DSP0 N1-priority interrupt.                              */
    } DSP0N1INT3STAT_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT3CLR;               /*!< (@ 0x000003B8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP0N1GPIO96 : 1;          /*!< [0..0] GPIO96 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO97 : 1;          /*!< [1..1] GPIO97 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO98 : 1;          /*!< [2..2] GPIO98 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO99 : 1;          /*!< [3..3] GPIO99 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO100 : 1;         /*!< [4..4] GPIO100 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO101 : 1;         /*!< [5..5] GPIO101 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO102 : 1;         /*!< [6..6] GPIO102 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO103 : 1;         /*!< [7..7] GPIO103 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO104 : 1;         /*!< [8..8] GPIO104 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO105 : 1;         /*!< [9..9] GPIO105 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO106 : 1;         /*!< [10..10] GPIO106 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO107 : 1;         /*!< [11..11] GPIO107 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO108 : 1;         /*!< [12..12] GPIO108 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO109 : 1;         /*!< [13..13] GPIO109 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO110 : 1;         /*!< [14..14] GPIO110 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO111 : 1;         /*!< [15..15] GPIO111 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO112 : 1;         /*!< [16..16] GPIO112 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO113 : 1;         /*!< [17..17] GPIO113 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO114 : 1;         /*!< [18..18] GPIO114 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO115 : 1;         /*!< [19..19] GPIO115 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO116 : 1;         /*!< [20..20] GPIO116 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO117 : 1;         /*!< [21..21] GPIO117 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO118 : 1;         /*!< [22..22] GPIO118 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO119 : 1;         /*!< [23..23] GPIO119 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO120 : 1;         /*!< [24..24] GPIO120 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO121 : 1;         /*!< [25..25] GPIO121 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO122 : 1;         /*!< [26..26] GPIO122 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO123 : 1;         /*!< [27..27] GPIO123 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO124 : 1;         /*!< [28..28] GPIO124 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO125 : 1;         /*!< [29..29] GPIO125 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO126 : 1;         /*!< [30..30] GPIO126 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO127 : 1;         /*!< [31..31] GPIO127 DSP0 N1-priority interrupt.                              */
    } DSP0N1INT3CLR_b;
  } ;

  union {
    __IOM uint32_t DSP0N1INT3SET;               /*!< (@ 0x000003BC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP0N1GPIO96 : 1;          /*!< [0..0] GPIO96 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO97 : 1;          /*!< [1..1] GPIO97 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO98 : 1;          /*!< [2..2] GPIO98 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO99 : 1;          /*!< [3..3] GPIO99 DSP0 N1-priority interrupt.                                 */
      __IOM uint32_t DSP0N1GPIO100 : 1;         /*!< [4..4] GPIO100 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO101 : 1;         /*!< [5..5] GPIO101 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO102 : 1;         /*!< [6..6] GPIO102 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO103 : 1;         /*!< [7..7] GPIO103 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO104 : 1;         /*!< [8..8] GPIO104 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO105 : 1;         /*!< [9..9] GPIO105 DSP0 N1-priority interrupt.                                */
      __IOM uint32_t DSP0N1GPIO106 : 1;         /*!< [10..10] GPIO106 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO107 : 1;         /*!< [11..11] GPIO107 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO108 : 1;         /*!< [12..12] GPIO108 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO109 : 1;         /*!< [13..13] GPIO109 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO110 : 1;         /*!< [14..14] GPIO110 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO111 : 1;         /*!< [15..15] GPIO111 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO112 : 1;         /*!< [16..16] GPIO112 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO113 : 1;         /*!< [17..17] GPIO113 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO114 : 1;         /*!< [18..18] GPIO114 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO115 : 1;         /*!< [19..19] GPIO115 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO116 : 1;         /*!< [20..20] GPIO116 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO117 : 1;         /*!< [21..21] GPIO117 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO118 : 1;         /*!< [22..22] GPIO118 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO119 : 1;         /*!< [23..23] GPIO119 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO120 : 1;         /*!< [24..24] GPIO120 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO121 : 1;         /*!< [25..25] GPIO121 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO122 : 1;         /*!< [26..26] GPIO122 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO123 : 1;         /*!< [27..27] GPIO123 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO124 : 1;         /*!< [28..28] GPIO124 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO125 : 1;         /*!< [29..29] GPIO125 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO126 : 1;         /*!< [30..30] GPIO126 DSP0 N1-priority interrupt.                              */
      __IOM uint32_t DSP0N1GPIO127 : 1;         /*!< [31..31] GPIO127 DSP0 N1-priority interrupt.                              */
    } DSP0N1INT3SET_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT0EN;                /*!< (@ 0x000003C0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP1N0GPIO0 : 1;           /*!< [0..0] GPIO0 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO1 : 1;           /*!< [1..1] GPIO1 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO2 : 1;           /*!< [2..2] GPIO2 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO3 : 1;           /*!< [3..3] GPIO3 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO4 : 1;           /*!< [4..4] GPIO4 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO5 : 1;           /*!< [5..5] GPIO5 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO6 : 1;           /*!< [6..6] GPIO6 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO7 : 1;           /*!< [7..7] GPIO7 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO8 : 1;           /*!< [8..8] GPIO8 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO9 : 1;           /*!< [9..9] GPIO9 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO10 : 1;          /*!< [10..10] GPIO10 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO11 : 1;          /*!< [11..11] GPIO11 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO12 : 1;          /*!< [12..12] GPIO12 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO13 : 1;          /*!< [13..13] GPIO13 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO14 : 1;          /*!< [14..14] GPIO14 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO15 : 1;          /*!< [15..15] GPIO15 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO16 : 1;          /*!< [16..16] GPIO16 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO17 : 1;          /*!< [17..17] GPIO17 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO18 : 1;          /*!< [18..18] GPIO18 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO19 : 1;          /*!< [19..19] GPIO19 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO20 : 1;          /*!< [20..20] GPIO20 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO21 : 1;          /*!< [21..21] GPIO21 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO22 : 1;          /*!< [22..22] GPIO22 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO23 : 1;          /*!< [23..23] GPIO23 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO24 : 1;          /*!< [24..24] GPIO24 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO25 : 1;          /*!< [25..25] GPIO25 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO26 : 1;          /*!< [26..26] GPIO26 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO27 : 1;          /*!< [27..27] GPIO27 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO28 : 1;          /*!< [28..28] GPIO28 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO29 : 1;          /*!< [29..29] GPIO29 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO30 : 1;          /*!< [30..30] GPIO30 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO31 : 1;          /*!< [31..31] GPIO31 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT0EN_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT0STAT;              /*!< (@ 0x000003C4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP1N0GPIO0 : 1;           /*!< [0..0] GPIO0 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO1 : 1;           /*!< [1..1] GPIO1 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO2 : 1;           /*!< [2..2] GPIO2 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO3 : 1;           /*!< [3..3] GPIO3 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO4 : 1;           /*!< [4..4] GPIO4 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO5 : 1;           /*!< [5..5] GPIO5 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO6 : 1;           /*!< [6..6] GPIO6 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO7 : 1;           /*!< [7..7] GPIO7 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO8 : 1;           /*!< [8..8] GPIO8 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO9 : 1;           /*!< [9..9] GPIO9 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO10 : 1;          /*!< [10..10] GPIO10 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO11 : 1;          /*!< [11..11] GPIO11 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO12 : 1;          /*!< [12..12] GPIO12 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO13 : 1;          /*!< [13..13] GPIO13 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO14 : 1;          /*!< [14..14] GPIO14 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO15 : 1;          /*!< [15..15] GPIO15 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO16 : 1;          /*!< [16..16] GPIO16 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO17 : 1;          /*!< [17..17] GPIO17 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO18 : 1;          /*!< [18..18] GPIO18 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO19 : 1;          /*!< [19..19] GPIO19 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO20 : 1;          /*!< [20..20] GPIO20 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO21 : 1;          /*!< [21..21] GPIO21 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO22 : 1;          /*!< [22..22] GPIO22 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO23 : 1;          /*!< [23..23] GPIO23 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO24 : 1;          /*!< [24..24] GPIO24 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO25 : 1;          /*!< [25..25] GPIO25 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO26 : 1;          /*!< [26..26] GPIO26 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO27 : 1;          /*!< [27..27] GPIO27 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO28 : 1;          /*!< [28..28] GPIO28 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO29 : 1;          /*!< [29..29] GPIO29 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO30 : 1;          /*!< [30..30] GPIO30 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO31 : 1;          /*!< [31..31] GPIO31 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT0STAT_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT0CLR;               /*!< (@ 0x000003C8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP1N0GPIO0 : 1;           /*!< [0..0] GPIO0 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO1 : 1;           /*!< [1..1] GPIO1 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO2 : 1;           /*!< [2..2] GPIO2 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO3 : 1;           /*!< [3..3] GPIO3 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO4 : 1;           /*!< [4..4] GPIO4 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO5 : 1;           /*!< [5..5] GPIO5 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO6 : 1;           /*!< [6..6] GPIO6 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO7 : 1;           /*!< [7..7] GPIO7 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO8 : 1;           /*!< [8..8] GPIO8 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO9 : 1;           /*!< [9..9] GPIO9 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO10 : 1;          /*!< [10..10] GPIO10 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO11 : 1;          /*!< [11..11] GPIO11 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO12 : 1;          /*!< [12..12] GPIO12 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO13 : 1;          /*!< [13..13] GPIO13 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO14 : 1;          /*!< [14..14] GPIO14 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO15 : 1;          /*!< [15..15] GPIO15 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO16 : 1;          /*!< [16..16] GPIO16 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO17 : 1;          /*!< [17..17] GPIO17 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO18 : 1;          /*!< [18..18] GPIO18 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO19 : 1;          /*!< [19..19] GPIO19 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO20 : 1;          /*!< [20..20] GPIO20 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO21 : 1;          /*!< [21..21] GPIO21 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO22 : 1;          /*!< [22..22] GPIO22 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO23 : 1;          /*!< [23..23] GPIO23 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO24 : 1;          /*!< [24..24] GPIO24 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO25 : 1;          /*!< [25..25] GPIO25 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO26 : 1;          /*!< [26..26] GPIO26 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO27 : 1;          /*!< [27..27] GPIO27 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO28 : 1;          /*!< [28..28] GPIO28 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO29 : 1;          /*!< [29..29] GPIO29 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO30 : 1;          /*!< [30..30] GPIO30 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO31 : 1;          /*!< [31..31] GPIO31 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT0CLR_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT0SET;               /*!< (@ 0x000003CC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP1N0GPIO0 : 1;           /*!< [0..0] GPIO0 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO1 : 1;           /*!< [1..1] GPIO1 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO2 : 1;           /*!< [2..2] GPIO2 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO3 : 1;           /*!< [3..3] GPIO3 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO4 : 1;           /*!< [4..4] GPIO4 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO5 : 1;           /*!< [5..5] GPIO5 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO6 : 1;           /*!< [6..6] GPIO6 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO7 : 1;           /*!< [7..7] GPIO7 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO8 : 1;           /*!< [8..8] GPIO8 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO9 : 1;           /*!< [9..9] GPIO9 DSP1 N0-priority interrupt.                                  */
      __IOM uint32_t DSP1N0GPIO10 : 1;          /*!< [10..10] GPIO10 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO11 : 1;          /*!< [11..11] GPIO11 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO12 : 1;          /*!< [12..12] GPIO12 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO13 : 1;          /*!< [13..13] GPIO13 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO14 : 1;          /*!< [14..14] GPIO14 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO15 : 1;          /*!< [15..15] GPIO15 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO16 : 1;          /*!< [16..16] GPIO16 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO17 : 1;          /*!< [17..17] GPIO17 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO18 : 1;          /*!< [18..18] GPIO18 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO19 : 1;          /*!< [19..19] GPIO19 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO20 : 1;          /*!< [20..20] GPIO20 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO21 : 1;          /*!< [21..21] GPIO21 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO22 : 1;          /*!< [22..22] GPIO22 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO23 : 1;          /*!< [23..23] GPIO23 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO24 : 1;          /*!< [24..24] GPIO24 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO25 : 1;          /*!< [25..25] GPIO25 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO26 : 1;          /*!< [26..26] GPIO26 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO27 : 1;          /*!< [27..27] GPIO27 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO28 : 1;          /*!< [28..28] GPIO28 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO29 : 1;          /*!< [29..29] GPIO29 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO30 : 1;          /*!< [30..30] GPIO30 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO31 : 1;          /*!< [31..31] GPIO31 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT0SET_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT1EN;                /*!< (@ 0x000003D0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP1N0GPIO32 : 1;          /*!< [0..0] GPIO32 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO33 : 1;          /*!< [1..1] GPIO33 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO34 : 1;          /*!< [2..2] GPIO34 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO35 : 1;          /*!< [3..3] GPIO35 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO36 : 1;          /*!< [4..4] GPIO36 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO37 : 1;          /*!< [5..5] GPIO37 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO38 : 1;          /*!< [6..6] GPIO38 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO39 : 1;          /*!< [7..7] GPIO39 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO40 : 1;          /*!< [8..8] GPIO40 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO41 : 1;          /*!< [9..9] GPIO41 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO42 : 1;          /*!< [10..10] GPIO42 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO43 : 1;          /*!< [11..11] GPIO43 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO44 : 1;          /*!< [12..12] GPIO44 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO45 : 1;          /*!< [13..13] GPIO45 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO46 : 1;          /*!< [14..14] GPIO46 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO47 : 1;          /*!< [15..15] GPIO47 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO48 : 1;          /*!< [16..16] GPIO48 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO49 : 1;          /*!< [17..17] GPIO49 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO50 : 1;          /*!< [18..18] GPIO50 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO51 : 1;          /*!< [19..19] GPIO51 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO52 : 1;          /*!< [20..20] GPIO52 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO53 : 1;          /*!< [21..21] GPIO53 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO54 : 1;          /*!< [22..22] GPIO54 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO55 : 1;          /*!< [23..23] GPIO55 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO56 : 1;          /*!< [24..24] GPIO56 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO57 : 1;          /*!< [25..25] GPIO57 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO58 : 1;          /*!< [26..26] GPIO58 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO59 : 1;          /*!< [27..27] GPIO59 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO60 : 1;          /*!< [28..28] GPIO60 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO61 : 1;          /*!< [29..29] GPIO61 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO62 : 1;          /*!< [30..30] GPIO62 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO63 : 1;          /*!< [31..31] GPIO63 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT1EN_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT1STAT;              /*!< (@ 0x000003D4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP1N0GPIO32 : 1;          /*!< [0..0] GPIO32 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO33 : 1;          /*!< [1..1] GPIO33 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO34 : 1;          /*!< [2..2] GPIO34 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO35 : 1;          /*!< [3..3] GPIO35 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO36 : 1;          /*!< [4..4] GPIO36 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO37 : 1;          /*!< [5..5] GPIO37 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO38 : 1;          /*!< [6..6] GPIO38 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO39 : 1;          /*!< [7..7] GPIO39 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO40 : 1;          /*!< [8..8] GPIO40 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO41 : 1;          /*!< [9..9] GPIO41 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO42 : 1;          /*!< [10..10] GPIO42 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO43 : 1;          /*!< [11..11] GPIO43 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO44 : 1;          /*!< [12..12] GPIO44 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO45 : 1;          /*!< [13..13] GPIO45 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO46 : 1;          /*!< [14..14] GPIO46 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO47 : 1;          /*!< [15..15] GPIO47 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO48 : 1;          /*!< [16..16] GPIO48 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO49 : 1;          /*!< [17..17] GPIO49 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO50 : 1;          /*!< [18..18] GPIO50 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO51 : 1;          /*!< [19..19] GPIO51 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO52 : 1;          /*!< [20..20] GPIO52 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO53 : 1;          /*!< [21..21] GPIO53 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO54 : 1;          /*!< [22..22] GPIO54 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO55 : 1;          /*!< [23..23] GPIO55 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO56 : 1;          /*!< [24..24] GPIO56 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO57 : 1;          /*!< [25..25] GPIO57 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO58 : 1;          /*!< [26..26] GPIO58 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO59 : 1;          /*!< [27..27] GPIO59 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO60 : 1;          /*!< [28..28] GPIO60 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO61 : 1;          /*!< [29..29] GPIO61 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO62 : 1;          /*!< [30..30] GPIO62 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO63 : 1;          /*!< [31..31] GPIO63 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT1STAT_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT1CLR;               /*!< (@ 0x000003D8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP1N0GPIO32 : 1;          /*!< [0..0] GPIO32 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO33 : 1;          /*!< [1..1] GPIO33 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO34 : 1;          /*!< [2..2] GPIO34 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO35 : 1;          /*!< [3..3] GPIO35 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO36 : 1;          /*!< [4..4] GPIO36 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO37 : 1;          /*!< [5..5] GPIO37 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO38 : 1;          /*!< [6..6] GPIO38 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO39 : 1;          /*!< [7..7] GPIO39 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO40 : 1;          /*!< [8..8] GPIO40 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO41 : 1;          /*!< [9..9] GPIO41 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO42 : 1;          /*!< [10..10] GPIO42 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO43 : 1;          /*!< [11..11] GPIO43 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO44 : 1;          /*!< [12..12] GPIO44 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO45 : 1;          /*!< [13..13] GPIO45 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO46 : 1;          /*!< [14..14] GPIO46 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO47 : 1;          /*!< [15..15] GPIO47 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO48 : 1;          /*!< [16..16] GPIO48 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO49 : 1;          /*!< [17..17] GPIO49 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO50 : 1;          /*!< [18..18] GPIO50 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO51 : 1;          /*!< [19..19] GPIO51 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO52 : 1;          /*!< [20..20] GPIO52 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO53 : 1;          /*!< [21..21] GPIO53 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO54 : 1;          /*!< [22..22] GPIO54 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO55 : 1;          /*!< [23..23] GPIO55 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO56 : 1;          /*!< [24..24] GPIO56 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO57 : 1;          /*!< [25..25] GPIO57 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO58 : 1;          /*!< [26..26] GPIO58 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO59 : 1;          /*!< [27..27] GPIO59 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO60 : 1;          /*!< [28..28] GPIO60 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO61 : 1;          /*!< [29..29] GPIO61 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO62 : 1;          /*!< [30..30] GPIO62 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO63 : 1;          /*!< [31..31] GPIO63 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT1CLR_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT1SET;               /*!< (@ 0x000003DC) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t DSP1N0GPIO32 : 1;          /*!< [0..0] GPIO32 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO33 : 1;          /*!< [1..1] GPIO33 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO34 : 1;          /*!< [2..2] GPIO34 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO35 : 1;          /*!< [3..3] GPIO35 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO36 : 1;          /*!< [4..4] GPIO36 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO37 : 1;          /*!< [5..5] GPIO37 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO38 : 1;          /*!< [6..6] GPIO38 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO39 : 1;          /*!< [7..7] GPIO39 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO40 : 1;          /*!< [8..8] GPIO40 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO41 : 1;          /*!< [9..9] GPIO41 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO42 : 1;          /*!< [10..10] GPIO42 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO43 : 1;          /*!< [11..11] GPIO43 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO44 : 1;          /*!< [12..12] GPIO44 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO45 : 1;          /*!< [13..13] GPIO45 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO46 : 1;          /*!< [14..14] GPIO46 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO47 : 1;          /*!< [15..15] GPIO47 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO48 : 1;          /*!< [16..16] GPIO48 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO49 : 1;          /*!< [17..17] GPIO49 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO50 : 1;          /*!< [18..18] GPIO50 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO51 : 1;          /*!< [19..19] GPIO51 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO52 : 1;          /*!< [20..20] GPIO52 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO53 : 1;          /*!< [21..21] GPIO53 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO54 : 1;          /*!< [22..22] GPIO54 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO55 : 1;          /*!< [23..23] GPIO55 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO56 : 1;          /*!< [24..24] GPIO56 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO57 : 1;          /*!< [25..25] GPIO57 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO58 : 1;          /*!< [26..26] GPIO58 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO59 : 1;          /*!< [27..27] GPIO59 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO60 : 1;          /*!< [28..28] GPIO60 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO61 : 1;          /*!< [29..29] GPIO61 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO62 : 1;          /*!< [30..30] GPIO62 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO63 : 1;          /*!< [31..31] GPIO63 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT1SET_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT2EN;                /*!< (@ 0x000003E0) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t DSP1N0GPIO64 : 1;          /*!< [0..0] GPIO64 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO65 : 1;          /*!< [1..1] GPIO65 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO66 : 1;          /*!< [2..2] GPIO66 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO67 : 1;          /*!< [3..3] GPIO67 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO68 : 1;          /*!< [4..4] GPIO68 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO69 : 1;          /*!< [5..5] GPIO69 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO70 : 1;          /*!< [6..6] GPIO70 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO71 : 1;          /*!< [7..7] GPIO71 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO72 : 1;          /*!< [8..8] GPIO72 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO73 : 1;          /*!< [9..9] GPIO73 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO74 : 1;          /*!< [10..10] GPIO74 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO75 : 1;          /*!< [11..11] GPIO75 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO76 : 1;          /*!< [12..12] GPIO76 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO77 : 1;          /*!< [13..13] GPIO77 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO78 : 1;          /*!< [14..14] GPIO78 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO79 : 1;          /*!< [15..15] GPIO79 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO80 : 1;          /*!< [16..16] GPIO80 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO81 : 1;          /*!< [17..17] GPIO81 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO82 : 1;          /*!< [18..18] GPIO82 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO83 : 1;          /*!< [19..19] GPIO83 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO84 : 1;          /*!< [20..20] GPIO84 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO85 : 1;          /*!< [21..21] GPIO85 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO86 : 1;          /*!< [22..22] GPIO86 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO87 : 1;          /*!< [23..23] GPIO87 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO88 : 1;          /*!< [24..24] GPIO88 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO89 : 1;          /*!< [25..25] GPIO89 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO90 : 1;          /*!< [26..26] GPIO90 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO91 : 1;          /*!< [27..27] GPIO91 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO92 : 1;          /*!< [28..28] GPIO92 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO93 : 1;          /*!< [29..29] GPIO93 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO94 : 1;          /*!< [30..30] GPIO94 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO95 : 1;          /*!< [31..31] GPIO95 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT2EN_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT2STAT;              /*!< (@ 0x000003E4) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t DSP1N0GPIO64 : 1;          /*!< [0..0] GPIO64 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO65 : 1;          /*!< [1..1] GPIO65 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO66 : 1;          /*!< [2..2] GPIO66 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO67 : 1;          /*!< [3..3] GPIO67 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO68 : 1;          /*!< [4..4] GPIO68 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO69 : 1;          /*!< [5..5] GPIO69 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO70 : 1;          /*!< [6..6] GPIO70 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO71 : 1;          /*!< [7..7] GPIO71 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO72 : 1;          /*!< [8..8] GPIO72 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO73 : 1;          /*!< [9..9] GPIO73 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO74 : 1;          /*!< [10..10] GPIO74 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO75 : 1;          /*!< [11..11] GPIO75 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO76 : 1;          /*!< [12..12] GPIO76 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO77 : 1;          /*!< [13..13] GPIO77 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO78 : 1;          /*!< [14..14] GPIO78 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO79 : 1;          /*!< [15..15] GPIO79 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO80 : 1;          /*!< [16..16] GPIO80 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO81 : 1;          /*!< [17..17] GPIO81 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO82 : 1;          /*!< [18..18] GPIO82 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO83 : 1;          /*!< [19..19] GPIO83 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO84 : 1;          /*!< [20..20] GPIO84 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO85 : 1;          /*!< [21..21] GPIO85 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO86 : 1;          /*!< [22..22] GPIO86 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO87 : 1;          /*!< [23..23] GPIO87 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO88 : 1;          /*!< [24..24] GPIO88 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO89 : 1;          /*!< [25..25] GPIO89 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO90 : 1;          /*!< [26..26] GPIO90 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO91 : 1;          /*!< [27..27] GPIO91 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO92 : 1;          /*!< [28..28] GPIO92 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO93 : 1;          /*!< [29..29] GPIO93 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO94 : 1;          /*!< [30..30] GPIO94 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO95 : 1;          /*!< [31..31] GPIO95 DSP1 N0-priority interrupt.                               */
    } DSP1N0INT2STAT_b;
  } ;

  union {
    __IOM uint32_t DSP1N0INT2CLR;               /*!< (@ 0x000003E8) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t DSP1N0GPIO64 : 1;          /*!< [0..0] GPIO64 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO65 : 1;          /*!< [1..1] GPIO65 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO66 : 1;          /*!< [2..2] GPIO66 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO67 : 1;          /*!< [3..3] GPIO67 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO68 : 1;          /*!< [4..4] GPIO68 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO69 : 1;          /*!< [5..5] GPIO69 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO70 : 1;          /*!< [6..6] GPIO70 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO71 : 1;          /*!< [7..7] GPIO71 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO72 : 1;          /*!< [8..8] GPIO72 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO73 : 1;          /*!< [9..9] GPIO73 DSP1 N0-priority interrupt.                                 */
      __IOM uint32_t DSP1N0GPIO74 : 1;          /*!< [10..10] GPIO74 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO75 : 1;          /*!< [11..11] GPIO75 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO76 : 1;          /*!< [12..12] GPIO76 DSP1 N0-priority interrupt.                               */
      __IOM uint32_t DSP1N0GPIO77 : 1;          /*!< [13..13] GPIO77 DSP1 N0-pr