//*****************************************************************************
//
//! @file em9304_patches.c
//!
//! @brief This is a generated file.
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#include <stdint.h>
#include "em9304_patches.h"

//*****************************************************************************
//
// Extracted binary array
//
//*****************************************************************************
em9304_container_info_t g_pEm9304Patches[8] =
{
//  Build  UserBuild Version  Type ID  bApply  Start End
  { 3089,     2,       1,     11,  24, false,    0,     1 },
  { 3089,     2,       1,     11,  23, false,    1,     2 },
  { 3089,     0,       1,     11,  43, false,    2,     3 },
  { 3089,     0,       1,      2,  31, false,    3,    12 },
  { 3089,     0,       2,      5,  77, false,   12,   128 },
  { 3089,     2,       1,     11,  21, false,  128,   129 },
  { 3089,     2,       1,     11,  20, false,  129,   130 },
  { 3089,     2,       1,     11,  22, false,  130,   131 }
};
const uint8_t g_pEm9304PatchesHCICmd[131][68] =
{
  { 0x27, 0xFC,     // HCI Vendor Specific Command EM_WritePatchStart
    0x25,           // HCI Parameter Length
    0x00,           // Destination Memory (0 = IRAM1; 1 = OTP)
    0xF5, 0x5E, 0xFC, 0xF9,     // CRC32
    0x33, 0x39, 0x6D, 0x65, 0x20, 0x00, 0x00, 0x00,
    0x01, 0x0B, 0x18, 0x14, 0x11, 0x0C, 0x02, 0x00,
    0x75, 0xDE, 0xC7, 0x98, 0x81, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00
  },
  { 0x27, 0xFC,     // HCI Vendor Specific Command EM_WritePatchStart
    0x25,           // HCI Parameter Length
    0x00,           // Destination Memory (0 = IRAM1; 1 = OTP)
    0x52, 0xBF, 0x30, 0xDC,     // CRC32
    0x33, 0x39, 0x6D, 0x65, 0x20, 0x00, 0x00, 0x00,
    0x01, 0x0B, 0x17, 0x14, 0x11, 0x0C, 0x02, 0x00,
    0xDA, 0xEE, 0xE9, 0x81, 0x81, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00
  },
  { 0x27, 0xFC,     // HCI Vendor Specific Command EM_WritePatchStart
    0x25,           // HCI Parameter Length
    0x00,           // Destination Memory (0 = IRAM1; 1 = OTP)
    0x33, 0x10, 0x0A, 0x64,     // CRC32
    0x33, 0x39, 0x6D, 0x65, 0x20, 0x00, 0x00, 0x00,
    0x01, 0x0B, 0x2B, 0x14, 0x11, 0x0C, 0x00, 0x00,
    0xEF, 0xDD, 0xB1, 0xFB, 0x1C, 0x01, 0x00, 0x00,
    0x02, 0x00, 0x00, 0x00, 0xE2, 0x04, 0x00, 0x00
  },
  { 0x27, 0xFC,     // HCI Vendor Specific Command EM_WritePatchStart
    0x40,           // HCI Parameter Length
    0x00,           // Destination Memory (0 = IRAM1; 1 = OTP)
    0x73, 0xAB, 0x2C, 0xEB,     // CRC32
    0x33, 0x39, 0x6D, 0x65, 0xFC, 0x01, 0x00, 0x00,
    0x01, 0x02, 0x1F, 0x14, 0x11, 0x0C, 0x00, 0x00,
    0xCA, 0x1B, 0xBC, 0x63, 0x44, 0x58, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x40, 0x54, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x44, 0x54, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x48, 0x54, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x4C, 0x54, 0x80, 0x00,
    0x00, 0x00, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x01, 0x00,         // Sequence Number
    0xE6, 0x45, 0x4D, 0x75,     // CRC32
    0x00, 0x50, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x54, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x58, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x5C, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x60, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x64, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x68, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x6C
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x02, 0x00,         // Sequence Number
    0x3D, 0xAF, 0x20, 0xCC,     // CRC32
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88,
    0x54, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x03, 0x00,         // Sequence Number
    0x2D, 0xE8, 0x17, 0xF2,     // CRC32
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8C, 0x54, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x54, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x54, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0x54, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9C, 0x54, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x54, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xA4, 0x54, 0x80,
    0x00, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x04, 0x00,         // Sequence Number
    0xED, 0x7B, 0xA2, 0x4F,     // CRC32
    0x00, 0x00, 0x00, 0xA8, 0x54, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xAC, 0x54, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xB0, 0x54, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xB4, 0x54, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xB8, 0x54, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xBC, 0x54, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xC0, 0x54, 0x80, 0x00, 0x00,
    0x00, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x05, 0x00,         // Sequence Number
    0xBD, 0xEF, 0xE0, 0xB2,     // CRC32
    0x00, 0xC4, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xC8, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xCC, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xD0, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xD4, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xD8, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xDC, 0x54, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xE0
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x06, 0x00,         // Sequence Number
    0x9D, 0xC5, 0x68, 0x5E,     // CRC32
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF4,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8,
    0x54, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
    0x54, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x07, 0x00,         // Sequence Number
    0x7F, 0x88, 0xA8, 0x66,     // CRC32
    0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x56, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0x56, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9C, 0x56, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x56, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xA4, 0x56, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xA8, 0x56, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xAC, 0x56, 0x80,
    0x00, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x31,           // HCI Parameter Length
    0x08, 0x00,         // Sequence Number
    0xEA, 0x31, 0x8B, 0x2B,     // CRC32
    0x00, 0x00, 0x00, 0xB0, 0x56, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xB4, 0x56, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xB8, 0x56, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xBC, 0x56, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xC0, 0x56, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00
  },
  { 0x27, 0xFC,     // HCI Vendor Specific Command EM_WritePatchStart
    0x40,           // HCI Parameter Length
    0x00,           // Destination Memory (0 = IRAM1; 1 = OTP)
    0xC0, 0x77, 0xBB, 0x15,     // CRC32
    0x33, 0x39, 0x6D, 0x65, 0x3C, 0x1A, 0x00, 0x00,
    0x02, 0x05, 0x4D, 0x14, 0x11, 0x0C, 0x00, 0x00,
    0x0B, 0x60, 0xB8, 0xCA, 0x2B, 0x00, 0x00, 0x00,
    0x22, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00,
    0x24, 0x00, 0x00, 0x00, 0x8F, 0x00, 0x00, 0x00,
    0xA2, 0x00, 0x00, 0x00, 0xAD, 0x00, 0x00, 0x00,
    0xB8, 0x00, 0x00, 0x00, 0xC9, 0x00, 0x00, 0x00,
    0xE2, 0x00, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x01, 0x00,         // Sequence Number
    0x5F, 0x18, 0x85, 0x4F,     // CRC32
    0x00, 0xF8, 0x00, 0x00, 0x00, 0x16, 0x01, 0x00,
    0x00, 0x1F, 0x01, 0x00, 0x00, 0x21, 0x01, 0x00,
    0x00, 0x55, 0x01, 0x00, 0x00, 0x6F, 0x01, 0x00,
    0x00, 0x9B, 0x01, 0x00, 0x00, 0xA1, 0x01, 0x00,
    0x00, 0xA6, 0x01, 0x00, 0x00, 0xA9, 0x01, 0x00,
    0x00, 0xAA, 0x01, 0x00, 0x00, 0xAC, 0x01, 0x00,
    0x00, 0xBC, 0x01, 0x00, 0x00, 0xBE, 0x01, 0x00,
    0x00, 0xC4
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x02, 0x00,         // Sequence Number
    0x54, 0x91, 0x92, 0xA7,     // CRC32
    0x01, 0x00, 0x00, 0xC6, 0x01, 0x00, 0x00, 0xDD,
    0x01, 0x00, 0x00, 0xDE, 0x01, 0x00, 0x00, 0xDF,
    0x01, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0xE7,
    0x01, 0x00, 0x00, 0xE8, 0x01, 0x00, 0x00, 0xE9,
    0x01, 0x00, 0x00, 0xF8, 0x01, 0x00, 0x00, 0x1A,
    0x02, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00, 0x43,
    0x02, 0x00, 0x00, 0x58, 0x02, 0x00, 0x00, 0x6C,
    0x02, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x03, 0x00,         // Sequence Number
    0xA7, 0x6A, 0x9A, 0x13,     // CRC32
    0x00, 0xAD, 0x02, 0x00, 0x00, 0xC0, 0x02, 0x00,
    0x00, 0xFB, 0x02, 0x00, 0x00, 0x18, 0x03, 0x00,
    0x00, 0x41, 0x03, 0x00, 0x00, 0x54, 0x02, 0x00,
    0x00, 0x68, 0x02, 0x00, 0x00, 0x7C, 0x02, 0x00,
    0x00, 0x90, 0x02, 0x00, 0x00, 0x98, 0x02, 0x00,
    0x00, 0x70, 0x03, 0x00, 0x00, 0xAC, 0x03, 0x00,
    0x00, 0x38, 0x05, 0x00, 0x00, 0x64, 0x05, 0x00,
    0x00, 0xF0
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x04, 0x00,         // Sequence Number
    0x88, 0x07, 0x43, 0x38,     // CRC32
    0x05, 0x00, 0x00, 0x10, 0x06, 0x00, 0x00, 0xCC,
    0x06, 0x00, 0x00, 0x78, 0x07, 0x00, 0x00, 0xD4,
    0x07, 0x00, 0x00, 0x18, 0x08, 0x00, 0x00, 0x58,
    0x08, 0x00, 0x00, 0x0C, 0x09, 0x00, 0x00, 0xA8,
    0x09, 0x00, 0x00, 0x94, 0x0C, 0x00, 0x00, 0x7C,
    0x0D, 0x00, 0x00, 0x98, 0x0D, 0x00, 0x00, 0x38,
    0x0E, 0x00, 0x00, 0x10, 0x0F, 0x00, 0x00, 0x18,
    0x11, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x05, 0x00,         // Sequence Number
    0x0C, 0xC6, 0xA2, 0x82,     // CRC32
    0x00, 0x24, 0x11, 0x00, 0x00, 0x4C, 0x12, 0x00,
    0x00, 0x60, 0x12, 0x00, 0x00, 0x78, 0x12, 0x00,
    0x00, 0x8C, 0x12, 0x00, 0x00, 0xA0, 0x12, 0x00,
    0x00, 0xB4, 0x12, 0x00, 0x00, 0xC8, 0x12, 0x00,
    0x00, 0xDC, 0x12, 0x00, 0x00, 0xF0, 0x12, 0x00,
    0x00, 0x04, 0x13, 0x00, 0x00, 0x60, 0x13, 0x00,
    0x00, 0x80, 0x15, 0x00, 0x00, 0xBC, 0x15, 0x00,
    0x00, 0x0C
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x06, 0x00,         // Sequence Number
    0xA1, 0x65, 0x84, 0x4E,     // CRC32
    0x16, 0x00, 0x00, 0x64, 0x16, 0x00, 0x00, 0xE0,
    0x17, 0x00, 0x00, 0x08, 0x18, 0x00, 0x00, 0x34,
    0x18, 0x00, 0x00, 0xA8, 0x18, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x40, 0x00, 0x00, 0x00, 0x60, 0x00, 0x30,
    0x00, 0x00, 0x00, 0x5A, 0x02, 0x00, 0x44, 0xCC,
    0x2C, 0x01
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x07, 0x00,         // Sequence Number
    0x8C, 0x7D, 0x3D, 0xC0,     // CRC32
    0x00, 0x6A, 0x02, 0x00, 0x44, 0x6C, 0x2C, 0x01,
    0x00, 0xA2, 0x02, 0x00, 0x44, 0x6C, 0x2C, 0x01,
    0x00, 0xCE, 0x02, 0x00, 0x44, 0xE0, 0x62, 0x00,
    0x00, 0xE6, 0x02, 0x00, 0x44, 0x04, 0x71, 0x00,
    0x00, 0xF8, 0x02, 0x00, 0x44, 0xE8, 0x59, 0x00,
    0x00, 0x00, 0x03, 0x00, 0x44, 0xE0, 0x62, 0x00,
    0x00, 0xC8, 0x03, 0x00, 0x44, 0xA0, 0x6F, 0x00,
    0x00, 0xD8
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x08, 0x00,         // Sequence Number
    0xBC, 0xD7, 0xA8, 0xAD,     // CRC32
    0x03, 0x00, 0x44, 0x0C, 0x2C, 0x01, 0x00, 0xF8,
    0x03, 0x00, 0x44, 0xA0, 0x2C, 0x01, 0x00, 0x2C,
    0x06, 0x00, 0x6C, 0xB4, 0x11, 0x00, 0x00, 0x4E,
    0x07, 0x00, 0x44, 0x64, 0xC0, 0x00, 0x00, 0x76,
    0x07, 0x00, 0x6D, 0x00, 0x00, 0x00, 0x00, 0x82,
    0x07, 0x00, 0x6D, 0x20, 0x00, 0x00, 0x00, 0x9A,
    0x07, 0x00, 0x6C, 0x80, 0x18, 0x00, 0x00, 0xA6,
    0x07, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x09, 0x00,         // Sequence Number
    0x5B, 0xA5, 0x3C, 0x30,     // CRC32
    0x6C, 0x78, 0x18, 0x00, 0x00, 0xCE, 0x07, 0x00,
    0x44, 0x24, 0xDF, 0x00, 0x00, 0xE6, 0x07, 0x00,
    0x44, 0xE4, 0x2C, 0x01, 0x00, 0x98, 0x08, 0x00,
    0x6C, 0x24, 0x09, 0x00, 0x00, 0x9C, 0x08, 0x00,
    0x40, 0x20, 0xBB, 0x01, 0x00, 0xDE, 0x08, 0x00,
    0x6D, 0x00, 0x00, 0x00, 0x00, 0xE4, 0x08, 0x00,
    0x6D, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x08, 0x00,
    0x44, 0x30
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x0A, 0x00,         // Sequence Number
    0x7D, 0xB5, 0xF7, 0xCE,     // CRC32
    0xCF, 0x01, 0x00, 0x28, 0x09, 0x00, 0x6C, 0x98,
    0x18, 0x00, 0x00, 0xA6, 0x09, 0x00, 0x44, 0x8C,
    0xD0, 0x01, 0x00, 0x64, 0x0A, 0x00, 0x44, 0x8C,
    0xD0, 0x01, 0x00, 0xA4, 0x0A, 0x00, 0x44, 0x8C,
    0xD0, 0x01, 0x00, 0xE4, 0x0A, 0x00, 0x44, 0x8C,
    0xD0, 0x01, 0x00, 0x28, 0x0C, 0x00, 0x44, 0xE0,
    0x62, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x44, 0xE0,
    0x62, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x0B, 0x00,         // Sequence Number
    0x99, 0xD1, 0xFC, 0x15,     // CRC32
    0x00, 0x0E, 0x0D, 0x00, 0x44, 0x54, 0x10, 0x01,
    0x00, 0x2A, 0x0E, 0x00, 0x44, 0xE0, 0x62, 0x00,
    0x00, 0x60, 0x0E, 0x00, 0x44, 0xE0, 0x62, 0x00,
    0x00, 0x80, 0x0E, 0x00, 0x44, 0xE0, 0x62, 0x00,
    0x00, 0x62, 0x10, 0x00, 0x44, 0x14, 0x13, 0x01,
    0x00, 0x74, 0x10, 0x00, 0x44, 0x14, 0x13, 0x01,
    0x00, 0xC0, 0x10, 0x00, 0x44, 0xC4, 0x1F, 0x01,
    0x00, 0x24
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x0C, 0x00,         // Sequence Number
    0x62, 0x44, 0x80, 0x62,     // CRC32
    0x11, 0x00, 0x44, 0x74, 0x20, 0x01, 0x00, 0x6A,
    0x11, 0x00, 0x44, 0x24, 0x70, 0x00, 0x00, 0xB8,
    0x11, 0x00, 0x44, 0x78, 0x4C, 0x01, 0x00, 0xEC,
    0x11, 0x00, 0x44, 0x3C, 0x2E, 0x01, 0x00, 0x1C,
    0x12, 0x00, 0x44, 0xF0, 0x23, 0x00, 0x00, 0x0A,
    0x13, 0x00, 0x44, 0x8C, 0x8E, 0x01, 0x00, 0x54,
    0x16, 0x00, 0x6C, 0x74, 0x18, 0x00, 0x00, 0xF2,
    0x17, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x0D, 0x00,         // Sequence Number
    0xF1, 0x7F, 0xF5, 0x4F,     // CRC32
    0x44, 0x90, 0xDB, 0x01, 0x00, 0x78, 0x18, 0x00,
    0x10, 0x5C, 0x07, 0x00, 0x00, 0x88, 0x18, 0x00,
    0x10, 0xA0, 0x08, 0x00, 0x00, 0x98, 0x18, 0x00,
    0x10, 0x84, 0x18, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
    0xFF, 0x00, 0x00, 0x00, 0x00, 0xE4, 0xC3, 0xAC,
    0xC1, 0xCB, 0x45, 0x80, 0x00, 0xE0, 0x02, 0xC0,
    0x85, 0x80, 0xC4, 0x80, 0xA5, 0x02, 0x58, 0xC0,
    0xA5, 0xC4
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x0E, 0x00,         // Sequence Number
    0xD3, 0xDA, 0x36, 0xCA,     // CRC32
    0xC7, 0xE0, 0x78, 0xE4, 0xC3, 0xBC, 0xC1, 0xCB,
    0x45, 0x80, 0x00, 0xE0, 0x02, 0xC0, 0x85, 0x80,
    0xC4, 0x80, 0xA5, 0x00, 0x58, 0xC0, 0xA5, 0xC4,
    0xC7, 0xE0, 0x78, 0xE4, 0xC3, 0xBC, 0xC1, 0xCB,
    0x45, 0x80, 0x00, 0xE0, 0x02, 0xC0, 0x85, 0x80,
    0xC4, 0x80, 0xA5, 0x01, 0x58, 0xC0, 0xA5, 0xC4,
    0xC7, 0xE0, 0x78, 0x00, 0x18, 0x43, 0x02, 0xE0,
    0x7F, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x0F, 0x00,         // Sequence Number
    0x21, 0x9B, 0xEF, 0x7E,     // CRC32
    0x19, 0x43, 0x02, 0xE0, 0x78, 0xEA, 0xC3, 0xA1,
    0xC1, 0x08, 0x47, 0x07, 0x5B, 0xCB, 0x46, 0x80,
    0x00, 0x54, 0x06, 0x00, 0x86, 0xD3, 0x40, 0x01,
    0x00, 0x6C, 0x06, 0x99, 0x08, 0x30, 0x00, 0xAD,
    0x70, 0x80, 0xC0, 0xC9, 0x58, 0x22, 0x86, 0x08,
    0x43, 0x0C, 0x77, 0xC1, 0x42, 0x23, 0x81, 0x71,
    0x71, 0xCA, 0x23, 0x45, 0x10, 0x54, 0x23, 0x08,
    0x1A, 0x07
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x10, 0x00,         // Sequence Number
    0x1A, 0x6A, 0x23, 0xF0,     // CRC32
    0x00, 0x00, 0x00, 0x44, 0x6B, 0x60, 0x82, 0x12,
    0xEB, 0x40, 0x83, 0xF9, 0x0A, 0xE0, 0x83, 0x2C,
    0x70, 0x83, 0x82, 0x11, 0x74, 0x02, 0x24, 0xCC,
    0x12, 0xCA, 0x21, 0x0D, 0x03, 0x23, 0xA2, 0x30,
    0x70, 0xCA, 0x20, 0x4D, 0x00, 0xCA, 0x25, 0x8D,
    0x10, 0xEE, 0xF1, 0x22, 0x87, 0x40, 0x27, 0x11,
    0x14, 0x30, 0x70, 0x23, 0xA7, 0xC1, 0x40, 0x22,
    0x41, 0x76
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x11, 0x00,         // Sequence Number
    0x11, 0x03, 0x56, 0xB3,     // CRC32
    0x0A, 0x6E, 0x09, 0xCA, 0x25, 0xCD, 0x13, 0x88,
    0xE8, 0x4C, 0x70, 0xC1, 0x40, 0x22, 0x41, 0x06,
    0x0A, 0x6E, 0x09, 0xE4, 0xA7, 0x00, 0xC1, 0xC3,
    0x40, 0x80, 0x00, 0xF8, 0x02, 0x3F, 0x0D, 0xE0,
    0x13, 0x20, 0xA0, 0x02, 0x86, 0x37, 0x08, 0xC0,
    0x03, 0xC3, 0x40, 0x80, 0x00, 0xF4, 0x02, 0x20,
    0xA0, 0x03, 0x85, 0x00, 0x1E, 0x00, 0x70, 0x80,
    0x00, 0xFC
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x12, 0x00,         // Sequence Number
    0xDF, 0x98, 0xC0, 0x5F,     // CRC32
    0x02, 0x17, 0xF0, 0x02, 0x87, 0xE4, 0xA7, 0xA8,
    0x4F, 0x03, 0xA7, 0x4C, 0x70, 0xCE, 0x09, 0x6E,
    0x09, 0xC1, 0x40, 0xE2, 0xA6, 0xCE, 0x58, 0x42,
    0x87, 0x02, 0x40, 0xE1, 0x41, 0xC3, 0x58, 0x07,
    0xF0, 0xCF, 0x58, 0xA2, 0xA6, 0x43, 0x85, 0x02,
    0x40, 0xA1, 0x41, 0xC3, 0x58, 0x08, 0x5B, 0xCA,
    0xC7, 0xE0, 0x78, 0xE2, 0xC2, 0x08, 0x45, 0x09,
    0xD8, 0x16
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x13, 0x00,         // Sequence Number
    0x08, 0x28, 0x2E, 0x1F,     // CRC32
    0x08, 0x2E, 0x03, 0x2C, 0x71, 0xC3, 0x40, 0x80,
    0x00, 0xC0, 0x09, 0x20, 0x80, 0x00, 0x8D, 0x0E,
    0xE9, 0x20, 0x89, 0x19, 0x08, 0x41, 0x00, 0x22,
    0x0E, 0x4E, 0x03, 0xC3, 0x41, 0x80, 0x00, 0xE5,
    0x06, 0x00, 0x89, 0x80, 0xB8, 0x00, 0xA9, 0x05,
    0xF0, 0xF2, 0x0E, 0xAE, 0x02, 0x2C, 0x70, 0x09,
    0xD8, 0xE2, 0x0F, 0xEE, 0x02, 0x2C, 0x70, 0xC2,
    0xC6, 0xEA
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x14, 0x00,         // Sequence Number
    0x02, 0x14, 0x46, 0x28,     // CRC32
    0xC2, 0x8A, 0x20, 0x07, 0x2D, 0x00, 0x20, 0x10,
    0x20, 0x08, 0x46, 0xF1, 0x10, 0x80, 0xA0, 0x0B,
    0x08, 0xB1, 0x0F, 0x28, 0x47, 0xF1, 0x18, 0x03,
    0xA2, 0x01, 0x8E, 0x0D, 0x08, 0x11, 0x04, 0x01,
    0x8F, 0x04, 0xE8, 0xE5, 0x1E, 0x43, 0x10, 0x09,
    0xEA, 0x93, 0x16, 0x80, 0x10, 0x54, 0x72, 0x04,
    0x71, 0x93, 0x1E, 0x02, 0x10, 0xA7, 0xF2, 0x76,
    0xF0, 0x93
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x15, 0x00,         // Sequence Number
    0x19, 0x26, 0xBD, 0x3B,     // CRC32
    0x1E, 0x03, 0x10, 0x20, 0x8E, 0x49, 0xD8, 0xAA,
    0x58, 0x00, 0x8F, 0x01, 0x10, 0x81, 0x20, 0x22,
    0xB8, 0xC0, 0xB8, 0x0D, 0x08, 0x61, 0x00, 0xC1,
    0x40, 0xB5, 0x59, 0x08, 0xF0, 0x79, 0x21, 0x40,
    0x00, 0x01, 0x18, 0x02, 0x20, 0xC1, 0x40, 0xB4,
    0x59, 0x00, 0x8F, 0x00, 0x10, 0x81, 0x20, 0x23,
    0xB8, 0x41, 0x29, 0x02, 0x01, 0xC0, 0xBA, 0xC0,
    0xB8, 0xAD
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x16, 0x00,         // Sequence Number
    0xB9, 0x8D, 0xBF, 0x97,     // CRC32
    0x08, 0xA1, 0x00, 0x50, 0x21, 0x00, 0x01, 0x84,
    0xB9, 0x54, 0x70, 0xCA, 0x20, 0x41, 0x00, 0x00,
    0x18, 0x02, 0x20, 0x01, 0x8F, 0x99, 0x08, 0x10,
    0x00, 0x14, 0x10, 0x80, 0x20, 0x3B, 0x08, 0x1E,
    0x01, 0x9D, 0x16, 0x00, 0x16, 0x14, 0x77, 0x05,
    0xF2, 0x04, 0x71, 0x9D, 0x1E, 0x18, 0x10, 0x0E,
    0xF0, 0xC1, 0x40, 0x9D, 0x1E, 0x19, 0x10, 0x80,
    0x20, 0x49
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x17, 0x00,         // Sequence Number
    0xF3, 0x86, 0xCC, 0x61,     // CRC32
    0x0C, 0x20, 0x88, 0xFE, 0xE1, 0x04, 0xF7, 0x24,
    0x71, 0x20, 0xA8, 0x04, 0xF0, 0x00, 0x18, 0x03,
    0x00, 0xDA, 0x0B, 0x4E, 0x03, 0xC1, 0x08, 0x30,
    0x00, 0x3D, 0xD8, 0xC3, 0x40, 0x80, 0x00, 0x68,
    0x08, 0x36, 0x08, 0x6E, 0x09, 0x10, 0x41, 0xA0,
    0x80, 0x58, 0x16, 0x01, 0x11, 0x00, 0x85, 0x21,
    0xB0, 0x20, 0x8F, 0x04, 0x76, 0x24, 0xAD, 0x41,
    0x8F, 0x22
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x18, 0x00,         // Sequence Number
    0x4B, 0xDC, 0x49, 0xBF,     // CRC32
    0x6F, 0x43, 0xB5, 0x1E, 0x58, 0x9C, 0x4D, 0xAA,
    0x08, 0x6E, 0x09, 0x40, 0x21, 0x00, 0x21, 0x04,
    0x8D, 0xC1, 0xB8, 0x1F, 0x08, 0xD1, 0x00, 0x40,
    0x85, 0x06, 0x8A, 0x17, 0x08, 0xB1, 0x00, 0xC1,
    0x40, 0x80, 0x20, 0x87, 0x0D, 0x20, 0x88, 0x85,
    0xB9, 0x20, 0xA8, 0x07, 0x8A, 0xF1, 0x18, 0x02,
    0xA0, 0x20, 0x8E, 0x22, 0xD8, 0xA9, 0x58, 0x93,
    0x16, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x19, 0x00,         // Sequence Number
    0xC0, 0xCE, 0x4C, 0x5E,     // CRC32
    0x10, 0x0F, 0x78, 0x2B, 0x08, 0x95, 0x00, 0x01,
    0x8E, 0x17, 0x08, 0x11, 0x08, 0x00, 0x8F, 0x13,
    0x08, 0x3F, 0x01, 0xC1, 0x40, 0x80, 0x20, 0x87,
    0x0D, 0x00, 0x88, 0x13, 0x08, 0x1E, 0x00, 0x32,
    0xD8, 0x02, 0xAE, 0xC1, 0x40, 0xA6, 0x59, 0x13,
    0x08, 0x51, 0x00, 0x2C, 0x71, 0xC1, 0x40, 0xA9,
    0x59, 0x20, 0x8E, 0x4A, 0xD8, 0xAA, 0x58, 0x20,
    0x8F, 0xC3
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x1A, 0x00,         // Sequence Number
    0x75, 0x62, 0x45, 0x0D,     // CRC32
    0x40, 0x80, 0x00, 0x64, 0x08, 0x20, 0xA8, 0x01,
    0x8E, 0x1F, 0x08, 0x11, 0x04, 0x95, 0x16, 0x80,
    0x10, 0x0F, 0x08, 0x50, 0x00, 0x13, 0x08, 0xD1,
    0x00, 0x95, 0x1E, 0x43, 0x10, 0x7A, 0x16, 0x00,
    0x11, 0x96, 0x1E, 0x04, 0x10, 0xCA, 0xC6, 0xF1,
    0x18, 0x02, 0xA0, 0xC1, 0x40, 0x9D, 0x59, 0xCA,
    0xC6, 0xE0, 0x78, 0xE2, 0xC3, 0xA1, 0xC1, 0x08,
    0x45, 0xC3
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x1B, 0x00,         // Sequence Number
    0x31, 0x4D, 0x92, 0x6D,     // CRC32
    0x40, 0xF0, 0x00, 0x08, 0x18, 0x80, 0xC1, 0xAA,
    0x5A, 0x00, 0xA5, 0xC3, 0x40, 0x80, 0x00, 0xF4,
    0x02, 0x20, 0x80, 0x00, 0xC0, 0x22, 0x78, 0x49,
    0x28, 0x01, 0x06, 0x45, 0x28, 0x00, 0x06, 0x8B,
    0xE1, 0xC0, 0x20, 0x6D, 0x00, 0xC2, 0xC7, 0xE0,
    0x78, 0xE8, 0xC3, 0xA1, 0xC1, 0xCB, 0x45, 0x80,
    0x00, 0x18, 0x03, 0x00, 0x8D, 0x50, 0x40, 0x2B,
    0x08, 0xB0
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x1C, 0x00,         // Sequence Number
    0xDA, 0x27, 0xF8, 0x11,     // CRC32
    0x00, 0x28, 0x47, 0x49, 0x08, 0x71, 0x00, 0xCD,
    0x71, 0x09, 0x5B, 0x8E, 0x59, 0x01, 0xA5, 0x0A,
    0x5B, 0x01, 0x85, 0x2F, 0xE8, 0xCD, 0x70, 0x00,
    0xA7, 0x00, 0x18, 0xC1, 0x20, 0xC1, 0xB5, 0x01,
    0x1D, 0x83, 0x10, 0x2B, 0xF0, 0x08, 0x8D, 0x43,
    0x08, 0x70, 0x00, 0x12, 0xDE, 0xFC, 0x5A, 0x8F,
    0x59, 0x01, 0xA5, 0xFD, 0x5A, 0x01, 0x85, 0x11,
    0xDE, 0x19
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x1D, 0x00,         // Sequence Number
    0x65, 0x8C, 0xFF, 0xB5,     // CRC32
    0xE8, 0xCD, 0x70, 0x00, 0xA7, 0x00, 0x18, 0x01,
    0x21, 0xC1, 0xB5, 0x01, 0x1D, 0xC3, 0x10, 0x19,
    0xF0, 0x03, 0x1C, 0xC3, 0x30, 0xA0, 0xA7, 0x00,
    0x18, 0x80, 0x23, 0x08, 0x15, 0x84, 0x10, 0x10,
    0xD8, 0x2C, 0x71, 0x40, 0x24, 0xC2, 0x30, 0x6C,
    0x70, 0xA1, 0x58, 0x90, 0x59, 0x09, 0xF0, 0xA0,
    0xA7, 0x00, 0x18, 0x41, 0x20, 0x05, 0xF0, 0xA0,
    0xA7, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x1E, 0x00,         // Sequence Number
    0xB7, 0x08, 0x67, 0xA9,     // CRC32
    0x18, 0x41, 0x20, 0x11, 0xDE, 0xC1, 0x40, 0xC8,
    0xC7, 0xE0, 0x78, 0xE2, 0xC2, 0xCB, 0x45, 0x80,
    0x00, 0xB0, 0x09, 0x04, 0x85, 0x02, 0x88, 0x09,
    0x08, 0xB0, 0x0C, 0x0C, 0x71, 0xDE, 0x5A, 0x24,
    0x95, 0x00, 0x85, 0xC3, 0x42, 0x01, 0x00, 0xA0,
    0x30, 0xD6, 0x5A, 0xC2, 0xC6, 0xE0, 0x78, 0xE4,
    0xC3, 0xA5, 0xC1, 0x28, 0x45, 0x84, 0xC1, 0x08,
    0x46, 0x3A
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x1F, 0x00,         // Sequence Number
    0xB1, 0xCF, 0xCB, 0xFD,     // CRC32
    0x59, 0x14, 0x70, 0x0C, 0x71, 0x56, 0xF4, 0x0A,
    0xD8, 0xD7, 0x59, 0x14, 0x73, 0x0C, 0x73, 0x52,
    0xF2, 0x04, 0xC0, 0x02, 0x88, 0x63, 0x08, 0x50,
    0x00, 0xB8, 0xE8, 0x60, 0xC6, 0x28, 0xBE, 0x01,
    0x1C, 0x82, 0x33, 0x00, 0x95, 0x80, 0xC2, 0x02,
    0x1C, 0x02, 0x30, 0x28, 0xB8, 0x03, 0x1C, 0x02,
    0x30, 0x01, 0x95, 0x61, 0xC0, 0x28, 0xB8, 0x05,
    0x1C, 0x02
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x20, 0x00,         // Sequence Number
    0x40, 0x29, 0x6F, 0xB9,     // CRC32
    0x30, 0x02, 0x95, 0x06, 0x1C, 0x02, 0x30, 0x28,
    0xB8, 0x07, 0x1C, 0x02, 0x30, 0x03, 0x95, 0x62,
    0xC0, 0x28, 0xB8, 0x09, 0x1C, 0x02, 0x30, 0x24,
    0x95, 0x13, 0xD8, 0x8D, 0xB8, 0x0A, 0x1C, 0x42,
    0x30, 0x28, 0xB9, 0x0B, 0x1C, 0x42, 0x30, 0x65,
    0x95, 0x0E, 0xD9, 0x63, 0xC3, 0x28, 0xBB, 0x0D,
    0x1C, 0xC2, 0x30, 0x4B, 0x59, 0x14, 0x71, 0x0C,
    0x72, 0x20
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x21, 0x00,         // Sequence Number
    0xD2, 0x31, 0xD6, 0x4B,     // CRC32
    0xF4, 0x0A, 0xF0, 0x06, 0x15, 0x04, 0x11, 0x62,
    0x95, 0x41, 0x95, 0x20, 0x95, 0xC1, 0x40, 0x42,
    0x5B, 0x0D, 0x08, 0x51, 0x00, 0x0C, 0x71, 0xD7,
    0x59, 0x0C, 0x71, 0xC4, 0xC7, 0x04, 0xC0, 0xC3,
    0x41, 0x00, 0x00, 0x10, 0x27, 0x69, 0x18, 0x58,
    0x00, 0x68, 0x18, 0x18, 0x00, 0x67, 0x18, 0x98,
    0x0F, 0x40, 0x00, 0xB4, 0x11, 0x80, 0x20, 0x06,
    0x07, 0xCB
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x22, 0x00,         // Sequence Number
    0x71, 0xD2, 0x88, 0x45,     // CRC32
    0x59, 0x0C, 0x72, 0xC4, 0xC7, 0xE0, 0x78, 0xEA,
    0xC2, 0xCD, 0x70, 0xCB, 0x45, 0x80, 0x00, 0x6C,
    0x58, 0x04, 0x15, 0x00, 0x14, 0x05, 0xE8, 0x02,
    0x80, 0x03, 0xE8, 0x40, 0x78, 0xC5, 0x71, 0xF3,
    0x0E, 0x94, 0x94, 0x25, 0x5B, 0x0C, 0x70, 0x3A,
    0x5A, 0x0C, 0x70, 0x36, 0x5A, 0xCB, 0x45, 0xF0,
    0x00, 0x50, 0x04, 0x20, 0x85, 0x00, 0x85, 0xFD,
    0x09, 0x01
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x23, 0x00,         // Sequence Number
    0x10, 0x2D, 0x58, 0xD9,     // CRC32
    0x80, 0xCB, 0x47, 0x80, 0x00, 0x00, 0x5D, 0x20,
    0xA7, 0x12, 0x5B, 0x08, 0x46, 0x14, 0x5B, 0x19,
    0x0E, 0xB0, 0x10, 0x10, 0x41, 0x0C, 0x71, 0x00,
    0x28, 0x40, 0x04, 0xCB, 0xB8, 0x00, 0x1E, 0x00,
    0x70, 0xF0, 0x00, 0xC4, 0x08, 0xC0, 0x15, 0x00,
    0x91, 0x80, 0x25, 0x0F, 0x1C, 0x41, 0x28, 0x01,
    0x03, 0xCB, 0xB8, 0x90, 0x1D, 0x50, 0x10, 0x00,
    0xA5, 0x02
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x24, 0x00,         // Sequence Number
    0xDD, 0x16, 0x21, 0xB1,     // CRC32
    0x5A, 0x06, 0xF0, 0x53, 0x20, 0x10, 0x21, 0x2F,
    0x21, 0x3F, 0x04, 0x2F, 0x27, 0x3F, 0x04, 0x6F,
    0x23, 0x3F, 0x00, 0x24, 0x59, 0x14, 0x70, 0xF6,
    0xF3, 0x2F, 0x26, 0x3F, 0x04, 0xD5, 0x72, 0x2F,
    0x26, 0x3F, 0x04, 0x6F, 0x27, 0x3F, 0x00, 0x6F,
    0x23, 0x3F, 0x00, 0x09, 0xF2, 0x0C, 0x71, 0x00,
    0x28, 0x40, 0x04, 0xCB, 0xB8, 0xF8, 0x1D, 0x00,
    0x90, 0x6F
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x25, 0x00,         // Sequence Number
    0x60, 0x7C, 0xD7, 0x9A,     // CRC32
    0x23, 0x3F, 0x00, 0x00, 0x1F, 0x01, 0x10, 0xCA,
    0xC6, 0xE4, 0xC2, 0xCB, 0x45, 0x80, 0x00, 0x40,
    0x02, 0xC0, 0x85, 0xD5, 0x70, 0x28, 0xF2, 0x00,
    0x16, 0x00, 0x70, 0x80, 0x00, 0x1C, 0x00, 0xCB,
    0x78, 0x0B, 0xF2, 0x00, 0x16, 0x00, 0x70, 0xF0,
    0x00, 0x04, 0x04, 0x2C, 0x73, 0x18, 0xB9, 0x24,
    0x78, 0x07, 0x08, 0x41, 0x00, 0xAD, 0x5A, 0x00,
    0x16, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x26, 0x00,         // Sequence Number
    0x51, 0xFF, 0x0B, 0xD1,     // CRC32
    0x70, 0x80, 0x00, 0x14, 0x00, 0xCB, 0x78, 0x09,
    0xF2, 0x00, 0x16, 0x00, 0x70, 0xF0, 0x00, 0x04,
    0x04, 0x0B, 0x08, 0x1F, 0x07, 0x4E, 0x5A, 0x4F,
    0x5A, 0x2F, 0x27, 0x7F, 0x00, 0x6F, 0x23, 0x3F,
    0x00, 0x00, 0x85, 0xC6, 0x78, 0x00, 0xA5, 0x2F,
    0x26, 0x7F, 0x00, 0xC4, 0xC6, 0xE0, 0x78, 0xE2,
    0xC2, 0x1A, 0x09, 0xEE, 0x05, 0x08, 0x45, 0x03,
    0x8D, 0x83
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x27, 0x00,         // Sequence Number
    0x54, 0x62, 0xFF, 0x8A,     // CRC32
    0xB8, 0x03, 0xAD, 0xC2, 0xC6, 0xE2, 0xC2, 0x00,
    0x16, 0x84, 0x70, 0x80, 0x00, 0x20, 0x03, 0x20,
    0x42, 0x08, 0x45, 0x0F, 0xD8, 0x2C, 0x74, 0x6C,
    0x70, 0xA1, 0x58, 0x23, 0x6D, 0xC3, 0x40, 0x60,
    0x00, 0x00, 0x00, 0x20, 0xDA, 0x1E, 0x58, 0xCB,
    0x4D, 0xC3, 0x40, 0x60, 0x00, 0x20, 0x00, 0x20,
    0xDA, 0x1E, 0x58, 0x3B, 0xD8, 0x95, 0x58, 0x0C,
    0x70, 0xC2
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x28, 0x00,         // Sequence Number
    0x1E, 0x1C, 0xD5, 0xEE,     // CRC32
    0xC6, 0xE0, 0x78, 0xE2, 0xC3, 0xB1, 0xC1, 0xC3,
    0x42, 0x40, 0x00, 0x80, 0x18, 0x08, 0x45, 0x00,
    0x90, 0x40, 0x82, 0xC3, 0x41, 0x40, 0x00, 0x78,
    0x18, 0x61, 0x59, 0x11, 0xE8, 0x8A, 0x21, 0x04,
    0x00, 0x00, 0x1C, 0x44, 0x30, 0x20, 0x95, 0x02,
    0x1C, 0x42, 0x30, 0x28, 0xB9, 0x03, 0x1C, 0x42,
    0x30, 0x40, 0x80, 0x80, 0xC1, 0x60, 0x7A, 0xA1,
    0x40, 0x0C
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x29, 0x00,         // Sequence Number
    0x24, 0x6F, 0x10, 0xCF,     // CRC32
    0x70, 0xC2, 0xC7, 0x5A, 0x0F, 0xAE, 0x06, 0xA1,
    0x40, 0xC2, 0xC7, 0xE0, 0x78, 0xEA, 0xC3, 0xA1,
    0xC1, 0xCB, 0x46, 0x80, 0x00, 0x54, 0x06, 0x08,
    0x45, 0xA8, 0x48, 0x02, 0x0D, 0x2E, 0x09, 0xC1,
    0x40, 0x02, 0x86, 0xA1, 0x08, 0x61, 0x03, 0x80,
    0xC0, 0xC9, 0x58, 0x22, 0x86, 0x10, 0x40, 0x00,
    0xC2, 0x03, 0x81, 0xC3, 0x41, 0x80, 0x00, 0xF8,
    0x02, 0x40
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x2A, 0x00,         // Sequence Number
    0xF6, 0xAD, 0xE1, 0xF0,     // CRC32
    0xA1, 0x12, 0x70, 0xCA, 0x20, 0x05, 0x20, 0xCF,
    0x58, 0xAD, 0x70, 0xC9, 0x47, 0xB1, 0x41, 0x04,
    0xF0, 0x40, 0x81, 0x60, 0x7A, 0x01, 0x81, 0x00,
    0x87, 0x1B, 0xE8, 0x20, 0x80, 0x13, 0x08, 0x30,
    0x20, 0x43, 0x81, 0x15, 0x08, 0xA5, 0x20, 0x02,
    0x22, 0x02, 0x04, 0x43, 0xA1, 0xD0, 0xE2, 0xC5,
    0xF7, 0xE4, 0x68, 0x10, 0x41, 0xF2, 0xF1, 0xA3,
    0xA1, 0x60
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x2B, 0x00,         // Sequence Number
    0xC4, 0xA0, 0xE4, 0x8D,     // CRC32
    0x86, 0x41, 0x80, 0x0F, 0x08, 0xE0, 0x00, 0xE4,
    0x68, 0x04, 0x19, 0x80, 0x20, 0xE5, 0xF1, 0x40,
    0xA6, 0xE3, 0xF1, 0x00, 0x86, 0x0F, 0xE8, 0x2C,
    0x70, 0x60, 0x80, 0x89, 0x69, 0x01, 0x80, 0x43,
    0x83, 0x50, 0x74, 0xCA, 0x25, 0xC6, 0x10, 0xCA,
    0x21, 0x86, 0x00, 0xF8, 0xE8, 0x79, 0x21, 0x00,
    0x00, 0x02, 0xF0, 0x0C, 0x70, 0x0A, 0xED, 0x0A,
    0xE8, 0xA2
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x2C, 0x00,         // Sequence Number
    0x6C, 0xF0, 0x22, 0xFB,     // CRC32
    0xA6, 0x43, 0x85, 0xC3, 0x40, 0x01, 0x00, 0x6C,
    0x06, 0xA1, 0x41, 0xC3, 0x58, 0xCA, 0xC7, 0x08,
    0x1E, 0x01, 0x10, 0xCA, 0xC7, 0xE0, 0x78, 0xC3,
    0x40, 0x80, 0x00, 0xC0, 0x00, 0xC3, 0x41, 0x40,
    0x00, 0x24, 0x09, 0x85, 0x02, 0x8E, 0x0D, 0xF1,
    0xC0, 0x0C, 0x88, 0x39, 0x08, 0xF0, 0x0E, 0xB1,
    0xC1, 0xBA, 0xE0, 0x0C, 0x70, 0x39, 0xF4, 0x40,
    0x24, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x2D, 0x00,         // Sequence Number
    0xB3, 0xBC, 0xA2, 0x32,     // CRC32
    0x30, 0x40, 0x24, 0x81, 0x38, 0x00, 0x1C, 0x03,
    0x32, 0xEA, 0x59, 0x00, 0x16, 0x84, 0x70, 0x80,
    0x00, 0x20, 0x03, 0x14, 0x70, 0x1F, 0xDC, 0xCA,
    0x24, 0x21, 0x10, 0x3E, 0xD8, 0x42, 0xD9, 0x80,
    0xC2, 0x6C, 0x70, 0x01, 0x1C, 0x02, 0x33, 0x21,
    0xF0, 0xC3, 0x40, 0x60, 0x00, 0x00, 0x00, 0xC3,
    0x41, 0x60, 0x00, 0x20, 0x00, 0x40, 0x24, 0x82,
    0x30, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x2E, 0x00,         // Sequence Number
    0x65, 0xC2, 0x7D, 0x89,     // CRC32
    0x1C, 0x43, 0x32, 0xEB, 0x59, 0x0B, 0xE8, 0x40,
    0x24, 0x80, 0x30, 0xFF, 0xD9, 0x20, 0xDA, 0x36,
    0x0E, 0x2E, 0x0E, 0x01, 0x1C, 0x83, 0x34, 0x03,
    0xF0, 0x01, 0x1C, 0x03, 0x30, 0x00, 0x16, 0x84,
    0x70, 0x80, 0x00, 0x20, 0x03, 0x3E, 0xD8, 0x22,
    0xD9, 0x80, 0xC2, 0x6C, 0x70, 0xA1, 0x58, 0x0C,
    0x73, 0xB1, 0xC0, 0xD1, 0xC0, 0xE0, 0x7E, 0x08,
    0x18, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x2F, 0x00,         // Sequence Number
    0xC0, 0x2A, 0x28, 0x49,     // CRC32
    0x0F, 0x40, 0x00, 0x98, 0x18, 0xE0, 0x7F, 0x09,
    0xD8, 0xEA, 0xC3, 0xAA, 0xC1, 0x24, 0x1C, 0x01,
    0x30, 0x08, 0x47, 0x02, 0x88, 0x8A, 0x21, 0x07,
    0x2D, 0x1B, 0x08, 0xB3, 0x06, 0x00, 0x21, 0xD1,
    0x23, 0x99, 0x08, 0x90, 0x00, 0x25, 0x08, 0x30,
    0x04, 0x94, 0xE0, 0x76, 0xF2, 0x1D, 0x08, 0x90,
    0x05, 0xD1, 0xF0, 0x89, 0x08, 0xB0, 0x0C, 0xA2,
    0xE0, 0xCB
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x30, 0x00,         // Sequence Number
    0x61, 0x25, 0x8E, 0xE1,     // CRC32
    0x45, 0x80, 0x00, 0xBC, 0x07, 0x8E, 0xF2, 0xB1,
    0xE0, 0xAB, 0xF2, 0x9A, 0xE0, 0xC7, 0xF4, 0x32,
    0xD5, 0x00, 0x8D, 0x0C, 0xDB, 0xCB, 0x46, 0x80,
    0x00, 0xBE, 0x06, 0x53, 0x68, 0x32, 0x68, 0xC2,
    0xB8, 0x6C, 0x22, 0x42, 0x01, 0x14, 0x71, 0x84,
    0x21, 0x02, 0x00, 0x45, 0x78, 0x25, 0x78, 0x60,
    0xC0, 0x04, 0xF2, 0x00, 0x8E, 0x66, 0x68, 0xE4,
    0x17, 0x10
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x31, 0x00,         // Sequence Number
    0xB9, 0x2B, 0x77, 0x4D,     // CRC32
    0x70, 0x04, 0x10, 0x01, 0x24, 0x40, 0x24, 0x80,
    0x30, 0x4C, 0x76, 0xEA, 0x0E, 0x2E, 0x0E, 0x01,
    0x1C, 0xC2, 0x30, 0x20, 0x8D, 0x53, 0x21, 0x80,
    0x00, 0x61, 0x08, 0x71, 0x00, 0x40, 0x20, 0xC0,
    0x21, 0xC3, 0x40, 0x80, 0x00, 0xA0, 0x09, 0x00,
    0x88, 0x57, 0x08, 0x7E, 0x00, 0x25, 0xB9, 0x89,
    0xC2, 0xC1, 0xB9, 0x02, 0x40, 0x6A, 0x59, 0x4B,
    0x08, 0x71
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x32, 0x00,         // Sequence Number
    0xD1, 0xC3, 0x0D, 0xCD,     // CRC32
    0x00, 0xCD, 0x76, 0x20, 0xC0, 0x87, 0xB8, 0x60,
    0xC0, 0x22, 0xF0, 0x80, 0xC1, 0x89, 0xC2, 0xE1,
    0x40, 0xB0, 0x59, 0x01, 0x14, 0x80, 0x30, 0x06,
    0xE8, 0x01, 0x8F, 0x09, 0x08, 0x11, 0x04, 0xE5,
    0x1F, 0x43, 0x10, 0x02, 0x8F, 0xAD, 0x71, 0x14,
    0x72, 0x83, 0xF4, 0x75, 0x17, 0x82, 0x10, 0x39,
    0x87, 0x18, 0x87, 0x6C, 0x71, 0x60, 0x44, 0xEE,
    0x58, 0x0C
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x33, 0x00,         // Sequence Number
    0xB4, 0x88, 0x73, 0x00,     // CRC32
    0x71, 0xF5, 0x58, 0x87, 0xF0, 0xC0, 0x8E, 0x49,
    0xC0, 0x04, 0xF0, 0xCD, 0x76, 0x24, 0x1C, 0x00,
    0x34, 0x02, 0x8F, 0x0E, 0x70, 0x25, 0xDA, 0x90,
    0xE0, 0x9F, 0xF2, 0x9A, 0xE0, 0x97, 0xF2, 0x96,
    0xE0, 0x97, 0xF4, 0x26, 0xDA, 0x99, 0xF0, 0xE0,
    0x78, 0x77, 0x06, 0x80, 0x00, 0xFC, 0x17, 0x01,
    0xF0, 0x20, 0x89, 0xCB, 0x45, 0x80, 0x00, 0xDE,
    0x06, 0x60
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x34, 0x00,         // Sequence Number
    0xFF, 0xED, 0xA6, 0x53,     // CRC32
    0x8D, 0x03, 0xB9, 0x0C, 0xD4, 0x64, 0x76, 0x84,
    0x21, 0x03, 0x00, 0x01, 0x1C, 0xC2, 0x30, 0x4F,
    0x21, 0x83, 0x00, 0x20, 0x84, 0x40, 0x24, 0x80,
    0x30, 0x4C, 0x76, 0x2A, 0x0E, 0x2E, 0x0E, 0x60,
    0xC3, 0xC0, 0x8D, 0xC3, 0x40, 0x80, 0x00, 0xBF,
    0x06, 0x4A, 0x20, 0x00, 0x22, 0x49, 0xC0, 0xCB,
    0xF0, 0xE0, 0x78, 0x94, 0x06, 0x80, 0x00, 0x20,
    0x85, 0xC3
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x35, 0x00,         // Sequence Number
    0xB9, 0x7E, 0x8F, 0x0B,     // CRC32
    0x43, 0x80, 0x00, 0xE0, 0x06, 0x84, 0x8B, 0x40,
    0x24, 0x80, 0x30, 0x20, 0x89, 0x06, 0xBC, 0x4C,
    0x76, 0x3B, 0x79, 0x84, 0x21, 0x02, 0x00, 0x85,
    0x79, 0x45, 0x21, 0xC1, 0x00, 0x60, 0xC1, 0x20,
    0x83, 0xEA, 0x0D, 0x2E, 0x0E, 0x01, 0x1C, 0x03,
    0x33, 0x20, 0x85, 0x82, 0xC0, 0x4C, 0x76, 0x24,
    0x72, 0x1E, 0x58, 0x4A, 0x20, 0x80, 0x23, 0xCD,
    0x70, 0xA9
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x36, 0x00,         // Sequence Number
    0x8B, 0xD6, 0x50, 0x72,     // CRC32
    0xF0, 0x80, 0x85, 0x6C, 0x8D, 0x25, 0x85, 0x22,
    0xDE, 0x80, 0x8C, 0x03, 0xBB, 0x84, 0x23, 0x03,
    0x00, 0x9B, 0x7C, 0x84, 0x24, 0x02, 0x10, 0x85,
    0x7B, 0x40, 0x24, 0x80, 0x30, 0x4C, 0x76, 0x45,
    0x23, 0x43, 0x01, 0x01, 0x1C, 0x82, 0x33, 0xAA,
    0x0D, 0x2E, 0x0E, 0x60, 0xC3, 0x00, 0x85, 0xA9,
    0x08, 0x30, 0x00, 0x22, 0x68, 0x82, 0xC0, 0x4C,
    0x76, 0x1E
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x37, 0x00,         // Sequence Number
    0xDC, 0x0E, 0xA9, 0xB5,     // CRC32
    0x58, 0x50, 0xF0, 0x0C, 0x70, 0xBB, 0x58, 0xAD,
    0x71, 0x8E, 0xF0, 0xC5, 0x58, 0x24, 0x87, 0x01,
    0x14, 0x83, 0x30, 0x4C, 0x70, 0x02, 0x21, 0x01,
    0x80, 0xE6, 0xD8, 0x76, 0x78, 0xCA, 0x22, 0x4D,
    0x00, 0x10, 0x72, 0x04, 0x01, 0x05, 0x00, 0x00,
    0x11, 0x81, 0x20, 0x01, 0x11, 0x80, 0x20, 0x02,
    0x11, 0x8C, 0x20, 0x22, 0xB9, 0x20, 0xC2, 0x73,
    0x68, 0x44
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x38, 0x00,         // Sequence Number
    0x76, 0xB5, 0x8B, 0x07,     // CRC32
    0x24, 0x40, 0x10, 0x44, 0x21, 0x01, 0x01, 0x94,
    0x68, 0x05, 0x21, 0xC0, 0x00, 0x45, 0x78, 0x85,
    0x78, 0x60, 0xC0, 0x14, 0x11, 0x80, 0x20, 0x01,
    0x14, 0x8E, 0x30, 0xC3, 0x08, 0x3E, 0x01, 0x0E,
    0x72, 0x00, 0x8F, 0x2C, 0x71, 0xAF, 0x59, 0x5B,
    0xF0, 0x27, 0xDA, 0x05, 0xF0, 0x0C, 0x70, 0xBB,
    0x58, 0x0E, 0x71, 0x4C, 0x70, 0x6C, 0x71, 0xC3,
    0x40, 0x89
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x39, 0x00,         // Sequence Number
    0x09, 0x8B, 0x03, 0x51,     // CRC32
    0x8E, 0xD6, 0xBE, 0xC3, 0x41, 0x55, 0x00, 0x55,
    0x55, 0x60, 0x44, 0xEE, 0x58, 0x00, 0x8D, 0xC2,
    0xB8, 0x09, 0x08, 0xB1, 0x00, 0x0C, 0x70, 0x03,
    0xF0, 0x0C, 0x71, 0xF5, 0x58, 0x16, 0x70, 0xAD,
    0x71, 0x4A, 0x20, 0x00, 0x22, 0x46, 0xF4, 0x3F,
    0xF0, 0x0C, 0x70, 0xBB, 0x58, 0x06, 0x85, 0x4E,
    0x95, 0x3E, 0x8D, 0x0E, 0x1C, 0x04, 0x30, 0x30,
    0xB8, 0xCD
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x3A, 0x00,         // Sequence Number
    0xE7, 0x6F, 0x5B, 0xAE,     // CRC32
    0x70, 0x65, 0xC1, 0xC3, 0x43, 0x80, 0x00, 0xE0,
    0x07, 0x12, 0x1C, 0x84, 0x30, 0x10, 0x1C, 0x04,
    0x30, 0x7F, 0x19, 0x03, 0x21, 0x99, 0x1F, 0x9C,
    0x13, 0x82, 0x93, 0x23, 0x93, 0x04, 0x93, 0x51,
    0x95, 0x00, 0x13, 0x8B, 0x00, 0x17, 0x1C, 0x82,
    0x33, 0x66, 0xC4, 0x1A, 0x1C, 0x42, 0x30, 0x67,
    0xC0, 0x20, 0x1C, 0x84, 0x30, 0x50, 0x95, 0x6C,
    0x8B, 0x28
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x3B, 0x00,         // Sequence Number
    0x48, 0x1E, 0xC2, 0xCF,     // CRC32
    0xBC, 0x1E, 0x1C, 0x84, 0x30, 0x55, 0x6B, 0x6D,
    0x8D, 0x28, 0xB9, 0x28, 0xB8, 0x65, 0x7A, 0x15,
    0x1C, 0x03, 0x31, 0x4A, 0x20, 0x00, 0x29, 0x16,
    0x1C, 0x82, 0x33, 0x22, 0x1C, 0xC2, 0x32, 0x19,
    0x1C, 0x02, 0x33, 0x1B, 0x1C, 0x42, 0x30, 0x1D,
    0x1C, 0x02, 0x30, 0x23, 0x1C, 0x82, 0x30, 0x09,
    0xC3, 0x80, 0xC1, 0xE1, 0x40, 0x02, 0x42, 0xC1,
    0x44, 0xB0
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x3C, 0x00,         // Sequence Number
    0x00, 0x66, 0x91, 0xFB,     // CRC32
    0x58, 0x08, 0x45, 0xA1, 0x40, 0xCA, 0xC7, 0xE4,
    0xC2, 0x28, 0x46, 0x08, 0x45, 0x09, 0xD8, 0xBA,
    0x0E, 0xAE, 0x02, 0x2C, 0x71, 0x1F, 0x0E, 0x71,
    0x10, 0xA9, 0x46, 0x80, 0x26, 0x0A, 0x1C, 0xFB,
    0x58, 0x00, 0x1E, 0x05, 0x10, 0xC3, 0x41, 0x80,
    0x00, 0xEC, 0x07, 0x00, 0x89, 0xA3, 0xB8, 0x00,
    0xA9, 0x41, 0x8D, 0x13, 0x0A, 0x30, 0x04, 0x95,
    0xD8, 0x49
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x3D, 0x00,         // Sequence Number
    0x19, 0xF7, 0xEC, 0xB1,     // CRC32
    0x0A, 0x30, 0x08, 0xA1, 0x40, 0x80, 0x20, 0x42,
    0x05, 0x18, 0xF0, 0x95, 0x15, 0x81, 0x10, 0xE5,
    0xDB, 0xB8, 0x60, 0x19, 0x09, 0x70, 0x00, 0xBB,
    0x63, 0x1D, 0x09, 0x11, 0x01, 0xE5, 0x15, 0x81,
    0x10, 0x8A, 0xE9, 0x00, 0x18, 0x43, 0x00, 0x08,
    0xF0, 0xE5, 0x15, 0x81, 0x10, 0x09, 0x09, 0x51,
    0x00, 0x00, 0x18, 0x03, 0x01, 0x00, 0x1B, 0x03,
    0x00, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x3E, 0x00,         // Sequence Number
    0x1C, 0x1B, 0x79, 0x85,     // CRC32
    0x88, 0x0D, 0x08, 0x51, 0x00, 0x6E, 0x15, 0x00,
    0x11, 0x8F, 0xE8, 0x92, 0x15, 0x83, 0x10, 0x77,
    0xDA, 0x54, 0x25, 0x00, 0x1E, 0x54, 0x25, 0xC1,
    0x1E, 0xBA, 0x62, 0xC4, 0xBB, 0xE2, 0x59, 0x41,
    0x8D, 0x75, 0x1D, 0x02, 0x10, 0x49, 0x0A, 0x31,
    0x04, 0x8A, 0x20, 0x0A, 0x02, 0xB8, 0x60, 0x00,
    0x88, 0xC2, 0xB8, 0x23, 0x08, 0x31, 0x01, 0x8A,
    0x20, 0x8A
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x3F, 0x00,         // Sequence Number
    0x1C, 0x3A, 0x2E, 0xAF,     // CRC32
    0x05, 0xB8, 0x60, 0x00, 0x90, 0x7A, 0x15, 0x01,
    0x11, 0x04, 0x77, 0x13, 0x09, 0x21, 0x00, 0xA1,
    0x40, 0x80, 0x20, 0x87, 0x0D, 0x20, 0x88, 0x83,
    0xB9, 0x20, 0xA8, 0x95, 0x15, 0x80, 0x10, 0x15,
    0x08, 0x51, 0x00, 0x6E, 0x15, 0x00, 0x11, 0x14,
    0x70, 0xFC, 0x09, 0x22, 0x00, 0xCA, 0x20, 0x42,
    0x03, 0x09, 0xD8, 0x2C, 0x70, 0x02, 0x1D, 0x43,
    0x10, 0xE2
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x40, 0x00,         // Sequence Number
    0x41, 0x39, 0x8A, 0xF2,     // CRC32
    0x0D, 0xAE, 0x02, 0x93, 0x1D, 0x03, 0x10, 0xC4,
    0xC6, 0xE0, 0x78, 0xE2, 0xC2, 0x4A, 0x0B, 0x2E,
    0x08, 0x08, 0x45, 0x01, 0x8D, 0x15, 0x08, 0x31,
    0x08, 0x80, 0x25, 0x87, 0x1D, 0x00, 0x8D, 0x09,
    0x08, 0xBF, 0x00, 0x0C, 0x71, 0xDE, 0x5A, 0xC2,
    0xC6, 0xE0, 0x78, 0xE6, 0xC2, 0x08, 0x45, 0x8A,
    0x20, 0x8A, 0x03, 0x1E, 0x65, 0xFC, 0x16, 0x00,
    0x91, 0x68
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x41, 0x00,         // Sequence Number
    0x31, 0x29, 0x75, 0xF7,     // CRC32
    0x15, 0x01, 0x11, 0x15, 0x09, 0x21, 0x00, 0xED,
    0x71, 0xFA, 0x16, 0x80, 0x90, 0x23, 0xB8, 0x44,
    0x20, 0x4F, 0x00, 0x0B, 0xF0, 0x68, 0x1D, 0x04,
    0x10, 0x00, 0x96, 0x6C, 0x1D, 0x04, 0x10, 0xFE,
    0x16, 0x00, 0x91, 0x6A, 0x1D, 0x04, 0x10, 0x22,
    0x96, 0x6E, 0x15, 0x00, 0x11, 0x0D, 0x08, 0x40,
    0x00, 0xED, 0x71, 0x20, 0x40, 0x6E, 0x1D, 0x44,
    0x10, 0x03
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x42, 0x00,         // Sequence Number
    0x78, 0xEE, 0x2E, 0xD6,     // CRC32
    0xE8, 0x95, 0x1D, 0xC3, 0x10, 0x03, 0x96, 0x78,
    0x15, 0x01, 0x11, 0x0D, 0x09, 0x00, 0x00, 0xED,
    0x71, 0x00, 0x41, 0x78, 0x1D, 0x04, 0x10, 0xFB,
    0x16, 0x8C, 0x90, 0x01, 0x96, 0x1F, 0x21, 0x83,
    0x0F, 0x00, 0x00, 0x10, 0x27, 0xE5, 0x1E, 0x02,
    0x93, 0x99, 0x1D, 0x1C, 0x10, 0x40, 0x25, 0x02,
    0x1E, 0xC8, 0x4D, 0x8A, 0x24, 0x01, 0x09, 0xA1,
    0x40, 0xA3
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x43, 0x00,         // Sequence Number
    0x44, 0x00, 0x21, 0xDB,     // CRC32
    0x59, 0xFA, 0x16, 0x80, 0x90, 0x09, 0xEF, 0x4F,
    0x20, 0xC1, 0x00, 0xFA, 0x1E, 0x42, 0x90, 0x20,
    0x8D, 0x25, 0xD8, 0xB7, 0x58, 0xC6, 0xC6, 0x6C,
    0x20, 0x80, 0x00, 0xFA, 0x1E, 0x02, 0x90, 0xC6,
    0xC6, 0xE6, 0xC2, 0x08, 0x45, 0x02, 0x88, 0x8A,
    0x26, 0x87, 0x1D, 0x4D, 0x08, 0xB0, 0x0D, 0xBE,
    0x66, 0x6B, 0x08, 0x10, 0x0D, 0x8B, 0x08, 0x91,
    0x00, 0x8B
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x44, 0x00,         // Sequence Number
    0x5D, 0x78, 0x69, 0x77,     // CRC32
    0x0A, 0xD1, 0x02, 0x01, 0x8D, 0x89, 0x08, 0x31,
    0x04, 0x54, 0x25, 0x82, 0x1A, 0x00, 0x8E, 0xFC,
    0x4D, 0x4F, 0x20, 0x4F, 0x00, 0xCB, 0x44, 0x80,
    0x00, 0x0A, 0x00, 0xC3, 0x43, 0x80, 0x00, 0x6C,
    0x00, 0x81, 0x08, 0xFF, 0x00, 0xE0, 0xAE, 0x34,
    0xD8, 0x80, 0x15, 0x0E, 0x10, 0x02, 0xAD, 0x00,
    0x94, 0x60, 0x93, 0x8A, 0x24, 0x81, 0x09, 0xD4,
    0x78, 0x42
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x45, 0x00,         // Sequence Number
    0x03, 0xF6, 0x7A, 0x71,     // CRC32
    0xF0, 0x4F, 0x0A, 0x71, 0x01, 0x08, 0xD8, 0xBA,
    0x0C, 0xAE, 0x02, 0x2C, 0x71, 0x84, 0x15, 0x80,
    0x10, 0x47, 0x08, 0xB5, 0x00, 0x2C, 0x71, 0xA1,
    0x40, 0xA9, 0x59, 0x94, 0x16, 0x00, 0x11, 0x9F,
    0xE8, 0x84, 0x1D, 0x83, 0x10, 0x1B, 0xF0, 0x2B,
    0x0A, 0x51, 0x01, 0x95, 0x15, 0x80, 0x10, 0x0B,
    0x08, 0x50, 0x00, 0x0B, 0x08, 0x11, 0x01, 0x95,
    0x1D, 0xC3
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x46, 0x00,         // Sequence Number
    0x62, 0x77, 0x1A, 0x9D,     // CRC32
    0x10, 0x08, 0xD8, 0x82, 0x0C, 0xAE, 0x02, 0x2C,
    0x71, 0x2C, 0x71, 0xA1, 0x40, 0xA9, 0x59, 0x09,
    0xF0, 0x00, 0x19, 0x43, 0x00, 0xC6, 0xC6, 0x32,
    0xD8, 0x02, 0xAD, 0xC6, 0xC6, 0xA1, 0x40, 0xAE,
    0x59, 0x08, 0xD8, 0x62, 0x0C, 0xAE, 0x02, 0x2C,
    0x70, 0xC6, 0xC6, 0x36, 0xD8, 0x80, 0x15, 0x0F,
    0x10, 0x02, 0xAD, 0x7D, 0x16, 0x80, 0x10, 0x80,
    0x94, 0x60
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x47, 0x00,         // Sequence Number
    0xF4, 0x5A, 0x36, 0xEF,     // CRC32
    0x93, 0x9F, 0x20, 0x93, 0x08, 0x98, 0x60, 0x8A,
    0x24, 0x81, 0x09, 0xF4, 0x78, 0x1B, 0x63, 0xA1,
    0x40, 0xA3, 0x59, 0xC6, 0xC6, 0xF1, 0xC0, 0x62,
    0x88, 0x15, 0x0B, 0x10, 0x08, 0x1F, 0x0B, 0x90,
    0x00, 0x0D, 0x0B, 0x10, 0x05, 0x08, 0xEB, 0x00,
    0x19, 0x43, 0x00, 0x13, 0xF0, 0x13, 0x0A, 0xD0,
    0x02, 0x1F, 0x0A, 0x51, 0x01, 0x02, 0x18, 0x43,
    0x00, 0x0B
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x48, 0x00,         // Sequence Number
    0xBB, 0xD0, 0xC2, 0xE5,     // CRC32
    0xF0, 0x17, 0x0A, 0xD1, 0x02, 0x56, 0x10, 0x81,
    0x00, 0x4C, 0x71, 0x42, 0x21, 0x41, 0x09, 0x38,
    0x7A, 0x4F, 0x79, 0xC0, 0x59, 0xD1, 0xC0, 0xE0,
    0x7E, 0xE0, 0x78, 0xF8, 0xC2, 0x08, 0x45, 0x8A,
    0x20, 0x8A, 0x20, 0x6E, 0x10, 0x00, 0x01, 0x7A,
    0x15, 0x03, 0x11, 0x00, 0x20, 0x50, 0x23, 0x06,
    0x10, 0x82, 0x20, 0x19, 0x63, 0xC1, 0x68, 0xC2,
    0xBA, 0x5D
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x49, 0x00,         // Sequence Number
    0xD9, 0xDB, 0xE3, 0x86,     // CRC32
    0x0A, 0x31, 0x01, 0x24, 0x71, 0x14, 0x10, 0x0C,
    0x21, 0x30, 0x78, 0xCB, 0x43, 0x00, 0x00, 0x00,
    0x80, 0x0F, 0x0C, 0x23, 0x10, 0xED, 0x71, 0x92,
    0x48, 0x0D, 0x0B, 0x84, 0x10, 0x08, 0xF0, 0x12,
    0x4C, 0x0D, 0x0B, 0x84, 0x10, 0x91, 0x70, 0xED,
    0x70, 0x28, 0x44, 0x18, 0xF4, 0xA1, 0x40, 0x80,
    0x20, 0x87, 0x0D, 0x20, 0x88, 0x83, 0xB9, 0x20,
    0xA8, 0x11
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x4A, 0x00,         // Sequence Number
    0xCE, 0x6C, 0x2F, 0x2E,     // CRC32
    0xEF, 0x2C, 0x71, 0x90, 0x78, 0x70, 0x70, 0x56,
    0x01, 0x2E, 0x00, 0x8F, 0xB9, 0x76, 0x48, 0x13,
    0x0E, 0x44, 0x10, 0x07, 0x20, 0x8E, 0x0F, 0x00,
    0x00, 0xFF, 0xFF, 0x7E, 0x66, 0x03, 0xF0, 0x28,
    0x44, 0x00, 0x10, 0x80, 0x20, 0x6E, 0x70, 0xC2,
    0xB8, 0x37, 0x08, 0x31, 0x01, 0x2C, 0x70, 0xA1,
    0x40, 0x80, 0x20, 0x0A, 0x00, 0x00, 0x90, 0x90,
    0x79, 0x49
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x4B, 0x00,         // Sequence Number
    0xAC, 0x5E, 0x38, 0xD8,     // CRC32
    0x68, 0x15, 0x0A, 0x45, 0x00, 0x50, 0x49, 0x2C,
    0x70, 0x1B, 0x08, 0x85, 0x0F, 0x00, 0x00, 0x01,
    0x80, 0x71, 0x4A, 0x09, 0xF0, 0x22, 0x7A, 0x2C,
    0x70, 0x0B, 0x0A, 0x84, 0x0F, 0x00, 0x00, 0x01,
    0x80, 0x11, 0x4B, 0x2F, 0x27, 0x48, 0x90, 0x75,
    0xD8, 0x92, 0xD9, 0x77, 0xDA, 0x54, 0x25, 0xD8,
    0x1E, 0x54, 0x25, 0x17, 0x1E, 0x2F, 0x21, 0x88,
    0x23, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x4C, 0x00,         // Sequence Number
    0xDC, 0xB7, 0x60, 0x99,     // CRC32
    0x25, 0x15, 0x10, 0x00, 0x25, 0x52, 0x10, 0x00,
    0x25, 0x94, 0x10, 0x25, 0xF2, 0x42, 0x27, 0x56,
    0x10, 0xCD, 0x70, 0x00, 0x12, 0x83, 0x20, 0xE2,
    0x40, 0x03, 0x41, 0xC4, 0xBB, 0x82, 0x42, 0xE2,
    0x59, 0x00, 0x1D, 0x02, 0x20, 0x32, 0x77, 0xCC,
    0x26, 0x81, 0x95, 0x06, 0xF2, 0x7A, 0x15, 0x00,
    0x11, 0x04, 0x71, 0x7A, 0x1D, 0x04, 0x10, 0xC5,
    0x71, 0xDD
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x4D, 0x00,         // Sequence Number
    0xC7, 0xA2, 0x44, 0x22,     // CRC32
    0x0E, 0xC4, 0x93, 0xA1, 0x41, 0x4C, 0x75, 0x80,
    0x21, 0xCA, 0x00, 0xE2, 0x40, 0x1E, 0x58, 0x00,
    0x10, 0x80, 0x20, 0x6C, 0x20, 0x80, 0x00, 0x00,
    0x18, 0x02, 0x20, 0x0E, 0x27, 0x4F, 0x14, 0x42,
    0x27, 0x50, 0x10, 0x03, 0xF0, 0x66, 0x71, 0x2F,
    0x26, 0xC8, 0x14, 0x29, 0x0E, 0xE3, 0x13, 0xE2,
    0x40, 0x00, 0x12, 0x83, 0x20, 0x03, 0x41, 0xC4,
    0xBB, 0x82
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x4E, 0x00,         // Sequence Number
    0xA3, 0x28, 0xD8, 0xC9,     // CRC32
    0x42, 0xE2, 0x59, 0xE9, 0x0E, 0x20, 0x94, 0x00,
    0x1D, 0x02, 0x20, 0x7A, 0x15, 0x00, 0x11, 0x04,
    0x71, 0x7A, 0x1D, 0x04, 0x10, 0xEC, 0xF1, 0x5D,
    0x09, 0xB4, 0x20, 0x42, 0x21, 0x4E, 0x20, 0x68,
    0x15, 0x01, 0x11, 0x92, 0x15, 0x80, 0x10, 0x5F,
    0x85, 0x9F, 0x21, 0x93, 0x08, 0x23, 0xA5, 0xCC,
    0x79, 0x25, 0xB8, 0x59, 0x61, 0xB6, 0x0A, 0x2E,
    0x08, 0x3F
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x4F, 0x00,         // Sequence Number
    0xDF, 0xCB, 0x4E, 0x0D,     // CRC32
    0xA5, 0xC3, 0x41, 0x80, 0x00, 0xEC, 0x07, 0x20,
    0x89, 0x08, 0x47, 0xC2, 0xB9, 0xA2, 0x0A, 0x2E,
    0x08, 0x20, 0x40, 0x3F, 0x85, 0xF8, 0x60, 0x63,
    0x85, 0x85, 0x29, 0x0F, 0x0A, 0x40, 0x25, 0x02,
    0x17, 0xCC, 0x7B, 0x8A, 0x24, 0x01, 0x08, 0x63,
    0xA5, 0x2C, 0x78, 0x85, 0x28, 0x0F, 0x0A, 0x24,
    0x6D, 0x80, 0x1D, 0x00, 0x10, 0xA1, 0x40, 0xA3,
    0x59, 0xD8
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x50, 0x00,         // Sequence Number
    0x64, 0x08, 0x0B, 0x5C,     // CRC32
    0xC6, 0x16, 0x4B, 0x30, 0x76, 0xC2, 0x06, 0xC5,
    0xFF, 0x07, 0x23, 0x8E, 0x0F, 0x00, 0x00, 0xFF,
    0xFF, 0x1E, 0x66, 0x59, 0xF1, 0xE0, 0x78, 0xE2,
    0xC2, 0x08, 0x45, 0x0C, 0x71, 0xDE, 0x5A, 0x06,
    0x0F, 0x6E, 0x08, 0xA1, 0x40, 0xC2, 0xC6, 0xE6,
    0xC2, 0x28, 0x47, 0x08, 0x45, 0x8A, 0x26, 0x87,
    0x1D, 0xA7, 0x58, 0x57, 0x08, 0x61, 0x03, 0xBE,
    0x66, 0x21
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x51, 0x00,         // Sequence Number
    0x5C, 0xA9, 0x02, 0xDA,     // CRC32
    0x8D, 0x0B, 0x09, 0x10, 0x08, 0x45, 0x09, 0x31,
    0x04, 0xA1, 0x40, 0x02, 0x8D, 0x45, 0x08, 0x91,
    0x0C, 0x00, 0x8E, 0x47, 0x08, 0x7F, 0x01, 0xED,
    0x70, 0x8F, 0x09, 0x11, 0x04, 0x94, 0x15, 0x80,
    0x10, 0x41, 0x08, 0x90, 0x00, 0x6F, 0x08, 0x51,
    0x00, 0x4E, 0x15, 0x00, 0x16, 0x33, 0xE8, 0x00,
    0x80, 0x00, 0x80, 0x00, 0x88, 0x5F, 0x08, 0x51,
    0x01, 0x12
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x52, 0x00,         // Sequence Number
    0x43, 0xDC, 0x20, 0xE5,     // CRC32
    0x8E, 0x3F, 0x08, 0xD0, 0x01, 0x3F, 0x08, 0x91,
    0x00, 0x12, 0x1E, 0x43, 0x16, 0x1B, 0xF0, 0x52,
    0x0F, 0x6E, 0x08, 0xE1, 0x41, 0xC6, 0xC6, 0x00,
    0x1F, 0x43, 0x10, 0xC6, 0xC6, 0xA5, 0xB8, 0x00,
    0xAE, 0xA1, 0x40, 0xAE, 0x59, 0xC6, 0xC6, 0xB0,
    0x15, 0x80, 0x10, 0x2F, 0x08, 0xF1, 0x02, 0xA1,
    0x41, 0x0C, 0x70, 0x80, 0x21, 0x08, 0x02, 0x00,
    0x19, 0x43
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x53, 0x00,         // Sequence Number
    0xA4, 0x5C, 0xA7, 0x52,     // CRC32
    0x01, 0x0D, 0xF0, 0x12, 0x1E, 0x03, 0x16, 0x7F,
    0xD9, 0x7B, 0x1E, 0x03, 0x10, 0x9D, 0x1D, 0x19,
    0x10, 0x7A, 0x1E, 0x42, 0x10, 0x0C, 0x71, 0x9B,
    0x1D, 0xD9, 0x1F, 0xBE, 0x0E, 0xCE, 0x02, 0xC3,
    0x40, 0x80, 0x00, 0x64, 0x08, 0x00, 0x88, 0x0F,
    0x08, 0x1F, 0x01, 0x00, 0x8E, 0x07, 0x08, 0x1F,
    0x00, 0xED, 0x71, 0xC5, 0x58, 0x94, 0xEF, 0x24,
    0x85, 0x25
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x54, 0x00,         // Sequence Number
    0x09, 0x8E, 0x5E, 0xDB,     // CRC32
    0x08, 0x65, 0x00, 0x10, 0x49, 0x21, 0x08, 0x84,
    0x0F, 0x00, 0x00, 0xDE, 0x08, 0x18, 0x85, 0x9F,
    0x59, 0x34, 0xD8, 0x02, 0xAD, 0x12, 0x8E, 0x8B,
    0x08, 0x3E, 0x81, 0x2C, 0x70, 0x00, 0x8D, 0xAF,
    0x59, 0xC6, 0xC6, 0x2C, 0x71, 0xA1, 0x40, 0xA9,
    0x59, 0xC6, 0xC6, 0xE2, 0xC3, 0xA1, 0xC1, 0xC2,
    0x0A, 0xEE, 0x09, 0x08, 0x45, 0x37, 0x08, 0xB1,
    0x02, 0x3B
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x55, 0x00,         // Sequence Number
    0xAB, 0x33, 0x61, 0x56,     // CRC32
    0xDC, 0x60, 0x95, 0x02, 0x1C, 0x02, 0x33, 0x60,
    0xC3, 0x28, 0xBB, 0x8A, 0x20, 0x90, 0x01, 0x2C,
    0x73, 0x80, 0xC2, 0x01, 0x1C, 0xC2, 0x30, 0x69,
    0x1D, 0x19, 0x10, 0x4B, 0x59, 0x13, 0x08, 0x71,
    0x00, 0x0C, 0x71, 0xD7, 0x59, 0x10, 0xD8, 0x2C,
    0x71, 0x52, 0x0C, 0xEE, 0x08, 0x4C, 0x70, 0xC2,
    0xC7, 0xE4, 0xC3, 0x82, 0x24, 0x02, 0x38, 0xCB,
    0x45, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x56, 0x00,         // Sequence Number
    0xCF, 0x99, 0x64, 0x5F,     // CRC32
    0x00, 0xE0, 0x02, 0xC0, 0x85, 0x80, 0xC4, 0x80,
    0xA5, 0x08, 0x58, 0xC0, 0xA5, 0xC4, 0xC7, 0xE4,
    0xC3, 0x82, 0x24, 0x02, 0x38, 0xCB, 0x45, 0x80,
    0x00, 0xE0, 0x02, 0xC0, 0x85, 0x80, 0xC4, 0xD6,
    0x09, 0xAE, 0x00, 0x80, 0xA5, 0xC0, 0xA5, 0xC4,
    0xC7, 0xE0, 0x78, 0xE4, 0xC3, 0x82, 0x24, 0x02,
    0x38, 0xCB, 0x45, 0x80, 0x00, 0xE0, 0x02, 0xC0,
    0x85, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x57, 0x00,         // Sequence Number
    0xAF, 0x70, 0x36, 0xDE,     // CRC32
    0xC3, 0x60, 0xA5, 0x0A, 0x58, 0xC0, 0xA5, 0xC4,
    0xC7, 0xE4, 0xC3, 0x82, 0x24, 0x02, 0x38, 0xCB,
    0x45, 0x80, 0x00, 0xE0, 0x02, 0xC0, 0x85, 0x80,
    0xC4, 0x80, 0xA5, 0x0C, 0x58, 0xC0, 0xA5, 0xC4,
    0xC7, 0xE4, 0xC3, 0x82, 0x24, 0x0A, 0x30, 0xCB,
    0x45, 0x80, 0x00, 0xE0, 0x02, 0xC0, 0x85, 0x80,
    0xC2, 0x40, 0xA5, 0x0E, 0x58, 0xC0, 0xA5, 0xC4,
    0xC7, 0xE4
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x58, 0x00,         // Sequence Number
    0x5A, 0xA9, 0xFC, 0x9D,     // CRC32
    0xC3, 0x82, 0x24, 0x0A, 0x30, 0xCB, 0x45, 0x80,
    0x00, 0xE0, 0x02, 0xC0, 0x85, 0x80, 0xC3, 0x60,
    0xA5, 0x0F, 0x58, 0xC0, 0xA5, 0xC4, 0xC7, 0xE4,
    0xC3, 0x82, 0x24, 0x0A, 0x30, 0xCB, 0x45, 0x80,
    0x00, 0xE0, 0x02, 0xC0, 0x85, 0x80, 0xC1, 0x20,
    0xA5, 0x10, 0x58, 0xC0, 0xA5, 0xC4, 0xC7, 0xE4,
    0xC3, 0x82, 0x24, 0x02, 0x38, 0xCB, 0x45, 0x80,
    0x00, 0xE0
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x59, 0x00,         // Sequence Number
    0xA6, 0xCD, 0x03, 0x96,     // CRC32
    0x02, 0xC0, 0x85, 0x80, 0xC2, 0x40, 0xA5, 0x12,
    0x58, 0xC0, 0xA5, 0xC4, 0xC7, 0xE4, 0xC3, 0x82,
    0x24, 0x02, 0x38, 0xCB, 0x45, 0x80, 0x00, 0xE0,
    0x02, 0xC0, 0x85, 0x80, 0xC1, 0x20, 0xA5, 0x13,
    0x58, 0xC0, 0xA5, 0xC4, 0xC7, 0xE8, 0xC3, 0xA2,
    0xC1, 0x50, 0x40, 0x28, 0x47, 0x0A, 0x25, 0x00,
    0x10, 0x17, 0x5B, 0x90, 0xE8, 0x8E, 0x58, 0x4B,
    0x20, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x5A, 0x00,         // Sequence Number
    0x1D, 0x99, 0xDA, 0xAF,     // CRC32
    0x8C, 0x0C, 0xF2, 0x81, 0xC0, 0x80, 0xC1, 0x6B,
    0x59, 0xFE, 0xE8, 0x01, 0xC0, 0x06, 0xE8, 0xA9,
    0x5A, 0x00, 0xC1, 0xF1, 0x09, 0x00, 0x80, 0xA1,
    0x40, 0xE1, 0x41, 0x02, 0x42, 0x2F, 0x27, 0xBF,
    0x03, 0x6F, 0x23, 0x3F, 0x00, 0x86, 0x0B, 0xCE,
    0x0B, 0x2F, 0x26, 0xBF, 0x03, 0x0E, 0xE8, 0x6C,
    0x25, 0x42, 0x10, 0xC3, 0x41, 0x10, 0x00, 0x00,
    0x00, 0x43
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x5B, 0x00,         // Sequence Number
    0x1A, 0x93, 0x4B, 0x3F,     // CRC32
    0x61, 0x0F, 0x0B, 0xE1, 0x03, 0x59, 0x61, 0x21,
    0x81, 0x07, 0x09, 0x01, 0x04, 0x0C, 0x70, 0xC8,
    0xC7, 0xF4, 0xC3, 0xAE, 0xC1, 0xCB, 0x46, 0x80,
    0x00, 0x58, 0x59, 0x23, 0x86, 0x10, 0x46, 0x34,
    0x11, 0x82, 0x00, 0x15, 0x0A, 0x71, 0x00, 0x04,
    0x11, 0x14, 0x00, 0x35, 0x11, 0x80, 0x00, 0x6E,
    0x70, 0x14, 0x70, 0x0C, 0xF2, 0x2C, 0x70, 0xA2,
    0x09, 0x20
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x5C, 0x00,         // Sequence Number
    0x90, 0x59, 0x54, 0xAC,     // CRC32
    0x00, 0x82, 0x40, 0xC3, 0x41, 0x80, 0x00, 0x95,
    0x59, 0x20, 0x89, 0x6E, 0x70, 0x34, 0x71, 0xB8,
    0x00, 0x21, 0x00, 0x52, 0x20, 0x3E, 0x80, 0xB0,
    0x00, 0x22, 0x00, 0x0C, 0x73, 0xC3, 0x41, 0xF0,
    0x00, 0x04, 0x04, 0x40, 0x81, 0x18, 0xB8, 0x04,
    0x7A, 0x15, 0x0A, 0x01, 0x00, 0x43, 0x86, 0x36,
    0x12, 0x80, 0x00, 0x14, 0x70, 0x1A, 0xF2, 0x0C,
    0x70, 0x6A
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x5D, 0x00,         // Sequence Number
    0x78, 0x09, 0xC3, 0xB7,     // CRC32
    0x5A, 0xAD, 0x70, 0x2C, 0x70, 0x2F, 0x27, 0xBF,
    0x03, 0x6F, 0x23, 0x3F, 0x00, 0xB5, 0x70, 0x0A,
    0x20, 0x40, 0x07, 0x3A, 0xF4, 0x14, 0x70, 0x38,
    0xF4, 0x4A, 0x09, 0x20, 0x00, 0x82, 0x40, 0x14,
    0x70, 0x32, 0xF2, 0xC2, 0x40, 0x44, 0x5A, 0x10,
    0x43, 0x61, 0x00, 0x00, 0x00, 0xC3, 0x40, 0xF0,
    0x00, 0x50, 0x04, 0xE0, 0x80, 0x00, 0x80, 0xF9,
    0x0F, 0x01
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x5E, 0x00,         // Sequence Number
    0xA1, 0x0E, 0x7B, 0x55,     // CRC32
    0x90, 0x0A, 0x86, 0x09, 0xE8, 0x64, 0x82, 0x73,
    0x4F, 0x0F, 0x08, 0xC4, 0x00, 0x39, 0x12, 0x80,
    0x00, 0x14, 0x70, 0xDA, 0xF5, 0x00, 0x16, 0x00,
    0x70, 0x80, 0x00, 0x50, 0x02, 0x4E, 0x70, 0x14,
    0x70, 0x1C, 0xF4, 0x1F, 0x8E, 0x14, 0x70, 0x18,
    0xF2, 0x2F, 0x27, 0xFF, 0x00, 0x6F, 0x23, 0x3F,
    0x00, 0x00, 0x81, 0x04, 0x20, 0x90, 0x0F, 0x10,
    0x00, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x5F, 0x00,         // Sequence Number
    0xC2, 0x69, 0x31, 0x1C,     // CRC32
    0x00, 0x4F, 0x20, 0x02, 0x05, 0x40, 0xA1, 0x41,
    0x28, 0x10, 0x25, 0x2F, 0x26, 0xFF, 0x00, 0x0A,
    0xF0, 0x0C, 0x70, 0x3A, 0x5A, 0x2F, 0x26, 0xBF,
    0x03, 0x62, 0x40, 0xD4, 0xC7, 0x0E, 0x70, 0x4E,
    0x71, 0x2F, 0x27, 0x7F, 0x03, 0x6F, 0x23, 0x3F,
    0x00, 0x0A, 0x25, 0x40, 0x27, 0xC4, 0x5A, 0x4A,
    0x24, 0x40, 0x73, 0x80, 0xC2, 0x2D, 0xD0, 0xA8,
    0x20, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x60, 0x00,         // Sequence Number
    0x20, 0xCE, 0x40, 0x58,     // CRC32
    0x02, 0x20, 0x80, 0x04, 0x1A, 0x50, 0x00, 0x24,
    0x18, 0x11, 0x00, 0xD3, 0x41, 0xF0, 0x00, 0xE0,
    0x09, 0x26, 0x40, 0xC3, 0x41, 0xF0, 0x00, 0x08,
    0x1C, 0x4D, 0xC0, 0x74, 0x19, 0x41, 0xA0, 0x2F,
    0x26, 0x7F, 0x03, 0x79, 0x25, 0x0D, 0x20, 0x00,
    0x81, 0x04, 0xF0, 0xE0, 0x78, 0x00, 0x81, 0xFD,
    0x08, 0x1E, 0x80, 0x0B, 0x00, 0x00, 0x00, 0xC4,
    0xBA, 0x2F
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x61, 0x00,         // Sequence Number
    0xDD, 0x9C, 0x4B, 0x40,     // CRC32
    0x21, 0xBF, 0x00, 0x2F, 0x27, 0xBF, 0x00, 0x6F,
    0x23, 0x3F, 0x00, 0x00, 0x81, 0xE0, 0xB8, 0xF8,
    0xF5, 0x2F, 0x26, 0xBF, 0x00, 0x05, 0x20, 0xBE,
    0xA4, 0x03, 0xF4, 0x0C, 0x70, 0x5D, 0x5A, 0x0A,
    0x25, 0x40, 0x35, 0x2F, 0x27, 0xFF, 0x00, 0x6F,
    0x23, 0x3F, 0x00, 0x4A, 0x24, 0x40, 0x73, 0x12,
    0xD0, 0x80, 0xC1, 0xA8, 0x20, 0xC0, 0x01, 0x04,
    0x11, 0x02
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x62, 0x00,         // Sequence Number
    0xB7, 0x84, 0x77, 0xAB,     // CRC32
    0x04, 0x24, 0x18, 0x90, 0x00, 0x0D, 0xC0, 0x00,
    0x19, 0x00, 0x20, 0x2F, 0x26, 0xFF, 0x00, 0xC3,
    0x40, 0x80, 0x00, 0x74, 0x02, 0x23, 0x86, 0x40,
    0x80, 0x42, 0xA1, 0x41, 0x80, 0x0C, 0x70, 0x43,
    0xA1, 0x6A, 0x5A, 0x28, 0x86, 0x03, 0x86, 0x4C,
    0x70, 0x02, 0x24, 0x54, 0xA0, 0xE4, 0xA0, 0x39,
    0x18, 0x43, 0x00, 0xB1, 0x06, 0xEF, 0xFF, 0x43,
    0x22, 0x01
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x63, 0x00,         // Sequence Number
    0xB5, 0x2E, 0x31, 0x28,     // CRC32
    0x80, 0x0C, 0x08, 0xF0, 0x00, 0xEA, 0xC2, 0xC3,
    0x43, 0xF0, 0x00, 0x4C, 0x04, 0x40, 0x8B, 0x10,
    0x40, 0x30, 0x41, 0x51, 0x0A, 0x3E, 0x00, 0x0C,
    0x71, 0x40, 0x23, 0x02, 0x02, 0x04, 0x12, 0x01,
    0x04, 0x0C, 0x77, 0x30, 0xB9, 0x53, 0x21, 0xCB,
    0x80, 0x14, 0xF2, 0x4A, 0x24, 0x00, 0x71, 0x2C,
    0x70, 0xA8, 0x20, 0x80, 0x02, 0x0D, 0x0B, 0x4E,
    0x10, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x64, 0x00,         // Sequence Number
    0xD5, 0x38, 0xAA, 0x02,     // CRC32
    0x82, 0x10, 0x74, 0xCA, 0x20, 0x05, 0x03, 0x44,
    0x74, 0x24, 0x71, 0x21, 0x83, 0x41, 0x83, 0xFD,
    0x09, 0x81, 0x80, 0x04, 0x77, 0x22, 0x78, 0x34,
    0x5A, 0x3C, 0x20, 0x02, 0x20, 0x3C, 0x21, 0x40,
    0x20, 0x32, 0x71, 0xCA, 0x20, 0x81, 0x00, 0xCA,
    0xC6, 0xE0, 0x78, 0xF1, 0xC0, 0x05, 0xF0, 0xC4,
    0xBA, 0x2F, 0x21, 0xBF, 0x00, 0x2F, 0x27, 0xBF,
    0x00, 0x6F
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x65, 0x00,         // Sequence Number
    0xE6, 0xF4, 0x0D, 0x70,     // CRC32
    0x23, 0x3F, 0x00, 0x00, 0x16, 0x01, 0x70, 0xF0,
    0x00, 0x04, 0x04, 0x38, 0xB9, 0xC1, 0xB9, 0x10,
    0x71, 0xF2, 0xF5, 0x2F, 0x26, 0xBF, 0x00, 0x17,
    0x08, 0xB1, 0x00, 0x8A, 0x20, 0x04, 0x00, 0x2C,
    0x70, 0x38, 0x5A, 0x8A, 0x20, 0x04, 0x00, 0x2C,
    0x70, 0x39, 0x5A, 0xD1, 0xC0, 0xE0, 0x7E, 0xE0,
    0x78, 0xF1, 0xC0, 0x00, 0x16, 0x00, 0x70, 0x80,
    0x00, 0x68
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x66, 0x00,         // Sequence Number
    0xF8, 0x2D, 0xC1, 0xF2,     // CRC32
    0x5C, 0x00, 0x18, 0x01, 0x00, 0x00, 0x16, 0x00,
    0x70, 0xF0, 0x00, 0x04, 0x04, 0x3A, 0xB8, 0xC1,
    0xB8, 0x00, 0x1E, 0x00, 0x70, 0x80, 0x00, 0x50,
    0x02, 0x32, 0x5B, 0x00, 0x16, 0x01, 0x70, 0x80,
    0x00, 0x68, 0x5C, 0x0C, 0x71, 0x0C, 0x19, 0xC3,
    0x0F, 0x33, 0x5B, 0x0C, 0x71, 0x3D, 0x5B, 0x2C,
    0x71, 0xC3, 0x40, 0xF0, 0x00, 0x88, 0x09, 0x20,
    0xA0, 0x6F
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x67, 0x00,         // Sequence Number
    0x83, 0xC0, 0x7B, 0x57,     // CRC32
    0x23, 0x3F, 0x00, 0xE4, 0x18, 0x40, 0x80, 0xD1,
    0xC0, 0xE0, 0x7F, 0xF0, 0x18, 0x40, 0x80, 0xE0,
    0x78, 0xF1, 0xC0, 0xC3, 0x41, 0x80, 0x00, 0x7C,
    0x5A, 0x00, 0x81, 0x13, 0x80, 0x0F, 0x08, 0x91,
    0x00, 0x00, 0x1E, 0x41, 0x70, 0xF0, 0x00, 0x00,
    0x18, 0x1F, 0xF0, 0x00, 0x81, 0x13, 0x80, 0x14,
    0x70, 0x1B, 0xF4, 0x0C, 0x73, 0x57, 0x5A, 0x0C,
    0x73, 0x58
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x68, 0x00,         // Sequence Number
    0xA6, 0xF1, 0xFE, 0x98,     // CRC32
    0x5A, 0xAF, 0x5A, 0x14, 0x70, 0x15, 0xF2, 0x0B,
    0x00, 0x00, 0x00, 0xC4, 0xB8, 0x2F, 0x21, 0x3F,
    0x00, 0x2F, 0x27, 0x3F, 0x00, 0x6F, 0x23, 0x3F,
    0x00, 0x00, 0x16, 0x01, 0x70, 0xF0, 0x00, 0x0C,
    0x18, 0xE0, 0xB9, 0xF4, 0xF3, 0x2F, 0x26, 0x3F,
    0x00, 0xB5, 0x5A, 0xAE, 0x5A, 0xD1, 0xC0, 0xE0,
    0x7E, 0xE0, 0x78, 0xE6, 0xC3, 0xA3, 0xC1, 0x00,
    0x16, 0x80
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x69, 0x00,         // Sequence Number
    0x50, 0x1E, 0xAB, 0xCF,     // CRC32
    0x70, 0x80, 0x00, 0x08, 0x5D, 0x06, 0xE8, 0xC3,
    0x40, 0x40, 0x00, 0x74, 0x18, 0x2C, 0x71, 0xC1,
    0x5A, 0x4A, 0x25, 0x00, 0x30, 0x42, 0x5A, 0x08,
    0x46, 0x14, 0x71, 0x0B, 0xF4, 0x0C, 0x70, 0x2F,
    0x27, 0x7F, 0x03, 0x6F, 0x23, 0x3F, 0x00, 0x65,
    0x5A, 0x2F, 0x26, 0x7F, 0x03, 0x79, 0xF0, 0xCB,
    0x45, 0x80, 0x00, 0x2C, 0x0B, 0xD5, 0x72, 0x46,
    0x00, 0x05
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x6A, 0x00,         // Sequence Number
    0xDE, 0xB4, 0xA3, 0x00,     // CRC32
    0x00, 0x00, 0x85, 0x23, 0x80, 0x60, 0x79, 0x0C,
    0x71, 0x2D, 0x5A, 0x0C, 0x71, 0x3A, 0x5A, 0x0A,
    0x20, 0x40, 0x07, 0x14, 0x70, 0x0E, 0xF4, 0x0C,
    0x70, 0x2F, 0x27, 0xFF, 0x03, 0x6F, 0x23, 0x3F,
    0x00, 0x65, 0x5A, 0x78, 0x26, 0xC0, 0x10, 0x04,
    0x75, 0x2F, 0x26, 0xFF, 0x03, 0x43, 0x5A, 0x0C,
    0x70, 0x3A, 0x5A, 0x0C, 0x70, 0x36, 0x5A, 0x00,
    0x85, 0x23
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x6B, 0x00,         // Sequence Number
    0x2F, 0x1D, 0x35, 0x6C,     // CRC32
    0x80, 0x60, 0x79, 0x0C, 0x70, 0xC6, 0xC7, 0x47,
    0x5A, 0x14, 0x70, 0x04, 0xF2, 0x24, 0x59, 0x14,
    0x70, 0x4D, 0xF2, 0x12, 0x5B, 0x14, 0x72, 0x0D,
    0xF2, 0x14, 0x5B, 0x2C, 0x71, 0x00, 0x29, 0x00,
    0x00, 0xCB, 0xB8, 0x00, 0x1E, 0x00, 0x70, 0xF0,
    0x00, 0xD4, 0x08, 0x6F, 0x23, 0x3F, 0x00, 0x82,
    0xC0, 0x81, 0xC1, 0x80, 0xC2, 0x29, 0x59, 0x6B,
    0x08, 0xB0
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x6C, 0x00,         // Sequence Number
    0xB7, 0xEF, 0x8B, 0xAA,     // CRC32
    0x00, 0x08, 0x46, 0x16, 0x5B, 0x63, 0x08, 0x11,
    0x00, 0x17, 0x5B, 0x5B, 0x08, 0x11, 0x00, 0x00,
    0x85, 0x23, 0x80, 0x60, 0x79, 0x0C, 0x71, 0x2D,
    0x5A, 0x0C, 0x71, 0x3A, 0x5A, 0x17, 0x5B, 0x35,
    0x08, 0x11, 0x00, 0x16, 0x5B, 0x31, 0x08, 0x11,
    0x00, 0x8E, 0xEE, 0x00, 0xC3, 0x01, 0xC2, 0x02,
    0xC0, 0x2C, 0x70, 0x30, 0x5A, 0x33, 0x08, 0x30,
    0x00, 0x2C
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x6D, 0x00,         // Sequence Number
    0x2C, 0x5D, 0xFF, 0x4C,     // CRC32
    0x70, 0x0C, 0x71, 0x8C, 0xB9, 0x4C, 0x71, 0x52,
    0x5A, 0x0A, 0x20, 0x40, 0x07, 0x86, 0xE8, 0x00,
    0x16, 0x00, 0x71, 0xF0, 0x00, 0x10, 0x04, 0x09,
    0xE8, 0x00, 0x85, 0x23, 0x80, 0x60, 0x79, 0x0C,
    0x70, 0x0C, 0x70, 0x3A, 0x5A, 0x28, 0xF0, 0x0C,
    0x75, 0x43, 0x5A, 0x00, 0x85, 0x23, 0x80, 0x60,
    0x79, 0x0C, 0x70, 0x0C, 0x70, 0x3A, 0x5A, 0x12,
    0x5B, 0x1B
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x6E, 0x00,         // Sequence Number
    0xF4, 0xFB, 0x18, 0x5F,     // CRC32
    0x08, 0x90, 0x00, 0x14, 0x5B, 0x2C, 0x71, 0x00,
    0x29, 0x00, 0x00, 0xCB, 0xB8, 0x00, 0x1E, 0x00,
    0x70, 0xF0, 0x00, 0xC4, 0x08, 0xE0, 0x78, 0xE0,
    0x78, 0x2F, 0x27, 0x3F, 0x00, 0x6F, 0x23, 0x3F,
    0x00, 0x0A, 0x21, 0x40, 0x07, 0x0D, 0x09, 0x10,
    0x00, 0x2F, 0x26, 0x3F, 0x00, 0x05, 0xF0, 0xC4,
    0xB8, 0x2F, 0x21, 0x3F, 0x00, 0x12, 0x5B, 0x07,
    0x08, 0x91
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x6F, 0x00,         // Sequence Number
    0xFB, 0xA8, 0x47, 0x65,     // CRC32
    0x00, 0xC6, 0xC7, 0x14, 0x5B, 0x2C, 0x71, 0x00,
    0x29, 0x00, 0x00, 0xCB, 0xB8, 0x00, 0x1E, 0x00,
    0x70, 0xF0, 0x00, 0xC8, 0x08, 0x6F, 0x23, 0x3F,
    0x00, 0xC6, 0xC7, 0xE0, 0x78, 0xF1, 0xC0, 0x14,
    0x71, 0x09, 0xF4, 0x00, 0x1E, 0x81, 0x70, 0xF0,
    0x00, 0x14, 0x08, 0x6F, 0x23, 0x3F, 0x00, 0xCD,
    0x58, 0x0A, 0xF0, 0xC3, 0x40, 0xF0, 0x00, 0x20,
    0x08, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x70, 0x00,         // Sequence Number
    0xD5, 0x03, 0xC0, 0x3B,     // CRC32
    0x18, 0x81, 0x00, 0x6F, 0x23, 0x3F, 0x00, 0xF0,
    0x18, 0x81, 0x80, 0xD1, 0xC0, 0xE0, 0x7E, 0xE4,
    0xC2, 0xA2, 0x0B, 0x0E, 0x0E, 0x08, 0x45, 0x11,
    0xE8, 0x14, 0x5B, 0x1F, 0x08, 0x35, 0x03, 0xCD,
    0x71, 0x18, 0x7E, 0x15, 0x5B, 0xC3, 0x41, 0xF0,
    0x00, 0x3C, 0x34, 0x04, 0xE8, 0x00, 0x81, 0xC5,
    0x78, 0x04, 0xF0, 0x00, 0x81, 0xC6, 0x78, 0x00,
    0xA1, 0xA1
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x71, 0x00,         // Sequence Number
    0x66, 0x7F, 0xB8, 0xF0,     // CRC32
    0x40, 0xC4, 0xC6, 0xE0, 0x78, 0xE6, 0xC0, 0xC3,
    0x43, 0x80, 0x00, 0x68, 0x02, 0x00, 0x13, 0xC2,
    0x00, 0xFF, 0xDD, 0xFF, 0xD9, 0x54, 0x77, 0x86,
    0xF6, 0x09, 0x0A, 0x32, 0x04, 0x40, 0x41, 0x0F,
    0xD9, 0x20, 0xAB, 0x2C, 0x70, 0x00, 0x16, 0x03,
    0x70, 0x80, 0x00, 0x68, 0x5C, 0xED, 0x71, 0xCB,
    0x8B, 0x8A, 0x8B, 0x03, 0xF0, 0x24, 0x71, 0x1F,
    0x09, 0x85
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x40,           // HCI Parameter Length
    0x72, 0x00,         // Sequence Number
    0x9D, 0xC1, 0xC9, 0x46,     // CRC32
    0x03, 0xFD, 0x0C, 0x6E, 0x90, 0x3A, 0x63, 0x04,
    0x12, 0xC2, 0x00, 0xF1, 0x08, 0xA3, 0x80, 0x00,
    0x2F, 0x42, 0x10, 0x46, 0x7D, 0xAF, 0x7D, 0xF2,
    0xF1, 0xAC, 0xAB, 0xC6, 0xC4, 0x00, 0x00, 0x62,
    0x73, 0x70, 0x00, 0x5C, 0x07, 0x40, 0x00, 0x26,
    0x20, 0x40, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xA0, 0x08, 0x40, 0x00, 0x00,
    0x00, 0x00
  },
  { 0x28, 0xFC,     // HCI Vendor Specific Command EM_WritePatchContinue
    0x33,           // HCI Parameter Length
    0x73, 0x00,         // Sequence Number
    0xCF, 0x17, 0xB1, 0x66,     // CRC32
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x84, 0x18, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x49, 0x4E, 0x49, 0x02, 0x00, 0x00, 0x60,
    0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
  },
  { 0x27, 0xFC,     // HCI Vendor Specific Command EM_WritePatchStart
    0x25,           // HCI Parameter Length
    0x00,           // Destination Memory (0 = IRAM1; 1 = OTP)
    0xC6, 0xA3, 0x06, 0xEC,     // CRC32
    0x33, 0x39, 0x6D, 0x65, 0x20, 0x00, 0x00, 0x00,
    0x01, 0x0B, 0x15, 0x14, 0x11, 0x0C, 0x02, 0x00,
    0x3C, 0x55, 0xF1, 0x34, 0x30, 0x02, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0xFB, 0x00, 0x00, 0x00
  },
  { 0x27, 0xFC,     // HCI Vendor Specific Command EM_WritePatchStart
    0x25,           // HCI Parameter Length
    0x00,           // Destination Memory (0 = IRAM1; 1 = OTP)
    0x0A, 0xAB, 0x2E, 0x76,     // CRC32
    0x33, 0x39, 0x6D, 0x65, 0x20, 0x00, 0x00, 0x00,
    0x01, 0x0B, 0x14, 0x14, 0x11, 0x0C, 0x02, 0x00,
    0xA5, 0xFF, 0xA9, 0x2F, 0x35, 0x02, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00
  },
  { 0x27, 0xFC,     // HCI Vendor Specific Command EM_WritePatchStart
    0x25,           // HCI Parameter Length
    0x00,           // Destination Memory (0 = IRAM1; 1 = OTP)
    0xD8, 0x4C, 0xCA, 0x86,     // CRC32
    0x33, 0x39, 0x6D, 0x65, 0x20, 0x00, 0x00, 0x00,
    0x01, 0x0B, 0x16, 0x14, 0x11, 0x0C, 0x02, 0x00,
    0x27, 0x54, 0x2B, 0xF0, 0x08, 0x01, 0x00, 0x00,
    0x02, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00
  }
};


