//*****************************************************************************
//
//! @file am_vos_audio.h
//!
//! @brief header file of audio processing work
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AM_VOS_AUDIO_H
#define AM_VOS_AUDIO_H

#include "am_vos_sys_config.h"
#include "am_vos_board_setup.h"
#include "am_vos_spp.h"
#include "am_vos_utils.h"

#if configUSE_AMBIQ_VADv3
#include "webrtc_vad.h"
#endif // configUSE_AMBIQ_VADv3

#if configUSE_SBC_BLUEZ || configUSE_MSBC_BLUEZ
#include "sbc.h"
#endif // configUSE_SBC_BLUEZ || configUSE_MSBC_BLUEZ
//********************************************************************************
// Audio pre & post buffer parameters
//********************************************************************************
#define AUDIO_KWD_TIMEOUT_S             8                            // 8 seconds timeout.

#define AUDIO_PREROLL_TIME_MS           500

#if configUSE_AMBIQ_VADv3
  #define VAD_TIMEOUT_ADJ_THRESHOLD     20                      // 20 seconds = QSD_TIMEOUT_MS * QSD_TIMEOUT_ADJ_THRESHOLD
  #define USE_VAD_DEBUG                 1
  #define USE_VAD_DEBOUNCE              1

#if configUSE_PREROLL
#define AM_VAD_PREROLL_MS       600     // Rewind
#else
#define AM_VAD_PREROLL_MS       400     // Rewind
#endif

#if USE_DMIC_PDM
#define AM_VAD_DEBOUNCE_SAMPLES         12800   // 0.8 sec
#else
#define AM_VAD_DEBOUNCE_SAMPLES         16000   // 1 sec
#endif
#endif // configUSE_AMBIQ_VADv3

#if configUSE_AAD
#if configUSE_AMBIQ_VADv3
  #define AAD_TIMEOUT_SEC               0.1 //  1.5 // timeout from VAD enter light mode
  #define AAD_TIMEOUT_HYS_SEC           0.5         // timeout for AAD self operation when waking up
  #define AAD_TIMEOUT_HYS_COUNT         (AAD_TIMEOUT_HYS_SEC * USE_PCM_SAMPLE_RATE / PCM_FRAME_SIZE_SAMPLES)   
#else
  #define AAD_TIMEOUT_SEC               10
#endif // configUSE_AMBIQ_VADv3
  #define AAD_TIMEOUT_COUNT             (AAD_TIMEOUT_SEC * USE_PCM_SAMPLE_RATE / PCM_FRAME_SIZE_SAMPLES)
  #define AAD_DISCARD_TIME_US           5000
#endif // configUSE_AAD

//********************************************************************************
// WWE parameters
//********************************************************************************
#if configUSE_Fluent
//#define WWE_INPUT_FRAME_LENTH_SAMPLES   640
#define WWE_INPUT_FRAME_LENTH_SAMPLES   240
#else
#define WWE_INPUT_FRAME_LENTH_SAMPLES   240
#endif // configUSE_Fluent

typedef struct _VosAudInfo {
    am_vos_ring_buffer_t                        sWweInputBuf;

#if configUSE_DSPC_TalkTo
    am_spp_input_buff_t                         sSppInputBuf;
#endif	
    am_spp_output_buff_t                        sSppOutputBuf;

#if configUSE_AMVOS_ATVV
    uint16_t                                    ui16SequenceNumber;
#endif

#if configUSE_AMBIQ_VADv3
    VadInst                                     *psVadHandle;
#endif // configUSE_AMBIQ_VADv3

#if configUSE_SPP_AGC || configUSE_SPP_DRC
    void                                        *pvSppAgcHandle;
#endif // configUSE_SPP_AGC || configUSE_SPP_DRC

#if configUSE_SPP_DRC
    void                                        *pvSppCompHandle;
#endif // configUSE_SPP_DRC

} VosAudInfo;

//extern void am_vos_AWE_instance_init(void);
void am_vos_audio_handler(int32_t *nLRSample);
void am_vos_audio_flush_ring_buffer(void);

uint8_t am_vos_engine_init(void);
void am_vos_engine_process(int16_t *pi16InputBuffer, int16_t i16InputLength);

void am_vos_audio_buffer_rewind(void);
void am_vos_audio_reset_flag_and_buffer(void);

void am_vos_vad_aad_threshold_to_high(void);
void am_vos_vad_aad_threshold_to_low(void);

void am_vos_audio_wwd_enable(void);
void am_vos_audio_wwd_disable(void);

extern VosAudInfo g_sVosAud;

#endif // AM_VOS_AUDIO_H
