//*****************************************************************************
//
//! @file am_vos_codec.c
//!
//! @brief Codec encoding wrapper parts
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#include "am_vos_sys_config.h"

#include "FreeRTOS.h"

#include "am_vos_board_setup.h"
#include "am_vos_init.h"
#include "am_vos_audio.h"
#include "am_vos_codec.h"

#if configUSE_AUDIO_CODEC

#if configUSE_SBC_BLUEZ || configUSE_MSBC_BLUEZ
#include "sbc.h" 
#endif // configUSE_SBC_BLUEZ || configUSE_MSBC_BLUEZ

#if configUSE_OPTIM_OPUS
#include "ae_api.h"
#endif // configUSE_OPTIM_OPUS

#if configUSE_ADPCM
#include "adpcm.h"
#endif // configUSE_ADPCM

//*****************************************************************************
//
// Audio codec init
//
//*****************************************************************************

void am_vos_codec_init(void)
{
#if configUSE_SBC_BLUEZ
    g_sVosAud.sSbcFrame.msbc = false;   // SBC
    g_sVosAud.sSbcFrame.mode = SBC_MODE_MONO;
    g_sVosAud.sSbcFrame.nsubbands = 8;
    g_sVosAud.sSbcFrame.nblocks = 16;
    g_sVosAud.sSbcFrame.bam = SBC_BAM_SNR;
    g_sVosAud.sSbcFrame.bitpool = 28;
    g_sVosAud.sSbcFrame.freq = 16000;
#endif // configUSE_SBC_BLUEZ

#if configUSE_MSBC_BLUEZ
    g_sVosAud.sSbcFrame.msbc = true;    // mSBC
    g_sVosAud.sSbcFrame.mode = SBC_MODE_MONO;
    g_sVosAud.sSbcFrame.nsubbands = 8;
    g_sVosAud.sSbcFrame.nblocks = 16;
    g_sVosAud.sSbcFrame.bam = SBC_BAM_SNR;
    //g_sVosAud.sSbcFrame.bam = SBC_BAM_LOUDNESS;
    g_sVosAud.sSbcFrame.bitpool = 28;
    //g_sVosAud.sSbcFrame.bitpool = 35;
    g_sVosAud.sSbcFrame.freq = 16000;
#endif // configUSE_MSBC_BLUEZ

#if configUSE_OPTIM_OPUS
    /* initialize the audio encoder */
    audio_enc_init(0);
#endif // configUSE_OPTIM_OPUS

#if configUSE_ADPCM
    adpcm_init();
#endif // configUSE_ADPCM
}
//*****************************************************************************
//
// Audio codec encoder
//
//*****************************************************************************

void am_vos_codec_encode(const void *p_InputBuf, size_t input_len,
			                void *p_OutputBuf, size_t output_len, int *p_CompressedLen)
{
#if configUSE_SBC_BLUEZ || configUSE_MSBC_BLUEZ
    //sbc_encoder_encode(p_InputBuf, input_len, p_OutputBuf, output_len, (int32_t *)p_CompressedLen);
    sbc_encode(&(g_sVosAud.sSbc), p_InputBuf, 1, NULL, 0, &(g_sVosAud.sSbcFrame), p_OutputBuf, output_len);
    *p_CompressedLen = output_len;
#endif // configUSE_SBC_BLUEZ || configUSE_MSBC_BLUEZ

#if configUSE_OPTIM_OPUS
    uint32_t ui32EncoderReturn;

    ui32EncoderReturn = audio_enc_encode_frame((int16_t*)p_InputBuf, OPUS_IN_FRAME_SIZE, (unsigned char*)p_OutputBuf);
    *p_CompressedLen = (int32_t)ui32EncoderReturn;
#endif // configUSE_OPTIM_OPUS
    
#if configUSE_ADPCM
    adpcm_encode_frame((uint8_t *)p_InputBuf, input_len, (uint8_t *)p_OutputBuf, output_len, (uint32_t *)p_CompressedLen);
#endif // configUSE_ADPCM
}

#endif // configUSE_AUDIO_CODEC
