//*****************************************************************************
//
//! @file am_vos_init.h
//!
//! @brief VoS global system handler and defines
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AM_VOS_INIT
#define AM_VOS_INIT

#include "am_vos_sys_config.h"

#include <stdbool.h>
#include "am_vos_audio_buffer.h"
#include "am_vos_spp.h"
#include "am_vos_logic.h"

#define HEART_BEAT_PERIOD               pdMS_TO_TICKS(1000)
#define RTT_RECORDER_RUNNING            pdMS_TO_TICKS(300)
#define GSENSOR_PERIOD                  pdMS_TO_TICKS(2000)

#define LONG_PRESS_TIMER_PERIOD_MS     100
#define LONG_PRESS_EFFECTIVE_MS        4000

//*****************************************************************************
//
// App ring buffer list structure typedefs
//
//*****************************************************************************
// this enum list contains all app related ring buffers between AM_VOS_RINGBUFF_NONE and AM_VOS_RINGBUFF_MAX
// where each index corresponds to a ring buffer
typedef enum
{
    AM_VOS_RINGBUFF_NONE = 0, // The enum must begin with this value as named.
#if configUSE_RTT_RECORDER
    AM_VOS_RINGBUFF_RTT_STREAM,
#endif // configUSE_RTT_RECORDER
    AM_VOS_RINGBUFF_MAX // The enum must end with this value as named.
} am_vos_ring_buffer_enum_t;

#if configUSE_RTT_RECORDER
    #define RTT_BUFFER_LENGTH               (100 * 1024)
#endif // configUSE_RTT_RECORDER

//*****************************************************************************
//
// Voice on SPOT global status structure
//
//*****************************************************************************
typedef struct _VosSysInfo {
    uint8_t     ui8KwdDetectedFlag;             // 1: the key word is detected; 0: no key word detected.
    uint8_t     ui8ButtonDownFlag;              // 1: the button is pushed down; 0: no button is pushed.
    uint8_t     ui8PushTalkFlag;                // trig for push-to-talk.
    uint8_t     ui8ProvideSpeechFlag;           // trig for conversation talk.
    uint8_t     ui8CmdDetectedFlag;             // 1: command is detected.

    uint32_t    ui32StreamingTimeOutCount;      // Voice streaming timeout counter
    bool        bWwdEnabled;

#if configUSE_RTT_RECORDER
    uint8_t     pui8RttRecorderBuffer[RTT_BUFFER_LENGTH];
#endif // configUSE_RTT_RECORDER

#if configUSE_AMVOS_AMA
    int32_t     i32DelayedSample;
    int32_t     i32EndingSampleCnt;
    int32_t     i32PreRollDelayMs;
    uint8_t     ui8AlexaAppPlatform;            // 1: iOS; 2: Android
#endif // configUSE_AMVOS_AMA

    uint8_t     ui8SeqNumber;

#if configUSE_AMVOS_ATVV
    uint32_t    ui32MicOpenTimeOutCount;        // MIC open command timeout at ATVV mode.
    uint8_t     ui8FragmentCount;               // For 23 bytes MTU mode processing at ATVV mode.
#endif

#if configUSE_RTT_RECORDER
    uint8_t     ui8RecordStartFlag;              // 1: the start of RTT recorder; 0: stop recording
#endif // configUSE_RTT_RECORDER

#if configUSE_AAD
    uint8_t     ui8AadEnabled;                   // 0: Noisy status; 1: Quiet status
    uint8_t     ui8AadDebounceFlag;               // Start pdm > AAD_TIMEOUT_COUNT * 5 ms when power-up
    int32_t     i32TimeoutToAadEnable;
    uint8_t     ui8AadSkipFrameFlag;
    uint32_t    ui32AadDiscardTimeUS;
#endif // configUSE_AAD

#if configUSE_AMBIQ_VADv3
    uint8_t             ui8FullProcessedFlag;
    uint8_t             ui8RequireFullProcess;
    uint16_t            ui16VadTimeoutCnt;
    int16_t             i16VadDebounceCnt;
#endif // configUSE_AMBIQ_VADv3

#if configUSE_SPP_P2A
    uint8_t             u8PgaFlag;
#endif

#if VOS_MEASURE_AMSPP_MIPS
    uint32_t            ui32PcmTimeTick;
    uint32_t            ui32PcmCallNum;
#endif // VOS_MEASURE_AMSPP_MIPS

#if VOS_MEASURE_SPP_MIPS
    uint32_t            ui32SppTimeTick;
    uint32_t            ui32SppCallNum;
#endif // VOS_MEASURE_SPP_MIPS

#if VOS_MEASURE_WWE_MIPS
    //uint32_t            ui32WweTimeMs;
    uint32_t            ui32WweTimeTick;
    uint32_t            ui32WweCallNum;
#endif // VOS_MEASURE_WWE_MIPS

#if VOS_MEASURE_CODEC_MIPS
    //uint32_t            ui32WweTimeMs;
    uint32_t            ui32CodecTimeTick;
    uint32_t            ui32CodecCallNum;
#endif // VOS_MEASURE_CODEC_MIPS

#if VOS_MEASURE_SYS_MIPS
    uint32_t            ui32VosSleepTimeTick;
    uint32_t            ui32VosSleepCallNum;
#endif

#if VOS_MEASURE_VAD_WAKETIME
    uint32_t            ui32VosVadWakeTimeTick;
    uint32_t            ui32VosVadWakeTimeTickTotal;
#endif // VOS_MEASURE_VAD_WAKETIME

#if VOS_MEASURE_ISR_PCM_DATA
    uint32_t            ui32VosIsrCount;
    uint32_t            ui32VosPcmSize;
#endif // VOS_MEASURE_ISR_PCM_DATA

#if VOS_MEASUREMENT_ENABLE
    uint32_t            ui32VosBenchTimeSec;
#endif

    uint32_t    ui32SysHeapSize;
} VosSysInfo;

extern VosSysInfo g_sVosSys;

extern am_vos_ring_buffer_t am_KWD_ring_buffers[];

extern void am_vos_sys_init(void);
extern void am_vos_reset_detected_flag(void);
extern void am_vos_board_init(void);
extern void am_vos_print_system_info(void);

#endif // AM_VOS_INIT
