//*****************************************************************************
//
//! @file am_vos_spp.h
//!
//! @brief header file for SPP (Sound pre-processing) engines.
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef __AM_VOS_SPP_H__
#define __AM_VOS_SPP_H__
//
// configuration header file
//
#include "am_vos_sys_config.h"
#include "am_vos_board_setup.h"
#include "am_util.h"

//*****************************************************************************
//
// Apollo platform configuration
//
//*****************************************************************************
#define AM_SPP_LOG(...)                                             am_util_stdio_printf(__VA_ARGS__)

//
// AWE error check handler
//
extern void spp_error_handler(uint32_t ui32ErrorStatus);
#define SPP_CHECK_ERRORS(x)                                                       \
    if ((x) != 0)                                                                 \
    {                                                                             \
        spp_error_handler(x);                                                     \
    }


//
// audio data common format
//
#define SAMPLE_16BIT                                                2
#define SAMPLE_32BIT                                                4

//*****************************************************************************
//
// Apollo Platform related configuration
// No need of manual modification
//
//*****************************************************************************
#define AM_SPP_SAMPLE_FREQ              USE_PCM_SAMPLE_RATE
#define AM_SPP_IN_CHANNEL_NUM           USE_MIC_NUM
#define AM_SPP_IN_DATA_FORMAT           SAMPLE_16BIT
#define AM_SPP_OUT_CHANNEL_NUM          1
#define AM_SPP_OUT_DATA_FORMAT          SAMPLE_16BIT

#define PCM_SAMPLE_BYTES                SAMPLE_16BIT

#if configUSE_DSPC_TalkTo
//
// SPP input data config structure
//
typedef struct
{
    //
    // SPP input data channel number
    //
    const uint32_t ui32SppInChNum;
    const uint32_t ui32SppInDataFormat;
    const uint32_t ui32SppInBlockSize;
    uint8_t SppInputArray[AM_SPP_IN_CHANNEL_NUM][AM_SPP_IN_DATA_FORMAT * PCM_FRAME_SIZE_SAMPLES];
}am_spp_input_buff_t;
#endif

//
// SPP output data config structure
//
typedef struct
{
    //
    // SPP input data channel number
    //
    const uint32_t ui32SppOutChNum;
    const uint32_t ui32SppOutDataFormat;
    const uint32_t ui32SppOutBlockSize;
    uint8_t SppOutputArray[AM_SPP_OUT_CHANNEL_NUM][AM_SPP_OUT_DATA_FORMAT * PCM_FRAME_SIZE_SAMPLES];
}am_spp_output_buff_t;

extern volatile bool g_bSppInDataReady;

extern int16_t g_pin16SppLeftInBuff[PCM_FRAME_SIZE_SAMPLES];
extern int16_t g_pin16SppRightInBuff[PCM_FRAME_SIZE_SAMPLES];
extern int16_t g_pin16SppOutBuff[PCM_FRAME_SIZE_SAMPLES];

#if configUSE_DSPC_TalkTo
extern void am_spp_init(am_spp_input_buff_t* spp_in, am_spp_output_buff_t* spp_out);
extern void am_spp_input_push(am_spp_input_buff_t* spp_input);
extern void am_spp_output_pop(am_spp_output_buff_t* spp_output);
extern void am_spp_process_handler(void);
#endif

#endif // __AM_VOS_SPP_H__

