//*****************************************************************************
//
//! @file am_vos_ble.h
//!
//! @brief The header of am_vos_ble.c
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef RADIO_TASK_H
#define RADIO_TASK_H

/*! Event types for ble rx data handler */
#define BLE_DATA_READY_EVENT                   0x01      /*! Trigger Rx data path */

//********************************************************************************
// BLE parameters
//********************************************************************************
#if configUSE_OPTIM_OPUS || configUSE_ADPCM
#define BLE_DATA_BUFFER_SIZE            CODEC_OUT_RING_BUFF_SIZE        // 2 times for Apollo2Blue, 4 times for Apollo3Blue due to SRAM resource difference
#else // configUSE_OPTIM_OPUS || configUSE_ADPCM
#define BLE_DATA_BUFFER_SIZE            CODEC_OUT_RING_BUFF_SIZE * 2    // 2 times for Apollo2Blue, 4 times for Apollo3Blue due to SRAM resource difference
#endif // configUSE_OPTIM_OPUS || configUSE_ADPCM

#define AMA_COMMAND_BUFFER_SIZE         64                              // command + header length   

typedef struct{
    uint8_t vos_buf[4]; //dummy
    uint32_t len;
    uint32_t reserved;
}sRadioQueue_t;

typedef struct{
    uint8_t cmd_buf[AMA_COMMAND_BUFFER_SIZE];
    uint32_t len;
}sRadioCmdQueue_t;

//*****************************************************************************
//
// External function definitions.
//
//*****************************************************************************

extern void am_vos_ble_hw_init(void);
extern int am_vos_ble_rx_handler(uint8_t *data, uint16_t len);
extern bool am_vos_ble_stream_send(void);
extern bool am_vos_ble_nextdata_check(uint8_t** buf, uint32_t* len, bool *bCmdFlag);

extern void am_vos_ble_task_setup(void);
extern void am_vos_ble_task(void *pvParameters);

extern void am_vos_streaming_start(void);
extern void am_vos_streaming_stop(void);
extern void am_vos_streaming_push_to_talk(void);
extern void am_vos_streaming_provide_speech(void);

extern bool am_vos_is_connected(void);
extern bool am_vos_is_tx_ready(void);
extern void am_vos_ble_tx_packet_encap(uint8_t *buf, uint16_t len);
extern bool am_vos_ble_cmd_send(uint8_t *buf, uint32_t length);
extern void am_vos_ble_tx_staus_set(uint8_t val);
extern void am_vos_ble_data_ready_evt_set(void);

extern void exactle_stack_init(void);

#if configUSE_AMVOS_ATVV
bool am_vos_ble_hid_search_send(void);
bool am_vos_ble_hid_btn_release_send(void);
bool am_vos_ble_hid_back_send(void);
#endif

#if (!configUSE_BLE)
extern void HciDrvRadioShutdown(void);
#endif

#if configUSE_PAIRING_MODE_BTN
void am_vos_ble_pairing_mode(void);
#endif

void am_vos_voice_start(void);

#endif // RADIO_TASK_H
