// ****************************************************************************
//
//  amvos_api.h
//! @file
//!
//! @brief Ambiq Micro's demonstration of AMVOS service.
//!
//! @{
//
// ****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AMVOS_API_H
#define AMVOS_API_H

#include "FreeRTOS.h"
#include "queue.h"
#include "wsf_timer.h"
#include "dm_api.h"

#include "am_vos_sys_config.h"

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************************************
  Macros
**************************************************************************************************/

#ifndef AMVOS_CONN_MAX
#define AMVOS_CONN_MAX                  1
#endif

#if configUSE_AMVOS_AMA
#define AMA_VID                 0x09AC      /* Company ID i.e. Ambiq */
#define ACCESSORY_COLOR_INDEX   0x0         /* Accessory color - TBD */
#endif // configUSE_AMVOS_AMA

#if configUSE_AMVOS_HID
/* HidApp TX path flags */
#define HIDAPP_TX_FLAGS_READY             0x01
#define HIDAPP_TX_FLAGS_PENDING           0x02

/* The input report fits in one byte */
#define HIDAPP_KEYBOARD_INPUT_REPORT_LEN     8
#define HIDAPP_MOUSE_INPUT_REPORT_LEN        5
#define HIDAPP_REMOTE_INPUT_REPORT_LEN       1
//#define HIDAPP_REMOTE_INPUT_REPORT_LEN       2
#define HIDAPP_TELEPHONY_INPUT_REPORT_LEN    3
#define HIDAPP_OUTPUT_REPORT_LEN             1
#define HIDAPP_FEATURE_REPORT_LEN            1

/* Remote Button Identifier bits */
#define REMOTE_USAGE_NONE                 (0<<0)
#define REMOTE_PLAY_PAUSE                 (1<<0)
#define REMOTE_AL_CCC                     (1<<1)
#define REMOTE_SCAN_NEXT                  (1<<2)
#define REMOTE_SCAN_PREVIOUS              (1<<3)
#define REMOTE_VOLUME_DOWN                (1<<4)
#define REMOTE_VOLUME_UP                  (1<<5)
#define REMOTE_AC_SEARCH                  (1<<6)
#define REMOTE_AC_BACKWARD                (1<<7)
//#define REMOTE_AC_FORWARD                 (1<<8)

/* HID Report IDs */
#define HIDAPP_REMOTE_REPORT_ID                 1
#define HIDAPP_KEYBOARD_REPORT_ID               2
#define HIDAPP_MOUSE_REPORT_ID                  3
#define HIDAPP_REMOTE_TELEPHONY_REPORT_ID       4

#define CONSUMER_CTRL_IN_REP_SIZE       12  /**< Size of a single field in the Consumer Control Input Report [bits]. */
#define CONSUMER_CTRL_IN_REP_COUNT      2   /**< Number of fields in the Consumer Control Input Report. */
#endif // configUSE_AMVOS_HID

typedef struct _VosBleInfo {
    wsfHandlerId_t      ui8AmVosHandlerId;      // WSF handler ID
    dmConnId_t          ui8AmVosConnId;

    uint8_t             ui8VosTxBusy;

    QueueHandle_t       hRadioQueue;
    QueueHandle_t       hRadioCmdQueue;

#if configUSE_AMVOS_AMA || configUSE_AMVOS_ATVV
    bool                bComSecured;         // flag indicating channel secured status
    bool                bSlaveSecReq;        // flag indicating a slave security request is needed or not
    bool                bCccSetupFlag;       // channel setup (firmware exchange) command sent or not
    uint32_t            ui32TxPktSize;
    bool                bConnected;
#endif // configUSE_AMVOS_AMA

#if defined (AM_PART_APOLLO2)
    wsfHandlerId_t      hBleDataReadyHandlerId;
#endif // AM_PART_APOLLO2

#if configUSE_BLE_WATCHDOG
    wsfTimer_t          sAmvosTxTimer;         // timeout timer to monitor ble controller tx activity
    wsfTimer_t          sAmvosRspTimer;        // timeout timer to monitor APP responsiveness
    wsfTimer_t          sAmvosTxCccTimer;      // timeout timer to monitor AMA setup
    wsfTimer_t          sAmvosTestTimer;       // timeout timer to monitor APP responsiveness
#endif // configUSE_BLE_WATCHDOG

#if configUSE_BLE_Measure_Throughput
    wsfTimer_t          sMeasTpTimer;          // timeout timer to measure throughput.

    uint32_t            ui32AmaDataSentLength;
    uint32_t            ui32AmaDataSentCnt;
    uint32_t            ui32AmaDataCnfCnt;
#endif // configUSE_BLE_Measure_Throughput

} VosBleInfo;

extern VosBleInfo g_sVosBle;

/**************************************************************************************************
  Function Declarations
**************************************************************************************************/
/*************************************************************************************************/
/*!
 *  \fn     AmvosStart
 *
 *  \brief  Start the application.
 *
 *  \return None.
 */
/*************************************************************************************************/
void AmVosStart(void);

/*************************************************************************************************/
/*!
 *  \fn     AmVosHandlerInit
 *
 *  \brief  Application handler init function called during system initialization.
 *
 *  \param  handlerID  WSF handler ID for App.
 *
 *  \return None.
 */
/*************************************************************************************************/
void AmVosHandlerInit(wsfHandlerId_t handlerId);

/*************************************************************************************************/
/*!
 *  \fn     AmVosHandler
 *
 *  \brief  WSF event handler for the application.
 *
 *  \param  event   WSF event mask.
 *  \param  pMsg    WSF message.
 *
 *  \return None.
 */
/*************************************************************************************************/
void AmVosHandler(wsfEventMask_t event, wsfMsgHdr_t *pMsg);

void am_vos_cmd_packet_tx(uint8_t * buf, uint32_t len);
void am_vos_audio_packet_tx(uint8_t * buf, uint32_t len);

#if configUSE_AMVOS_HID
void hidAppRemoteReportEvent(uint16_t button);
#endif // configUSE_AMVOS_HID

#ifdef __cplusplus
};
#endif

#endif /* AMVOS_API_H */
