//*****************************************************************************
//
//! @file am_vos_comp.h
//!
//! @brief The header of Ambiq Compression algorithm.
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AM_VOS_COMP_H
#define AM_VOS_COMP_H

#define FIX_POINT //for fixpoint version
// #define FLOAT     //for float version

typedef struct
{
    int   block_len;
    int   frame_len;
    float attack_time;
    float release_time;
    int   noise_gate;
    float knee_thr;
    int   knee_type;
    float knee_width;
    float knee_thr_gain;
    float G_low;
    float slope1;
    float slope2;
    float SmoothGain;
    float LinearGain;
    float gain_thr;
    float curr_dB;
    float calc_gain;
    float AlphaRInVAD;
    float AlphaRSil;
    float AlphaABeginVAD;
    float AlphaAInVAD;

    // float vad;
    float vad_smooth_short_thr;
    float vad_smooth_long_thr;
    float vad_thr;
    float VadSmoothShort;
    float VadSmoothLong;
    int   VadBufLen;
    int   VadShortLen;
    int   VadBuff[20 * 8];     // 32ms---20,  4ms---20*8
    int   VadShortBuff[3 * 8]; // 32ms---3, 4ms---3*8
    int   VadIdx;
    int   VadShortIdx;

} objComp;

/**
****************************************************************************************
* @brief Initialize the parameters of DRC
* @param samplerate Audio sample rate
* @param frame_len Audio frame length
* @param knee_thrd Knee threshold 
* @param noise_gate Noise gate 
* @param slope Slope 
* @param attack_time Attack time 
* @param decay_time Decay time 
* @param obj_ptr Pointer of DRC struct
* @return None
****************************************************************************************
 */
void am_vos_comp_init(int samplerate, int frame_len, int knee_thrd, int noise_gate,
               float slope, int attack_time, int decay_time, void *obj_ptr);

/**
****************************************************************************************
* @brief DRC algorithm
* @param obj_ptr Pointer of DRC struct
* @param in Pointer of audio input data buffer
* @param out Pointer of audio ouput data buffer
* @param sample_n Audio data sample number
* @return None
****************************************************************************************
 */
void am_vos_comp_process(void *obj_ptr, short *in, short *out, int sample_n);

/**
****************************************************************************************
* @brief Free memory of DRC struct
* @param obj_ptr Pointer of DRC struct
* @return None
****************************************************************************************
 */
void am_vos_comp_uninit(void *obj_ptr);

#endif // AM_VOS_COMP_H

