//*****************************************************************************
//
//! @file am_vos_ama.h
//!
//! @brief header file of AMA protocol handler
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2017, Ambiq Micro
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision v1.2.11 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AM_VOS_AMA_H
#define AM_VOS_AMA_H

#include "accessories.pb.h"

#define AMA_TRANSPORT_HEADER_VERSION_MASK       0xF000
#define AMA_TRANSPORT_HEADER_STEAM_ID_MASK      0x0F80
#define AMA_TRANSPORT_HEADER_LENGTH_TYPE_MASK   0x01

#define AM_AMA_DEVICE_TYPE_STR              	"A3U3B4RTI76K2J"        // Ambiq Mirco ID

#define configUSE_AMA_2021                      1

typedef struct _AmaDevInfo {
    char                serial_number[20];
    char                name[16];
    char                device_type[14];
    AudioProfile        eAudioProfile;
    uint8_t             ui8AudioFormat;
    uint8_t             ui8TransportType;
    uint8_t             ui8TransportCount;
} AmaDevInfo;

typedef struct _AmaSpeechInfo {
    uint8_t     ui8PushTalkFlag;

    bool        bPreRollEnabled;
    int32_t     i32PreRollDelayMs;
    int32_t     i32DelayedSample;
    int32_t     i32EndingSampleCnt;
} AmaSpeechInfo;

// AMA Event callback
typedef void (*amaEvtCback_t)(Command cmd, void* pMsg, bool bResponse);

//*****************************************************************************
// External function declaration
//*****************************************************************************

void am_vos_ama_status_reset(void);
void am_vos_ama_status_ready(void);
void am_vos_ama_devinfo_set(AmaDevInfo *pInfo);
bool am_vos_ama_isready(void);

void am_vos_ama_event_callback(Command cmd, void* pMsg, bool bResponse);
bool am_vos_ama_evt_cback_register(amaEvtCback_t cback);
int am_vos_ama_rx_handler(uint8_t *data, uint16_t len);

bool am_vos_ama_tx_ver_exchange_send(void);
bool am_vos_ama_reset_connection_send(void);
bool am_vos_ama_start_speech_send(AmaSpeechInfo *pSpeechInfo);
bool am_vos_ama_stop_speech_send(ErrorCode eErrCode);
bool am_vos_ama_get_central_info_send(void);
bool am_vos_ama_get_state_send(uint32_t feature);
bool am_vos_ama_sync_state_send(State *pInput);
bool am_vos_ama_media_control_send(uint32_t control);

bool am_vos_ama_rsp_send(uint8_t tag, uint8_t err);
bool am_vos_ama_get_locale_rsp_send(void);
bool am_vos_ama_provide_speech_rsp_send(uint32_t dialogId);
bool am_vos_ama_speech_rsp_send(uint8_t cmd, uint32_t dialogId);
bool am_vos_ama_get_devinfo_rsp_send(void);
bool am_vos_ama_get_devconf_rsp_send(void);
bool am_vos_ama_get_state_rsp_send(State *pInput);

#endif // AM_VOS_AMA_H
