//*****************************************************************************
//
//! @file am_vos_atvv.h
//!
//! @brief Google ATVV (Android TV Voice) protocol header
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AM_VOS_ATVV_H
#define AM_VOS_ATVV_H

#include <stdbool.h>

#define AM_VOS_ATVV_ATVCMD_GET_CAPS             0x0A
#define AM_VOS_ATVV_ATVCMD_MIC_OPEN             0x0C
#define AM_VOS_ATVV_ATVCMD_MIC_CLOSE            0x0D

#define AM_VOS_ATVV_CTRL_AUDIO_STOP             0x00
#define AM_VOS_ATVV_CTRL_AUDIO_START            0x04
#define AM_VOS_ATVV_CTRL_START_SEARCH           0x08
#define AM_VOS_ATVV_CTRL_AUDIO_SYNC             0x0A
#define AM_VOS_ATVV_CTRL_GET_CAPS_RESP          0x0B
#define AM_VOS_ATVV_CTRL_MIC_OPEN_ERROR         0x0C

#define AM_VOS_ATVV_MIC_OPEN_TIMEOUT_SEC        3

typedef struct _AtvvCapsInfo {
    char        version_major;
    char        version_minor;
    char        codecs_supported[2];
    char        bytes_frame[2];
    char        bytes_characteristic[2];
} AtvvCapsInfo;

typedef struct _AtvvAudioSync {
    uint16_t    ui16FrameNum;
} AtvvAudioSync;

typedef struct _AtvvMicOpenError {
    uint16_t    ui16ErrorCode;
} AtvvMicOpenError;

typedef struct _AtvvDevInfo {
    uint8_t     ui8AudioFormat;
    uint8_t     ui8TransportType;
} AtvvDevInfo;

// ATVV Event callback
typedef void (*atvvEvtCback_t)(uint8_t);

//*****************************************************************************
// External function declaration
//*****************************************************************************

void am_vos_atvv_devinfo_set(AtvvDevInfo *pInfo);
int am_vos_atvv_rx_handler(uint8_t *data, uint16_t len);
bool am_vos_atvv_start_search_send(void);
void am_vos_atvv_start_search_cancel(void);
bool am_vos_atvv_audio_start_send(void);
bool am_vos_atvv_audio_end_send(void);
void am_vos_atvv_status_reset(void);
bool am_vos_atvv_isready(void);

void am_vos_atvv_event_callback(uint8_t);
bool am_vos_atvv_evt_cback_register(atvvEvtCback_t cback);

#endif // AM_VOS_ATVV_H
