//*****************************************************************************
//
//! @file am_vos_sys_config.h
//!
//! @brief Ambiq VoS global system configuration
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-0904a758c7 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef __AM_VOS_SYS_CONFIG_H__
#define __AM_VOS_SYS_CONFIG_H__

#define VOS_FW_VER_STRING               "4.5.0"

// ---------------------------------------
// User Hardware Selection
// ---------------------------------------
// Select Mikro Board(s)used and MikroBUS slots
#define USE_DMIC_MB0                    1       // Dual DMIC on Mikrobus slot 0
#define USE_DMIC_MB1                    0       // Dual DMIC on Mikrobus slot 1
#define USE_DMIC_MB2                    0       // Dual DMIC on Mikrobus slot 2
#define USE_DMIC_MB0_T5838              0       // Single DMIC on Mikrobus slot 0 (TDK T5838)

#define USE_AMIC_J15                    0       // AMIC doughter board (J15 slot).

#define USE_MIC_SINGLE                  1       // Single MIC (Left).
#define USE_MIC_DUAL                    0       // Dual MIC.

#if USE_MIC_SINGLE
#define USE_MIC_NUM                     1
#elif USE_MIC_DUAL
#define USE_MIC_NUM                     2
#endif

//*******************************************************************************
// System level functional module selection
//*******************************************************************************

#define configUSE_SPP_HPF               0
#define configUSE_SPP_P2A               0
#define configUSE_SPP_AGC               0
#define configUSE_SPP_EXP               0
#define configUSE_SPP_DRC               0

#define configUSE_AMBIQ_VADv3           0       // Enable VADv3

#define configUSE_SYSVIEWER             0
#define configUSE_RTT_RECORDER          0
#define configUSE_STDIO_PRINTF          1

#define configUSE_VOS_BENCH_ISR         0
#define configUSE_DTCM_SRAM_LP          0

#if defined (AM_VOS_TALKTO)
    #define configUSE_DSPC_TalkTo       1       // DSPC AWE frame work switch
#endif // AM_VOS_TALKTO

#if defined (AM_VOS_THF)
    #define configUSE_Sensory_THF       1       // Sensory detection lib
#endif // AM_VOS_THF

#if defined (AM_VOS_FLUENT)
    #define configUSE_Fluent            1       // Fluent detection lib
#endif // AM_VOS_FLUENT

#define configUSE_BLE                   1
#define configUSE_AUDIO_CODEC           1
#define configUSE_LEDs                  1

#define configUSE_PUSH_TO_TALK          1       // Use BTN1 as paring mode function
#define configUSE_MUTE_MIC              0       // Use BTN1 as mute mic function

#if (configUSE_SPP_HPF || configUSE_SPP_P2A || configUSE_SPP_AGC || configUSE_SPP_EXP || configUSE_SPP_DRC || configUSE_AMBIQ_VADv3) 
#define configUSE_AMBIQ_SPP             1
#endif // (configUSE_SPP_HPF || configUSE_SPP_P2A || configUSE_SPP_AGC || configUSE_SPP_EXP || configUSE_SPP_DRC || configUSE_AMBIQ_VADv3)

#if configUSE_BLE                                       // If AMA,ATVV define all 0, then common GATT configuration.
    #define configUSE_AMVOS_AMA                 1       // Alexa mobile accessory protocol
    #define configUSE_AMVOS_ATVV                0       // Android TV voice protocol

    #define configUSE_BLE_WATCHDOG              1       // Using watchdog timeout feature to recover connection.
    #define configUSE_BLE_SECURE_CONNECTION     1       // Using BLE with secured connection.
    #define configUSE_BLE_BURST_MODE            0       // Enable burst mode at BLE operation.
    #define configUSE_BLE_Measure_Throughput    0
    #define configUSE_BLE_TX_POWER_SET          0
#endif // configUSE_BLE

#define configUSE_BURST_MODE_ALWAYS_ON          0       // This is debugging define to performance check.

//********************************************************************************
// AWE module configuration
//********************************************************************************
#if configUSE_DSPC_TalkTo
#if USE_MIC_SINGLE
    #define configUSE_1MIC_SCNR_LAYOUT          1
#else
    #define configUSE_ALEXA_QUAL_LAYOUT         1
    #define configUSE_ALEXA_SCNRV3_LAYOUT       0
    #define configUSE_AIC_LITE_LAYOUT           0
#endif

    #define configUSE_TalkTo_SCNR               1
#endif // configUSE_TalkTo

#if (configUSE_DSPC_TalkTo && configUSE_AIC_LITE_LAYOUT) || configUSE_AMBIQ_VADv3
  #define PCM_FRAME_SIZE_MS             10
#else
  #define PCM_FRAME_SIZE_MS             5
#endif // (configUSE_DSPC_TalkTo && configUSE_AIC_LITE_LAYOUT) || configUSE_AMBIQ_VADv3

//********************************************************************************
// Sensory module configuration
//********************************************************************************
#if configUSE_Sensory_THF
    #define configUSE_THF_WW            1
    #define configUSE_THF_CMD           0

    #define configUSE_THF_FA            0
    #define configUSE_THF_LPSD          0

#if configUSE_THF_WW
#if configUSE_AMVOS_AMA
    #define configUSE_WW_Alexa          1       // "Alexa"
#elif configUSE_AMVOS_ATVV
    #define configUSE_WW_Alexa          0       // "Alexa"
    #define configUSE_WW_Google         1       // "Hey(Okay), Google"
#else
    #define configUSE_WW_Alexa          1       // "Alexa"
    #define configUSE_WW_Google         0       // "Hey, Google"
    #define configUSE_WW_Ambiq          0       // "Hey, Ambiq", "OK, Sensory"
#endif // configUSE_AMVOS_AMA, configUSE_AMVOS_ATVV
#endif // configUSE_THF_WW

#if configUSE_THF_CMD
    #define configUSE_CMD_VoiceHubDemo  1       // Light control demo. 
    #define configUSE_CMD_LightDemoCN   0       // Light control demo at Chinese.
    #define configUSE_CMD_UrgentCall    0       // "Please help me" urgent call 

    #define configUSE_THF_Static_Alloc  1       // If CMD phrase is enabled, Static mem allocation is recommended.
#endif // configUSE_THF_CMD

#endif // configUSE_Sensory_THF

#define VOS_MEASURE_AMSPP_MIPS          0
#define VOS_MEASURE_SPP_MIPS            0
#define VOS_MEASURE_WWE_MIPS            0
#define VOS_MEASURE_CODEC_MIPS          0
#define VOS_MEASURE_SYS_MIPS            0
#define VOS_MEASURE_VAD_WAKETIME        0

#if (VOS_MEASURE_AMSPP_MIPS || VOS_MEASURE_SPP_MIPS || VOS_MEASURE_WWE_MIPS || VOS_MEASURE_CODEC_MIPS || VOS_MEASURE_SYS_MIPS || VOS_MEASURE_VAD_WAKETIME)
#define VOS_MEASUREMENT_ENABLE          1
#endif // (VOS_MEASURE_AMSPP_MIPS || VOS_MEASURE_SPP_MIPS || VOS_MEASURE_WWE_MIPS || VOS_MEASURE_CODEC_MIPS || VOS_MEASURE_SYS_MIPS || VOS_MEASURE_VAD_WAKETIME)

#if USE_DMIC_MB0_T5838
    #define configUSE_AAD               1       // Acoustic Activity Detection (Wake on sound)
#endif // USE_DMIC_MB0_T5838

//********************************************************************************
// BLE module configuration
//********************************************************************************
#if configUSE_AMVOS_AMA
    #define configUSE_BLE_ERROR_SW_RESET        0

#if configUSE_Sensory_THF
    #define configUSE_PREROLL                   1       // Audio preroll function, like Amazon CBWWV.
#else
    #define configUSE_PREROLL                   0
#endif // configUSE_Sensory_THF
#endif // configUSE_AMVOS_AMA

#if configUSE_AMVOS_ATVV
    #define configUSE_AMVOS_HID         1
    #define configUSE_AMVOS_BATT        1
#endif
//********************************************************************************
// Audio Codec module configuration
//********************************************************************************
#if configUSE_AUDIO_CODEC
#if configUSE_AMVOS_AMA
    #define configUSE_OPTIM_OPUS        1
    #define configUSE_MSBC_BLUEZ        0
#elif configUSE_AMVOS_ATVV
    #define configUSE_ADPCM             1
#else
    #define configUSE_SBC_BLUEZ         0       // Codec selection. You could only choose 1
    #define configUSE_MSBC_BLUEZ        0
    #define configUSE_OPTIM_OPUS        1
    #define configUSE_ADPCM             0
#endif
#endif // configUSE_AUDIO_CODEC

#if configUSE_OPTIM_OPUS
    #define AM_TX_AUDIO_FORMAT          1       // OPUS_32KBPS
#elif configUSE_MSBC_BLUEZ
    #define AM_TX_AUDIO_FORMAT          3       // MSBC
#elif configUSE_ADPCM
    #define AM_TX_AUDIO_FORMAT          4       // ADPCM
#else
    #define AM_TX_AUDIO_FORMAT          0       // format
#endif // configUSE_MSBC_BLUEZ, configUSE_OPTIM_OPUS

//********************************************************************************
// RTT recorder module configuration
//********************************************************************************
#if configUSE_RTT_RECORDER
    #define configUSE_RECORD_RAW_PCM            1       // Select which data be recorded
    #define configUSE_RECORD_AM_SPP             0
    #define configUSE_RECORD_DSPC_SPP           0
    #define configUSE_RECORD_CODEC_ENCODED      0
#endif // configUSE_RTT_RECORDER

//********************************************************************************
// std IO sub module configuration
//********************************************************************************
#define configUSE_Debug_Log_Print       0

#if configUSE_STDIO_PRINTF
    #define configUSE_PRINTF_UART0      0
    #define configUSE_PRINTF_RTT        0
    #define configUSE_PRINTF_SWO        1

#if configUSE_Debug_Log_Print
    #define AM_VOS_LOG_DEBUG(...)       am_vos_stdio_printf(1, __VA_ARGS__)
#else // configUSE_Debug_Log_Print
    #define AM_VOS_LOG_DEBUG(...)
#endif // configUSE_Debug_Log_Print

    #define AM_VOS_LOG_WARNING(...)     am_vos_stdio_printf(2, __VA_ARGS__)
    #define AM_VOS_LOG_INFO(...)        am_vos_stdio_printf(3, __VA_ARGS__)

#else // configUSE_STDIO_PRINTF
    #define AM_VOS_LOG_DEBUG(...)
    #define AM_VOS_LOG_WARNING(...)
    #define AM_VOS_LOG_INFO(...)
#endif // configUSE_STDIO_PRINTF

//********************************************************************************
// Heap Memory parameters
//********************************************************************************
#define VOS_HEAP_SYSTEM                 (15 * 1024)     // Minimum Memory size that needed for audio task stack and scheduler

#if configUSE_DSPC_TalkTo
    #define VOS_HEAP_PREPROCESSING      (2 * 1024)      // AWE Tick task stack (2352 bytes at VoS 1.1.3)
#else // configUSE_DSPC_TalkTo
    #define VOS_HEAP_PREPROCESSING      0
#endif // configUSE_DSPC_TalkTo

#if configUSE_Sensory_THF 
#if configUSE_THF_Static_Alloc
    #define VOS_HEAP_WWD_ENGINE         (6 * 1024)      // 12864 bytes (CMD phrase) 11672 bytes (64K Alexa kwd) at VoS 1.1.3
#elif configUSE_WW_Ambiq
    #define VOS_HEAP_WWD_ENGINE         (20 * 1024)
#else
    #define VOS_HEAP_WWD_ENGINE         (15 * 1024)     // 12864 bytes (CMD phrase) 11672 bytes (64K Alexa kwd) at VoS 1.1.3
#endif

#elif configUSE_Fluent
    #define VOS_HEAP_WWD_ENGINE         (8 * 1024)

#else
    #define VOS_HEAP_WWD_ENGINE         0
#endif // configUSE_Sensory_THF, configUSE_Fluent

#if configUSE_AUDIO_CODEC
    #define VOS_HEAP_CODEC              (10 * 1024)     // Audio Codec task stack (4528 bytes at VoS 1.1.3)
#else // configUSE_AUDIO_CODEC
    #define VOS_HEAP_CODEC              0
#endif // configUSE_AUDIO_CODEC

#if configUSE_BLE
    #define VOS_HEAP_BLE                (3 * 1024)      // This value is depend on RadioQueue Size
#else // configUSE_BLE
    #define VOS_HEAP_BLE                0
#endif // configUSE_BLE

#if configUSE_LOG_UART0 || configUSE_PRINTF_UART0
    #define VOS_HEAP_UART               (2 * 1024)      // UART task stack (4528 bytes at VoS 1.1.3)
#else // configUSE_LOG_UART0 || configUSE_PRINTF_UART0
    #define VOS_HEAP_UART               0
#endif // configUSE_LOG_UART0 || configUSE_PRINTF_UART0

#if configUSE_PRINTF_RTT || configUSE_PRINTF_SWO
    #define VOS_HEAP_RTT_SWO            (4 * 1024)      // SWD STDIO task stack (4528 bytes at VoS 1.1.3)
#else // configUSE_PRINTF_RTT || configUSE_PRINTF_SWO
    #define VOS_HEAP_RTT_SWO            0
#endif // configUSE_PRINTF_RTT || configUSE_PRINTF_SWO

#if configUSE_SYSVIEWER
    #define VOS_HEAP_SYSTEMVIEW         (16 * 1024)
#else // configUSE_SYSVIEWER
    #define VOS_HEAP_SYSTEMVIEW         0
#endif // configUSE_SYSVIEWER

#define VOS_HEAP_TOTAL_SIZE             (VOS_HEAP_SYSTEM + VOS_HEAP_PREPROCESSING + VOS_HEAP_WWD_ENGINE + VOS_HEAP_CODEC + VOS_HEAP_BLE + VOS_HEAP_UART + VOS_HEAP_RTT_SWO + VOS_HEAP_SYSTEMVIEW)

#endif // __AM_VOS_SYS_CONFIG_H__

