//*****************************************************************************
//
//! @file am_hal_pin.c
//!
//! @brief Function select information for Apollo4 GPIOs.
//!
//! Date: 11/13/2023
//!
//! @addtogroup
//! @ingroup
//! @{
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2024, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision ambiqvos_r4.5-fdfa8cf6a4 of the AmbiqSuite Development Package.
//
//*****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include "am_mcu_apollo.h"

//*****************************************************************************
//
// GPIO function select table.
//
//*****************************************************************************
const uint16_t am_hal_pin_fn_list[AM_HAL_PIN_TOTAL_GPIOS][AM_HAL_PIN_NUMFUNCS] =
{
    // PIN 0
    {   AM_HAL_PIN_FN_SWTRACECLK,
        AM_HAL_PIN_FN_SLSCL,
        AM_HAL_PIN_FN_SLSCK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_UART1TX,
        AM_HAL_PIN_FN_CT0,
        AM_HAL_PIN_FN_NCE0,
        AM_HAL_PIN_FN_OBSBUS0,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 1
    {   AM_HAL_PIN_FN_SWTRACE0,
        AM_HAL_PIN_FN_SLSDAWIR3,
        AM_HAL_PIN_FN_SLMOSI,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_UART3TX,
        AM_HAL_PIN_FN_CT1,
        AM_HAL_PIN_FN_NCE1,
        AM_HAL_PIN_FN_OBSBUS1,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN4,
    },

    // PIN 2
    {   AM_HAL_PIN_FN_SWTRACE1,
        AM_HAL_PIN_FN_SLMISO,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_UART1RX,
        AM_HAL_PIN_FN_CT2,
        AM_HAL_PIN_FN_NCE2,
        AM_HAL_PIN_FN_OBSBUS2,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANRSTN,
    },

    // PIN 3
    {   AM_HAL_PIN_FN_SWTRACE2,
        AM_HAL_PIN_FN_SLnCE,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_UART3RX,
        AM_HAL_PIN_FN_CT3,
        AM_HAL_PIN_FN_NCE3,
        AM_HAL_PIN_FN_OBSBUS3,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN5,
    },

    // PIN 4
    {   AM_HAL_PIN_FN_SWTRACE3,
        AM_HAL_PIN_FN_SLINT,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_UART1RTS,
        AM_HAL_PIN_FN_CT4,
        AM_HAL_PIN_FN_NCE4,
        AM_HAL_PIN_FN_OBSBUS4,
        AM_HAL_PIN_FN_I2S0_SDIN,
        AM_HAL_PIN_FN_I2S1_SDIN,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_FLB_TDO,
        AM_HAL_PIN_FN_FLLOAD_DIR,
        AM_HAL_PIN_FN_MDA_TDO,
        AM_HAL_PIN_FN_OPCG_TRIG,
    },

    // PIN 5
    {   AM_HAL_PIN_FN_M0SCL,
        AM_HAL_PIN_FN_M0SCK,
        AM_HAL_PIN_FN_I2S0_CLK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RTS,
        AM_HAL_PIN_FN_UART3RTS,
        AM_HAL_PIN_FN_CT5,
        AM_HAL_PIN_FN_NCE5,
        AM_HAL_PIN_FN_OBSBUS5,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_I2S1_CLK,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_FLB_TDI,
        AM_HAL_PIN_FN_FLLOAD_DATA,
        AM_HAL_PIN_FN_MDA_SRST,
        AM_HAL_PIN_FN_DFT_ISO,
    },

    // PIN 6
    {   AM_HAL_PIN_FN_M0SDAWIR3,
        AM_HAL_PIN_FN_M0MOSI,
        AM_HAL_PIN_FN_I2S0_DATA,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0CTS,
        AM_HAL_PIN_FN_UART1CTS,
        AM_HAL_PIN_FN_CT6,
        AM_HAL_PIN_FN_NCE6,
        AM_HAL_PIN_FN_OBSBUS6,
        AM_HAL_PIN_FN_I2S0_SDOUT,
        AM_HAL_PIN_FN_I2S1_SDOUT,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN6,
    },

    // PIN 7
    {   AM_HAL_PIN_FN_M0MISO,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_I2S0_WS,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2CTS,
        AM_HAL_PIN_FN_UART3CTS,
        AM_HAL_PIN_FN_CT7,
        AM_HAL_PIN_FN_NCE7,
        AM_HAL_PIN_FN_OBSBUS7,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_I2S1_WS,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN7,
    },

    // PIN 8
    {   AM_HAL_PIN_FN_CMPRF1,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_M1SCL,
        AM_HAL_PIN_FN_M1SCK,
        AM_HAL_PIN_FN_CT8,
        AM_HAL_PIN_FN_NCE8,
        AM_HAL_PIN_FN_OBSBUS8,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANOUT4,
    },

    // PIN 9
    {   AM_HAL_PIN_FN_CMPRF0,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_M1SDAWIR3,
        AM_HAL_PIN_FN_M1MOSI,
        AM_HAL_PIN_FN_CT9,
        AM_HAL_PIN_FN_NCE9,
        AM_HAL_PIN_FN_OBSBUS9,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANOUT5,
    },

    // PIN 10
    {   AM_HAL_PIN_FN_CMPIN0,
        AM_HAL_PIN_FN_TRIG3,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_M1MISO,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT10,
        AM_HAL_PIN_FN_NCE10,
        AM_HAL_PIN_FN_OBSBUS10,
        AM_HAL_PIN_FN_DISP_TE,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_OPCG_LOAD,
    },

    // PIN 11
    {   AM_HAL_PIN_FN_CMPIN1,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_I2S0_CLK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_UART3RX,
        AM_HAL_PIN_FN_CT11,
        AM_HAL_PIN_FN_NCE11,
        AM_HAL_PIN_FN_OBSBUS11,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_FLB_TCLK,
        AM_HAL_PIN_FN_FLLOAD_ADDR,
        AM_HAL_PIN_FN_MDA_TCK,
        AM_HAL_PIN_FN_SCANIN0,
    },

    // PIN 12
    {   AM_HAL_PIN_FN_ADCSE7,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_I2S0_DATA,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_UART1TX,
        AM_HAL_PIN_FN_CT12,
        AM_HAL_PIN_FN_NCE12,
        AM_HAL_PIN_FN_OBSBUS12,
        AM_HAL_PIN_FN_CMPRF2,
        AM_HAL_PIN_FN_I2S0_SDOUT,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANOUT3,
    },

    // PIN 13
    {   AM_HAL_PIN_FN_ADCSE6,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_I2S0_WS,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_UART3TX,
        AM_HAL_PIN_FN_CT13,
        AM_HAL_PIN_FN_NCE13,
        AM_HAL_PIN_FN_OBSBUS13,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_FLB_FCLK,
        AM_HAL_PIN_FN_FLLOAD_DATA,
        AM_HAL_PIN_FN_MDA_TDI,
        AM_HAL_PIN_FN_SCANOUT0,
    },

    // PIN 14
    {   AM_HAL_PIN_FN_ADCSE5,
        AM_HAL_PIN_FN_TRIG3,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_MILLI_CLK,
        AM_HAL_PIN_FN_UART1RX,
        AM_HAL_PIN_FN_CT14,
        AM_HAL_PIN_FN_NCE14,
        AM_HAL_PIN_FN_OBSBUS14,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_I2S0_SDIN,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_FLLOAD_ADDR,
        AM_HAL_PIN_FN_MDA_TRSTN,
        AM_HAL_PIN_FN_SCANOUT2,
    },

    // PIN 15
    {   AM_HAL_PIN_FN_ADCSE4,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_MILLI_REC_DAT,
        AM_HAL_PIN_FN_UART3RX,
        AM_HAL_PIN_FN_CT15,
        AM_HAL_PIN_FN_NCE15,
        AM_HAL_PIN_FN_OBSBUS15,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_REFCLK_EXT,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_FLLOAD_DATA,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANOUT1,
    },

    // PIN 16
    {   AM_HAL_PIN_FN_ADCSE3,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_I2S1_CLK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_MILLI_PBDATA1,
        AM_HAL_PIN_FN_UART1RTS,
        AM_HAL_PIN_FN_CT16,
        AM_HAL_PIN_FN_NCE16,
        AM_HAL_PIN_FN_OBSBUS0,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_DFT_RET,
    },

    // PIN 17
    {   AM_HAL_PIN_FN_ADCSE2,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_I2S1_DATA,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_MILLI_PBDATA2,
        AM_HAL_PIN_FN_UART3RTS,
        AM_HAL_PIN_FN_CT17,
        AM_HAL_PIN_FN_NCE17,
        AM_HAL_PIN_FN_OBSBUS1,
        AM_HAL_PIN_FN_I2S1_SDOUT,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_FLLOAD_STRB,
        AM_HAL_PIN_FN_MDA_TMS,
        AM_HAL_PIN_FN_OPCG_CLK,
    },

    // PIN 18
    {   AM_HAL_PIN_FN_ADCSE1,
        AM_HAL_PIN_FN_ANATEST2,
        AM_HAL_PIN_FN_I2S1_WS,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0CTS,
        AM_HAL_PIN_FN_UART1CTS,
        AM_HAL_PIN_FN_CT18,
        AM_HAL_PIN_FN_NCE18,
        AM_HAL_PIN_FN_OBSBUS2,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_FLB_TMS,
        AM_HAL_PIN_FN_FLLOAD_DATA,
        AM_HAL_PIN_FN_MDA_HFRC_EXT,
        AM_HAL_PIN_FN_SCANIN1,
    },

    // PIN 19
    {   AM_HAL_PIN_FN_ADCSE0,
        AM_HAL_PIN_FN_ANATEST1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2CTS,
        AM_HAL_PIN_FN_UART3CTS,
        AM_HAL_PIN_FN_CT19,
        AM_HAL_PIN_FN_NCE19,
        AM_HAL_PIN_FN_OBSBUS3,
        AM_HAL_PIN_FN_I2S1_SDIN,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_FLB_TRSTN,
        AM_HAL_PIN_FN_FLLOAD_ADDR,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN2,
    },

    // PIN 20
    {   AM_HAL_PIN_FN_SWDCK,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_UART1TX,
        AM_HAL_PIN_FN_CT20,
        AM_HAL_PIN_FN_NCE20,
        AM_HAL_PIN_FN_OBSBUS4,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANCLK,
    },

    // PIN 21
    {   AM_HAL_PIN_FN_SWDIO,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_UART3TX,
        AM_HAL_PIN_FN_CT21,
        AM_HAL_PIN_FN_NCE21,
        AM_HAL_PIN_FN_OBSBUS5,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANSHFT,
    },

    // PIN 22
    {   AM_HAL_PIN_FN_M7SCL,
        AM_HAL_PIN_FN_M7SCK,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_UART1RX,
        AM_HAL_PIN_FN_CT22,
        AM_HAL_PIN_FN_NCE22,
        AM_HAL_PIN_FN_OBSBUS6,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN3,
    },

    // PIN 23
    {   AM_HAL_PIN_FN_M7SDAWIR3,
        AM_HAL_PIN_FN_M7MOSI,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_UART3RX,
        AM_HAL_PIN_FN_CT23,
        AM_HAL_PIN_FN_NCE23,
        AM_HAL_PIN_FN_OBSBUS7,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANOUT6,
    },

    // PIN 24
    {   AM_HAL_PIN_FN_M7MISO,
        AM_HAL_PIN_FN_TRIG3,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_UART1RTS,
        AM_HAL_PIN_FN_CT24,
        AM_HAL_PIN_FN_NCE24,
        AM_HAL_PIN_FN_OBSBUS8,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANOUT7,
    },

    // PIN 25
    {   AM_HAL_PIN_FN_M2SCL,
        AM_HAL_PIN_FN_M2SCK,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_LFRC_EXT,
        AM_HAL_PIN_FN_DSP_TMS,
        AM_HAL_PIN_FN_CT25,
        AM_HAL_PIN_FN_NCE25,
        AM_HAL_PIN_FN_OBSBUS9,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN8,
    },

    // PIN 26
    {   AM_HAL_PIN_FN_M2SDAWIR3,
        AM_HAL_PIN_FN_M2MOSI,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_HFRC_EXT,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT26,
        AM_HAL_PIN_FN_NCE26,
        AM_HAL_PIN_FN_OBSBUS10,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN9,
    },

    // PIN 27
    {   AM_HAL_PIN_FN_M2MISO,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_XT_EXT,
        AM_HAL_PIN_FN_DSP_TCK,
        AM_HAL_PIN_FN_CT27,
        AM_HAL_PIN_FN_NCE27,
        AM_HAL_PIN_FN_OBSBUS11,
        AM_HAL_PIN_FN_I2S0_SDIN,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANIN10,
    },

    // PIN 28
    {   AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_I2S0_CLK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2CTS,
        AM_HAL_PIN_FN_DSP_TDO,
        AM_HAL_PIN_FN_CT28,
        AM_HAL_PIN_FN_NCE28,
        AM_HAL_PIN_FN_OBSBUS12,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_CME,
    },

    // PIN 29
    {   AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_I2S0_DATA,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART1CTS,
        AM_HAL_PIN_FN_DSP_TRSTN,
        AM_HAL_PIN_FN_CT29,
        AM_HAL_PIN_FN_NCE29,
        AM_HAL_PIN_FN_OBSBUS13,
        AM_HAL_PIN_FN_I2S0_SDOUT,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_CMLE,
    },

    // PIN 30
    {   AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_I2S0_WS,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_DSP_TDI,
        AM_HAL_PIN_FN_CT30,
        AM_HAL_PIN_FN_NCE30,
        AM_HAL_PIN_FN_OBSBUS14,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANOUT8,
    },

    // PIN 31
    {   AM_HAL_PIN_FN_M3SCL,
        AM_HAL_PIN_FN_M3SCK,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT31,
        AM_HAL_PIN_FN_NCE31,
        AM_HAL_PIN_FN_OBSBUS15,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_SCANOUT9,
    },

    // PIN 32
    {   AM_HAL_PIN_FN_M3SDAWIR3,
        AM_HAL_PIN_FN_M3MOSI,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT32,
        AM_HAL_PIN_FN_NCE32,
        AM_HAL_PIN_FN_OBSBUS0,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_LPG_ENABLE,
    },

    // PIN 33
    {   AM_HAL_PIN_FN_M3MISO,
        AM_HAL_PIN_FN_CLKOUT,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT33,
        AM_HAL_PIN_FN_NCE33,
        AM_HAL_PIN_FN_OBSBUS1,
        AM_HAL_PIN_FN_DISP_TE,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_LPG_LOAD,
    },

    // PIN 34
    {   AM_HAL_PIN_FN_M4SCL,
        AM_HAL_PIN_FN_M4SCK,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT34,
        AM_HAL_PIN_FN_NCE34,
        AM_HAL_PIN_FN_OBSBUS2,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 35
    {   AM_HAL_PIN_FN_M4SDAWIR3,
        AM_HAL_PIN_FN_M4MOSI,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_UART3TX,
        AM_HAL_PIN_FN_CT35,
        AM_HAL_PIN_FN_NCE35,
        AM_HAL_PIN_FN_OBSBUS3,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 36
    {   AM_HAL_PIN_FN_M4MISO,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_UART1RX,
        AM_HAL_PIN_FN_CT36,
        AM_HAL_PIN_FN_NCE36,
        AM_HAL_PIN_FN_OBSBUS4,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 37
    {   AM_HAL_PIN_FN_MSPI1_0,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_DISP_D15,
        AM_HAL_PIN_FN_CT37,
        AM_HAL_PIN_FN_NCE37,
        AM_HAL_PIN_FN_OBSBUS5,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 38
    {   AM_HAL_PIN_FN_MSPI1_1,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_SWTRACECLK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_DISP_D16,
        AM_HAL_PIN_FN_CT38,
        AM_HAL_PIN_FN_NCE38,
        AM_HAL_PIN_FN_OBSBUS6,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 39
    {   AM_HAL_PIN_FN_MSPI1_2,
        AM_HAL_PIN_FN_TRIG3,
        AM_HAL_PIN_FN_SWTRACE0,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RTS,
        AM_HAL_PIN_FN_DISP_D17,
        AM_HAL_PIN_FN_CT39,
        AM_HAL_PIN_FN_NCE39,
        AM_HAL_PIN_FN_OBSBUS7,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 40
    {   AM_HAL_PIN_FN_MSPI1_3,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_SWTRACE1,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0CTS,
        AM_HAL_PIN_FN_DISP_D18,
        AM_HAL_PIN_FN_CT40,
        AM_HAL_PIN_FN_NCE40,
        AM_HAL_PIN_FN_OBSBUS8,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 41
    {   AM_HAL_PIN_FN_MSPI1_4,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_SWTRACE2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_DISP_D19,
        AM_HAL_PIN_FN_CT41,
        AM_HAL_PIN_FN_NCE41,
        AM_HAL_PIN_FN_OBSBUS9,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 42
    {   AM_HAL_PIN_FN_MSPI1_5,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_SWTRACE3,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_DISP_D20,
        AM_HAL_PIN_FN_CT42,
        AM_HAL_PIN_FN_NCE42,
        AM_HAL_PIN_FN_OBSBUS10,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 43
    {   AM_HAL_PIN_FN_MSPI1_6,
        AM_HAL_PIN_FN_TRIG3,
        AM_HAL_PIN_FN_SWTRACECTL,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_DISP_D21,
        AM_HAL_PIN_FN_CT43,
        AM_HAL_PIN_FN_NCE43,
        AM_HAL_PIN_FN_OBSBUS11,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 44
    {   AM_HAL_PIN_FN_MSPI1_7,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_DISP_D22,
        AM_HAL_PIN_FN_CT44,
        AM_HAL_PIN_FN_NCE44,
        AM_HAL_PIN_FN_OBSBUS12,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 45
    {   AM_HAL_PIN_FN_MSPI1_8,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_DISP_D23,
        AM_HAL_PIN_FN_CT45,
        AM_HAL_PIN_FN_NCE45,
        AM_HAL_PIN_FN_OBSBUS13,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 46
    {   AM_HAL_PIN_FN_MSPI1_9,
        AM_HAL_PIN_FN_TRIG3,
        AM_HAL_PIN_FN_CLKOUT_32M,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_UART3TX,
        AM_HAL_PIN_FN_CT46,
        AM_HAL_PIN_FN_NCE46,
        AM_HAL_PIN_FN_OBSBUS14,
        AM_HAL_PIN_FN_I2S1_SDIN,
        AM_HAL_PIN_FN_I2S0_SDIN,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 47
    {   AM_HAL_PIN_FN_M5SCL,
        AM_HAL_PIN_FN_M5SCK,
        AM_HAL_PIN_FN_I2S1_CLK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_UART1RX,
        AM_HAL_PIN_FN_CT47,
        AM_HAL_PIN_FN_NCE47,
        AM_HAL_PIN_FN_OBSBUS15,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_I2S0_CLK,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 48
    {   AM_HAL_PIN_FN_M5SDAWIR3,
        AM_HAL_PIN_FN_M5MOSI,
        AM_HAL_PIN_FN_I2S1_DATA,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_UART3RX,
        AM_HAL_PIN_FN_CT48,
        AM_HAL_PIN_FN_NCE48,
        AM_HAL_PIN_FN_OBSBUS0,
        AM_HAL_PIN_FN_I2S1_SDOUT,
        AM_HAL_PIN_FN_I2S0_SDOUT,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 49
    {   AM_HAL_PIN_FN_M5MISO,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_I2S1_WS,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_UART1RTS,
        AM_HAL_PIN_FN_CT49,
        AM_HAL_PIN_FN_NCE49,
        AM_HAL_PIN_FN_OBSBUS1,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_I2S0_WS,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 50
    {   AM_HAL_PIN_FN_PDM0_CLK,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_SWTRACECLK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RTS,
        AM_HAL_PIN_FN_UART3RTS,
        AM_HAL_PIN_FN_CT50,
        AM_HAL_PIN_FN_NCE50,
        AM_HAL_PIN_FN_OBSBUS2,
        AM_HAL_PIN_FN_DISP_TE,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 51
    {   AM_HAL_PIN_FN_PDM0_DATA,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_SWTRACE0,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0CTS,
        AM_HAL_PIN_FN_UART1CTS,
        AM_HAL_PIN_FN_CT51,
        AM_HAL_PIN_FN_NCE51,
        AM_HAL_PIN_FN_OBSBUS3,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 52
    {   AM_HAL_PIN_FN_PDM1_CLK,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_SWTRACE1,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2CTS,
        AM_HAL_PIN_FN_UART3CTS,
        AM_HAL_PIN_FN_CT52,
        AM_HAL_PIN_FN_NCE52,
        AM_HAL_PIN_FN_OBSBUS4,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 53
    {   AM_HAL_PIN_FN_PDM1_DATA,
        AM_HAL_PIN_FN_TRIG3,
        AM_HAL_PIN_FN_SWTRACE2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_UART1TX,
        AM_HAL_PIN_FN_CT53,
        AM_HAL_PIN_FN_NCE53,
        AM_HAL_PIN_FN_OBSBUS5,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 54
    {   AM_HAL_PIN_FN_PDM2_CLK,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_SWTRACE3,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_UART3TX,
        AM_HAL_PIN_FN_CT54,
        AM_HAL_PIN_FN_NCE54,
        AM_HAL_PIN_FN_OBSBUS6,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 55
    {   AM_HAL_PIN_FN_PDM2_DATA,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_SWTRACECTL,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_UART1RX,
        AM_HAL_PIN_FN_CT55,
        AM_HAL_PIN_FN_NCE55,
        AM_HAL_PIN_FN_OBSBUS7,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 56
    {   AM_HAL_PIN_FN_PDM3_CLK,
        AM_HAL_PIN_FN_TRIG2,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_UART3RX,
        AM_HAL_PIN_FN_CT56,
        AM_HAL_PIN_FN_NCE56,
        AM_HAL_PIN_FN_OBSBUS8,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 57
    {   AM_HAL_PIN_FN_PDM3_DATA,
        AM_HAL_PIN_FN_TRIG3,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_UART1RTS,
        AM_HAL_PIN_FN_CT57,
        AM_HAL_PIN_FN_NCE57,
        AM_HAL_PIN_FN_OBSBUS9,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 58
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_UART3RTS,
        AM_HAL_PIN_FN_CT58,
        AM_HAL_PIN_FN_NCE58,
        AM_HAL_PIN_FN_OBSBUS10,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 59
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_TRIG0,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0CTS,
        AM_HAL_PIN_FN_UART1CTS,
        AM_HAL_PIN_FN_CT59,
        AM_HAL_PIN_FN_NCE59,
        AM_HAL_PIN_FN_OBSBUS11,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 60
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_TRIG1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_UART3CTS,
        AM_HAL_PIN_FN_CT60,
        AM_HAL_PIN_FN_NCE60,
        AM_HAL_PIN_FN_OBSBUS12,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 61
    {   AM_HAL_PIN_FN_M6SCL,
        AM_HAL_PIN_FN_M6SCK,
        AM_HAL_PIN_FN_I2S1_CLK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_UART3TX,
        AM_HAL_PIN_FN_CT61,
        AM_HAL_PIN_FN_NCE61,
        AM_HAL_PIN_FN_OBSBUS13,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 62
    {   AM_HAL_PIN_FN_M6SDAWIR3,
        AM_HAL_PIN_FN_M6MOSI,
        AM_HAL_PIN_FN_I2S1_DATA,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_UART1RX,
        AM_HAL_PIN_FN_CT62,
        AM_HAL_PIN_FN_NCE62,
        AM_HAL_PIN_FN_OBSBUS14,
        AM_HAL_PIN_FN_I2S1_SDOUT,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 63
    {   AM_HAL_PIN_FN_M6MISO,
        AM_HAL_PIN_FN_CLKOUT,
        AM_HAL_PIN_FN_I2S1_WS,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_UART3RX,
        AM_HAL_PIN_FN_CT63,
        AM_HAL_PIN_FN_NCE63,
        AM_HAL_PIN_FN_OBSBUS15,
        AM_HAL_PIN_FN_DISP_TE,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 64
    {   AM_HAL_PIN_FN_MSPI0_0,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_DISP_D0,
        AM_HAL_PIN_FN_CT64,
        AM_HAL_PIN_FN_NCE64,
        AM_HAL_PIN_FN_OBSBUS0,
        AM_HAL_PIN_FN_I2S1_SDIN,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 65
    {   AM_HAL_PIN_FN_MSPI0_1,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0CTS,
        AM_HAL_PIN_FN_DISP_D1,
        AM_HAL_PIN_FN_CT65,
        AM_HAL_PIN_FN_NCE65,
        AM_HAL_PIN_FN_OBSBUS1,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 66
    {   AM_HAL_PIN_FN_MSPI0_2,
        AM_HAL_PIN_FN_CLKOUT,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_DISP_D2,
        AM_HAL_PIN_FN_CT66,
        AM_HAL_PIN_FN_NCE66,
        AM_HAL_PIN_FN_OBSBUS2,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 67
    {   AM_HAL_PIN_FN_MSPI0_3,
        AM_HAL_PIN_FN_CLKOUT,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_DISP_D3,
        AM_HAL_PIN_FN_CT67,
        AM_HAL_PIN_FN_NCE67,
        AM_HAL_PIN_FN_OBSBUS3,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 68
    {   AM_HAL_PIN_FN_MSPI0_4,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_DISP_D4,
        AM_HAL_PIN_FN_CT68,
        AM_HAL_PIN_FN_NCE68,
        AM_HAL_PIN_FN_OBSBUS4,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 69
    {   AM_HAL_PIN_FN_MSPI0_5,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_DISP_D5,
        AM_HAL_PIN_FN_CT69,
        AM_HAL_PIN_FN_NCE69,
        AM_HAL_PIN_FN_OBSBUS5,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 70
    {   AM_HAL_PIN_FN_MSPI0_6,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_SWTRACE0,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_DISP_D6,
        AM_HAL_PIN_FN_CT70,
        AM_HAL_PIN_FN_NCE70,
        AM_HAL_PIN_FN_OBSBUS6,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 71
    {   AM_HAL_PIN_FN_MSPI0_7,
        AM_HAL_PIN_FN_CLKOUT,
        AM_HAL_PIN_FN_SWTRACE1,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0CTS,
        AM_HAL_PIN_FN_DISP_D7,
        AM_HAL_PIN_FN_CT71,
        AM_HAL_PIN_FN_NCE71,
        AM_HAL_PIN_FN_OBSBUS7,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 72
    {   AM_HAL_PIN_FN_MSPI0_8,
        AM_HAL_PIN_FN_CLKOUT,
        AM_HAL_PIN_FN_SWTRACE2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_DISP_D8,
        AM_HAL_PIN_FN_CT72,
        AM_HAL_PIN_FN_NCE72,
        AM_HAL_PIN_FN_OBSBUS8,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 73
    {   AM_HAL_PIN_FN_MSPI0_9,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_SWTRACE3,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2TX,
        AM_HAL_PIN_FN_DISP_D9,
        AM_HAL_PIN_FN_CT73,
        AM_HAL_PIN_FN_NCE73,
        AM_HAL_PIN_FN_OBSBUS9,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 74
    {   AM_HAL_PIN_FN_MSPI2_0,
        AM_HAL_PIN_FN_DISP_QSPI_D0_OUT,
        AM_HAL_PIN_FN_DISP_QSPI_D0,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RX,
        AM_HAL_PIN_FN_DISP_D10,
        AM_HAL_PIN_FN_CT74,
        AM_HAL_PIN_FN_NCE74,
        AM_HAL_PIN_FN_OBSBUS10,
        AM_HAL_PIN_FN_DISP_SPI_SD,
        AM_HAL_PIN_FN_DISP_SPI_SDO,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 75
    {   AM_HAL_PIN_FN_MSPI2_1,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_DISP_QSPI_D1,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART2RX,
        AM_HAL_PIN_FN_DISP_D11,
        AM_HAL_PIN_FN_CT75,
        AM_HAL_PIN_FN_NCE75,
        AM_HAL_PIN_FN_OBSBUS11,
        AM_HAL_PIN_FN_DISP_SPI_DCX,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 76
    {   AM_HAL_PIN_FN_MSPI2_2,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_DISP_QSPI_D2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0RTS,
        AM_HAL_PIN_FN_DISP_D12,
        AM_HAL_PIN_FN_CT76,
        AM_HAL_PIN_FN_NCE76,
        AM_HAL_PIN_FN_OBSBUS12,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 77
    {   AM_HAL_PIN_FN_MSPI2_3,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_DISP_QSPI_D3,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0CTS,
        AM_HAL_PIN_FN_DISP_D13,
        AM_HAL_PIN_FN_CT77,
        AM_HAL_PIN_FN_NCE77,
        AM_HAL_PIN_FN_OBSBUS13,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 78
    {   AM_HAL_PIN_FN_MSPI2_4,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_DISP_QSPI_SCK,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_UART0TX,
        AM_HAL_PIN_FN_DISP_D14,
        AM_HAL_PIN_FN_CT78,
        AM_HAL_PIN_FN_NCE78,
        AM_HAL_PIN_FN_OBSBUS14,
        AM_HAL_PIN_FN_DISP_SPI_SCK,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 79
    {   AM_HAL_PIN_FN_MSPI2_5,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_SDIF_DAT4,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_SWO,
        AM_HAL_PIN_FN_DISP_VS,
        AM_HAL_PIN_FN_CT79,
        AM_HAL_PIN_FN_NCE79,
        AM_HAL_PIN_FN_OBSBUS15,
        AM_HAL_PIN_FN_DISP_SPI_SDI,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 80
    {   AM_HAL_PIN_FN_MSPI2_6,
        AM_HAL_PIN_FN_CLKOUT,
        AM_HAL_PIN_FN_SDIF_DAT5,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_SWTRACE0,
        AM_HAL_PIN_FN_DISP_HS,
        AM_HAL_PIN_FN_CT80,
        AM_HAL_PIN_FN_NCE80,
        AM_HAL_PIN_FN_OBSBUS0,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 81
    {   AM_HAL_PIN_FN_MSPI2_7,
        AM_HAL_PIN_FN_CLKOUT,
        AM_HAL_PIN_FN_SDIF_DAT6,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_SWTRACE1,
        AM_HAL_PIN_FN_DISP_DE,
        AM_HAL_PIN_FN_CT81,
        AM_HAL_PIN_FN_NCE81,
        AM_HAL_PIN_FN_OBSBUS1,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 82
    {   AM_HAL_PIN_FN_MSPI2_8,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_SDIF_DAT7,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_SWTRACE2,
        AM_HAL_PIN_FN_DISP_PCLK,
        AM_HAL_PIN_FN_CT82,
        AM_HAL_PIN_FN_NCE82,
        AM_HAL_PIN_FN_OBSBUS2,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 83
    {   AM_HAL_PIN_FN_MSPI2_9,
        AM_HAL_PIN_FN_32KHzXT,
        AM_HAL_PIN_FN_SDIF_CMD,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_SWTRACE3,
        AM_HAL_PIN_FN_DISP_SD,
        AM_HAL_PIN_FN_CT83,
        AM_HAL_PIN_FN_NCE83,
        AM_HAL_PIN_FN_OBSBUS3,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 84
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_SDIF_DAT0,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT84,
        AM_HAL_PIN_FN_NCE84,
        AM_HAL_PIN_FN_OBSBUS4,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 85
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_SDIF_DAT1,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT85,
        AM_HAL_PIN_FN_NCE85,
        AM_HAL_PIN_FN_OBSBUS5,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 86
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_SDIF_DAT2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT86,
        AM_HAL_PIN_FN_NCE86,
        AM_HAL_PIN_FN_OBSBUS6,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 87
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_SDIF_DAT3,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT87,
        AM_HAL_PIN_FN_NCE87,
        AM_HAL_PIN_FN_OBSBUS7,
        AM_HAL_PIN_FN_DISP_TE,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 88
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_SDIF_CLKOUT,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT88,
        AM_HAL_PIN_FN_NCE88,
        AM_HAL_PIN_FN_OBSBUS8,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 89
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_DISP_CM,
        AM_HAL_PIN_FN_CT89,
        AM_HAL_PIN_FN_NCE89,
        AM_HAL_PIN_FN_OBSBUS9,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 90
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT90,
        AM_HAL_PIN_FN_NCE90,
        AM_HAL_PIN_FN_OBSBUS10,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 91
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT91,
        AM_HAL_PIN_FN_NCE91,
        AM_HAL_PIN_FN_OBSBUS11,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 92
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT92,
        AM_HAL_PIN_FN_NCE92,
        AM_HAL_PIN_FN_OBSBUS12,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 93
    {   AM_HAL_PIN_FN_MSPI2_9,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT93,
        AM_HAL_PIN_FN_NCE93,
        AM_HAL_PIN_FN_OBSBUS13,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 94
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT94,
        AM_HAL_PIN_FN_NCE94,
        AM_HAL_PIN_FN_OBSBUS14,
        AM_HAL_PIN_FN_VCMPO,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 95
    {   AM_HAL_PIN_FN_MSPI1_0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT95,
        AM_HAL_PIN_FN_NCE95,
        AM_HAL_PIN_FN_OBSBUS15,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 96
    {   AM_HAL_PIN_FN_MSPI1_1,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT96,
        AM_HAL_PIN_FN_NCE96,
        AM_HAL_PIN_FN_OBSBUS0,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 97
    {   AM_HAL_PIN_FN_MSPI1_2,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT97,
        AM_HAL_PIN_FN_NCE97,
        AM_HAL_PIN_FN_OBSBUS1,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 98
    {   AM_HAL_PIN_FN_MSPI1_3,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT98,
        AM_HAL_PIN_FN_NCE98,
        AM_HAL_PIN_FN_OBSBUS2,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 99
    {   AM_HAL_PIN_FN_MSPI1_4,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT99,
        AM_HAL_PIN_FN_NCE99,
        AM_HAL_PIN_FN_OBSBUS3,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 100
    {   AM_HAL_PIN_FN_MSPI1_5,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT100,
        AM_HAL_PIN_FN_NCE100,
        AM_HAL_PIN_FN_OBSBUS4,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 101
    {   AM_HAL_PIN_FN_MSPI1_6,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT101,
        AM_HAL_PIN_FN_NCE101,
        AM_HAL_PIN_FN_OBSBUS5,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 102
    {   AM_HAL_PIN_FN_MSPI1_7,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT102,
        AM_HAL_PIN_FN_NCE102,
        AM_HAL_PIN_FN_OBSBUS6,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 103
    {   AM_HAL_PIN_FN_MSPI1_8,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT103,
        AM_HAL_PIN_FN_NCE103,
        AM_HAL_PIN_FN_OBSBUS7,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 104
    {   AM_HAL_PIN_FN_MSPI1_9,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT104,
        AM_HAL_PIN_FN_NCE104,
        AM_HAL_PIN_FN_OBSBUS8,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_FPIO,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 105
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT105,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS9,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 106
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT106,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS10,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 107
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT107,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS11,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 108
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT108,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS12,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 109
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT109,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS13,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 110
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT110,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS14,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 111
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT111,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS15,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 112
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT112,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS0,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 113
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT113,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS1,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 114
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT114,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS2,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 115
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT115,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS3,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 116
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT116,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS4,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 117
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT117,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS5,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 118
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT118,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS6,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 119
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT119,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS7,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 120
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT120,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS8,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 121
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT121,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS9,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 122
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT122,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS10,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 123
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT123,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS11,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 124
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT124,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS12,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 125
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT125,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS13,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 126
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT126,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS14,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },

    // PIN 127
    {   AM_HAL_PIN_FN_RESERVED0,
        AM_HAL_PIN_FN_RESERVED1,
        AM_HAL_PIN_FN_RESERVED2,
        AM_HAL_PIN_FN_GPIO,
        AM_HAL_PIN_FN_RESERVED4,
        AM_HAL_PIN_FN_RESERVED5,
        AM_HAL_PIN_FN_CT127,
        AM_HAL_PIN_FN_RESERVED7,
        AM_HAL_PIN_FN_OBSBUS15,
        AM_HAL_PIN_FN_RESERVED9,
        AM_HAL_PIN_FN_RESERVED10,
        AM_HAL_PIN_FN_RESERVED11,
        AM_HAL_PIN_FN_RESERVED12,
        AM_HAL_PIN_FN_RESERVED13,
        AM_HAL_PIN_FN_RESERVED14,
        AM_HAL_PIN_FN_RESERVED15,
    },
};

//*****************************************************************************
//
// End Doxygen group.
//! @}
//
//*****************************************************************************
