//*****************************************************************************
//
//! @file amota_profile_config.h
//!
//! @brief Global bootloader information.
//!
//! This is a bootloader program that supports flash programming over UART,
//! SPI, and I2C. The correct protocol is selected automatically at boot time.
//!
//! SWO is configured in 1M baud, 8-n-1 mode.
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2026, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision stable-7884e9252d of the AmbiqSuite Development Package.
//
//*****************************************************************************

#ifndef AMOTA_PROFILE_CONFIG_H
#define AMOTA_PROFILE_CONFIG_H

#include "am_mcu_apollo.h"

//*****************************************************************************
//
// Define the OTA Descriptor address by reserving default maximum 256k bytes app
// image/upgrading image size. Allocate AM_HAL_FLASH_PAGE_SIZE bytes for the OTA
// Descriptor. OTA Descriptor needs to be made sure no overlaps with the current
// running app image and the upgrading image storage area:
// - OTA_POINTER_LOCATION should be larger than app start address + app image size
// - OTA_POINTER_LOCATION should be larger than app start address + upgrading image size
// The app start address is corresponding to ROMEM start address of app example
// in linker_script file, which is 0x0000C000 by default.
//
//*****************************************************************************
#define OTA_MAX_IMAGE_SIZE                  (256 * 1024)
#if (OTA_MAX_IMAGE_SIZE > (AM_HAL_FLASH_TOTAL_SIZE - 0xC000) / 2)
#error "OTA_MAX_IMAGE_SIZE is too large!"
#endif
#define OTA_POINTER_LOCATION                (0x0000C000 + OTA_MAX_IMAGE_SIZE)
#define OTA_DESCRIPTOR_SIZE                 AM_HAL_FLASH_PAGE_SIZE

//*****************************************************************************
//
// Internal flash area to be used for OTA temporary storage. This address must
// be AM_HAL_FLASH_PAGE_SIZE (8k bytes) aligned.
// This should be customized to the desired memory map of the design.
// Make sure the OTA temporary storage does not overlap with the running
// app image and OTA Descriptor.
//
//*****************************************************************************
#define AMOTA_INT_FLASH_OTA_ADDRESS         (OTA_POINTER_LOCATION + OTA_DESCRIPTOR_SIZE)

//*****************************************************************************
//
// The maximum size of OTA storage area.
//
//*****************************************************************************
#define AMOTA_INT_FLASH_OTA_MAX_SIZE        (AM_HAL_FLASH_LARGEST_VALID_ADDR - AMOTA_INT_FLASH_OTA_ADDRESS + 1)

#define AMOTAS_SUPPORT_EXT_FLASH            0

#endif // AMOTA_PROFILE_CONFIG_H
